/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * MODULE NAME:		layout.h
 *
 * SCCSINFO:		@(#)layout.h	1.2 5/3/94
 *
 * ORIGINAL AUTHOR(S):	Nilgun Mat & Michael Jansson, 1990-09-11.
 *
 * MODIFICATIONS:
 *	< list mods with name and date >
 *
 * DESCRIPTION:
 *	Lincks layout widget client header file.
 *
 **********************************************************************/

#ifndef _XlLayout_h
#define _XlLayout_h

#include <X11/Constraint.h>
#include <X11/Xaw/Form.h>

/***********************************************************************
 *
 * Lincks XlLayout Widget
 * Written by Nilgun & Michael. 1990-09-11
 * @(#)layout.h	5.3 6/1/92
 *
 ***********************************************************************/

/* Parameters:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 defaultDistance     Thickness		int		4
 destroyCallback     Callback		Pointer		NULL
 height		     Height		Dimension	computed at realize
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 sensitive	     Sensitive		Boolean		True
 width		     Width		Dimension	computed at realize
 x		     Position		Position	0
 y		     Position		Position	0
 layout		     Layout		LayoutType	XlVertical
*/
#define XtNlayout "layout"
#define XtClayout "Layout"
#define XtRlayout "LayoutType"

typedef struct _XlLayoutClassRec	*XlLayoutWidgetClass;
typedef struct _XlLayoutRec		*XlLayoutWidget;

extern WidgetClass XllayoutWidgetClass;

typedef enum {XlVertical, XlOptimal, XlHorizontal} XlLayoutType;

#endif /* _XlLayout_h */
