/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	graphP.h
 *
 * SCCSINFO:		@(#)graphP.h	1.2 5/3/94
 *
 * ORIGINAL AUTHOR(S):  Michael Jansson 25-Feb-92
 *
 * MODIFICATIONS:
 *	< add mods with name and date >
 *
 *
 * DESCRIPTION:
 *	Standard private Widget include file. It defines the data structures in
 *	the GraphWidget.
 */

#ifndef _GraphP_h
#define _GraphP_h

/* Needed definitions that are included. */
#include "graph.h"
#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>

/* Representations type for the graph widget. */
#define XtRGraph "Graph"
#define XtRGravity "Gravity"
#define XtRLayout "Layout"

typedef struct _GraphClassRec {
  CoreClassPart	core_class;
} GraphClassRec;

extern GraphClassRec graphClassRec;

typedef struct {
  /* resources */
  fixpoint scale;	/* Scale of the layout. Applied to all resources. */
  int space_x;		/* Horizontal distance between nodes */
  int space_y;		/* Vertical -"- */
  int start_x;		/* Positions of the root of the graph. */
  int start_y;		/* -"- */
  int nodesize;		/* Width and height of the nodes. */
  enum Gravity gravity; /* Layout orientation,e.g. left to right, up to down.*/
  GraphNode *root;	/* The first node of the graph. */
  char *name;		/* The name of the graph. */
  void *value;		/* Value associated to the whole graph. */
  void *current;	/* Current selection in the graph. */

  /* Rendering call backs. */
  void (*DrawNode)();	/* Args: graph, gc, x, y, size, value */
  void (*DrawLink)();	/* Args: graph, gc, x1, y1, x2, y2, size */
  void (*NodeHit)();	/* Args: graph, node */
  GraphNode *(*LocateNode)(); /* Args: root, x, y, d */

  /* private state */
  enum Layout layout;   /* Indicates whether the layout is computed or not. */
  GC gc;		/* Used by DrawNode() and DrawLink(). */
  XFontStruct *font;	/* Used by DefDrawNode. */
} GraphPart;

typedef struct _GraphRec {
    CorePart	core;
    GraphPart	graph;
} GraphRec;

#endif /* _GraphP_h */
