/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	graph.h
 *
 * SCCSINFO:		@(#)graph.h	1.2 5/3/94
 *
 * ORIGINAL AUTHOR(S):  Michael Jansson 25-Feb-92
 *
 * MODIFICATIONS:
 *	< add mods with name and date >
 *
 * DESCRIPTION:
 *	Standard  Widget include file. It defines the resources in the
 *	GraphWidget.
 */

#include <X11/Intrinsic.h>
#include <X11/Core.h>

/* $XConsortium: Template.h,v 1.4 89/07/21 01:41:49 kit Exp $ */
/* Copyright	Massachusetts Institute of Technology	1987, 1988 */


#ifndef _Graph_h
#define _Graph_h

/****************************************************************
 *
 * Graph widget
 *
 ****************************************************************/

/* Resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 destroyCallback     Callback		Pointer		NULL
 height		     Height		Dimension	0
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 sensitive	     Sensitive		Boolean		True
 width		     Width		Dimension	0
 x		     Position		Position	0
 y		     Position		Position	0
--- New stuff for this widget follows:
 graph		     Graph		GraphType	NULL
 scale		     Scale		FixPoint	1.0
 spaceX		     Space		Dimension	20
 spaceY		     Space		Dimension	20
 nodesize	     Space		Dimension	10
 startX		     Position		Position	20
 startY		     Position		Position	20
 gravity	     Gravity		Gravity		LeftRight
 graphName	     String		String		"UnNamed"
 drawNode	     Callback		Pointer		DefDrawNode
 drawLink	     Callback		Pointer		DefDrawLink
 layout		     Layout		Layout		NotDone
 nodeHit	     Callback		Pointer		DefNodeHit
 locateNode	     Callback		Pointer		DefLocateNode
 graphValue          Generic		Pointer		NULL

Name			Description
----			-----------
graph			The data structure that represents the graph.
scale			Scaling factor that is applied when calculating
                        the layout (the position of all the nodes of
                        the graph).
spaceX			Horizontal distance between nodes.
spaceY			Vertical distance between nodes.
nodesize		Dimmension of the node. The DefDrawNode function
                        will interprate this as the diameter of the node. 
			Application programs may writte their own DrawNode()
			callback that interprates the dimension in any way
			thay want,  e.g. widht and/or height etc.
startX			Horizontal distance between the origin of the widgit
			and the origin of the graph.
startY                  Same as startX,  but it indicates the vertical
			distance.
gravity			Indicates whether the graph should be layed out from 
                        left to right or from top to bottom.
graphName		The name of the graph.
drawNode		Callback function that draws the nodes of the graph.
drawLink 		Callback function that draws the links of the graph.
layout			Indicated whether the layout is already computed or 
                        not.
nodeHit			Callback function that gets called if the graph is
                        sensitive and the user clicks left mouse button while
			pointing at a node. A node is hit if locateNode says 
                        so. Action/Translation tables may be changed to allow 
                        different modes of selecting nodes of the graph. The 
                        default function (DefNodeHit) is a no-op.
locateNode		Callback function that maps a coordinate to the node
                        that reside at the coordinate, or null if none resides
                        there. The default function (DefLocateNode) assumes 
			that nodes are circular, i.e. a coordinate within the
			"nodesize" from the center is a hit.
graphValue		A generic value associated to the whole graph,  e.g. 
                        a pointer to a reference strcture whose history is
			represented with the graph.
			

*/


/* The resources that are specific for the Graph Widget. */
#define XtNgraph "graph"
#define XtNscale "scale"
#define XtNspaceX "spaceX"
#define XtNspaceY "spaceY"
#define XtNstartX "startX"
#define XtNstartY "startY"
#define XtNgravity "gravity"
#define XtNgraphName "graphName"
#define XtNnodeSize "nodeSize"
#define XtNdrawNode "drawNode"
#define XtNdrawLink "drawLink"
#define XtNlayout "layout"
#define XtNlocateNode "locateNode"
#define XtNnodeHit "nodeHit"
#define XtNgraphValue "graphValue"

/* The new classes of resources. */
#define XtCGraph "Graph"
#define XtCScale "Scale"
#define XtCGravity "Gravity"
#define XtCLayout "Layout"
#define XtCGeneric "Generic"

/* The new widget types. */
#define FIX_OFFSET	(1<<16)	/* Conversions factor for fixpoint values. */

typedef int fixpoint;		/* Used for the scale of the graphs. */
typedef struct _GraphClassRec*	GraphWidgetClass;
typedef struct _GraphRec*	GraphWidget;
enum Gravity {LeftRight, UpDown};
enum Layout {Done, NotDone};


typedef struct GraphNodeRec {
  struct GraphNodeRec **children;
  int dx, dy;
  int x, y;

  int flags;
#define GNF_TOUCHED	0x01

  void *value;		/* Is used/defined by the apllication ONLY,
			   e.g. could be a value or a pointer
			   to any thing that the application wants. The
			   DefDrawNode() function interprets it as a integer,
			   which is a valid interpretation. */ 
} GraphNode;

/* declare the class constant */
extern WidgetClass graphWidgetClass;

#endif /* _Graph_h */

