/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	graph.c
 *
 * SCCSINFO:		@(#)graph.c	1.4 5/3/94
 *
 * ORIGINAL AUTHOR(S):  Michael Jansson 25-Feb-92
 *
 * MODIFICATIONS:
 *      <list mods with name and date>
 *
 * DESCRIPTION:
 *	This module is a X window widget. It follows the X11/Template.c
 *	from MIT. It implements the graphWidgetClass.
 *
 **************************************************************************
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 **************************************************************************
 */
void ClearGraphPart();

/**************************************************************************
 * INCLUDES:
 **************************************************************************/
#include "config.h"	/* includes system dependent includes */
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include "graphP.h"

/*************************************************************************
 * INTERNAL FUNCTIONS USED BY THIS MODULE:
 **************************************************************************/
static void Destroy P_(( GraphWidget widget, XEvent event, Region region ));
static void Redisplay P_(( GraphWidget widget, XEvent *event, Region
                            region ));

/******************************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 ******************************************************************************/
#include "f_graphutils.h"
#include "f_rendering.h"

/**************************************************************************
 * INTERNAL (STATIC) DATA: 
 **************************************************************************/
#define offset(field) XtOffset(GraphWidget, graph.field)
static XtResource resources[] = {
    /* {name, class, type, size, offset, default_type, default_addr}, */
    { XtNgraph, XtCGraph, XtRGraph, sizeof(void *),
	offset(root), XtRPointer, NULL },
    { XtNgraphName, XtCString, XtRString, sizeof(char *),
	offset(name), XtRString, (XtPointer)"UnNamed"},
    { XtNgravity, XtCGravity, XtRGravity,  sizeof(enum Gravity),
	offset(gravity), XtRImmediate, (XtPointer)LeftRight},
    { XtNlayout, XtCLayout, XtRLayout,  sizeof(enum Layout),
	offset(layout), XtRImmediate, (XtPointer)NotDone},
    { XtNspaceX, XtCSpace, XtRInt, sizeof(int),
	offset(space_x), XtRImmediate, (XtPointer)20}, 
    { XtNspaceY, XtCSpace, XtRInt, sizeof(int),
	offset(space_y), XtRImmediate, (XtPointer)20},
    { XtNstartX, XtCPosition, XtRInt, sizeof(int),
	offset(start_x), XtRImmediate, (XtPointer)20}, 
    { XtNstartY, XtCPosition, XtRInt, sizeof(int),
	offset(start_y), XtRImmediate, (XtPointer)20},
    { XtNnodeSize, XtCSpace, XtRInt, sizeof(int),
	offset(nodesize), XtRImmediate, (XtPointer)10},
    { XtNscale, XtCScale, XtRInt, sizeof(int),
	offset(scale), XtRImmediate, (XtPointer)FIX_OFFSET}, 
    { XtNdrawNode, XtCCallback, XtRPointer, sizeof(void *),
	offset(DrawNode), XtRImmediate, (XtPointer)DefDrawNode}, 
    { XtNdrawLink, XtCCallback, XtRPointer, sizeof(void *),
	offset(DrawLink), XtRImmediate, (XtPointer)DefDrawLink}, 
    { XtNnodeHit, XtCCallback,  XtRImmediate, sizeof(void *),
	offset(NodeHit), XtRImmediate, (XtPointer)DefNodeHit}, 
    { XtNlocateNode, XtCCallback,  XtRImmediate, sizeof(void *),
	offset(LocateNode), XtRImmediate, (XtPointer)DefLocateNode}, 
    { XtNgraphValue, XtCGeneric, XtRPointer, sizeof(void *),
	offset(value), XtRPointer, (XtPointer)NULL}
};
#undef offset


/* Action Table */
XtActionsRec graphActionsTable[] = {
  {"selectNode", (XtActionProc)DetectHit}
};

/* Translation Table */
char graphTranslationTable[] = "<Btn1Down>:	selectNode()";

/******************************************************************************
 * EXTERNALLY-AVAILABLE	DATA FOUND IN THIS MODULE:
 ******************************************************************************/
GraphClassRec graphClassRec = {
  { /* core fields */
    /* superclass		*/	(WidgetClass) &widgetClassRec,
    /* class_name		*/	"Graph",
    /* widget_size		*/	sizeof(GraphRec),
    /* class_initialize		*/	NULL,
    /* class_part_initialize	*/	NULL,
    /* class_inited		*/	FALSE,
    /* initialize		*/	ClearGraphPart, 
    /* initialize_hook		*/	NULL,
    /* realize			*/	XtInheritRealize, 
    /* actions			*/	graphActionsTable, 
    /* num_actions		*/	XtNumber(graphActionsTable),
    /* resources		*/	resources,
    /* num_resources		*/	XtNumber(resources),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	XtExposeCompressSeries,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	(XtWidgetProc)Destroy,
    /* resize			*/	NULL,
    /* expose			*/	(XtExposeProc)Redisplay,
    /* set_values		*/	NULL,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	graphTranslationTable, 
    /* query_geometry		*/	XtInheritQueryGeometry,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,
    /* extension		*/	NULL
    }
};
WidgetClass graphWidgetClass = (WidgetClass)&graphClassRec;



/******************************************************************************
 * LOCAL DEFINES, STRUCTS, TYPEDEFS, ETC.:
 ******************************************************************************/
#define FONTNAME "6x10"

/******************************************************************************
 * EXTERNAL DATA STRUCTURES USED BY THIS MODULE:
 ******************************************************************************/
/* None */

/*  */
/*ARGSUSED*/
/**********************************************************************
 * Function: static void Redisplay(THREE PARAMETERS)
 * 
 * Parameters:
 *	GraphWidget widget
 *	XEvent *event
 *	Region region
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void Redisplay(widget, event, region)
  GraphWidget widget;
  XEvent *event;
  Region region;
{

  /* Create the Graphics Context and load the font if not already done! */
  if (widget->graph.gc==NULL) {
    XGCValues value;

    /* Create GC. */
    value.foreground = BlackPixelOfScreen(XtScreen(widget));
    if (!(widget->graph.gc = XCreateGC(XtDisplay(widget),
			      XtWindow(widget),
				       GCForeground, &value))) {
      (void)fprintf(stderr,"Failed - Couldn't create graphic context.\n");
      exit(0);
    }

    /* Load font. */
    if (widget->graph.font) {
      XFreeFont(XtDisplay(widget), widget->graph.font);
      widget->graph.font = NULL;
    }

    if ((widget->graph.font = XLoadQueryFont(XtDisplay(widget), FONTNAME))) {
      XSetFont(XtDisplay(widget),
	       widget->graph.gc,
	       widget->graph.font->fid);
    }
    else
      (void)fprintf(stderr, "Warning - Could't access font.\n");
  }

  DrawGraph(widget);
}

/*  */
/*ARGSUSED*/
/**********************************************************************
 * Function: static void Destroy(THREE PARAMETERS)
 * 
 * Parameters:
 *	GraphWidget widget
 *	XEvent event
 *	Region region
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void Destroy(widget, event, region)
  GraphWidget widget;
  XEvent event;
  Region region;
{
  if (widget->graph.font)
    XFreeFont(XtDisplay(widget), widget->graph.font);
  if (widget->graph.gc)
    XFreeGC(XtDisplay(widget), widget->graph.gc);
}

/*  */
/*ARGSUSED*/
/**********************************************************************
 * Function: void ClearGraphPart(GraphWidget req, GraphWidget graph)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
void ClearGraphPart(req, graph)
  GraphWidget req;
  GraphWidget graph;
{
  Dimension width, height;
  fixpoint scale = graph->graph.scale / FIX_OFFSET;
  int x = graph->graph.root->x;
  int y = graph->graph.root->y;

  graph->graph.gc = NULL;
  graph->graph.font = NULL;

  /* Calculate the position of the nodes,  if it's not already done. */
  if (graph->graph.layout == NotDone) {
    Untouch(graph->graph.root);
    (void)ComputeDistances(graph->graph.gravity,
		     graph->graph.space_x,
		     graph->graph.space_y,
		     graph->graph.root, 0, 0);
    graph->graph.root->x = graph->graph.start_x;
    graph->graph.root->y = graph->graph.start_y;
    Untouch(graph->graph.root);
    ComputePositions(graph->graph.root);
    graph->graph.layout = Done;
    graph->core.width=0;
    graph->core.height=0;
  }

  /* Compute the size. */
  if (graph->core.width!=0)
    return;
  width = GraphWidth(graph->graph.root)*scale + x + 50;
  height = GraphHeight(graph->graph.root)*scale + y + 50;
  if (XtIsRealized((Widget)graph)) {
    XtVaSetValues((Widget)graph,XtNwidth,width, XtNheight,height, NULL);
  } else {
    graph->core.width = width;
    graph->core.height = height;
  }
}

