/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	aim_version.c
 *
 * SCCSINFO:		@(#)aim_version.c	1.6 6/2/94
 *
 * ORIGINAL AUTHOR(S):  David Partain, 1992-02-25
 *
 * MODIFICATIONS:
 *	<list mods here>
 *
 * DESCRIPTION:
 *
 * This tiny little module contains two strings which contain interim
 * version numbers for xlincks and ttyaim.  They are printed upon login in
 * order to distinguish between "minor" versions of the software which
 * have been compiled but which do not warrant updating the file which
 * contains the "major" version of the software.  Basically whatever you
 * want to put as distinguishing your updates from the previous is
 * appropriate.
 *********************************************************************
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 *********************************************************************
 * void print_aim_version()
 */
/*********************************************************************
 * INCLUDES:
 *********************************************************************/
#include "config.h"	/* includes system dependent includes */
#include "f_aim_version.h"

/*********************************************************************
 * EXTERNALLY-AVAILABLE	DATA FOUND IN THIS MODULE:
 *********************************************************************/
char aim_version[] = 
"xlincks LINCKS interface, version 1.3 (1994-06-01)";

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
/* none */

/***************************************************************
 * Function: void print_aim_version()
 *
 * Prints out the current version of the Application Interface Manager
 * (AIM)
 */
void print_aim_version()
{
  (void)printf("\n\t%s\n\n", aim_version);
}
