/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	monitor.h
 *
 * SCCSINFO:		@(#)monitor.h	1.5 6/1/94
 *
 * ORIGINAL AUTHOR(S):  ???, 23 Dec, 1986
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 *  This file contains all constants, data structures and macro
 *  definitions for the monitor.
 */

#ifndef MONITOR_H
#define MONITOR_H

#include "machine.h"

/* Type definitions */

/* Index file/table definitions */

/* Index table data structure */
typedef struct {
    LABEL label;
    int   filenum;
    SEEK  filepos;
#define UNDEFINED_ENTRY (-1)
    unsigned short wrperm;
    unsigned short rdperm;
    int   checkno;
    FLAGS flags;
    unsigned short patch_for_24_bytes_record;
} INDEX;

/* Indextable size definitions */
#define INDEXSIZE	(sizeof(INDEX))
#define INDEXMEMBERS	7
#define INDEXTABLESIZE  1024

/* Flag field definitions,  see also dbserver.h */
#ifndef MONITOR_STATUS_DEFINED
#define MONITOR_STATUS_DEFINED
#define DELETED      1
#define LOCKED       2
#define NOENTRY      4
#define NOWRITEPERM  8
#define NOREADPERM  16
#define LOCKFAIL    32
#define NOTLOCKED   32
#define CREATEFAIL  64
#define SYSERR     128
#endif

    
/* Type conversion definitions (not used) */
#define SCANINDEXENTRIES(e) &e->label, &e->filenum, &e->filepos, &e->wrperm, \
                            &e->rdperm, &e->checkno, &e->flags
#define PRINTINDEXENTRIES(e) e->label, e->filenum, e->filepos, e->wrperm, \
                            e->rdperm, e->checkno, e->flags
#define SCANINDEXFORMAT "%ld %d %ld %h %h %d %c"
#define PRINTINDEXFORMAT "%ld %d %ld %d %d %d %c"



/* Molecule file definitions */
#define MAXMOLFILESIZE 100000



/* Data file definitions */
#define MAXDATAFILESIZE 10000000



/* Protection lists definitions */

/* Data structure definition */
typedef struct prot {
    UID uid;
    struct prot *p_next;
} PROT;

/* Protection lists size definitions */
#define PROTLISTSIZE 512
#define PROTSIZE sizeof(PROT)



/* Lock list definitions */

/* Lock list data structure */
typedef struct lock {
	LABEL molecule;
	UID owner;
	TIME time;
	struct lock *l_next;
} LOCK;

/* Lock list size definition */
#define LOCKSIZE sizeof(LOCK)

/* Label information */
typedef struct labelinfo {
    LABEL label;
    void *infop;
    struct labelinfo *nextp;
} LabelInfo;

/* DBS queue */
typedef struct dbsqueue {
    pid_t pid;
    void *infop;
    struct dbsqueue *nextp;
} DBSQueue;

/* Editing information */
typedef struct peninfo {
    pid_t pid;
    char *username;
    struct peninfo *nextp;
} PENInfo;

/* Error code definitions */

/* Codes */
#ifndef MONITOR_ERRORS_DEFINED
#define MONITOR_ERRORS_DEFINED    
#define ER_CREATE 1
#define ER_MALLOC 2
#define ER_LSEEK 3
#define ER_WRITE 4
#define ER_READ 5
#define ER_OPEN 6
#define ER_INIT 7
#define ER_MAXMOLFILES 8
#define ER_MAXDATFILES 9
#define ER_SEEKADR 10
#define ER_HASH 11
#define ER_IT_NOSPACE 12
#define ER_EOF 13
#define ER_NOLOCKFOUND 14
#define ER_ILLEGALPERM 15
#define ER_SUPER 16
#define ER_CALL 17

#define ER_SYSERR 6
#endif


/* Constant definitions */
#define SEARCHDIST 3
#define READ 0
#define WRITE 1
#define MAY 0
#define MUST -1
#define SET 1
#define CLEAR 0
#define TIMEOUT 60
#define MAXNOOFFILES 256

/************************************************************************
 *  Macro definitions:
 *      Hash(l): takes label and converts it to index table position
 *      ConvToSeek(l): takes label and converts it to file seek address
 *      ConvToLabel(s): takes seek address and converts to label
 *      ConvToIndex(e,b): takes buffer and converts its contents to
 *                        index entry
 *      ConvToBuff(b,e): takes entry and converts it to buffer
 */

#define Hash(l) ((l >> 1) % INDEXTABLESIZE)

#define ConvToSeek(l)  (((off_t)(l)) - 256)
#define ConvToLabel(s) (((LABEL)(s)) + 256)

#define ConvToIndex(e, b) sscanf(b, SCANINDEXFORMAT, SCANINDEXENTRIES(e))
#define ConvToBuff(b, e) sprintf(b, PRINTINDEXFORMAT, PRINTINDEXENTRIES(e))

#endif /* MONITOR_H */
