/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	lincks.h
 *
 * SCCSINFO:		@(#)lincks.h	1.6 6/1/94
 *
 * ORIGINAL AUTHOR(S):  Peter berg, Arne Stahre
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 *	This is the Universal Lincks Include File. It contains essential
 *	data structure definitions and some system constants
 *	RPC procedure and program numbering is defined here
 */

#ifndef LINCKS_H
#define LINCKS_H

#include "machine.h"

#define UNKNOWN	 ((UID) -1)
#define SUPERUSER ((UID)  0)

/* File entry size definition */
#define FILEMOLSIZE sizeof(FILEMOL)

/* Universal constants */
#define NOBLINKS  1	/* Signals that back-links should not be handled */

#ifndef MAXNAMELEN
#define MAXNAMELEN 48
#endif	/* MAXNAMELEN */

#define MAXMESSAGELEN 32768
#define MAXOPENFILES 20
#define CHILDMINTIME 60

#ifndef NULL
#  define NULL (0L)
#endif

#ifndef SUCCESS
#define SUCCESS   0
#endif
#ifndef FAIL
#define FAIL    (-1)
#endif

/* Monitor RPC procedure calls */
#define ACCESS            ((u_long) 1)
#define LOCKACCESS        ((u_long) 2)
#define UNLOCK            ((u_long) 3)
#define SETPROT           ((u_long) 4)
#define GETPROT           ((u_long) 5)
#define DELETE            ((u_long) 6)
#define UNDELETE          ((u_long) 7)
#define GETCHECKNO        ((u_long) 8)
#define UPDATECHECKNO     ((u_long) 9)
#define UPDATEENTRY       ((u_long) 10)
#define CREATE            ((u_long) 11)
#define KILL              ((u_long) 12)
#define RESTART           ((u_long) 13)
#define CHECK             ((u_long) 14)
#define REMOVE            ((u_long) 15)
#define POLL              ((u_long) 16)

/* Molecule file entry data structure definition */

/* File entry */
typedef struct {
	SEEK  flink_filepos;		
	int   flink_size;

	SEEK  blink_filepos;
	int   blink_size;

	SEEK  attr_filepos;
	int   attr_size;

	SEEK  image_filepos;
	int   image_size;
} FILEMOL;

/*  */
/* XDR functions data definitions */

/* Access and lock */ 
typedef struct { 
	int   a_status; 
	char *a_filename;
	SEEK  a_filepos;
	int   a_checkno;
} A_ENTRY;

/* Getchecknum, updatechecknum */
typedef struct {
	int c_status;
	int c_checkno;
} C_ENTRY;

/* Getprot */
typedef struct {
	int p_status;
	unsigned short p_wrperm;
	unsigned short p_rdperm;
} P_ENTRY;

/* Createentry */
typedef struct {
	int   n_status;
	LABEL n_label;
	char *n_filename;
	SEEK  n_filepos;
	int   n_checkno;
} N_ENTRY;

/*
 * Parameters for: access, lock, unlock, getprot, delete, undelete
 * getcheckno, updatecheckno
 */
typedef struct {
	LABEL l_label;
	UID l_uid;
} L_ENTRY;

/* Parameters for: setprot */
typedef struct {
	LABEL s_label;
	UID s_uid;
	unsigned short s_wrperm;
	unsigned short s_rdperm;
} S_ENTRY;

/* Parameters for: updateentry */
typedef struct {
	LABEL u_label;
	UID   u_uid;
	char *u_filename;
	SEEK  u_filepos;
} U_ENTRY;

/* Parameters for: remove, check */
typedef struct {
    LABEL r_label;
    pid_t r_pid;
    char *r_username;
    int r_flag;
} R_ENTRY;

/* Edit info */
typedef struct {
    LABEL e_label;
    char *e_usernames;
} E_ENTRY;

/* Parallell editing notification */
typedef struct penmsg {
    WS_LABEL index;
    int type;
    char *msg;
} PEN_MESSAGE;

#endif /* LINCKS_H */
