/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	newfiles.c
 *
 * SCCSINFO:		@(#)newfiles.c	1.8 5/3/94
 *
 * ORIGINAL AUTHOR(S):  ???, 1987-03-07
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 *	This file contains NewMolFile, NewDataFile, and MakeName.
 */
/*********************************************************************
 * INCLUDES:
 *********************************************************************/
#include "config.h"	/* includes system dependent includes */

#include <time.h>

#include "lincks.h"
#include "monitor.h"
#include "xconfig.h"
#include "libshared.h"

/*********************************************************************
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 *********************************************************************/
#include "f_newfiles.h"

/*********************************************************************
 * EXTERNALLY-AVAILABLE	DATA FOUND IN THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
#include "f_monerrors.h"

/* libc */
#if defined(sun) || defined(__sun__)
extern time_t time P_((time_t *tloc));
#endif

/*********************************************************************
 * EXTERNAL DATA STRUCTURES USED BY THIS MODULE:
 *********************************************************************/
extern int currentmol;		/* monitormain.c */
extern int currentdata;		/* monitormain.c */
extern int currentmolfd;	/* monitormain.c */
extern int currentdatafd;	/* monitormain.c */
extern char *molnames[];	/* monitormain.c */
extern char *datanames[];	/* monitormain.c */

/*********************************************************************
 * LOCAL DEFINES, STRUCTS, TYPEDEFS, ETC.:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL (STATIC) DATA: 
 *********************************************************************/
/* none */

/*  */
/**********************************************************************
 * Function: int NewMolFile(char *name)
 * 
 * Creates a new molecule file using name with extension .mol
 *
 * Modifications:
 *      <list mods with name and date>
 */
int NewMolFile(name)
  char *name;
{
	char fname[MAXPATHLEN];
	int newfd;
	FILE *molfp, *fopen();
#ifdef HAVE_BROKEN_PRINTF
	static char null[1] = { '\0' };
	if ( name == NULL)
	  name = &null[0];
#endif /* HAVE_BROKEN_PRINTF */
	/* Make complete file name */
        (void)sprintf(fname, "%s.mol", name);

	/* Check if possible to add another file */
	if (currentmol + 1 >= MAXNOOFFILES) {
		Error(ER_MAXMOLFILES,
		      "NewMolFile: exceeded maximum number of molecule files");
		return(FAIL);
	}

	/* Make room for file name in table */
        if ((molnames[currentmol + 1] = malloc((ALLOC_T)strlen(fname) + 1))
            == NULL) {
		Error(ER_MALLOC, "NewMolFile: no more memory");
		return(FAIL);
	}
        (void)strcpy(molnames[++currentmol], fname);

	/* Create new file */
	if ((newfd = creat(fname, 0600)) < 0) {
	    Error(ER_CREATE, "NewMolFile: could not create %s", fname);
	    free(molnames[currentmol--]);
	    return(FAIL);
	}

	/* Append new name to names file */
	if ((molfp = fopen(MOLNAMES, "a")) == NULL) {
	    Error(ER_OPEN, "NewMolFile: could not open %s", MOLNAMES);
	    return(FAIL);
	}
        (void)fprintf(molfp, "%s\n", fname);
        (void)fclose(molfp);

	/* Close current molecule file */
        (void)close(currentmolfd);

	/* Return new file descriptor */
	return(newfd);
}

/*  */
/**********************************************************************
 * Function: int NewDataFile(char *name)
 * 
 * Creates a new data file using name with extension .dat
 *
 * Modifications:
 *      <list mods with name and date>
 */
int NewDataFile(name)
  char *name;
{
	char fname[MAXPATHLEN];
	int newfd;
	FILE *datafp, *fopen();
#ifdef HAVE_BROKEN_PRINTF
	static char null[1] = { '\0' };
	if ( name == NULL)
	  name = &null[0];
#endif /* HAVE_BROKEN_PRINTF */
	/* Make complete file name */
        (void)sprintf(fname, "%s.dat", name);

	/* Check if possible to add another file */
	if (currentdata + 1 >= MAXNOOFFILES) {
		Error(ER_MAXDATFILES,
		      "NewDataFile: exceeded maximum number of data files");
		return(FAIL);
	}

	/* Make room for file name in table */
        if ((datanames[currentdata + 1] = malloc((ALLOC_T)strlen(fname) + 1))
            == NULL) {
		Error(ER_MALLOC, "NewDataFile: no more memory");
		return(FAIL);
	}
        (void)strcpy(datanames[++currentdata], fname);

	/* Create new file */
	if ((newfd = creat(fname, 0600)) < 0) {
	    Error(ER_CREATE, "NewDataFile: could not create %s", fname);
	    free(datanames[currentdata--]);
	    return(FAIL);
	}

	/* Append new name to names file */
	if ((datafp = fopen(DATANAMES, "a")) == NULL) {
	    Error(ER_OPEN, "NewDataFile: could not open %s", DATANAMES);
	    return(FAIL);
	}
        (void)fprintf(datafp, "%s\n", fname);
        (void)fclose(datafp);

	/* Close current data file */
        (void)close(currentdatafd);

	/* Return new file descriptor */
	return(newfd);
}

/*  */
/**********************************************************************
 * Function: char *MakeName()
 * 
 * Creates a string with the current date and time
 *
 * Modifications:
 *      <list mods with name and date>
 */
char *MakeName()
{
	struct tm *t, *localtime();
	time_t secs;
	static char tname[MAXPATHLEN];

	/* Take present system time and convert to string */
        (void)time(&secs);
	t = localtime(&secs);
        (void)sprintf(tname, "%02d%03d%02d%02d%02d",
			     t->tm_year, t->tm_yday,
			     t->tm_hour, t->tm_min, t->tm_sec);

	/* Return pointer to time string */
	return(tname);
}


