/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	flags.c
 *
 * SCCSINFO:		@(#)flags.c	1.7 6/1/94
 *
 * ORIGINAL AUTHOR(S):  ???, Aug 12, 1987
 *
 * MODIFICATIONS:
 *      1994-05-11 Martin Sjlin. Added separate wrprotlists to
 *                 separate out the read/write protection before
 *                 we add some "real" protection/access features ...
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 */
/*********************************************************************
 * INCLUDES:
 *********************************************************************/
#include "config.h"	/* includes system dependent includes */
#include "lincks.h"
#include "monitor.h"

/*********************************************************************
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 *********************************************************************/
#include "f_flags.h"

/*********************************************************************
 * EXTERNALLY-AVAILABLE	DATA FOUND IN THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
#include "f_monerrors.h"
#include "f_putentry.h"

/*********************************************************************
 * EXTERNAL DATA STRUCTURES USED BY THIS MODULE:
 *********************************************************************/
extern PROT *rdprotlists[];
extern PROT *wrprotlists[];

/*********************************************************************
 * LOCAL DEFINES, STRUCTS, TYPEDEFS, ETC.:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL (STATIC) DATA: 
 *********************************************************************/
/* none */

/*  */
/**********************************************************************
 * Function: int ReadProtFile(char *filename, PROT *protlist[], char *monnam, int errflg );
 * 
 * Read the specified protection file (filename) into memory and hangs
 * the strucutre on protlist, returns errors if errflg == SUCCESS.
 *
 * Modifications:
 *      <list mods with name and date>
 */
int ReadProtFile(filename, protlist, monnam, errflg)
  char *filename;
  PROT *protlist[];
  char *monnam;
  int   errflg;
{
    FILE *protectfp;
    int uid;
    int grp;

    /* Open protection file for reading */
    if ((protectfp = fopen(filename, "r")) == NULL) {
      if (errflg == SUCCESS)
	Error(ER_INIT, "%s: could not open %s", monnam, filename);
      return(FAIL);
    }

    /* Read file contents into protection lists */
    /* Lists are organized by protection group number */
    /* The file is organized by uid */
    while (fscanf(protectfp, "%d", &uid) != EOF) {
      while (fscanf(protectfp, "%d", &grp) == 1) {
	if (protlist[grp] == NULL) {
	  if ((protlist[grp] = (PROT *)malloc(PROTSIZE)) == NULL) {
	    Error(ER_INIT, "%s: no more memory for protlists",
		  monnam);
	    (void) fclose(protectfp);
	    return(FAIL);
	  }
	  protlist[grp]->uid    = uid;
	  protlist[grp]->p_next = NULL;
	}
	else {
	  PROT * protlistp = protlist[grp];
	  while (protlistp->p_next != NULL) 
	    protlistp = protlistp->p_next;
	  
	  if ((protlistp->p_next = (PROT *)malloc(PROTSIZE)) == NULL) {
	    Error(ER_INIT, "%s: no more memory for protlists",
		  monnam);
	    (void) fclose(protectfp);
	    return(FAIL);
	  }
	  protlistp->p_next->uid    = uid;
	  protlistp->p_next->p_next = NULL;
	}
      }
      if (getc(protectfp) == EOF)
	break;
    } /* while */

    (void)fclose(protectfp);
    return(SUCCESS);
}

/*  */
/**********************************************************************
 * Function: int CheckPerm(UID uid, INDEX *entry, int mode)
 * 
 * Checks that the uid specified exists in the protection
 * list specified be entry and access mode.
 * Returns SUCCESS if verification succeeded
 *
 * Modifications:
 *      <list mods with name and date>
 */
int CheckPerm(uid, entry, mode)
  UID uid;
  INDEX *entry;
  int mode;
{
    unsigned short permgrp;
    PROT *protlist = NULL;

    /* Establish which mode of access permission to check for */
    if (mode == READ) 
      permgrp = entry->rdperm;
    else if (mode == WRITE) 
      permgrp = entry->wrperm;
    else return(FAIL);

    /* Check for valid permission group number */
    if (permgrp >= PROTLISTSIZE) {
	Error(ER_ILLEGALPERM,
	      "CheckPerm: permission group referance out of bounds");
        return(FAIL);
    }

    /* Select the correct list ... */
    protlist = (mode == WRITE) ? wrprotlists[permgrp] : rdprotlists[permgrp];

    /* Scan appropriate list for uid */
    while (protlist) {
      if (protlist->uid == uid)
        return(SUCCESS);
      else protlist = protlist->p_next;
    }

    /* uid not found in list, return FAIL */
    return(FAIL);
}

/*  */
/**********************************************************************
 * Function: int ChangeProt(unsigned int wrprotgrp, rdprotgrp, INDEX *entry, int fd)
 *
 * Sets molecule protection modes.  Also changes file entry
 * Uses WriteEntry
 * 
 * Modifications:
 *      <list mods with name and date>
 */
int ChangeProt(wrprotgrp, rdprotgrp, entry, fd)
  unsigned int wrprotgrp, rdprotgrp;
  INDEX *entry;
  int fd;
{
    /* Change protection groups */
    entry->rdperm = rdprotgrp;
    entry->wrperm = wrprotgrp;

    /* Write change to file as well */
    if (WriteEntry(entry, fd) < 0)
      return(FAIL);
	
    return(SUCCESS);
}

/*  */
/**********************************************************************
 * Function: int CheckDel(INDEX *entry)
 * 
 * Checks if the deleted bit is set in an entry.
 * If so, return FAIL.
 *
 * Modifications:
 *      <list mods with name and date>
 */
int CheckDel(entry)
  INDEX *entry;
{
    /* Check deleted bit in flags field */
    if (entry->flags & DELETED) 
      return(FAIL);
    else
      return(SUCCESS);
}

/*  */
/**********************************************************************
 * Function: int DelMark(INDEX *entry, int mode, int fd)
 * 
 * Sets the deleted bit in index entry and writes to file
 * Uses WriteEntry
 *
 * Modifications:
 *      <list mods with name and date>
 */
int DelMark(entry, mode, fd)
  INDEX *entry;
  int mode, fd;
{
	/* Set or clear the delete flag depending on mode */
	if (mode == SET) 
		entry->flags |= DELETED;
	else
		entry->flags &= ~DELETED;

	/* Save to file */
	if (WriteEntry(entry, fd) < 0)
		return(FAIL);
	else
		return(SUCCESS);
}

/*  */
/**********************************************************************
 * Function: int IncrChkNo(INDEX *entry, int fd)
 * 
 * Increments the molecule check number and writes to file
 * Uses WriteEntry
 *
 * Modifications:
 *      <list mods with name and date>
 */
int IncrChkNo(entry, fd)
  INDEX *entry;
  int fd;
{
	/* Increment check number */
	entry->checkno += 1;
	/* Save to file */
	if (WriteEntry(entry, fd) < 0)
		return(FAIL);
	else
		return(SUCCESS);
}
