/* -*- Mode: C -*- */
/* LList.cc - LineList implementation code
 * Created by Robert Heller on Tue Mar 24 19:25:29 1992
 *
 * ------------------------------------------------------------------
 * Home Libarian by Deepwoods Software
 * Common Class library implementation code
 * ------------------------------------------------------------------
 * Modification History:
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 * 
 * 
 * Copyright (c) 1991,1992 by Robert heller (D/B/A Deepwoods Software)
 *        All Rights Reserved
 * 
 */

#include <LList.h>

int LineList::numblocks;	// current number of allocated blocks
LineList* LineList::blocks[maxblocks]; // allocated LineLists
LineList* LineList::freelist;	// linked list of available LineLists

static LineList dummy;		// dummy LineList

// Helper function to allocate an additional block of 100 LineLists
void LineList::moreblocks ()
{
	// Have we run out of blocks?
	if (numblocks < maxblocks) {
		// if not...  bump block counter
		int iblock = numblocks++;
		// snarf some memory
		LineList* p = blocks[iblock] = (LineList*) new char[sizeof(LineList)*blocksize];
		// build linked list.  nextline field doubles as next pointer.
		for (int ic = 1; ic < blocksize; ic++) {
			p->nextline = (p+1);
			p++;
		}
		// point last tail at current freelist
		p->nextline = freelist;
		// and set freelist head to first LineList in fresh block
		freelist = blocks[iblock];
	}
}
			
// overloaded new operator for LineLists
void* LineList::operator new (long bytes)
{
	// if freelist is empty, get more memory
	if (dummy.freelist == 0) dummy.moreblocks();
	// if freelist is still empty, return null
	if (dummy.freelist == 0) return(0);
	// get pointer to head of list
	LineList* newLineList = dummy.freelist;
	// set freelist to next LineList in the list
	dummy.freelist = (LineList*) newLineList->nextline;
	// unlink new LineList from the list
	newLineList->nextline = 0;
	// retun new LineList
	return(newLineList);
}

// overloaded delete operator for LineLists
void LineList::operator delete(void* vptr)
{
	// convert pointer to a LineList*
	LineList* ptr = (LineList*) vptr;
	// if a null pointer, just return
	if (ptr == 0) return;
	// has this LineList already be freed?
	for (LineList* p = dummy.freelist; p != 0; p = (LineList*) p->nextline) {
		if (p == ptr) return;	// if so, don't free it again
	}
	// link onto head of free list
	ptr->nextline = dummy.freelist;
	dummy.freelist = ptr;
}

void FreeLineList(LineList* l)
{
	if (l == (LineList*) 0) return;
	for (LineList* n = l->nextline; l != (LineList*) 0;) {
		delete l;
		l = n;
		if (l != (LineList*) 0) n = l->nextline;
	}
}

