/*
 * Various tunable parameters.  This should appear before any other local
 * header file.
 */

/* Are you using a Berkeley flavor of Unix? */
#undef 	BSD

/* Use the dialing routines specific to the AT&T Unix PC 7300/3b1 */
#undef	UNIXPC

/* Older versions of curses(3) use termcap in lieu of terminfo */
#undef 	OLDCURSES

/* Should a missing video attribute be promoted to standout? */
#undef 	NOPROMOTE

/* Should Pcomm make a log of all phone calls? */
#undef  LOG_CALLS

/* The name of the log file (if used).  */
#define	LOG_FILE	"/usr/adm/phone.calls"

/* Should long distance (toll) calls be limited to a specific group? */
#undef	LIMIT_LD

/* The name of the privileged group for limiting long distance calls */
#define	GROUP_NAME	"uucp"

/* The path to the line printer program */
#define	LPR		"lp -s"

/* The path to the "pretty" printer program (if none, use "pr | lp") */
#define	LPRINT		"pr | lp -s"

/* The path to the default directory containing the Pcomm support files */
#define	DEFAULT_DIR	"/usr/local/lib/pcomm"

/* The path to the directory where UUCP locks are found */
#define	LOCK_DIR	"/usr/spool/lock"

/* Do the lock files use ASCII encoded PID's? */
#define	ASCII_PID

/* Fold the last character of the lock to lower case? */
#undef	XENIX_LOCKS

/* Use the new SVR4 lock format? */
#undef	SVR4_LOCKS

/* Does the status line scroll up on "magic cookie" terminals? */
#undef	XMC_BROKE

/* Does the alarm() system call work correctly with the wgetch() function? */
#undef	WGETCH_BROKE

/* Does the O_NDELAY mode tend to stick around when asked to leave? */
#undef	O_NDELAY_BROKE

/* The size of the serial port character buffer (or Stream buffer) */
#define	CLIST_SIZ	64

/* The size of the input buffer (should be about the same as CLIST_SIZ) */
#define	INPUT_BUF	64

/* The size of the output buffer (should be about one half INPUT_BUF) */
#define	OUTPUT_BUF	32

/* Does memmove() exist or is memcpy() well behaved when overlapping? */
#define	MEMMOVE(a,b,c)	memmove(a,b,c)
/* #define	MEMMOVE(a,b,c)	memcpy(a,b,c) */
/* #define	MEMMOVE(a,b,c)	bcopy(b,a,c) */

/* Does your Unix allow flip-flop between real and effective user IDs? */
#undef	SETUID_BROKE

/* Does your system have the strstr() function? */
#define	HAVE_STRSTR

/* Does your system have the usleep() function? */
#define	HAVE_USLEEP

/* Does your system have the truncate() system call? */
#define	HAVE_TRUNCATE

typedef void SIG_TYPE;
/* typedef int SIG_TYPE; */

#ifdef BSD
#define	strchr	index
#define	strrchr	rindex
#endif /* BSD */
