/*
   qsend.c - Cover page generator and file wrapper for Renaissoft Qfax 1.0
   (c) 1994 Robert LeBlanc and Renaissoft
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "qfax.h"

char *fullname(char *username);

char *fullname(char *username)
{
/*
   Searches the GECOS field of the /etc/passwd file to get the user's
   full name.
*/

  char full[LONGLEN];
  char tmp[LONGLEN];
  char cmd[LINELEN];
  char line[LINELEN];
  FILE *ipp;
  int done, k, pos, ctr;

  sprintf(tmp, "%s:", username);
  sprintf(cmd, "egrep '%s' /etc/passwd", tmp);
  ipp = popen(cmd, "r");
  fgets(line, 255, ipp);
  pclose(ipp);
  ctr = 0;
  pos = 0;
  while ((pos < strlen(line)) && (ctr < 4)) {
    if (line[pos] == ':')
      ctr++;
    pos++;
  }
  k = 0;
  done = 0;
  while ((pos < strlen(line)) && (!done)) {
    if ((line[pos] == ',') || (line[pos] == ':'))
      done = 1;
    else
      full[k++] = line[pos];
    pos++;
  }
  full[k] = '\0';
  return(full);
}

void get_send_info(Fax *f)
{
/*
   Gets the following cover page information from the user:

           Attn (alias): <person>
	     At (alias): <company>
	             Re: <subject>
	       Comments: <comments>

   The following values are gleaned from the system:

           From (alias): <person>
       From (full name): <person>
                   Date: <system date>
	     Time Stamp: <stamp value>

   In short, when this routine is done, we have exactly the same
   information we'd have if we'd parsed through a mail header.
*/

  strcpy(f->fperson.username, getenv("USER"));
  strcpy(f->fperson.fullname, fullname(f->fperson.username));
  strcpy(f->date, timestring());
  strcpy(f->tstamp, time_stamp());
  printf("\nQsend 1.0 (c) 1994 Renaissoft\n\n");
  printf("Attn (alias): ");
  scanf("%s", f->tperson.alias);
  if (strcmp(f->tperson.alias, "") == 0)
    exit(EXIT_FAILURE);
  printf("  At (alias): ");
  scanf("%s", f->tcompany.alias);
  if (strcmp(f->tcompany.alias, "") == 0)
    exit(EXIT_FAILURE);
  getc(stdin);
  printf("          Re: ");
  strcpy(f->subject, getsline(stdin));
  printf("    Comments: ");
  strcpy(f->comments, getsline(stdin));
}

void make_fax_page(Fax *f, char *file)
{
/*
   Convert a file (ASCII or PostScript) to G3 format, or simply pass
   along a G3 file to Efax, doing some fancy footwork to renumber the
   pages so that multiple files can be sent as one fax.  This kind of
   consolidation is necessary for the fax spooler (Qrun) to work
   properly.
*/

  char cmd[LINELEN];
  int i, pages;
  FILE *ifp;

  if ((strlen(file) > 4) && (file[strlen(file)-4] == '.')
                         && (atoi((file+strlen(file)-3)) > 0)) {

    /*
       This file already has a *.[0-9][0-9][0-9] extender, so we assume
       it's already a G3 fax, just as Efax does.  All we have to do is
       put it in the proper sequence in our list of pages by renaming it
       appropriately.
    */

    ++(f->pages);
    sprintf(cmd, "cp %s %s/fax.%s.%s.%03d", file, FAXQUEUE,
	    f->fperson.username, f->tstamp, f->pages);
    system(cmd);

  } else {

    /*
       This is not likely a G3 fax file, so we have to use "fax make" to
       do the dirty work for us.  Then we simply rename the result to
       put it into the proper order.

       Since "fax make" wants to number pages "001...002...", we use the
       convention of using the filename format "tmp.user.timestamp"
       instead of "fax.user.timestamp"; when we're done, we rename the
       "tmp.*" files to "fax.*" files with the proper page numbers.
    */

    sprintf(cmd, "cp %s %s/tmp.%s.%s", file, FAXQUEUE,
	    f->fperson.username, f->tstamp);
    system(cmd);
    sprintf(cmd, "%s make %s/tmp.%s.%s > /dev/null", FAX, FAXQUEUE,
	    f->fperson.username, f->tstamp);
    system(cmd);
    i = 0;
    pages = 0;
    sprintf(cmd, "%s/tmp.%s.%s.%03d", FAXQUEUE, f->fperson.username,
	    f->tstamp, ++i);
    while ((ifp = fopen(cmd, "r")) != NULL) {
      fclose(ifp);
      pages++;
      sprintf(cmd, "%s/tmp.%s.%s.%03d", FAXQUEUE, f->fperson.username,
	      f->tstamp, ++i);
    }
    for (i = 0; i < pages; i++) {
      ++(f->pages);
      sprintf(cmd, "mv %s/tmp.%s.%s.%03d %s/fax.%s.%s.%03d",
	      FAXQUEUE, f->fperson.username, f->tstamp, (i+1),
	      FAXQUEUE, f->fperson.username, f->tstamp, f->pages);
      system(cmd);
    }
  }
}

void main(int argc, char *argv[])
{
  Fax f;
  int i;

  read_config(&f);               /* load fax parameters */
  get_send_info(&f);             /* get cover page info from user */
  lookup_db(&f);                 /* look up recipient in phonebook */
  f.pages = 0;
  for (i = 1; i < argc; i++) {   /* convert files to fax format and */
    make_fax_page(&f, argv[i]);  /*    order them properly.         */
  }
  make_cover(&f);                /* create a fax cover page */
  insert_cover(&f);              /* make the cover page #1 */
  queue_fax(&f);                 /* put the fax on the spool */
  cleanup(&f);                   /* delete any garbage we created */
}
