/*+-------------------------------------------------------------------------
	baudtest.c
	wht@n4hgf.Mt-Park.GA.US

Alas, on some systems, curses insists on sgtty.h inclusion
which does not get along with termio.h AT ALL
--------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:09-10-1992-14:00-wht@n4hgf-ECU release 3.20 */
/*:08-22-1992-15:39-wht@n4hgf-ECU release 3.20 BETA */
/*:08-28-1991-14:08-wht@n4hgf2-SVR4 cleanup by aega84!lh */
/*:08-23-1991-18:33-wht@n4hgf2-disable force no curses for tty vs. line speed */
/*:07-25-1991-12:59-wht@n4hgf-ECU release 3.10 */
/*:12-04-1990-05:36-wht-creation */

#include <stdio.h>
#include "../ecu_types.h"
#include <termio.h>

extern int iofd;
extern int dumbtty;
extern int report_verbosity;
extern int report_init_complete;
extern char *numeric_revision;

/*+-------------------------------------------------------------------------
	test_tty_and_line_baud()

  if non-multiscreen tty baud rate not at least that
  of the attached line, use no curses, but do be a bit more
  verbose than if tty not char special

--------------------------------------------------------------------------*/
#ifdef TTY_VS_LINE_SPEED_NO_CURSES
void
test_tty_and_line_baud()
{
	struct termio tty_termio;
	struct termio line_termio;

	memset((char *)&tty_termio,0,sizeof(struct termio));
	memset((char *)&line_termio,0,sizeof(struct termio));
	if(ioctl(0,TCGETA,&tty_termio) || ioctl(iofd,TCGETA,&line_termio) ||
	    (((unsigned)tty_termio.c_cflag & CBAUD) <
		(unsigned)((line_termio.c_cflag & CBAUD))))
	{
		dumbtty = 1;
		report_verbosity = 1;
		report_init_complete = 1;
	}

}	/* end of test_tty_and_line_baud */
#endif

/* vi: set tabstop=4 shiftwidth=4: */
/* end of baudtest.c */
