/* CHK=0x80A3 */
/*+-------------------------------------------------------------------------
	proc_error.c - print ecu procedure error
--------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:09-10-1992-14:00-wht@n4hgf-ECU release 3.20 */
/*:08-31-1992-15:12-build_err-creation from ecuerror.h */

#include "ecu.h"
#include "ecuerror.h"

/*+-------------------------------------------------------------------------
	proc_error(erc) - print error message
--------------------------------------------------------------------------*/
void
proc_error(erc)
int erc;
{
	switch(erc)
	{
		case eProcEmpty:
			pputs("empty procedure\n");
			break;
		case eConnectFailed:
			pputs("failed to connect\n");
			break;
		case eNoSwitches:
			pputs("no switch(es) to command\n");
			break;
		case eIllegalCommand:
			pputs("invalid command\n");
			break;
		case eNoMemory:
			pputs("no more memory available\n");
			break;
		case eSyntaxError:
			pputs("syntax error\n");
			break;
		case eIllegalVarNumber:
			pputs("number is invalid or out of range\n");
			break;
		case eIllegalVarType:
			pputs("unrecognized variable type\n");
			break;
		case eNotInteger:
			pputs("integer expected and not found\n");
			break;
		case eCONINT:
			pputs("abort due to interrupt\n");
			break;
		case eInvalidFunction:
			pputs("invalid function name\n");
			break;
		case eMissingLeftParen:
			pputs("did not find expected left paren\n");
			break;
		case eMissingRightParen:
			pputs("did not find expected right paren\n");
			break;
		case eCommaExpected:
			pputs("expected comma not found\n");
			break;
		case eProcStackTooDeep:
			pputs("procedure stack depth exceeded\n");
			break;
		case eInvalidRelOp:
			pputs("invalid relational operator\n");
			break;
		case eInvalidIntOp:
			pputs("invalid integer operator\n");
			break;
		case eInvalidStrOp:
			pputs("invalid string operator\n");
			break;
		case eNotExecutingProc:
			pputs("not executing DO at this time\n");
			break;
		case eInvalidLabel:
			pputs("invalid label\n");
			break;
		case eInternalLogicError:
			pputs("internal logic error ... whoops\n");
			break;
		case eEOF:
			pputs("end of file or read error\n");
			break;
		case eBufferTooSmall:
			pputs("string too long\n");
			break;
		case eNoParameter:
			pputs("expected parameter not found\n");
			break;
		case eBadParameter:
			pputs("bad parameter\n");
			break;
		case eInvalidHexNumber:
			pputs("invalid hexadecimal digit\n");
			break;
		case eInvalidDecNumber:
			pputs("invalid decimal digit\n");
			break;
		case eInvalidOctNumber:
			pputs("invalid octal digit\n");
			break;
		case eInteractiveCmd:
			pputs("interactive command\n");
			break;
		case eNoLineAttached:
			pputs("no line (modem) attached\n");
			break;
		case eBadFileNumber:
			pputs("file number out of range\n");
			break;
		case eNotImplemented:
			pputs("not implemented\n");
			break;
		case eDuplicateMatch:
			pputs("more than one condition matches\n");
			break;
		case eColonExpected:
			pputs("expected colon not found\n");
			break;
		case eLabelInvalidHere:
			pputs("label not allowed on this statement\n");
			break;
		case eNoCloseFrame:
			pputs("missing '}' for '{'\n");
			break;
		case eNoFrame:
			pputs("missing command or command group after 'while' or 'if'\n");
			break;
		case eMissingCommand:
			pputs("expected command not found\n");
			break;
		case eBreakCommand:
			pputs("'break' outside 'while'\n");
			break;
		case eContinueCommand:
			pputs("'continue' outside 'while'\n");
			break;
		case eElseCommand:
			pputs("'else' without matching 'if'\n");
			break;
		case eInvalidVarName:
			pputs("invalid variable name\n");
			break;
		case eNoSuchVariable:
			pputs("variable by this name not defined\n");
			break;
		case eInvalidLogicOp:
			pputs("invalid logical operator\n");
			break;
		case eExpectRespondFail:
			pputs("expect-respond failed\n");
			break;
		case eSwitchesTooLong:
			pputs("switches too long\n");
			break;
		case eProcAttn_GOTO:
			pputs("GOTO detected\n");
			break;
		case eProcAttn_GOTOB:
			pputs("GOTOB detected\n");
			break;
		case eProcAttn_RETURN:
			pputs("RETURN detected\n");
			break;
		case eProcAttn_ESCAPE:
			pputs("ESCAPE detected\n");
			break;
		case eProcAttn_Interrupt:
			pputs("procedure interrupted\n");
			break;
		case eProcAttn_DCDloss:
			pputs("DCD lost during procedure execution\n");
			break;
		case eFATAL_ALREADY:
		case eWARNING_ALREADY:
			break;
		default:
			pprintf("unknown error %x\n",erc);
			break;
	}
} /* end of proc_error */

/* vi: set tabstop=4 shiftwidth=4: */
/* end of proc_error.c */
