/*+-------------------------------------------------------------------------
	pprintf.c - procedure printf

  This module has been hacked a bit to work for ECU applications
  as of its writing.  If you use this with SCO MSC, the ifdefs
  will work in any environment.  Using it without any SCO
  predefines will cause %p to print as a 32-bit linear pointer.
  M_I286 assumes %p is a segmented pointer unless M_SDATA is
  supplied too, in which case %p prints as a 16-bit segment offset.
--------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:09-10-1992-14:00-wht@n4hgf-ECU release 3.20 */
/*:08-22-1992-15:39-wht@n4hgf-ECU release 3.20 BETA */
/*:08-21-1991-02:12-wht@n4hgf-handle char *sprintf */
/*:07-25-1991-12:59-wht@n4hgf-ECU release 3.10 */
/*:01-09-1991-22:31-wht@n4hgf-ISC port */
/*:08-14-1990-20:40-wht@n4hgf-ecu3.00-flush old edit history */

/* based on Portable vsprintf  by Robert A. Larson <blarson@skat.usc.edu> */

/* Copyright 1989 Robert A. Larson.
 * Distribution in any form is allowed as long as the author
 * retains credit, changes are noted by their author and the
 * copyright message remains intact.  This program comes as-is
 * with no warentee of fitness for any purpouse.
 *
 * Thanks to Doug Gwen, Chris Torek, and others who helped clarify
 * the ansi printf specs.
 *
 * Please send any bug fixes and improvments to blarson@skat.usc.edu .
 * The use of goto is NOT a bug.
 */

#if !defined(BUILDING_PROTOTYPES)

#include <stdio.h>
#include <varargs.h>

#if defined(M_I386) || defined(i386)
#define LONGINT
#endif

/* This must be a typedef not a #define! */
#define NOVOID
#if defined(NOVOID)
typedef char *pointer;
#else
typedef void *pointer;
#endif

typedef int *intp;

/*+-------------------------------------------------------------------------
	pprintf(format,va_alist)
--------------------------------------------------------------------------*/
void
pprintf(format,va_alist)
register char *format;
va_dcl
{
va_list args;
register char c;
register char *tp;
char tempfmt[64];
#if !defined(LONGINT)
int longflag;
#endif
char accum_string[256];
register char *dp = accum_string;

	va_start(args);

	tempfmt[0] = '%';
	while(c = *format++)
	{
		if(c=='%')
		{
			tp = &tempfmt[1];
#if !defined(LONGINT)
			longflag = 0;
#endif
continue_format:
			switch(c = *format++)
			{
			case 's':
				*tp++ = c;
				*tp = '\0';
#if defined(INT_SPRINTF)
				dp += sprintf(dp,tempfmt,va_arg(args,char *));
#else
				sprintf(dp,tempfmt,va_arg(args,char *));
				dp += strlen(dp);
#endif
				break;
			case 'u':
			case 'x':
			case 'o':
			case 'X':
#if defined(UNSIGNEDSPECIAL)
				*tp++ = c;
				*tp = '\0';
#if !defined(LONGINT)
				if(longflag)
				{
#if defined(INT_SPRINTF)
					dp += sprintf(dp,tempfmt,va_arg(args,unsigned long));
#else
					sprintf(dp,tempfmt,va_arg(args,unsigned long));
					dp += strlen(dp);
#endif
				}
				else
#endif /* LONGINT */
				{
#if defined(INT_SPRINTF)
					dp += sprintf(dp,tempfmt,va_arg(args,unsigned));
#else
					sprintf(dp,tempfmt,va_arg(args,unsigned));
					dp += strlen(dp);
#endif
				break;
#endif
			case 'd':
			case 'c':
			case 'i':
				*tp++ = c;
				*tp = '\0';
#if !defined(LONGINT)
				if(longflag)
				{
#if defined(INT_SPRINTF)
					dp += sprintf(dp,tempfmt,va_arg(args,long));
#else
					sprintf(dp,tempfmt,va_arg(args,long));
					dp += strlen(dp);
#endif
				}
				else
#endif
				{
#if defined(INT_SPRINTF)
					dp += sprintf(dp,tempfmt,va_arg(args,int));
#else
					sprintf(dp,tempfmt,va_arg(args,int));
					dp += strlen(dp);
#endif
				}
				break;
			case 'f':
			case 'e':
			case 'E':
			case 'g':
			case 'G':
				*tp++ = c;
				*tp = '\0';
#if defined(INT_SPRINTF)
				dp += sprintf(dp,tempfmt,va_arg(args,double));
#else
				sprintf(dp,tempfmt,va_arg(args,double));
				dp += strlen(dp);
#endif
				break;
			case 'p':
#if defined(M_I286)
				tp = va_arg(args,pointer);
#if defined(M_SDATA)
				dp += sprintf(dp,"0x%04x",tp);
#else
				dp += sprintf(dp,"%04x:%04x",(int)tp,(int)((long)tp >> 16));
#endif /* M_SDATA */
#else
#if defined(INT_SPRINTF)
				dp += sprintf(dp,"0x%08lx",va_arg(args,pointer));
#else
				sprintf(dp,"0x%08lx",va_arg(args,pointer));
				dp += strlen(dp);
#endif
#endif /* M_I286 */
				break;
			case '-':
			case '+':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case '.':
			case ' ':
			case '#':
			case 'h':
				*tp++ = c;
				goto continue_format;
			case 'l':
#if !defined(LONGINT)
				longflag = 1;
				*tp++ = c;
#endif
				goto continue_format;
			case '*':
#if defined(INT_SPRINTF)
				tp += sprintf(tp,"%d",va_arg(args,int));
#else
				printf(tp,"%d",va_arg(args,int));
				tp += strlen(tp);
#endif
				goto continue_format;
			case '%':
			default:
				*dp++ = c;
				break;
			}
		}
		else *dp++ = c;
	}
	*dp = '\0';
	va_end(args);
	pputs(accum_string);
}	/* end of pprintf */
#endif /* !defined(BUILDING_PROTOTYPES) */

/* vi: set tabstop=4 shiftwidth=4: */
/* end of pprintf.c */
