/*+-------------------------------------------------------------------------
	logevent.c - log ecu event
	wht@n4hgf.Mt-Park.GA.US
--------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:09-10-1992-13:59-wht@n4hgf-ECU release 3.20 */
/*:08-22-1992-15:39-wht@n4hgf-ECU release 3.20 BETA */
/*:08-21-1991-02:00-wht@n4hgf-sun does not have xenix locking - fix later */
/*:08-07-1991-14:23-wht@n4hgf-use static logname */
/*:07-25-1991-12:58-wht@n4hgf-ECU release 3.10 */
/*:09-19-1990-19:36-wht@n4hgf-ecu_log_event now gets pid for log from caller */
/*:08-14-1990-20:40-wht@n4hgf-ecu3.00-flush old edit history */

#include <stdio.h>
#if defined(USE_LOCKING)
# include <sys/locking.h>
#endif
#ifdef USE_PROTOS
# include "protos.h"
#endif

/*+-------------------------------------------------------------------------
	ecu_log_event(pid,event_note)
--------------------------------------------------------------------------*/
void
ecu_log_event(pid,event_note)
int pid;
char *event_note;
{
char s32[32];
FILE *ecu_log_fp;
static char logname[256] = "";

	if(!logname[0])
	{
		get_home_dir(logname);
		strcat(logname,"/.ecu/log");
	}
	if(ecu_log_fp = fopen(logname,"a"))
	{
#if defined(USE_LOCKING)
		locking(fileno(ecu_log_fp),LK_LOCK,0L);
#endif
		get_tod(2,s32);
		s32[10] = '-';
		fputs(s32,ecu_log_fp);
		fprintf(ecu_log_fp,"-%05d-",pid);
		fputs(event_note,ecu_log_fp);
		fputs("\n",ecu_log_fp);
#if defined(USE_LOCKING)
		fflush(ecu_log_fp);
		locking(fileno(ecu_log_fp),LK_UNLCK,0L);
#endif
		fclose(ecu_log_fp);
	}
}	/* end of ecu_log_event */

/* vi: set tabstop=4 shiftwidth=4: */
/* end of logevent.c */
