/*+-----------------------------------------------------------------------
	ecuusage.c - user admonishment
	wht@n4hgf.Mt-Park.GA.US

  Defined functions:
	fkmap_cmd_usage()
	general_usage(uptr)
	log_cmd_usage()
	usage()

------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:09-16-1992-13:54-wht@n4hgf-add fkmap usage */
/*:09-10-1992-13:59-wht@n4hgf-ECU release 3.20 */
/*:08-22-1992-15:38-wht@n4hgf-ECU release 3.20 BETA */
/*:04-24-1992-21:07-wht@n4hgf-put defaults back into cmd line usage */
/*:04-24-1992-06:30-wht@n4hgf-rll usage fixes */
/*:07-25-1991-12:57-wht@n4hgf-ECU release 3.10 */
/*:04-27-1991-01:52-wht@n4hgf-overhaul revision numbers */
/*:08-14-1990-20:40-wht@n4hgf-ecu3.00-flush old edit history */

#include <stdio.h>
#include "termecu.h"
#define pf printf

#if defined(BUILDING_PROTOTYPES) || defined(lint)
#define DEFAULT_TTY "/dev/tty1"
#define DEFAULT_BAUD_RATE 2400
#define DEFAULT_PARITY 'n'
#endif

extern char *makedate;			/* temporary make date */
extern char *revstr;			/* ecunumrev.c */

char *usage_text[] = 
{
"usage: ecu [-l <ttyname>] [-b <baud_rate>] [-eon]\n",
"           [-h] [-t] [-P <phonedir>] [-F name] [-T <trace-level>]\n",
"           [-p <initial_proc> [-d] [-D] | <phone_number>]\n",
"-D unconditionally stop execution when -p initial procedure is done\n",
"-F sets an alternate funckeymap name for the *keyboard*\n",
"-P choose alternate phone directory (<phonedir> must be a full pathname)\n",
"-T set procedure tracing to level: 0=none, 1=standard, 2=ECU-debugging\n",
"-b choose baud rate (any UNIX rate 110-38400)\n",
"-d stop execution if -p initial procedure fails\n",
"-e even parity   -o odd parity   -n no parity\n",
"-h half duplex ... default is full duplex\n",
"-l choose line (/dev/<ttyname>)\n",
"-p execute an initial procedure\n",
"-t append NL to incoming and outgoing CR characters\n",
"<phone_number> is either an actual number or a directory entry name\n",
"\n",
"For interactive option selection, try executing ecu with no arguments\n",
"\n",
"For a list of built in commands, type HOME?<ENTER> once program started\n",
	(char *)0		/* terminated with null pointer */
};

char *log_cmd_usage_text[] = 
{
"Usage: log [-s] [-r] <filename>\n",
"       log off   turn logging off\n",
" -s scratch any previous contents of <filename>, else append\n",
" -r raw log, else drop 0x00-0x08,0x11-0x1F,0x7F-0xFF\n",
	(char *)0		/* terminated with null pointer */
};

char *fkmap_cmd_usage_text[] = 
{
"usage: fkmap \n",
"       fkmap <keyname>\n",
"       fkmap <keyname> <keylist>\n",
"       fkmap -l <name>\n",
"       fkmap -r\n",
"       fkmap -s <file>\n",
	(char *)0		/* terminated with null pointer */
};

/*+-----------------------------------------------------------------------
	general_usage(uptr)
------------------------------------------------------------------------*/
void
general_usage(uptr)
register char **uptr;
{
	while(*uptr != (char *)0)
		pputs(*(uptr++));
}	/* end of usage */

/*+-----------------------------------------------------------------------
	usage()
------------------------------------------------------------------------*/
void
usage()
{
	fprintf(stderr,"ecu %s made: %s\n",revstr,makedate);
	general_usage(usage_text);
	pprintf("\nDefaults: tty=%s baud=%d parity=%c\n",
		DEFAULT_TTY, DEFAULT_BAUD_RATE, DEFAULT_PARITY);
	termecu(TERMECU_USAGE);
	/*NOTREACHED*/
}

/*+-------------------------------------------------------------------------
	log_cmd_usage()
--------------------------------------------------------------------------*/
void
log_cmd_usage()
{
	general_usage(log_cmd_usage_text);
}	/* end of log_cmd_usage */

/*+-------------------------------------------------------------------------
	fkmap_cmd_usage()
--------------------------------------------------------------------------*/
void
fkmap_cmd_usage()
{
	general_usage(fkmap_cmd_usage_text);
}	/* end of fkmap_cmd_usage */

/* vi: set tabstop=4 shiftwidth=4: */
