#define HONEYDANBER /* means use ASCII pids in lock files */
#define USE_SVR4_MKDEV_H /* jeff@samantha.chi.il.us SVR4 lock file correction */
#if defined(SHARE_DEBUG)
#define LOG_LOCKS
#endif

/*+-----------------------------------------------------------------------
	ecuLCK.c -- ECU lock file management
	wht@n4hgf.Mt-Park.GA.US

  Defined functions:
	is_active_lock(name)
	line_lock_status(ttyname)
	make_lock_name(ttyname,lock_file_name)

Lock files under XENIX are supposed to use the direct line name
(lower-case last letter); we create only the lower-case case, but
check for both.
------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:10-07-1992-21:09-jeff@samantha.chi.il.us-SVR4 lock file correction */
/*:09-10-1992-13:58-wht@n4hgf-ECU release 3.20 */
/*:08-22-1992-15:38-wht@n4hgf-ECU release 3.20 BETA */
/*:08-21-1992-13:39-wht@n4hgf-rewire direct/modem device use */
/*:04-24-1992-21:59-wht@n4hgf-more SCO tty name normalizing */
/*:08-25-1991-14:39-wht@n4hgf-ISCSVR4 port thanks to aega84!lh */
/*:08-21-1991-03:37-wht@n4hgf-kill LINST_INVALID check */
/*:08-11-1991-18:06-wht@n4hgf-SCO_TTY_NAMING considerations */
/*:08-09-1991-11:07-wht@n4hgf-configurable lock directory */
/*:08-07-1991-14:41-wht@n4hgf-race with ecuungetty over lock resolved */
/*:07-25-1991-12:55-wht@n4hgf-ECU release 3.10 */
/*:11-19-1990-01:05-wht@n4hgf-remove lock in is_active_lock if we locked */
/*:10-16-1990-20:43-wht@n4hgf-add SHARE_DEBUG */
/*:09-19-1990-19:36-wht@n4hgf-ecu_log_event now gets pid for log from caller */
/*:08-14-1990-20:39-wht@n4hgf-ecu3.00-flush old edit history */

#include "ecu.h"
#include "utmpstatus.h"
#if defined(SVR4)
#ifndef USE_SVR4_MKDEV_H
# include <sys/sysmacros.h>
#else
# include <sys/mkdev.h>
#endif /* USE_SVR4_MKDEV_H */
#endif

extern int errno;
extern char ungetty_ttyname[];

char *lock_dir_name = LOCK_DIR_NAME; /* location of LCK.. files */

/*+-------------------------------------------------------------------------
	make_lock_name(ttyname,lock_file_name)
--------------------------------------------------------------------------*/
int
make_lock_name(ttyname,lock_file_name)
char *ttyname;
char *lock_file_name;
{

#if defined(SVR4)
	struct stat tbuf;

	if(stat(ttyname, &tbuf) < 0)
	{
		if(errno == ENOENT)
			return(LINST_NODEV);		/* device does not exist */
		else
			return(LINST_OPNFAIL);		/* could not access line */
	}
	sprintf(lock_file_name,"%s/LK.%03u.%03u.%03u",
		lock_dir_name,major(tbuf.st_dev),
#ifndef USE_SVR4_MKDEV_H
	    tbuf.st_rdev >> 18,
#else
	    major(tbuf.st_rdev),
#endif /* USE_SVR4_MKDEV_H */
		 minor(tbuf.st_rdev));
#else

	/*
	 * SVR3 and before
	 */
	strcpy(lock_file_name,lock_dir_name);
	strcat(lock_file_name,"/LCK..");
#ifdef SCO_TTY_NAMING
	strcat(lock_file_name,direct_tty(ttyname) + 5);
#else
	strcat(lock_file_name,ttyname + 5);
#endif /* SCO_TTY_NAMING */

#endif /* SVR4 */

	return(0);

}	/* end of make_lock_name */

/*+-------------------------------------------------------------------------
	is_active_lock(name) - check to see if lock still active

if not unlink any old lock name
--------------------------------------------------------------------------*/
is_active_lock(name)
register char *name;
{
	register itmp;
	PID_T lockpid;
	int fd;
	int status = 0;
	char pidstr[12];

#ifdef SCO_TTY_NAMING
	char name2[256];

	if(isupper(name[itmp = strlen(name) - 1]))
	{
		strcpy(name2,name);
		name2[itmp] = to_lower(name2[itmp]);
		name = name2;
	}
#endif /* SCO_TTY_NAMING */

	errno = 0;
	if((fd = open(name,O_RDONLY,0)) < 0)
	{
		if(errno != ENOENT)
			status = LINST_LCKERR;
		goto RETURN_STATUS;
	}

#if defined(HONEYDANBER)
	itmp = read(fd,(char *)pidstr,11);
	pidstr[11] = 0;
	close(fd);
	if(itmp != 11)
		goto UNLINK_OLD_LOCK;
	lockpid = atoi(pidstr);
#else
	itmp = read(fd,(char *)&lockpid,sizeof(int));
	close(fd);
	if(itmp != sizeof(int))
		goto UNLINK_OLD_LOCK;
#endif

	/* if we are the locker, return no error */
	if(lockpid == xmtr_pid)
	{
		status = LINST_WEGOTIT;
		goto RETURN_STATUS;
	}

	if((!(itmp = kill(lockpid,0))) || (errno != ESRCH))
	{
		errno = EACCES;		/* for termecu() */
		status = lockpid;
		goto RETURN_STATUS;
	}

UNLINK_OLD_LOCK:
	if(unlink(name))
		status = LINST_LCKERR;

RETURN_STATUS:

#if defined(LOG_LOCKS)
{ char s128[128];
  extern char *errno_text();
	sprintf(s128,"ISLOCK %s status=%d errno=%d",name,status,errno);
	ecu_log_event(getpid(),s128);
}
#endif

	return(status);
}	/* end of is_active_lock */

/*+-----------------------------------------------------------------------
	line_lock_status(ttyname)

  ttyname must be of style "/dev/ttyxx"
  Returns locking pid if locked else LOPEN lock error code (< 0) else 0
------------------------------------------------------------------------*/
int
line_lock_status(ttyname)
char *ttyname;
{
	register itmp;
	char lock_file_name[128];
	
	if(itmp = make_lock_name(ttyname,lock_file_name))
		return(itmp);

	if(itmp = is_active_lock(lock_file_name))
		return(itmp);

	return(0);

}	/* end of line_lock_status */

/* end of ecuLCK.c */
/* vi: set tabstop=4 shiftwidth=4: */
