/*
 *                            COPYRIGHT
 *
 *  PCB, interactive printed circuit board design
 *  Copyright (C) 1994,1995 Thomas Nau
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Contact addresses for paper mail and Email:
 *  Thomas Nau, Schlehenweg 15, 88471 Baustetten, Germany
 *  Thomas.Nau@rz.uni-ulm.de
 *
 *  RCS: $Header$
 */

/* prototypes for memory routines
 */

#ifndef	__MYMEM_INCLUDED__
#define	__MYMEM_INCLUDED__

#include <stdlib.h>
#include "global.h"

/* ---------------------------------------------------------------------------
 * number of additional objects that are allocated with one system call
 */
#define	STEP_VIA			500		/* block size for realloc() calls */
#define	STEP_PIN			30
#define	STEP_LINE			500
#define	STEP_ELEMENTLINE	20
#define	STEP_ELEMENTARC		5
#define	STEP_TEXT			50
#define	STEP_ELEMENT		50
#define	STEP_SYMBOLLINE		10
#define	STEP_FILENAME		500
#define	STEP_REMOVELIST		500
#define	STEP_UNDOLIST		500
#define	STEP_POLYGON		10
#define	STEP_POLYGONPOINT	10

/* ---------------------------------------------------------------------------
 * some memory types
 */
typedef struct
{
	size_t	MaxLength;
	char	*Data;
} DynamicStringType, *DynamicStringTypePtr;

PinTypePtr			GetPinMemory(ElementTypePtr);
PinTypePtr			GetViaMemory(DataTypePtr);
LineTypePtr			GetLineMemory(LayerTypePtr);
TextTypePtr			GetTextMemory(LayerTypePtr);
PolygonTypePtr		GetPolygonMemory(LayerTypePtr);
PolygonPointTypePtr	GetPointMemoryInPolygon(PolygonTypePtr);
ElementTypePtr		GetElementMemory(DataTypePtr);
void				*MyCalloc(size_t, size_t, char *);
void				*MyRealloc(void *, size_t, char *);
char				*MyStrdup(char *s, char *);
void				MyFree(char **);
void				FreePolygonMemory(PolygonTypePtr);
void				FreeElementMemory(ElementTypePtr);
void				FreePCBMemory(PCBTypePtr);
void				FreeDataMemory(DataTypePtr);
void				SaveFree(void *);
void				DSAddCharacter(DynamicStringTypePtr, char);
void				DSAddString(DynamicStringTypePtr, char *);
void				DSClearString(DynamicStringTypePtr);
char				*StripWhiteSpaceAndDup(char *);

#ifdef NEED_STRDUP
char				strdup(const char *);
#endif

#endif
