
#
#   xfstool - manage floppy mounts/umounts/mkfs and shutdown for users
#   Copyright (C) 1994 Torsten Eichner
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#   email: 	eichner@rhrk.uni-kl.de
#   papermail:	Torsten Eichner, Kampshardtweg 1, D-57587 Birken-Honigsessen, Germany
#

#   Modify this to your needs
FLOPPY   = /dev/fd0
DIR      = /fd
PERM     = /usr/local/lib/xfstool.perm
FSTYPE   = ext2
SHUTDOWNMSG = Hasta la vista, baby!
MOUNT    = /bin/mount
MKFS     = /sbin/mke2fs
UMOUNT   = /bin/umount
SHUTDOWN = /sbin/shutdown
DELAY	 = now
#DELAY	 = +1
#XAWLIB   = Xaw3d
XAWLIB   = Xaw
INSTBINDIR = /usr/local/bin/X11
INSTMANDIR = /usr/local/man/man1

#   Don't modify below this line

SRC = xfstool.c
OBJ = xfstool.o
CC = gcc
# define SOUND to play wav file
CFLAGS = -O2 -m486 -DSOUND \
	 -DFLOPPY="\"$(FLOPPY)\"" -DDIR="\"$(DIR)\"" -DDELAY="\"$(DELAY)\"" \
	 -DPERM="\"$(PERM)\"" -DFSTYPE="\"$(FSTYPE)\"" -DSHUTDOWNMSG="\"$(SHUTDOWNMSG)\"" -DMOUNT="\"$(MOUNT)\"" -DSHUTDOWN="\"$(SHUTDOWN)\"" \
	 -DUMOUNT="\"$(UMOUNT)\"" -DMKFS="\"$(MKFS)\""

LDFLAGS= -l$(XAWLIB) -lXt -lX11

xfstool: $(OBJ)
	 $(CC) -o xfstool $(OBJ) $(LDFLAGS)

.c.o:
	 $(CC) $(CFLAGS) -c $<

depend:
	 makedepend $(SRC)

clean:
	 rm -f $(OBJ) core xfstool.tar xfstool.tar.gz xfstool.tar.z Makefile.bak

allclean: clean
	 rm -f xfstool

install: allclean depend xfstool
	 install -g root -o root -m 644 xfstool.1 $(INSTMANDIR)/xfstool.1
	 install -g bin -o root -m 4755 xfstool $(INSTBINDIR)/xfstool

dist:
	 $(MAKE) clean
	 $(MAKE) depend
	 cd ..; tar -cvf xfstool.tar xfstool
	 mv ../xfstool.tar .
	 gzip xfstool.tar


# DO NOT DELETE THIS LINE -- make depend depends on it.
