/* $Id: et2hku.c,v 1.3 1992/07/21 07:15:45 ygz Exp $ */

#ifndef lint
static char *rcs_id="$Id: et2hku.c,v 1.3 1992/07/21 07:15:45 ygz Exp $";
#endif /* lint */

#include "io.h"

#define	UNCONV_H 0xa1
#define	UNCONV_L 0xbc

#define c1	(unsigned char)(s[0])
#define c2	(unsigned char)(s[1])

static void e2h (s)
     register char *s;
{
	if ((c1 < 0xc6) || ((c1 == 0xc6) && (c2 <= 0x7e))) {
            /* Frequent BIG5 */
	} else if ((c1 <= 0xc8) || (c1 > 0xf9) ||
		   ((c1 == 0xf9) && (c2 > 0xd5))) {
            s[0] = UNCONV_H;  s[1] = UNCONV_L;	/* ET non-standard codes */
        } else if ((c2 >= 0xc0) && (c2 <= 0xfe)) {
            s[0] -= 2;  s[1] += -0xc0 + 0x40;
        } else if ((c2 >= 0xa1) && (c2 <= 0xbf)) {
            s[0] -= 3;  s[1] += -0xa1 + 0xe0;
        } else if ((c2 >= 0x40) && (c2 <= 0x7e)) {
            s[0] -= 3;  s[1] += -0x40 + 0xa1;
        } else {
	    s[0] = UNCONV_H;  s[1] = UNCONV_L;
        }
}

static void h2e (s)
     register char *s;
{
        if ((c1 < 0xc6) || ((c1 == 0xc6) && (c2 <= 0x7e))) {
            /* Frequent BIG5 */
        } else if ((c1 > 0xf7) || ((c1 == 0xf7) && (c2 > 0x55))) {
	    s[0] = UNCONV_H;  s[1] = UNCONV_L;		/* non-standard BIG5 */
        } else if ((c2 >= 0xe0) && (c2 <= 0xfe)) {	/* Non-frequnt BIG5 */
            s[0] += 3;  s[1] += -0xe0 + 0xa1;
        } else if ((c2 >= 0xa1) && (c2 <= 0xdf)) {
            s[0] += 3;  s[1] += -0xa1 + 0x40;
        } else if ((c2 >= 0x40) && (c2 <= 0x7e)) {
            s[0] += 2;  s[1] += -0x40 + 0xc0;
        } else {
	    s[0] = UNCONV_H;  s[1] = UNCONV_L;
        }
}

#undef c1
#undef c2

extern char *hzconvert ();
static char et2hku_savec[MAX_MODULE];
static char hku2et_savec[MAX_MODULE];

int et2hku_init (arg)
     char *arg;
{
  static int et2hku_inst = 0;

	et2hku_savec[et2hku_inst] = '\0';
	return (et2hku_inst++);
}

int hku2et_init (arg)
     char *arg;
{
  static int hku2et_inst = 0;

	hku2et_savec[hku2et_inst] = '\0';
	return (hku2et_inst++);
}

char *et2hku (s,plen,inst)
     char *s;
     int *plen;
     int inst;
{
	return (hzconvert (s, plen, &et2hku_savec[inst], e2h));
}

char *hku2et (s,plen,inst)
     char *s;
     int *plen;
     int inst;
{
	return (hzconvert (s, plen, &hku2et_savec[inst], h2e));
}

