#!/bin/sh

# definitions

: ${ECHONONL:="echo -n"}


# startup

## has xmkmf/imake ?

has_xmkmf=0
allpathes=`echo $PATH | sed -e 's/:/ /g'`
for p in $allpathes; do
    if [ -x $p/xmkmf ]; then
	has_xmkmf=1
	xdir="$p"
	break
    fi
done

if [ "$has_xmkmf" -eq 0 ]; then
    cat << __NO_XMKMF__

ERROR:  "xmkmf" not found!

"xmkmf" is a standard X11 command.  If the X Window System is properly
installed in your machine, it should have xmkmf.  Please double check
your PATH variable and make should you include the right X11 path.  Ask
your system administrator or local X gurus for the availability of xmkmf. 

If your system indeed does not have xmkmf, please consider switching to
a better system that has a better version of X Window -- it makes
things much easier!

__NO_XMKMF__
    echo "** CXTERM not compiled."
    exit 1
fi

cat << __MAKE_CXTERM__

Now starting making cxterm.  It may take 10-20 minutes (depend on how fast
is your computer).  Take a break and relax.  If anything goes wrong during
the make, the message log file is "./Install.log"

__MAKE_CXTERM__

echo 'make -f Makefile.ini World  2>&1 | tee Install.log'

make -f Makefile.ini World  2>&1 | tee Install.log

if [ -f .done ]; then
    echo "Compilation well done."
    exit 0
else
    cat << __MAKE_FAIL__

Possible compilation error.  Please check Install.log.  If you plan
to get help from other people, be sure to include Install.log and tell
them all the details of your system, including the machine type and
model, host name and terminal name, operating system version number,
X window version number, etc.

__MAKE_FAIL__
    echo "" >> Install.log
    echo "The version of cxterm is" >> Install.log
    tail -1 version >> Install.log
    echo "The result of 'uname -a' is" >> Install.log
    uname -a >> Install.log 2>&1
    echo "The result of 'xdpyinfo' is" >> Install.log
    xdpyinfo >> Install.log 2>&1
    echo "The result of 'xset -q' is" >> Install.log
    xset -q >> Install.log 2>&1
    exit 1
fi
