/*

Copyright (C) 1992 Klaus Hartenstein

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation.  This software is provided "as is" without express or
implied warranty.

*/


#include "globaldefs.h"
#include "list.h"

typedef int Boolean;

extern char *MyCalloc();

/********************************************************************************/
/* append a list element to a list */

void AppendList( WhichList, Name, Host, tty ,idle, fili)
     List **WhichList;
     char *Name;
     char *Host;
     char tty;
     int  idle;
     char *fili;
{
  List *dummy;
  dummy=(List *)MyCalloc(1,sizeof(List));
  if(Name) { dummy->Name = (char *)MyCalloc(1,strlen(Name)+1);
	     strcpy(dummy->Name,Name); }
  if(Host) { dummy->Host = (char *)MyCalloc(1,strlen(Host)+1);
	     strcpy(dummy->Host,Host); }
  if(fili) { dummy->FiLi = (char *)MyCalloc(1,strlen(fili)+1);
	     strcpy(dummy->FiLi,fili); }
  dummy->tty = tty;
  dummy->idle = idle;
  dummy->next = *WhichList;
  *WhichList  = dummy;
}
/********************************************************************************/
/* Delete a list completely */

void DeleteList(WhichList)
     List **WhichList;
{
  List *dummy = *WhichList;
  List *dummy2;
  if(*WhichList == NULL) return;
  else{
    while(dummy){
      *WhichList = dummy->next;
      dummy2=dummy;
      dummy=dummy->next;
      XtFree(dummy2->Name);
      XtFree(dummy2->Host);
      XtFree(dummy2->FiLi);
      XtFree(dummy2);
    }
  }
}
/********************************************************************************/
/* checks if a Name is in a list */

int IsNameInList(WhichList, Name)
     List *WhichList;
     char *Name;
{
  for( ; WhichList ; WhichList = WhichList->next){
    if(strcmp(Name,WhichList->Name) == NULL) /* name found */
      return TRUE;
  }
  return FALSE;
}
/********************************************************************************/
/* searches usr with smallest idle value on tty */

List *SearchUser(WhichList,uname,tty, Idle, HideWhenIdle)
     List *WhichList;
     char *uname;
     char tty;
     int Idle;
     Boolean HideWhenIdle;
{
  List *dummy=WhichList;
  List *select=NULL;
  int lastIdle=MAXINT;
  for(;dummy;dummy=dummy->next){
    if(!strcmp(uname,dummy->Name) &&
       (dummy->tty == tty)&& 
       ((dummy->idle <= Idle)||(HideWhenIdle==False))){
      if(dummy->idle < lastIdle){
        select=dummy;
        lastIdle=dummy->idle;
      }
    }
  }
  return select;
}
/********************************************************************************/
/* append line to Fingerlist */
void AppendLine( WhichList, Line, Host)
     FList **WhichList;
     char *Line;
     char *Host;
     
{
  FList *dummy;
  dummy=(FList *)MyCalloc(1,sizeof(List));
  if(Line) { dummy->Line = (char *)MyCalloc(1,strlen(Line)+1);
	     strcpy(dummy->Line,Line); }
  if(Host) { dummy->Host = (char *)MyCalloc(1,strlen(Host)+1);
	     strcpy(dummy->Host,Host); }
  dummy->next = *WhichList;
  *WhichList  = dummy;
}

/********************************************************************************/
/* Delete a list completely */

void DeleteFList(WhichList)
     FList **WhichList;
{
  FList *dummy = *WhichList;
  FList *dummy2;
  if(*WhichList == NULL) return;
  else{
    while(dummy){
      *WhichList = dummy->next;
      dummy2=dummy;
      dummy=dummy->next;
      free(dummy2->Line);
      free(dummy2);
    }
  }
}




