/* 
 *                     CopyRight (C) 1995 Harm Arts
 * 
 *                 (Fallback resource: Hans Fleurkens)
 *
 * xmemuse.c      -- show memory usage (a la xload)
 *
 * Created On      : Mon May  8 23:29:53 1995
 * Last Modified On: Fri May 12 14:43:22 1995
 *
 * $Id: xmemuse.c,v 0.3 1995/05/12 10:46:12 harm Exp harm $
 *
 *****************************************************************************/

#include <stdio.h>
#include <limits.h>
#include <stdarg.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Simple.h>

#define MEMINFO		"/proc/meminfo"
#define CLASSTYPE	"Xmemuse"
#define NOMP		2048

typedef struct {
  int		scale;		/* draw scale lines, unused yet */
  Pixel		sc;		/* scale lines */       
  int		update;		/* update interval in seconds */
  Pixel		sw;		/* swap line */         
  Pixel		xs;		/* not available swap */
  Pixel		fs;		/* free swap */         
  Pixel		um;		/* used ram + swap */   
  Pixel		sm;		/* shared mem */        
  Pixel		fm;		/* free ram */          
  Pixel		bm;		/* buffers ram */       
  int		debug;		/* print debug-level info */
} AppData;

unsigned int		max_mem = 0;
unsigned short		mempoints[NOMP][5];
unsigned short		swapline;
int			base = 0;

double			shrt2hght;

Display 		*dpy = NULL;
GC			gc;
Window 			wnd;
Widget			wdg;
XWindowAttributes	w_att;
int			expect_gexpo = 0;
AppData			app_data;

static XtResource resources[] = {
  { "scale", "Scale", XtRInt, sizeof(int), XtOffsetOf(AppData, scale),
      XtRImmediate, (XtPointer) 4 },
  { "sc", "Sc", XtRPixel, sizeof(Pixel), XtOffsetOf(AppData, sc),
      XtRString, (XtPointer) "gray73" },
  { "update", "Update", XtRInt, sizeof(int), XtOffsetOf(AppData, update),
      XtRImmediate, (XtPointer) 10 },
  { "sw", "Sw", XtRPixel, sizeof(Pixel), XtOffsetOf(AppData, sw),
      XtRString, (XtPointer) "black" },
  { "xs", "Xs", XtRPixel, sizeof(Pixel), XtOffsetOf(AppData, xs),
      XtRString, (XtPointer) "black" },
  { "fs", "Fs", XtRPixel, sizeof(Pixel), XtOffsetOf(AppData, fs),
      XtRString, (XtPointer) "green" },
  { "um", "Um", XtRPixel, sizeof(Pixel), XtOffsetOf(AppData, um),
      XtRString, (XtPointer) "red" },
  { "sm", "Sm", XtRPixel, sizeof(Pixel), XtOffsetOf(AppData, sm),
      XtRString, (XtPointer) "orange" },
  { "fm", "Fm", XtRPixel, sizeof(Pixel), XtOffsetOf(AppData, fm),
      XtRString, (XtPointer) "green" },
  { "bm", "Bm", XtRPixel, sizeof(Pixel), XtOffsetOf(AppData, bm),
      XtRString, (XtPointer) "blue" },
  { "debug", "Debug", XtRInt, sizeof(int), XtOffsetOf(AppData, debug),
      XtRImmediate, (XtPointer) 0 },
};  

static XrmOptionDescRec options[] = {
  {"-scale",	"*scale",	XrmoptionSepArg,	NULL},
  {"-sc",	"*sc",		XrmoptionSepArg,	NULL},
  {"-update",	"*update",	XrmoptionSepArg,	NULL},
  {"-sw",	"*sw",		XrmoptionSepArg,	NULL},
  {"-xs",	"*xs",		XrmoptionSepArg,	NULL},
  {"-fs",	"*fs",		XrmoptionSepArg,	NULL},
  {"-um",	"*um",		XrmoptionSepArg,	NULL},
  {"-sm",	"*sm",		XrmoptionSepArg,	NULL},
  {"-fm",	"*fm",		XrmoptionSepArg,	NULL},
  {"-bm",	"*bm",		XrmoptionSepArg,	NULL},
  {"-debug",	"*debug",	XrmoptionSepArg,	NULL},
};

static String fallback_resources[] = {
  "*geometry: 200x100",
  NULL
};

void
Usage (int argc, char * argv[])
{
  int i;
  
  printf ("Wrong option%s : %s\n", (argc > 2)?"s":" ", argv[1]);
  for (i = 2; i < argc; i++)
    printf ("                  %s\n", argv[i]);
  printf ("\nUsage: %s [toolkitoptions] [options]\n", argv[0]);
  for (i = 0; i < XtNumber (options); i++)
    printf ("%8s %s %s\n", (i == 0)?"Options:":"", options[i].option,
	    (options[i].argKind == XrmoptionSepArg)?"<value>":"");
  printf ("(The 2-letter options take a color as argument,\n"
	  " scaley in Mbytes, update in seconds)\n");
  exit (1);
}


int
QuitX (const char *fmt, ...)
{
  va_list   ap;
  va_start (ap, fmt);
  fprintf  (stderr, "Error: ");
  vfprintf (stderr, fmt, ap);
  fprintf  (stderr, "\n");
  exit (1);
}

void
DrawLine (int mempos, int xpos)
{
  int			i;
  unsigned short	points[5];

  for (i = 0; i< 5; i++)
    points[i] = mempoints[mempos][i] * shrt2hght;
  if (app_data.debug > 2)
    printf ("DrawLine %3d - 0, %d, %d, %d, %d, %d, %d\n", xpos, points[0],
	    points[1], points[2], points[3], points[4], w_att.height);

  if (points[0] > 0)
    {
      XSetForeground (dpy, gc, app_data.xs);
      XDrawLine (dpy, wnd, gc, xpos, 0, xpos, points[0]);
    }
  XSetForeground (dpy, gc, app_data.fs);
  XDrawLine (dpy, wnd, gc, xpos, points[0], xpos, points[1]);
  if (points[1] > points[2])
    {
      if (app_data.debug > 0) printf ("Waaaaw\n");
      XSetForeground (dpy, gc, app_data.sm);
      XDrawLine (dpy, wnd, gc, xpos, points[1], xpos, points[3]); 
    }
  else
    {
      XSetForeground (dpy, gc, app_data.um);
      XDrawLine (dpy, wnd, gc, xpos, points[1], xpos, points[2]); 
      XSetForeground (dpy, gc, app_data.sm);
      XDrawLine (dpy, wnd, gc, xpos, points[2], xpos, points[3]); 
    }
  XSetForeground (dpy, gc, app_data.fm);
  XDrawLine (dpy, wnd, gc, xpos, points[3], xpos, points[4]); 
  XSetForeground (dpy, gc, app_data.bm);
  XDrawLine (dpy, wnd, gc, xpos, points[4], xpos, w_att.height); 

  if (app_data.scale)
    {
      int i, su = app_data.scale * shrt2hght;

      XSetForeground (dpy, gc, app_data.sc);
      for (i = w_att.height; i > 0; i -= su)
	XDrawPoint (dpy, wnd, gc, xpos, i);
    }
  if (swapline)
    {
      XSetForeground (dpy, gc, app_data.sw);
      XDrawPoint (dpy, wnd, gc, xpos, (int) (swapline * shrt2hght));
    }
}

void
ReDrawWindow (int x, int y, int w, int h)
{
  int i;
  
  if (app_data.debug > 1)
    printf ("Draw: base=%d,  x=%d, w=%d, width=%d, y=%d, h=%d, height=%d\n",
	    base,  x, w, w_att.width, y, h, w_att.height);
  if (x < 0 || w < 0 || x + w > w_att.width ||
      y < 0 || h < 0 || y + h > w_att.height)
    QuitX ("Wrong expose dimensions");
  
  for (i = x; i < x + w; i++)
    DrawLine ((NOMP + base - w_att.width + i) % NOMP, i);
}

void
CreateGC ()
{
  XGCValues	gcv;

  gcv.line_width = 1;
  gcv.line_style = 0;
  if (app_data.debug > 0) printf("CreateGC\n");
  gc = XtGetGC (wdg, (GCLineWidth | GCLineStyle), &gcv);

  shrt2hght = w_att.height / (double) USHRT_MAX;
}

void
GetMemPoints (unsigned short points[])
{
  unsigned int  cumm, tm, um, fm, sm, bm, ts, us, fs;
  FILE          *mi = NULL;
  char          buf[80];
  static double	norm;

  if (!(mi = fopen(MEMINFO, "r"))) QuitX ("Can't open meminfo");
  
  fgets(buf, 79, mi);
  /* uint ==> max. 4Gbyte ram + swap; should be enough for a few years ... */
  fscanf (mi, "%*s %d %d %d %d %d", &tm, &um, &fm, &sm, &bm);
  fscanf (mi, "%*s %d %d %d"      , &ts, &us, &fs);
  
  if (fclose (mi)) QuitX ("Can't close meminfo");
  
  if (app_data.debug > 0 && (tm != um + fm || ts != us + fs))
    printf ("      %9s %9s %9s %9s %9s\n"
	    "Mem:  %9d %9d %9d %9d %9d\n"
	    "Swap: %9d %9d %9d\n",
	    "total", "used", "free", "shared", "buffers",
	    tm, um, fm, sm, bm,
	    ts, us, fs);
  if (max_mem == 0) /* initialize */
    {
      max_mem = tm + ts;
      norm = (max_mem) / (double) USHRT_MAX;
      swapline = ts / norm;
      app_data.scale *= 1024 * 1024 / norm;
    }
  else if (max_mem < tm + ts)	/* swap increased */
    {				/* (tm didn't change; I hope ...) */
      int i,j;			/* reinitialize */
      for (i = 0; i < NOMP; i++)
	for(j = 0; j < 5; j++)
	  mempoints[i][j] = USHRT_MAX - ((USHRT_MAX - mempoints[i][j]) *
					 ((max_mem / (double) (tm + ts))));
      app_data.scale *= (max_mem / (double) (tm + ts));
      max_mem = tm + ts;
      norm = (max_mem) / (double) USHRT_MAX;
      swapline = ts / norm;
      ReDrawWindow (0, 0, w_att.width, w_att.height);
    }

  /* mempoints are ushort ==> 64k resolution for 100% window.height */
  um = tm - fm - bm - sm + us;
  points[0] = (cumm = max_mem - tm - ts) / norm;
  points[1] = (cumm += fs) / norm;
  points[2] = (cumm += um) / norm;
  points[3] = (cumm += sm) / norm;
  points[4] = (cumm += fm) / norm;
  if (cumm + bm != max_mem)
    QuitX ("cumm + bm != max_mem\n");
  return;
}

void
ScrollMap (void)
{
  if (app_data.debug > 0)
    printf ("ScrollMap\n");

  GetMemPoints (mempoints[base]);

  XCopyArea (dpy, wnd, wnd, gc, 1, 0, w_att.width - 1, w_att.height, 0, 0);
  DrawLine (base, w_att.width - 1);
  expect_gexpo++;
  
  if (++base == NOMP)
    base = 0;
}

void
Update (XtPointer app_ctxt,  XtIntervalId *id)
{
  XtAppAddTimeOut (app_ctxt, (unsigned long)app_data.update * 1000,
		   Update, app_ctxt);

  ScrollMap ();
}

void
HandleKeyPress (Widget wdg, XtPointer unsused, XEvent *ev, Boolean *c_t_d)
{
  KeySym		ks;
  char			string[10];
  XComposeStatus	cs;

  XLookupString ((XKeyEvent *) ev, string, 9, &ks, &cs);
  if (app_data.debug > 0) printf ("KeyPress EVENT: %d\n", ks);
  switch (ks)
    {
    case XK_Q:
      exit (0);
    case XK_space:
      ScrollMap ();
    }
}

void
HandleExpose (Widget wdg, XtPointer unsused, XEvent *ev, Boolean *c_t_d)
{
  if (app_data.debug > 0)
    printf ("Expose EVENT: %d %d %d %d: expect = %d\n",
	    ev -> xexpose.x    , ev -> xexpose.y,
	    ev -> xexpose.width, ev -> xexpose.height, expect_gexpo);
  ReDrawWindow ((ev -> xexpose.x > expect_gexpo)?
		ev -> xexpose.x     - expect_gexpo : 0, ev -> xexpose.y,
		ev -> xexpose.width                   , ev -> xexpose.height);
}

void
HandleGExpose (Widget wdg, XtPointer unsused, XEvent *ev, Boolean *c_t_d)
{
  if (ev -> type == GraphicsExpose)
    {
      if (app_data.debug > 0)
	printf ("GraphicsExpose EVENT: %d %d %d %d, "
		"serno = %d, count = %d, gexpo = %d\n",
		ev -> xgraphicsexpose.x        , ev -> xgraphicsexpose.y,
		ev -> xgraphicsexpose.width    , ev -> xgraphicsexpose.height,
		ev -> xgraphicsexpose.serial   , ev -> xgraphicsexpose.count,
		expect_gexpo);
      ReDrawWindow (ev -> xgraphicsexpose.x - expect_gexpo + 1
		                               , ev -> xgraphicsexpose.y,
		    ev -> xgraphicsexpose.width, ev -> xgraphicsexpose.height);
      if (ev -> xgraphicsexpose.count == 0)
	expect_gexpo--;
    }
  else if (ev -> type == NoExpose)
    {
      if (app_data.debug > 0)
	printf ("NoExpose EVENT\n");
      expect_gexpo--;
    }
  else
    {
      if (app_data.debug > 0)
	printf ("GExpose EVENT %d: %d %d %d %d\n", ev -> type,
		ev -> xexpose.x, ev -> xexpose.y,
		ev -> xexpose.width, ev -> xexpose.height);
      ReDrawWindow (ev -> xexpose.x    , ev -> xexpose.y,
		    ev -> xexpose.width, ev -> xexpose.height);
    }
}

void
HandleStructure (Widget wdg, XtPointer unsused, XEvent *ev, Boolean *c_t_d)
{
  if (ev -> type == ConfigureNotify)
    {
      if (app_data.debug > 0)
	printf ("ConfigureNotify EVENT: %dx%d+%d+%d\n",
		ev -> xconfigure.width, ev -> xconfigure.height,
		ev -> xconfigure.x, ev -> xconfigure.y);
      
      if (w_att.width  != ev -> xconfigure.width ||
	  w_att.height != ev -> xconfigure.height)
	{
	  w_att.width  = ev -> xconfigure.width;
	  w_att.height = ev -> xconfigure.height;
	  
	  shrt2hght = w_att.height / (double) USHRT_MAX;
	  
	  if (app_data.debug > 0) printf("RedrawWindow\n");
	  ReDrawWindow (0, 0, w_att.width, w_att.height);
	}
    }
}

int
main (int argc, char *argv[])
{
  int		i, j;
  Widget	toplevel;
  XtAppContext	app_ctxt;

  toplevel = XtVaAppInitialize (&app_ctxt, CLASSTYPE,
				options, XtNumber (options),
				&argc, argv, fallback_resources, NULL);
  if (argc > 1) Usage (argc, argv);
  XtGetApplicationResources (toplevel, &app_data,
			     resources, XtNumber(resources), NULL, 0);
  
  wdg = XtVaCreateManagedWidget ("simple",
				 simpleWidgetClass, toplevel, NULL);

  XtRealizeWidget (toplevel);

  dpy = XtDisplay (wdg);
  wnd = XtWindow (wdg);

  XtAddEventHandler (wdg, KeyPressMask,        False, HandleKeyPress , NULL);
  XtAddEventHandler (wdg, ExposureMask,        False, HandleExpose   , NULL);
  XtAddEventHandler (wdg, StructureNotifyMask, False, HandleStructure, NULL);
  XtAddEventHandler (wdg, 0,                   True , HandleGExpose  , NULL);

  XGetWindowAttributes (dpy, wnd, &w_att);
  if (app_data.debug > 0) printf ("Geometry = %dx%d+%d+%d\n",
				  w_att.width, w_att.height, w_att.x, w_att.y);
  
  CreateGC ();
  
  GetMemPoints (mempoints[base = 0]);

  for (i = 1; i < NOMP; i++)
    for (j = 0; j < 5; j++)
      mempoints[i][j] = mempoints[0][j];

  if (app_data.debug > 0) printf ("SetTimer\n");
  XtAppAddTimeOut (app_ctxt, (unsigned long)app_data.update * 1000,
		   Update, app_ctxt);

  if (app_data.debug > 0) printf ("EventLoop\n");
  XtAppMainLoop (app_ctxt);

  exit (0);
}
