.TH xmss-module 8 "" "X Version 11"
.SH NAME
xmss-module \- adding modules to
.IR xmss (1)
.SH DESCRIPTION
This manpage discusses the addition of new modules to
.IR xmss (1).
.I XMss
was designed to allow the easy addition of new modules, by defining a public
module interface format.  A module is visible to
.I xmss
and other modules only via its module definition.
.P
Modules for
.I xmss
are used on a single screen.  They should not attempt to manage any display or
screen other than the one managed by
.I xmss
itself.
.P
It is expected that the reader is familiar with the X11 library, Xlib.
Neither Xt nor any other toolkit (such as XView) should be used in a module.
.SH "WARNING!!!  WARNING!!!  DANGER, WILL ROBINSON!!!"
.BI "This is a " very " preliminary definition."
The semantics of resource classes is guaranteed to change; other changes are
also likely.  I plan to reorganize
.I xmss
such that the modules are classes, and user-specified instances are run; the
class resources will be exactly that, resources for all instances of a class,
as opposed to per-named-instance resources.  This will allow much greater
flexibility, and should solve the current problems with irrelevant resource
class aliases.
.P
I am releasing
.I xmss
now to get portability inputs, a wider testing base, and hopefully to fill a
need.  Not everyone manages to get
.I xscreensaver
or
.I xautolock
working; the latter, at least, has several bugs in its command line and
resource parsing that make it work only on some installations.
.SH "MODULE DEFINITION"
An
.I xmss
module consists of the following components:
.TP 15
.I name
The module's name, as would be used in the
.B xmss.module
resource;
.TP 15
.I options
The options specific to the module, as a pointer to an array of
.B XrmOptionDescRec
structures.  The resources specified in this array will be qualified by the
module's name, unless the first character (after the period or asterisk
beginning the resource specification) is uppercase; in the latter case, the
name will be qualified by the class name
.BR Saver .
(This will likely change in the future, when module classes are properly
implemented.)
.TP 15
nopt
The number of options in
.IR options .
If this value is zero, the
.I options
pointer may be
.BR NULL .
.TP 15
.I init
The initialization routine, which returns
.B True
if the module successfully initializes itself, else
.BR False ;
.TP 15
.I finit
The post-initialization routine, which behaves like the
.I init
routine and is used to check for the successful initialization of other
modules;
.TP 15
.I startup
The routine called to activate the module when the screen should be blanked
and returns the elapsed time in microseconds until the work routine should be
called or -1;
.TP 15
.I shutdown
The routine called to unblank the screen, returning the elapsed time in
microseconds until the work routine should be called or -1; and
.TP 15
.I work
The work routine also returns either the elapsed time in microseconds until it
should be called again or -1.  While
.I xmss
will not call this routine if neither the
.I startup
or
.I shutdown
routines return any value other than -1, other
modules may call it from their own
.I work
routines.  (Actually, this should never happen in
.I xmss
as distributed, but it is not unthinkable for a new module to be built ``on
top of'' an older one.  Think of it as module subclassing with inheritance.)
.P
There is also a flag in the module definition,
.IR initted ,
which indicates that the initialization of the module was successful.
Normally, this flag is maintained by
.I xmss
from the result of the
.I init
routine; however, if a module later discovers a ``permanent'' failure
condition it may clear its own
.I initted
flag to prevent itself from being invoked or reinitialized in the future.
.P
An additional flag,
.BR enabled ,
is maintained by
.B xmss
according to the contents of the
.BI xmss. module .disabled
resource.  When
.BR True ,
the module is not available via
.B module_get()
but is available by name via
.BR module_select() ;
this prevents the
.B random
module and possibly other modules from selecting the module for use.
.P
Every module must include the files
.B <X11/Xlib.h>
and
.BR "xmss-module.h" .
.SH INITIALIZATION
.BI "int (*module->" init ")( int " reinit );
.P
The
.I init
procedure is called immediately after
.I xmss
initializes itself.  The routine is expected to read module-specific
resources, allocate any ``permanent'' resources such as memory, windows,
colormaps, etc. and determine whether the module is usable.  If the
initialization is successful, the routine is expected to return
.B True
and
.I xmss
will consider that module to be usable; otherwise,
.B False
should be returned and that module will be considered nonexistent from that
point forward.
.P
When the
.B reinit
parameter is
.BR True ,
the module is being reinitialized in the wake of a change to the resource
manager database.  The module should re-read its resources from the database.
(Be warned that the module must protect against resource values changing at
inopportune times, since reinitialization can be performed while the module is
active.  If a given resource value must not change while the module is active,
the value should be copied elsewhere and reinitialized at a safe time.  For
example, the
.B dim
module copies the current value of the
.B xmss.dim.serverGrabs
resource at the beginning of its animated dim/undim process, because if its
value were to change from
.B True
to
.B False
in the middle of the animation (possible because of event delivery race
conditions) the server might never be ungrabbed.
.P
The initialization routine is allowed to perform any operations which do not
affect the screen.
.SH "POST-INITIALIZATION ROUTINE"
.BI "long (*module->" finit ")(int " reinit );
This routine is called after all modules have been initialized.  It is used
when a module requires another module to be present in order to work properly.
For example, the
.BR dim ,
.BR 2600 ,
and
.B xlock
modules all check for the
.B blank
module, and the
.B random
module checks to see that at least one other module's initialization was
successful.
.P
The
.I finit
routine is called in exactly the same way as the
.I init
routine, and returns the same value.
.SH "STARTUP ROUTINE"
.BI "long (*module->" startup ")(void);"
.P
The
.I startup
routine is expected to perform the actual blanking operation.  It is not,
however, required to do so if the
.I work
routine is to be called immediately afterward.
.P
The organization of
.I xmss
is such that the
.I startup
and
.I shutdown
routines control the invocation of the
.I work
routine by specifying the time until that routine should be called.  This time
is specified in microseconds, and should be -1 if the
.I work
routine is not to be called.
.SH "SHUTDOWN ROUTINE"
.BI "long (*module->" shutdown ")(void);"
.P
The
.I shutdown
routine is called when
.I xmss
detects keyboard or pointer activity.  It is expected to restore the screen to
its proper state.  Note that this state is not necessarily the one that was
current when the
.I startup
routine was called, since other windows may have been opened or colormaps or
cursors may have been changed, etc.  Like the
.I startup
routine, it returns the time in microseconds until the
.I work
routine should be called, or -1 if the
.I work
routine does not need to be called.  Again, the
.I shutdown
routine is not required to modify the screen if the
.I work
routine will be called immediately afterward.
.SH "WORK ROUTINE:
.BI "long (*module->" work ")(int blanked);"
.P
The
.I work
routine is called periodically by
.I xmss
if it is requested to do so by the
.I startup
or
.I shutdown
routines.  This routine can be used to modify the contents of the screen:
the
.B dim
module uses it to animate the dimming and un-dimming operations, while
.B 2600
uses it to periodically alter the contents of the colormap it installs.
As an alternative usage, the
.B xlock
module uses it to periodically check the status of the program it spawns, so
it can reset itself when the program exits and possibly compensate for an
unexpected failure of that program.
.P
As with the
.I startup
and
.I shutdown
routines, this routine should return the time in microseconds until it is to
be invoked again or -1 if it should not be run.
.P
The argument is a flag, which is
.B True
if
.B xmss
considers the screen to currently be blanked.
.SH "THE MODULE'S ENVIRONMENT"
All modules run in an environment defined by
.IR xmss ,
which consists of global variables and functions.  The variables that are
available to a module's routines are:
.TP 15
.B "Display *dpy;"
.B "int scr;"
The display and screen managed by
.IR xmss .
Only this display and screen should be considered for blanking operations, as
only this display and screen are being checked for pointer motion and key
events.
.TP 15
.B "Window root;"
A shorthand for
.BR "RootWindow(dpy, scr)" .
.SH "MODULE UTILITY FUNCTIONS"
The following functions are available for use by module routines.
.TP 15
.BI "void fatal(const char *" message ", const char *" object );
This routine should be called when an unrecoverable error occurs.  It causes a
diagnostic to be printed which includes the class name
.RB ( XMss ),
the specified
.IR message ,
and if
.I object
is not the
.B NULL
pointer, a colon and the
.IR object .
.P
This routine should only be called if the failure is likely to affect the
entire operation of
.IR xmss .
If it only affects the module itself, then the module should deinitialize
itself and either return
.B False
if the faiilure occurs in its
.I init
routine, or call the appropriate routine from the
.B blank
module otherwise.  As an example, the only time the
.B dim
and
.B 2600
modules call
.B fatal()
is when the root window's default colormap cannot be determined, indicating a
massive failure on the part of either
.I xmss
or the X server; other failures simply cause
.B dim
and
.B 2600
to deinitialize themselves and transfer control to
.BR blank .
This is sensible because most of the possible failures in these modules
involve colormap manipulation; given that the
.B blank
and
.B xlock
modules, and possibly other modules, will work on StaticGray, StaticColor,
and TrueColor visuals, it is excessive for the
.B dim
and
.B 2600
modules to abort the entire program just because they won't work in such
visuals.
.TP 15
.BI "void warning(const char *" message ", const char *" object );
This function issues messages in the same format as
.BR fatal() ,
but does not halt the program.  It can be used to signal to the user an error
during resource parsing or other errors which do not affect the operation of
the entire program.
.TP 15
.BI "const char *getRes(const char *" res_name ", const char *" res_class );
Retrieve the value of the specified resource, unparsed.  Neither the instance
name nor the class name of
.IR xmss ,
or the periods following them, should be included in the
.I res_name
or
.I res_class
(an asterisk is, however, acceptable).
.TP 15
.BI "int getNumRes(const char *" res_name ", const char *" res_class );
Return the numeric value of a resource.  The
.I res_name
and
.I res_class
are handled as described above.
.TP 15
.BI "int getBoolRes(const char *" res_name ", const char *" res_class );
Return the value of a boolean (true or false) resource, as above.  The same
values are accepted as for an Xt Boolean resource.
.TP 15
.BI "unsigned long getColorRes(const char *" res_name ", const char *" res_class );
Return the value of a color resource as above.  Both named colors and the
.BI #nnn
syntax are valid.  The value returned for a nonexistent color is the
predefined value
.BR BAD .
.TP 15
.BI "const Module *module_select(const char *" module_name );
Returns a pointer to the definition for the module named
.IR module_name .
Note that this is a
.B const
pointer:  the calling routine may not modify the resulting definition.
.TP 15
.B "int module_count(void);"
Returns the number of modules which are both initialized and enabled.  This
function is unreliable in the
.I init
routine because neither condition is fully known at that time; from the other
module routines its value is guaranteed until the routine returns.
.TP 15
.BI "const Module *module_get(int " number );
Return the module whose index is specified by
.IR number ,
which is between 0 and
.B module_count()
minus one.  The index is guaranteed to remain the same within a single module
routine, but is not guaranteed to persist between invocations of module
routines.  (The module pointer returned will remain valid, but it may be wise
to check that the module has not deinitialized itself.)
.SH "COLORMAP ROUTINES"
These routines are not technically part of the
.I xmss
module interface; rather, they are helper routines written to the interface to
perform common operations for the
.B dim
and
.B 2600
modules.  They are documented here so that other modules may use them.
Use of these routines and variables requires the inclusion of the file
colormap.h.  The variables are only usable after the
.B colormap_init()
routine has returned
.BR True .
.TP 15
.B "XVisualInfo *vis;"
A description of the default visual of the root window.
.TP 15
.B "Colormap blankCM;"
A colormap the size of the default visual's colormap, with all cells allocated
read/write.
.TP 15
.B "XColor *Colors;"
An array of XColor structures the size of the default visual's colormap, with
index and flag values predefined in ascending order for all cells.
.TP 15
.B "int colormap_init(void);"
This routine queries the X server for the root window's default visual and
defines the variables listed above accordingly.  If it returns
.BR True ,
the variables above are valid and may be used; if not, it can be assumed that
the default visual does not allow read-write colormaps.
.P
This routine may safely be called multiple times, so a module may call it from
its
.I init
routine regardless of whether other modules have already called it.
.SH "COMPILING AND LINKING"
At present, it is expected that new modules are placed in the
.B xmss
source directory and that the
.B Imakefile
is updated.  In the future, a ``link kit'' may be created which would allow
custom copies of
.B xmss
to be created without write access to the entire
.B xmss
distribution.
.SH "SEE ALSO"
xmss(1)
