/*
 * Module maintenance routines.
 */

#include <X11/Xlib.h>
#include "xmss.h"

/* not in xmss.h so it can be hidden from the rest of xmss */
/* (it must be shared, since it comes from modules.c) */
extern Module *modules[];

/*
 * Add all modules' options to the option database.
 */

void
#if NeedFunctionPrototypes
module_options(void)
#else
module_options()
#endif
{
    int c;

    for (c = 0; modules[c]; c++)
	addOptions(modules[c]->options, modules[c]->nopt, modules[c]->name);
}

/*
 * Initialize all the modules we know about.
 */

int
#if NeedFunctionPrototypes
module_init(int reinit)
#else
module_init(reinit)
    int reinit;
#endif
{
    char rn[1024];
    int c, cnt;

    /* pre-initialization */
    cnt = 0;
    for (c = 0; modules[c]; c++)
    {
	if (reinit && !modules[c]->initted)
	    continue;
	if ((modules[c]->initted = (*modules[c]->init)(reinit)))
	{
	    strcpy(rn, modules[c]->name);
	    strcat(rn, ".disabled");
	    if ((modules[c]->enabled = !getBoolRes(rn, SCLASS, ".Disabled")))
		cnt++;
	}
    }
    if (!cnt)
	return 0;
    /* post-initialization */
    cnt = 0;
    for (c = 0; modules[c]; c++)
    {
	if (!modules[c]->initted)
	    continue;
	if ((modules[c]->initted = (*modules[c]->finit)(reinit)))
	    cnt++;
    }
    return cnt;
}

/*
 * Select a module by name.
 */

_Xconst Module *
#if NeedFunctionPrototypes
module_select(_Xconst char *name)
#else
module_select(name)
    char *name;
#endif
{
    int cnt;

    if (!name || !*name)
	return modules[0];
    for (cnt = 0; modules[cnt]; cnt++)
    {
	if (strcasecmp(modules[cnt]->name, name) == 0)
	    break;
    }
    /* note that we ignore "enabled" here! */
    if (modules[cnt] && modules[cnt]->initted)
	return modules[cnt];
    return 0;
}

/*
 * Return the number of modules.
 */

int
#if NeedFunctionPrototypes
module_count(void)
#else
module_count()
#endif
{
    int cnt, c;

    cnt = 0;
    for (c = 0; modules[c]; c++)
    {
	if (modules[c]->initted && modules[c]->enabled)
	    cnt++;
    }
    return cnt;
}

/*
 * Return a module by number, counting only initialized modules.  Note that
 * the index of a module can change over the life of the program.
 */

_Xconst Module *
#if NeedFunctionPrototypes
module_get(int mod)
#else
module_get(mod)
    int mod;
#endif
{
    int c, cnt;

    cnt = 0;
    for (c = 0; modules[c]; c++)
    {
	if (modules[c]->initted && modules[c]->enabled)
	{
	    if (cnt == mod)
		return modules[c];
	    cnt++;
	}
    }
    return 0;
}
