/*
 * Run xlock, or some other external program, as a screen saver.  This module
 * has the same functionality as xautolock.
 */

#include <stdlib.h>
#include <unistd.h>
#include <sys/wait.h>
#include <X11/Xlib.h>
#include "xmss-module.h"

#ifndef DEFAULT_LOCKER
#define DEFAULT_LOCKER	"xlock -nolock"
#endif

static XrmOptionDescRec xlock_options[] =
{
    "-locker",		".locker",	 XrmoptionSepArg,	(caddr_t) 0,
};

static _Xconst Module *blank;
static int pid = -1;

/*
 * Nothing much worth doing to initialize...
 */

static int
#if NeedFunctionPrototypes
xlock_init(int reinit)
#else
xlock_init(reinit)
    int reinit;
#endif
{
    return True;
}

static int
#if NeedFunctionPrototypes
xlock_finit(int reinit)
#else
xlock_finit(reinit)
    int reinit;
#endif
{
    return (blank = module_select("blank")) != 0;
}

/*
 * Spawn xlock or the selected program.
 */

static long
#if NeedFunctionPrototypes
xlock_on(void)
#else
xlock_on()
#endif
{
    _Xconst char *cp;

    if (pid != -1)		/* already running? */
	return 1000000;
    if (!(cp = getRes("xlock.locker", SCLASS, ".Program")))
	cp = DEFAULT_LOCKER;
    switch ((pid = fork()))
    {
    case -1:
	return (*blank->startup)();
    case 0:
	close(ConnectionNumber(dpy));
	execl("/bin/sh", "sh", "-c", cp, 0);
	_exit(-1);
    default:
	break;
    }
}

static long
#if NeedFunctionPrototypes
xlock_off(void)
#else
xlock_off()
#endif
{
    if (pid == -1)
	return (*blank->shutdown)();
    return 1000000;
}

static long
#if NeedFunctionPrototypes
xlock_work(int blanked)
#else
xlock_work(blanked)
    int blanked;
#endif
{
    int res;

    if (pid == -1)
	return (*blank->work)(blanked);
    switch (waitpid(pid, &res, WNOHANG))
    {
    case 0:
	return 1000000;
    case -1:
	warning("waitpid failed", 0);
	res = -1;
	/*FALLTHROUGH*/
    default:
	pid = -1;
	if ((!WIFEXITED(res) || WEXITSTATUS(res)) && blanked)
	    return (*blank->startup)();
	return -2;
    }
}

Module xlock_module =
{
    "xlock",			/* module name */
    xlock_options,		/* module options */
    sizeof xlock_options / sizeof xlock_options[0],	/* # of options */
    xlock_init,			/* initialization */
    xlock_finit,		/* post-initialization */
    xlock_on,			/* transition to "on" state */
    xlock_off,			/* transition to "off" state */
    xlock_work,			/* called on every pass */
};
