/*
 * Random module selection for xmss.
 */

#include <X11/Xlib.h>
#include "xmss-module.h"

#ifdef SYSV
#define InitRandom srand48
#define Random lrand48
#else
#define InitRandom srandom
#define Random random
#endif

extern Module random_module;	/* forward declaration */
static _Xconst Module *module;

/*
 * Initialization:  seed the random number generator.
 */

static int
#if NeedFunctionPrototypes
random_init(int reinit)
#else
random_init(reinit)
    int reinit;
#endif
{
    if (!reinit)
	InitRandom(time(0) ^ getpid());
    return True;
}

/*
 * Post-initialization:  complain if we are the only valid module.
 */

static int
#if NeedFunctionPrototypes
random_finit(int reinit)
#else
random_finit(reinit)
    int reinit;
#endif
{
    if (module_count() <= 1)
	warning("random: no other modules!", 0);
    return module_count() > 1;
}

/*
 * Select a module at random and run its startup procedure.
 */

static long
#if NeedFunctionPrototypes
random_on(void)
#else
random_on()
#endif
{
    while ((module = module_get(Random() % module_count())) == &random_module)
	;
    if (!module)
	fatal("random: lost the module list", 0);
    return (*module->startup)();
}

/*
 * Call the randomly selected module's shutdown procedure.
 */

static long
#if NeedFunctionPrototypes
random_off(void)
#else
random_off()
#endif
{
    return (*module->shutdown)();
}

/*
 * Call the randomly-selected module's work procedure.
 */

static long
#if NeedFunctionPrototypes
random_work(int blanked)
#else
random_work(blanked)
    int blanked;
#endif
{
    if (module)
	return (*module->work)(blanked);
    return -1;
}

Module random_module =
{
    "random",			/* module name */
    0,				/* options */
    0,				/* number of options */
    random_init,		/* initialization */
    random_finit,		/* post-initialization */
    random_on,			/* transition to "on" state */
    random_off,			/* transition to "off" state */
    random_work,		/* called on every pass */
};
