/*
 * xmss HotWindow management,
 */

#include <stdlib.h>
#include <X11/Xlib.h>
#include "xmss.h"

static HotWindow *hotwin;

/*
 * Check to see if the specified coordinates are inside a hotspot.
 */

_Xconst HotGeometry *
#if NeedFunctionPrototypes
ck_hot(int x, int y, _Xconst HotGeometry *g)
#else
ck_hot(x, y, g)
    int x, y;
    HotGeometry *g;
#endif
{
    _Xconst HotGeometry *hp;

    for (hp = g; hp; hp = hp->next)
    {
	if (x < hp->x || x >= hp->x + hp->w)
	    continue;
	if (y >= hp->y && y < hp->y + hp->h)
	    break;
    }
    return hp;
}

/*
 * Display a "hot window".
 */

void
#if NeedFunctionPrototypes
show_hot(_Xconst HotGeometry *g, unsigned long color)
#else
show_hot(g, color)
    HotGeometry *g;
    unsigned long color;
#endif
{
    XSetWindowAttributes sw;
    HotWindow *hot, *w, *hp;
    int f;

    if (color == BAD)
	return;
    hot = 0;
    f = 0;
    for (w = hotwin; w; w = hp)
    {
	hp = w->next;
	if (w->hot == g || w->setp)
	{
	    w->next = hot;
	    hot = w;
	    if (w->hot == g)
		f = 1;
	}
	else
	{
	    XDestroyWindow(dpy, w->win);
	    free(w);
	}
    }
    if (f)
	return;
    if (!(hp = malloc(sizeof *hp)))
	fatal("can't allocate hotwindow", 0);
    hp->next = hot;
    hotwin = hp;
    hp->hot = g;
    hp->setp = 0;
    sw.background_pixel = color;
    sw.border_pixel = BlackPixel(dpy, scr);
    sw.save_under = True;
    sw.override_redirect = True;
    hp->win = XCreateWindow(dpy, RootWindow(dpy, scr), g->x, g->y, g->w, g->h,
			    1, CopyFromParent, InputOutput, CopyFromParent,
			    CWBackPixel|CWBorderPixel|CWSaveUnder|
			      CWOverrideRedirect,
			    &sw);
    XMapRaised(dpy, hp->win);
}

/*
 * Display the hotspots specified by the HotGeometry *list*.  Don't remove
 * existing hotspot windows.
 */

void
#if NeedFunctionPrototypes
add_hot(_Xconst HotGeometry *g, unsigned long color)
#else
add_hot(g, color)
    HotGeometry *g;
    unsigned long color;
#endif
{
    XSetWindowAttributes sw;
    HotWindow *hp;

    if (color == BAD)
	return;
    sw.background_pixel = color;
    sw.border_pixel = BlackPixel(dpy, scr);
    sw.save_under = True;
    sw.override_redirect = True;
    while (g)
    {
	for (hp = hotwin; hp; hp = hp->next)
	{
	    if (hp->hot == g)
	    {
		hp->setp = 1;
		break;
	    }
	}
	if (!hp)
	{
	    if (!(hp = malloc(sizeof *hp)))
		fatal("can't allocate hotwindow", 0);
	    hp->next = hotwin;
	    hotwin = hp;
	    hp->hot = g;
	    hp->setp = 1;
	    hp->win = XCreateWindow(dpy, RootWindow(dpy, scr), g->x, g->y,
				    g->w, g->h, 1, CopyFromParent,
				    InputOutput, CopyFromParent,
				    CWBackPixel|CWBorderPixel|CWSaveUnder|
				      CWOverrideRedirect,
				    &sw);
	    XMapRaised(dpy, hp->win);
	}
	g = g->next;
    }
}

/*
 * Hide a hotspot window.
 */

void
#if NeedFunctionPrototypes
hide_hot(void)
#else
hide_hot()
#endif
{
    HotWindow *hot, *hp, *w;

    hot = 0;
    for (w = hotwin; w; w = hp)
    {
	hp = w->next;
	if (w->setp)
	{
	    w->next = hot;
	    hot = w;
	}
	else
	{
	    XDestroyWindow(dpy, w->win);
	    free(w);
	}
    }
    hotwin = hot;
}

/*
 * Hide the hotspot windows that are in the set.
 */

void
#if NeedFunctionPrototypes
del_hot(_Xconst HotGeometry *g)
#else
del_hot(g)
    HotGeometry *g;
#endif
{
    HotWindow *hot, *hp, *w;
    _Xconst HotGeometry *gp;

    hot = 0;
    for (w = hotwin; w; w = hp)
    {
	hp = w->next;
	for (gp = g; gp; gp = gp->next)
	{
	    if (w->hot == gp && w->setp)
		break;
	}
	if (gp)
	{
	    XDestroyWindow(dpy, w->win);
	    free(w);
	}
	else
	{
	    w->next = hot;
	    hot = w;
	}
	w = hp;
    }
    hotwin = hot;
}

/*
 * Check to see if a window's one of our hot windows.  Pity the xcreatewindow
 * event doesn't specify the client that created the window...
 */

int
#if NeedFunctionPrototypes
is_hot(Window w)
#else
is_hot(w)
    Window w;
#endif
{
    HotWindow *hp;

    for (hp = hotwin; hp; hp = hp->next)
    {
	if (hp->win == w)
	    return True;
    }
    return False;
}
