/*
 * Common colormap information for the dim and 2600 modules.
 */

#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "xmss-module.h"
#include "colormap.h"

static int initted = -1;
XVisualInfo *vis;
Colormap blankCM;
XColor *Colors;

/*
 * Initialization:  check visual and colormap for compatibility, disqualifying
 * ourself if unusable, and set up for dimming.  Return True if we successfully
 * initialize, or False to disable our use.
 */

int
#if NeedFunctionPrototypes
colormap_init(void)
#else
colormap_init()
#endif
{
    XVisualInfo vit;
    int z;

    if (initted != -1)
	return initted;
    vit.visualid = XVisualIDFromVisual(DefaultVisual(dpy, scr));
    if (!(vis = XGetVisualInfo(dpy, VisualIDMask, &vit, &z)))
	return False;
    if (DefaultDepth(dpy, scr) == 1)
    {
	initted = False;
	return False;
    }
    else if (vis->class != DirectColor && vis->class != PseudoColor &&
	     vis->class != GrayScale)
    {
	initted = False;
	return False;
    }
    blankCM = XCreateColormap(dpy, root, DefaultVisual(dpy, scr), AllocAll);
    if (!blankCM || blankCM == DefaultColormap(dpy, scr))
    {
	initted = False;
	return False;
    }
    if (!(Colors = malloc(vis->colormap_size * sizeof *Colors)))
	return False;
    for (z = vis->colormap_size; z--; )
	Colors[z].pixel = z;
    XQueryColors(dpy, DefaultColormap(dpy, scr), Colors, vis->colormap_size);
    initted = True;
    return True;
}
