/*
   
   Permission hereby granted to use and change this software, and make
   derivative works based on this code, as long as it mentions initial
   author - Roman Mitnitski, mitnits@shani.net.

   ROMAN MITNITSKI MAKES NO WARRANTY OF ANY KIND WITH REGARD
   TO THIS SOFWARE, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
   WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
   PURPOSE.  Roman Mitnitski shall not be liable for errors
   contained herein or direct, indirect, special, incidental or
   consequential damages in connection with the furnishing,
   performance, or use of this program.               

*/

#include <X11/IntrinsicP.h>
#ifdef MSDOS /* Yes, it compiles under Deskview/X */
#include <X11/Intrinsc.h>
#include <X11/IntrinsP.h>
#endif
#include <X11/XWDFile.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/ShellP.h>
#include "wiconsh.h"
#include "wiconshp.h"
#include <stdio.h>
#include <X11/xpm.h>
#include <X11/Xaw/Label.h>
#include <X11/cursorfont.h>
#include <X11/extensions/shape.h>

/***************************************************************************
 *
 * wicon shell class record
 *
 ***************************************************************************/


#define SHW 6
#undef Offset
#define Offset(x)       (XtOffsetOf(WiconShellRec, x))

/* You will need do link with blip.c */
extern int _Blip_Is_Working;

static XtResource wiconResources[]=
{
    {XtNpixmapData, XtCPixmapData, XtRStringArray, sizeof(char **),
         Offset(wicon.pixmapData), XtRStringArray, (XtPointer)NULL},
    {XtNtagLabel, XtCTagLabel, XtRString, sizeof(char *),
         Offset(wicon.tagLabel), XtRString, "NoName"},

    {XtNtagBackground, XtCTagBackground, XtRPixel, sizeof(Pixel),
         Offset(wicon.Bg), XtRString, "#9e9e9e"},
    {XtNtagForeground, XtCTagForeground, XtRPixel, sizeof(Pixel),
         Offset(wicon.Fg), XtRString, "black"},

    {XtNtagActiveBackground, XtCTagActiveBackground, XtRPixel, sizeof(Pixel),
         Offset(wicon.ABg), XtRString, "midnightblue"},

    {XtNtagActiveForeground, XtCTagActiveForeground, XtRPixel, sizeof(Pixel),
         Offset(wicon.AFg), XtRString, "white"},

    {XtNmiddleColor, XtCMiddleColor, XtRPixel, sizeof(Pixel),
         Offset(wicon.middlec), XtRString, "#9e9e9e"},
    {XtNtopShadow, XtCTopShadow, XtRPixel, sizeof(Pixel),
         Offset(wicon.topsh), XtRString, "white"},

    {XtNbottomShadow, XtCBottomShadow, XtRPixel, sizeof(Pixel),
         Offset(wicon.botsh), XtRString, "black"},

    {XtNfreezeIcon, XtCBoolean, XtRBoolean, sizeof(Boolean),
         Offset(wicon.freezed), XtRImmediate, (XtPointer)False},

    {XtNiconDropCallback, XtCCallback, XtRCallback, sizeof(XtPointer),
         Offset(wicon.dropcallback), XtRCallback, (XtPointer)NULL},

    {XtNiconClickCallback, XtCCallback, XtRCallback, sizeof(XtPointer),
         Offset(wicon.clickcallback), XtRCallback, (XtPointer)NULL},

    {XtNiconDoubleClickCallback, XtCCallback, XtRCallback, sizeof(XtPointer),
         Offset(wicon.doubleclickcallback), XtRCallback, (XtPointer)NULL},

};

#undef Offset


static char defaultTranslations[]=
             "<Btn1Motion>:   HandleMotion()   \n\
              <Btn1Down>:     HandlePush()     \n\
              <Btn1Up>:       HandleRelease()";


static void Realize();
static void HandleRelease(),HandleMotion(),HandlePush(); 
static void Destroy();
static Boolean SetValues ();
Pixmap BevelPixmap(Widget gw,
		   unsigned int ini_w,
		   unsigned int ini_h,
		   unsigned int * ret_w,unsigned int *ret_h);

static XtActionsRec actionsList[]={
    {"HandlePush"   , HandlePush    },
    {"HandleRelease", HandleRelease },
    {"HandleMotion" , HandleMotion  },
};                                                                             

externaldef(wiconshellclassrec) WiconShellClassRec wiconShellClassRec = {
  {
    /* superclass         */    (WidgetClass) &transientShellClassRec,
    /* class_name         */    "WiconShell",
    /* size               */    sizeof(WiconShellRec),
    /* Class Initializer  */	NULL,
    /* class_part_initialize*/	NULL,
    /* Class init'ed ?    */	FALSE,
    /* initialize         */    NULL,
    /* initialize_notify    */	NULL,		
    /* realize            */    Realize, /*  XtInheritRealize,*/ 
    /* actions            */    actionsList,
    /* num_actions        */    XtNumber(actionsList),
    /* resources          */    wiconResources,
    /* resource_count     */	XtNumber(wiconResources),
    /* xrm_class          */    NULLQUARK,
    /* compress_motion    */    FALSE,
    /* compress_exposure  */    TRUE,
    /* compress_enterleave*/	FALSE,
    /* visible_interest   */    FALSE,
    /* destroy            */    Destroy,
    /* resize             */    XtInheritResize,
    /* expose             */    NULL,
    /* set_values         */    SetValues,
    /* set_values_hook      */	NULL,			
    /* set_values_almost    */	XtInheritSetValuesAlmost,  
    /* get_values_hook      */	NULL,
    /* accept_focus       */    NULL,
    /* intrinsics version */	XtVersion,
    /* callback offsets   */    NULL,
    /* tm_table		  */	defaultTranslations,
    /* query_geometry	    */  NULL,
    /* display_accelerator  */  NULL,
    /* extension	    */  NULL
  },{
    /* geometry_manager   */    XtInheritGeometryManager,
    /* change_managed     */    XtInheritChangeManaged,
    /* insert_child	  */	XtInheritInsertChild,
    /* delete_child	  */	XtInheritDeleteChild,
    /* extension	    */  NULL
  },{
    /* extension	    */  NULL
  },{
    /* extension	    */  NULL
  },{
    /* extension	    */  NULL
  },{
    /* extension	    */  NULL
  }
};

#if !defined(AIXSHLIB) || !defined(SHAREDCODE)
externaldef(vendorshellwidgetclass) WidgetClass wiconShellWidgetClass =
	(WidgetClass) (&wiconShellClassRec);
#endif


/*
 *  This function searches up in widget tree to find
 *  the shell parent (or toplevel) for given widget.
 */

static int PushX,PushY;

static Boolean SetValues (gcurrent, grequest, gnew)
    Widget gcurrent, grequest, gnew;
{
    WiconShellWidget current = (WiconShellWidget) gcurrent;
    WiconShellWidget new = (WiconShellWidget) gnew;
    WiconShellWidget request = (WiconShellWidget) grequest;
    Boolean redisplay = FALSE;
    Arg al[20];
    int ac;
    unsigned int h,w;

    ac=0;
/* Does not work on SGI for no apparent reason */
  if (strcmp(new->wicon.tagLabel, current->wicon.tagLabel)!=0)
      {
	ac=0;
	XtSetArg(al[ac],XtNlabel,current->wicon.tagLabel); ac++;
	XtSetValues(new->wicon.label,al,ac);
	ac=0;
	XtSetArg(al[ac],XtNwidth,&w);ac++;
	XtSetArg(al[ac],XtNheight,&h);ac++;
	XtGetValues(new->wicon.label,al,ac);    
	new->wicon.label_w=w+current->wicon.LabelBorder*2;
	new->wicon.label_h=h+current->wicon.LabelBorder*2;
	ac=0;
	XtSetArg(al[ac],XtNx,new->core.x-(w-
					  new->core.width)/2 -1); ac++;
	XtSetArg(al[ac],XtNy,new->core.y+new->core.height+2); ac++;
	XtSetValues(new->wicon.labelsh,al,ac);
      }
    if (new->core.x!= current->core.x
	|| new->core.y!= current->core.y)
      {
	int newx= current->core.x;
	int newy=current->core.y;
	if (new->core.x!= current->core.x) 
	    newx=new->core.x;
	if (new->core.y!= current->core.y) newy=new->core.y;
	XMoveWindow(XtDisplay((Widget)new),XtWindow((Widget)new),newx,newy);
	XtMoveWidget((Widget)new,newx,newy);

	ac=0;
	XtSetArg(al[ac],XtNx,newx-(new->wicon.label_w-
					  new->core.width)/2); ac++;
	XtSetArg(al[ac],XtNy,newy+new->core.height+2); ac++;
	XtSetValues(new->wicon.labelsh,al,ac);

      }
    if ((new->wicon.pixmapData!= current->wicon.pixmapData)
	||new->core.width!=current->core.width
	||new->core.height!=current->core.height)
      {
	Pixmap NewPixmap;
	WiconShellWidget gw=new;
	unsigned int new_w = current->core.width;
	unsigned int new_h = current->core.height;

	if (new->core.width!= current->core.width) 
	  new_w=new->core.width;
	if (new->core.height!= current->core.height)
	  new_h=new->core.height;

	NewPixmap=
	  BevelPixmap((Widget)gw, new_w,new_h,&w,
		      &h);
	XSetWindowBackgroundPixmap(XtDisplay(gw),XtWindow(gw),NewPixmap);
	XFreePixmap(XtDisplay(gw),NewPixmap);
	XClearWindow(XtDisplay(gw),XtWindow(gw));
	XFlush(XtDisplay(gw));

	XtResizeWidget((Widget)gw,w,h,0);

	ac=0;
	XtSetArg(al[ac],XtNx,new->core.x-(new->wicon.label_w-w)/2); ac++;
	XtSetArg(al[ac],XtNy,new->core.y+new->core.height+2); ac++;
	XtSetValues(new->wicon.labelsh,al,ac);
      }
    return (redisplay);
}
 

static void  ButtonClick(f,gw,event,flag)
Widget f;
Widget gw;
XEvent *event;
Boolean *flag;    
{
  time_t t;
  WiconShellWidget sh = (WiconShellWidget) gw;  
  
  if (event->xbutton.type==ButtonPress)
    {
      time(&t);
      PushX=event->xbutton.x+sh->wicon.LabelBorder;
      PushY=event->xbutton.y+sh->wicon.LabelBorder;
      if (!_Blip_Is_Working)
	{
	  if ((abs((long)t-(long)sh->wicon.etime))<1)
	    {
	      BlipPoint(event->xbutton.x_root,event->xbutton.y_root,20);
	      XtCallCallbackList((Widget)gw,sh->wicon.doubleclickcallback,
				 (XtPointer)gw);
	    }
	  time(&sh->wicon.etime);
	  if (!sh->wicon.freezed)
	    {
	      XRaiseWindow(XtDisplay(gw), XtWindow(gw));
	      XRaiseWindow(XtDisplay(gw),XtWindow(sh->wicon.labelsh));
	    }
	}
      XtCallCallbackList((Widget)gw,  sh->wicon.clickcallback,
			 (XtPointer)gw);
    }

  if (event->xbutton.type==ButtonRelease)
    {
      XtCallCallbackList((Widget)gw,  sh->wicon.dropcallback,
			 (XtPointer)gw);
    }
}


static void  ButtonMove(f,gw,event,flag)
Widget f;
Widget gw;
XEvent *event;
Boolean *flag;    
{
  WiconShellWidget sh = (WiconShellWidget) gw;  
  int MotionX,MotionY;
  if (!sh->wicon.freezed)
    {
      MotionX=event->xmotion.x_root;
      MotionY=event->xmotion.y_root;
      
      MotionX-= PushX;
      MotionY-= PushY;
      
      XMoveWindow(XtDisplay(gw),XtWindow(gw),
		  MotionX + (sh->wicon.label_w - sh->core.width)/2,
		  MotionY - sh->core.height-2);
      
      XMoveWindow(XtDisplay(gw),XtWindow(sh->wicon.labelsh),MotionX,MotionY);
    }
/*  XFlush(XtDisplay(gw));  */
}
static void
Destroy (gw)
    Widget gw;
{
/* MUST to do more things here! */  
    WiconShellWidget sh = (WiconShellWidget) gw;

    XtPopdown(sh->wicon.labelsh);
    XtDestroyWidget(sh->wicon.labelsh);
}

Pixmap BevelPixmap(gw,ini_w,ini_h,ret_w,ret_h)
Widget gw;
unsigned int ini_w;
unsigned int ini_h;
unsigned int * ret_w;
unsigned int  * ret_h;
{
  Pixmap pixmap=None,mask=None;
  Display * dpy=XtDisplay(gw);
  WiconShellWidget sh = (WiconShellWidget) gw;
  XpmAttributes attributes;
  int Error;
  Pixmap NewPixmap;
  XGCValues gcv;
  GC gc,gcf;
  int vmask;  

  attributes.valuemask = 0; 

  Error=XpmCreatePixmapFromData(dpy,XtWindow(sh),
				sh->wicon.pixmapData,
				&pixmap,&mask,&attributes);

/* If shell size is too small for the icon - adjust it */
  if (ini_h<attributes.height+SHW) ini_h=attributes.height+SHW;
  if (ini_w<attributes.width+SHW)  ini_w=attributes.width+SHW;

/* Create substitute pixmap */
  NewPixmap=XCreatePixmap(dpy,XDefaultRootWindow(dpy),
			  ini_w,
			  ini_h,
			  XDefaultDepth(dpy,XDefaultScreen(dpy)));
  
  gcv.function=GXcopy;
  gcv.background=sh->wicon.middlec;
  gcv.foreground=sh->wicon.middlec;
  vmask=GCFunction|GCBackground|GCForeground;
  gcf=XCreateGC(dpy,XtWindow(gw),vmask,&gcv);
  if (mask!=None)
    {
      vmask=vmask|GCClipMask|GCClipXOrigin|GCClipYOrigin;
      gcv.clip_mask=mask;
      gcv.clip_x_origin=(ini_w-attributes.width)/2;
      gcv.clip_y_origin=(ini_h-attributes.height)/2;
    }
  gc=XCreateGC(dpy,XtWindow(gw),vmask,&gcv);
  XFillRectangle(dpy,NewPixmap,gcf,0,0,ini_w,ini_h);

  XCopyArea(dpy,pixmap,NewPixmap,gc,0,0,
	    attributes.width,attributes.height,
	    (ini_w-attributes.width)/2,(ini_h-attributes.height)/2);

  vmask=GCBackground|GCForeground;
  gcv.background=sh->wicon.topsh;
  gcv.foreground=sh->wicon.topsh;
  XChangeGC(dpy,gcf,vmask,&gcv);
  
  /* Draw bevelled edges around the icon */
  
  XDrawLine(dpy,NewPixmap,gcf,0,0,ini_w,0);
  XDrawLine(dpy,NewPixmap,gcf,0,0,0,ini_h);
  XDrawLine(dpy,NewPixmap,gcf,SHW/2-1,
	    ini_h-SHW/2,
	    ini_w-SHW/2,
	    ini_h-SHW/2);
  XDrawLine(dpy,NewPixmap,gcf,ini_w-SHW/2,
	    SHW/2-1,
	    ini_w-SHW/2,
	    ini_h-SHW/2);
  XDrawLine(dpy,NewPixmap,gcf,0,0,0,ini_h);
  
  vmask=GCBackground|GCForeground;
  gcv.background=sh->wicon.botsh;
  gcv.foreground=sh->wicon.botsh;
  XChangeGC(dpy,gcf,vmask,&gcv);
  
  XDrawLine(dpy,NewPixmap,gcf,ini_w-1,
		      0,ini_w-1,ini_h);
  XDrawLine(dpy,NewPixmap,gcf,0,
	    ini_h-1,
	    ini_w,
	    ini_h-1);
  
  XDrawLine(dpy,NewPixmap,gcf,SHW/2-1,
	    SHW/2-1,
	    SHW/2-1,
	    ini_h-SHW/2-1);
  XDrawLine(dpy,NewPixmap,gcf,SHW/2,
	    SHW/2-1,
	    ini_w-SHW/2-1,
	    SHW/2-1);
  
  
  XFreeGC(dpy,gc);
  XFreeGC(dpy,gcf);

  *ret_w=ini_w;
  *ret_h=ini_h;

  XFreePixmap(XtDisplay(gw),pixmap);
  if (mask!=None) XFreePixmap(XtDisplay(gw),mask);

  return NewPixmap;
}

static void Realize (gw, valuemaskp, attr)
    Widget gw;
    XtValueMask *valuemaskp;
    XSetWindowAttributes *attr;
{
    WiconShellWidget sh = (WiconShellWidget) gw;
    int ac;
    Arg al[10];
    unsigned int width,height;
    Widget dialog;
    Widget tmp;

    Pixmap NewPixmap;
    Cursor WCursor;
    
    InitBlip(XtParent(gw));

    WCursor=XCreateFontCursor(XtDisplay(gw),XC_top_left_arrow);
    sh->wicon.label=NULL;
    if (sh->core.height==0) {sh->core.height=1;}
    if (sh->core.width==0)  {sh->core.width =1;}
    /* Call superclass realize fuction set */
    
    (*wiconShellWidgetClass->core_class.superclass->core_class.realize)
	(gw, valuemaskp, attr);

    /* Make shell INVISIBLE for window manager */

    ac=0;
    XtSetArg(al[ac],XtNoverrideRedirect,True);ac++;
    XtSetValues((Widget)sh,al,ac);
    
    if (sh->wicon.pixmapData!=NULL)
      {
	NewPixmap=
	  BevelPixmap(gw,sh->core.width,sh->core.height,&width,
		      &height);
	XSetWindowBackgroundPixmap(XtDisplay(gw),XtWindow(gw),NewPixmap);
	XFreePixmap(XtDisplay(gw),NewPixmap);
	XClearWindow(XtDisplay(gw),XtWindow(gw));
	XtResizeWidget(gw,width,height,0);
      }
    XMoveWindow(XtDisplay(gw),XtWindow(gw),sh->core.x,sh->core.y);

    ac=0;

    XtSetArg(al[ac],XtNx,sh->core.x); ac++;
    XtSetArg(al[ac],XtNy,sh->core.y+
	     sh->core.height+2); ac++;

    XtSetArg(al[ac],XtNtransientFor,XtParent(gw)); ac++;
/* Positively NEED to allow shell resize, OR ELSE! */
    XtSetArg(al[ac],XtNallowShellResize,True); ac++;
    XtSetArg(al[ac], XtNoverrideRedirect,True);ac++;

    dialog=XtCreatePopupShell("labelsh", shellWidgetClass,
                             XtParent(gw) , al, ac);
    ac=0;
    XtSetArg(al[ac],XtNlabel,sh->wicon.tagLabel); ac++;
    XtSetArg(al[ac],XtNbackground,sh->wicon.Bg); ac++;
    XtSetArg(al[ac],XtNforeground,sh->wicon.Fg); ac++;
    tmp=XtCreateManagedWidget("label", labelWidgetClass,
                             dialog , al, ac);

    sh->wicon.labelsh=dialog;
    sh->wicon.label=tmp;

    XtPopup(dialog,XtGrabNone);
    {
      int ac;
      Arg al[10];
      Dimension w,h;
      ac=0;
      XtSetArg(al[ac],XtNwidth,&w);ac++;
      XtSetArg(al[ac],XtNheight,&h);ac++;
      XtGetValues(tmp,al,ac);

      ac=0;
      XtSetArg(al[ac],XtNborderWidth,&sh->wicon.LabelBorder);ac++;
      XtGetValues(dialog,al,ac);

      sh->wicon.label_w=w+sh->wicon.LabelBorder*2;
      sh->wicon.label_h=h+sh->wicon.LabelBorder*2;

      ac=0;
      XtSetArg(al[ac],XtNx,sh->core.x-(sh->wicon.label_w-sh->core.width)/2); 
      ac++;
      XtSetArg(al[ac],XtNy,sh->core.y+sh->core.height+2); ac++;
      XtSetValues(dialog,al,ac);
    }
    XDefineCursor(XtDisplay(gw),XtWindow(gw),WCursor);
    XDefineCursor(XtDisplay(gw),XtWindow(tmp),WCursor);
    XFreeCursor(XtDisplay(gw),WCursor);
    XtAddEventHandler(tmp,ButtonPressMask|ButtonReleaseMask,True,
		      (XtPointer)ButtonClick,gw);    
    XtAddEventHandler(tmp,ButtonMotionMask,True,
		      (XtPointer)ButtonMove,gw);    
}

void
WiconSetActive(gw)
     Widget gw;
{
  WiconShellWidget sh = (WiconShellWidget) gw;
  int ac;
  Arg al[10];

  ac=0;
  XtSetArg(al[ac],XtNbackground,sh->wicon.ABg); ac++;
  XtSetArg(al[ac],XtNforeground,sh->wicon.AFg); ac++;
  XtSetValues(sh->wicon.label,al,ac);
}
void
WiconSetNonActive(gw)
     Widget gw;
{
  WiconShellWidget sh = (WiconShellWidget) gw;
  int ac;
  Arg al[10];

  ac=0;
  XtSetArg(al[ac],XtNbackground,sh->wicon.Bg); ac++;
  XtSetArg(al[ac],XtNforeground,sh->wicon.Fg); ac++;
  XtSetValues(sh->wicon.label,al,ac);
}

void
WiconRaise(gw)
     Widget gw;
{
  WiconShellWidget sh = (WiconShellWidget) gw;

  XRaiseWindow(XtDisplay(gw),XtWindow(gw));
  XRaiseWindow(XtDisplay(gw),XtWindow(sh->wicon.labelsh));
}

void
WiconLower(gw)
     Widget gw;
{
  WiconShellWidget sh = (WiconShellWidget) gw;
  int ac;
  Arg al[10];

  XLowerWindow(XtDisplay(gw),XtWindow(gw));
  XLowerWindow(XtDisplay(gw),XtWindow(sh->wicon.labelsh));
}

void
WiconGetLabelSize(gw,w,h)
Widget gw;
Dimension * w;
Dimension * h;
{
  WiconShellWidget sh = (WiconShellWidget) gw;
  
  *w=sh->wicon.label_w;
  *h=sh->wicon.label_h;
}

void
WiconSetPosition(gw,x,y)
     Widget gw;
     int x;
     int y;
{
  WiconShellWidget sh = (WiconShellWidget) gw;

  gw->core.x=x;
  gw->core.y=x;

  XMoveWindow(XtDisplay(gw),XtWindow(gw),x,y);

  XtMoveWidget(gw,x,y);

  XMoveWindow(XtDisplay(gw),XtWindow(sh->wicon.labelsh),
	      x - (sh->wicon.label_w-sh->core.width)/2,
	      y + sh->core.height+2);

}


void
WiconSetLabel(gw,str)
     Widget gw;
     char * str;
{
  WiconShellWidget sh = (WiconShellWidget) gw;
  Dimension w,h;
  int ac;
  Arg al[10];

  ac=0;
  XtSetArg(al[ac],XtNlabel,str); ac++;
  XtSetValues(sh->wicon.label,al,ac);
  ac=0;
  XtSetArg(al[ac],XtNwidth,&w);ac++;
  XtSetArg(al[ac],XtNheight,&h);ac++;
  XtGetValues(sh->wicon.label,al,ac);
  sh->wicon.label_w=w+sh->wicon.LabelBorder*2;
  sh->wicon.label_h=h+sh->wicon.LabelBorder*2;
  ac=0;
  XtSetArg(al[ac],XtNx,sh->core.x-(w-
				    sh->core.width)/2 -1); ac++;
  XtSetArg(al[ac],XtNy,sh->core.y+sh->core.height+2); ac++;
  XtSetValues(sh->wicon.labelsh,al,ac);
}


static void
HandleRelease(gw,event,params,num_params)
     Widget gw;
     XEvent *event;
     String * params;       /* unused */
     Cardinal * num_params; /* unused */
{
  int PopX,PopY;
  WiconShellWidget sh = (WiconShellWidget) gw;
  
  if (!sh->wicon.freezed)
    {
      PopX=event->xbutton.x_root-PushX;
      PopY=event->xbutton.y_root-PushY;
      gw->core.x=PopX;
      gw->core.y=PopY;

      XMoveWindow(XtDisplay(gw),XtWindow(gw),PopX,PopY);
      
      XtMoveWidget(gw,PopX,PopY);
      
      XMoveWindow(XtDisplay(gw),XtWindow(sh->wicon.labelsh),
		  PopX - (sh->wicon.label_w-sh->core.width)/2,
		  PopY+sh->core.height+2);

      /*XMapWindow(XtDisplay(gw),XtWindow(sh->wicon.labelsh));*/
    }
  if (!_Blip_Is_Working)
    if (!sh->wicon.freezed)
      XRaiseWindow(XtDisplay(gw),XtWindow(sh->wicon.labelsh));
  XtCallCallbackList((Widget)gw,  sh->wicon.dropcallback,
		       (XtPointer)gw);
}

static void
HandleMotion(gw,event,params,num_params)
     Widget gw;
     XEvent *event;
     String * params;       /* unused */
     Cardinal * num_params; /* unused */
{
  int MotionX,MotionY;
  WiconShellWidget sh = (WiconShellWidget) gw;  
  int w=sh->wicon.label_w;
  Widget l=sh->wicon.labelsh;
  if (!sh->wicon.freezed)
    {
      MotionX=event->xmotion.x_root;
      MotionY=event->xmotion.y_root;
      
      MotionX-= PushX;
      MotionY-= PushY;
      
      /*  XUnmapWindow(XtDisplay(gw),XtWindow(sh->wicon.labelsh));*/
      
      XMoveWindow(XtDisplay(gw),XtWindow(gw),MotionX,MotionY);
      XMoveWindow(XtDisplay(gw),XtWindow(l),
		  MotionX - (w-sh->core.width)/2,
		  MotionY+sh->core.height+2);
      /*  XFlush(XtDisplay(gw));*/
    }
  sh->wicon.etime=0; /* Prevent double click when dragging */
}
static void
HandlePush(gw,event,params,num_params)
     Widget gw;
     XEvent *event;
     String * params;       /* unused */
     Cardinal * num_params; /* unused */
{
  WiconShellWidget sh = (WiconShellWidget) gw;
  time_t t;
  PushX=event->xbutton.x;
  PushY=event->xbutton.y;
  if (!_Blip_Is_Working)
    {
      if (!sh->wicon.freezed)
	{
	  XRaiseWindow(XtDisplay(gw),XtWindow(gw));
	  XRaiseWindow(XtDisplay(gw),XtWindow(sh->wicon.labelsh));
	}
      time(&t);
      if ((abs((long)t-(long)sh->wicon.etime))<1)
	{
	  BlipPoint(event->xbutton.x_root,event->xbutton.y_root,20);
	  XtCallCallbackList((Widget)gw,sh->wicon.doubleclickcallback,
			     (XtPointer)gw);
	}
      time(&sh->wicon.etime);
    }
  XtCallCallbackList((Widget)gw,  sh->wicon.clickcallback,
		       (XtPointer)gw);
}
