/*
 *  Permission hereby granted to use and change this software, and make
 *  derivative works based on this code, as long as it mentions initial
 *  authors - Roman Mitnitski (mitnits@shani.net) and Vladimir Lobak
 *  (vels@spider.cs.biu.ac.il).
 * 
 *  ROMAN MITNITSKI AND VLADIMIR LOBAK MAKE NO WARRANTY OF ANY KIND 
 *  WITH REGARD TO THIS SOFWARE, INCLUDING, BUT NOT LIMITED TO, THE 
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 *  PURPOSE.  Roman Mitnitski and Vladimir Lobak will not be liable 
 *  for errors contained herein or direct, indirect, special, incidental 
 *  or consequential damages in connection with the furnishing,
 *  performance, or use of this program.               
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/cursorfont.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/Xatom.h>
#include <X11/XWDFile.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>  
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdlib.h>
#include <unistd.h>
#include "wiconsh.h"
#include "config.h"

#include "cry.xpm"

/*
 * Extern stuff
 */ 
extern Atom  XA_TYCOON;
extern Atom  XA_KILL_ACTIVE;
extern Atom  XA_ADD_ICON;
extern Atom  XA_EDIT_ICON;
extern Atom  XA_KILL;
extern Atom  XA_ALIGN;
extern Atom  XA_FREEZE;
extern Atom  XA_UNFREEZE;
extern Atom  XA_LOWER;
extern Atom  XA_RAISE;

extern Widget toplevel, current_item, dialog;

/* 1 if icons are sticked to the screen */
Boolean Freezed=False;

/*
 * WIconSH functions
 */ 
void WiconSetActive (Widget);
void WiconSetNonActive (Widget);
void WiconSetPosition (Widget, int, int);

/*
 * Icon parameters
 */ 
typedef struct _Tycoon_Item_
{
    int x,y;                  /* Icon coordinates */
    char cmdline[MAX_PATH];   /* Command line to execute when doubleclicked */
    char icon[MAX_PATH];      /* XPM file path */
    char label[MAX_LINE];     /* Icon label */
    Widget shell;             /* wiconsh widget */
} Tycoon_Item;

/*
 * Array of icons
 */ 
static Tycoon_Item Item[MAX_ICONS]; 
static int num_icons = 0;

/*
 * Update ini-file. Ini-file updated each time an icon has changed 
 * active status, moved, removed or added.
 */ 
void UpdateRc (void)
{
    int i,k;
    Dimension temp_x, temp_y;
    FILE *iconrc;
    char ini_file[MAX_PATH], bak_ini_file[MAX_PATH];
   struct stat *buf;     

   /*
    * Try to open/create ini-file 
    */ 
   strcpy (ini_file, getenv("HOME"));
   strcat (ini_file, INI_FILE);
   /*
    * Backup the current first
    */ 
   strcpy (bak_ini_file, ini_file);
   strcat (bak_ini_file, ".bak");
    if ((iconrc=fopen(ini_file,"r"))!=0) /* File exists, save the copy */  
     if (rename (ini_file, bak_ini_file) < 0)
     {
       fclose(iconrc);
       perror ("rename ini-file");
       return;
      }
    if ((iconrc=fopen(ini_file, "wt")) == NULL)
	{
	    perror ("open ini-file");
	    return;
	}
    /* Update freeze state */
    if (Freezed)
      {
	fprintf(iconrc,"Freezed\n");
      }
    /*
     * Go over all icons and write information about each one
     * to ini-file
     */ 
    for (i=0;i<num_icons;i++)
	{
	    XtVaGetValues (Item[i].shell, 
			   XtNx, &temp_x,
			   XtNy, &temp_y,
			   NULL);
	    Item[i].x = temp_x;
	    Item[i].y = temp_y;
	    
	    /*
	     * Write information about an item
	     */ 
	    if (Item[i].shell == current_item)
	      fprintf(iconrc, "Active");
	    else
	      fprintf(iconrc, "Icon");
/*	    fprintf(iconrc, " %d %d %s %s %s\n",
		    Item[i].x, Item[i].y,
		    Item[i].label, Item[i].icon,
		    Item[i].cmdline);*/
	    fprintf(iconrc, " %d %d \"", Item[i].x, Item[i].y);
	    /*
	     * When storing label - we have to store each '\n'
	     * (to restore multi-line labels properly)
	     */
	     k=0;
	     while (Item[i].label[k])
		{
		    if (Item[i].label[k]=='\n')
			fprintf(iconrc,"%s","\\n");
		    else
			fprintf(iconrc,"%c",Item[i].label[k]);
		    k++;
		}
	    fprintf(iconrc,"\" %s %s\n", Item[i].icon,Item[i].cmdline);
	    
	}
    
    fclose (iconrc);
    
    /*
     * If we have no icons - remove ini-file
     */ 
    if (num_icons == 0) unlink(ini_file);
}


/*
 * Mouse click callback - change current item
 */ 
void ClickCallback (item, lArg, N)
    Widget item;
    XtPointer lArg;
    XtPointer N;        
{
    if (item != current_item)
	{
	    WiconSetActive(item);
	    if (current_item != NULL)
		WiconSetNonActive (current_item);
	    current_item = item;
	}
}

/*
 * Drag & drop callback - update ini-file
 */ 
void DropCallback (item, lArg, N)
    Widget item;
    XtPointer lArg;
    XtPointer N;        
{
  int h,w;
  UpdateRc();
}

/*
 * Doubleclick callback - execute command line
 */ 
void DoubleClickCallback (item, lArg, N)
    Widget item;
    XtPointer lArg;
    XtPointer N;        
{
    char cmd[MAX_PATH];
    
    /*
     * Use fork()/exec()/wait() !
     */
    sprintf (cmd, "%s &", Item[(int)lArg].cmdline);
    system (cmd);
}


/*
 * Handle message received from controlling tycoon instance.
 */ 
void HandleClientMsg (item, junk, event, flag)
    Widget item;
    Widget junk;
    XEvent *event;
    Boolean *flag;
{  
    int i;
    int nbytes_return;
    /*
     * Remove current item
     */ 
    if (event->xclient.message_type == XA_KILL_ACTIVE)
	{
	    if (current_item != NULL)
		{
		    XtDestroyWidget(current_item);
		    
		    /*
		     * Remove item from array
		     */ 
		    for (i=0;i<num_icons;i++)
			if (Item[i].shell == current_item)
			    {
				Item[i] = Item[num_icons-1];
				num_icons--;
				break;
			    }
		    UpdateRc();
		}
	    current_item=NULL;
	    return;
	}
    
    /*
     * Add item to array
     */ 
    if (event->xclient.message_type == XA_EDIT_ICON)
	{
	    FILE *tmpcfg;            /* Temporary ini-file */
            char *str;
	    char tmpname[MAX_PATH];  /* Name of temporary ini-file */  
	    int  num;
	    char **icondata;
	    char tmpline[MAX_LINE];
	    int i,k;
	    
	    if (current_item == NULL) 
	      {
		return;
	      }
	    for (i=0;i<num_icons;i++)
	      {
		if (Item[i].shell==current_item)
		  num=i;
	      }
	    str=XFetchBuffer(XtDisplay(item), &nbytes_return, X_COORD);
	    str[nbytes_return]=0;
	    Item[num].x=atoi(str);
	    XFree(str);

	    str=XFetchBuffer(XtDisplay(item), &nbytes_return, Y_COORD);
	    str[nbytes_return]=0;
	    Item[num].y=atoi(str);
	    XFree(str);

	    str=XFetchBuffer(XtDisplay(item), &nbytes_return, LABEL);
	    str[nbytes_return]=0;
	    strcpy(tmpline,str);
	    tmpline[nbytes_return]=0;
	    XFree(str);
	    for (i=0;Item[num].label[i]!=0;i++) Item[num].label[i]=0;
	    /* Now take care of multi-line label. Yuck */
	    for (i=0,k=0;tmpline[i]!=0;i++,k++)
	      {
		Item[num].label[k]=tmpline[i];
		if (tmpline[i]=='\\' && 
		    tmpline[i+1]=='n') /* \n sequence */
		  {
		    Item[num].label[k]='\n';
		    i++;
		  }
	      }	    

	    str=XFetchBuffer(XtDisplay(item), &nbytes_return, XPMFILE);
	    str[nbytes_return]=0;
	    strcpy(Item[num].icon,str);
	    XFree(str);

	    str=XFetchBuffer(XtDisplay(item), &nbytes_return, COMMAND);
	    str[nbytes_return]=0;
	    strcpy(Item[num].cmdline,str);
	    XFree(str);

	    /* 
	     *                     Create new item
	     * 
	     * Read pixmap file
	     */
	    if (XpmReadFileToData (Item[num].icon, &icondata) < 0)
		{
		    icondata=cry_xpm;
		}
	    
	    /*
	     * Update wiconsh widget
	     */ 

	    XtVaSetValues (Item[num].shell, 
				    XtNx, Item[num].x,
				    XtNy, Item[num].y,
				    XtNpixmapData, icondata,
				    NULL);
	    WiconSetLabel(Item[num].shell,Item[num].label);
	    UpdateRc();
	    return;
	}
    /*
     * Add item to array
     */ 
    if (event->xclient.message_type == XA_ADD_ICON)
	{
	  char *str;
	  char tmpname[MAX_PATH];  /* Name of temporary ini-file */  
	  int  num;
	  char **icondata;
	  char tmpline[MAX_LINE];
	  int i,k;
	  
	  for (i=0;i<num_icons;i++)
	  num = num_icons;
	  
	  str=XFetchBuffer(XtDisplay(item), &nbytes_return, X_COORD);
	  str[nbytes_return]=0;
	  Item[num].x=atoi(str);
	  XFree(str);
	  
	  str=XFetchBuffer(XtDisplay(item), &nbytes_return, Y_COORD);
	  str[nbytes_return]=0;
	  Item[num].y=atoi(str);
	  XFree(str);
	  
	  str=XFetchBuffer(XtDisplay(item), &nbytes_return, LABEL);
	  str[nbytes_return]=0;
	  strcpy(tmpline,str);
	  XFree(str);
	  
	  /* Now take care of multi-line label. Yuck */
	  for (i=0,k=0;tmpline[i]!=0;i++,k++)
	    {
	      Item[num].label[k]=tmpline[i];
	      if (tmpline[i]=='\\' && 
		  tmpline[i+1]=='n') /* \n sequence */
		{
		  Item[num].label[k]='\n';
		  i++;
		}
	    }	    
	  
	  str=XFetchBuffer(XtDisplay(item), &nbytes_return, XPMFILE);
	  str[nbytes_return]=0;
	  strcpy(Item[num].icon,str);
	  XFree(str);
	  
	  str=XFetchBuffer(XtDisplay(item), &nbytes_return, COMMAND);
	  str[nbytes_return]=0;
	  strcpy(Item[num].cmdline,str);
	  XFree(str);
	  
	  /* 
	   *                     Create new item
	   * 
	   * Read pixmap file
	   */
	  if (XpmReadFileToData (Item[num].icon, &icondata) < 0)
	    {
	      icondata=cry_xpm;
	    }
	  
	  /*
	   * Create wiconsh widget
	   */ 
	  dialog = XtVaCreatePopupShell ("tycoon", wiconShellWidgetClass,
					 toplevel, 
					 XtNx, Item[num].x,
					 XtNy, Item[num].y,
					 XtNtagLabel, Item[num].label,
					 XtNtransientFor, toplevel,
					 XtNpixmapData, icondata,
					 XtNpixmapData, icondata,
					 XtNallowShellResize, False,
					 NULL);
	  
	  Item[num].shell = dialog;
	  
	  /*
	   * Add callbacks
	   */  
	  XtAddCallback (dialog, XtNiconClickCallback, ClickCallback,
			 (XtPointer)num);      
	  
	  XtAddCallback (dialog,
			 XtNiconDropCallback,DropCallback,
			 (XtPointer)num);
	  
	  XtAddCallback (dialog,
			 XtNiconDoubleClickCallback,DoubleClickCallback,
			 (XtPointer)num);
	  
	  XtPopup (dialog, XtGrabNone);
	  
	  /*
	   * If we have no current item - make this one be the one 
	   */ 
	  if (current_item == NULL) 
	    {
	      current_item = dialog;
	      WiconSetActive (dialog);
	    }
	  
	  num_icons++;
	  UpdateRc();
	  return;
	}
    
    /*
     * Realign icons on desktop
     */ 
    if (event->xclient.message_type == XA_ALIGN)
	{
	    FILE *tmpcfg;            /* Temporary ini-file */
	    char tmpline[MAX_LINE];  /* Name of temporary ini-file */  
	    char str[MAX_LINE];      
	    int x, y, sx, sy;
	    char * xbuf;
	    Window wjunk;
	    int ijunk;
	    unsigned int root_h,root_w,ujunk;
	    Dimension width, height;
	    Dimension lwidth,lheight;
	    char orient;
	    
	    XGetGeometry(XtDisplay(item),XDefaultRootWindow(XtDisplay(item)),
			 &wjunk,&ijunk,&ijunk,&root_w,&root_h,&ujunk,&ujunk);
	    /*
	     * Get align parameters
	     */
	    xbuf=XFetchBuffer(XtDisplay(item), &nbytes_return, COMMAND);
	    xbuf[nbytes_return]=0;
	    strcpy(tmpline,xbuf);
	    XFree(xbuf);	    
	    sscanf (tmpline, "%d %d %s", &x, &y, str);
	    orient = str[0];
	    sx=x;sy=y;
	    for (i=0; i<num_icons; i++)
	      {
		  /*
		   * Move icon
		   */ 
		  XtVaGetValues (Item[i].shell,
			       XtNwidth, &width,
			       XtNheight, &height,
			       NULL);
		  WiconGetLabelSize(Item[i].shell,&lwidth,&lheight);
		  if (orient == 'v' &&  x+width+X_OFFSET >root_w && i==0)
		    {XBell(XtDisplay(item),100);return;}
		  if (orient== 'h' && y+height+lheight+Y_OFFSET>root_h && i==0)
		    {XBell(XtDisplay(item),100);return;}
		  if (orient == 'v' && y+height+lheight+ Y_OFFSET >root_h)
		    {
		      if (i==0)
			{XBell(XtDisplay(item),100);return;}
		      x=x+width+X_OFFSET;
		      y=sy;
		    }
		  if (orient == 'h' && x+width+X_OFFSET >root_w)
		    {
		      if (i==0)
			{XBell(XtDisplay(item),100);return;}
		      x=sx;
		      y=y+height+lheight+Y_OFFSET;
		    }

		  WiconSetPosition (Item[i].shell, x, y);
		  
		  /*
		   * Calculate coordinates for next icon
		   */ 
		  XtVaGetValues (Item[i].shell,
			       XtNwidth, &width,
			       XtNheight, &height,
			       NULL);
		  WiconGetLabelSize(Item[i].shell,&lwidth,&lheight); 
		  if (orient == 'v') /* Vertical */
		    y += height + Y_OFFSET + lheight;
		  else
		    x += width + X_OFFSET;
	      }
	    UpdateRc();
	    return;
	}

    /*
     * Exit tycoon (remove all icons)
     */ 
    if (event->xclient.message_type == XA_KILL)
      {
	exit(0);
      }
    /*
     * Freeze all icons - no more moving icons
     */ 
    if (event->xclient.message_type == XA_FREEZE)
      {
	for (i=0; i<num_icons; i++)
	  XtVaSetValues (Item[i].shell, 
			 XtNfreezeIcon  , True,
			 NULL);
	Freezed=True;
	UpdateRc();
	return;
      }
    /*
     * lower all icons 
     */ 
    if (event->xclient.message_type == XA_LOWER)
      {
	for (i=0; i<num_icons; i++)
	  WiconLower(Item[i].shell); 
	return;
      }
    /*
     * raise all icons 
     */ 
    if (event->xclient.message_type == XA_RAISE)
      {
	for (i=0; i<num_icons; i++)
	  WiconRaise(Item[i].shell); 
	return;
      }
    /*
     * Unfreeze all icons -  you can move 'em icons!
     */ 
    if (event->xclient.message_type == XA_UNFREEZE)
      {
	for (i=0; i<num_icons; i++)
	  XtVaSetValues (Item[i].shell, 
			 XtNfreezeIcon  , False,
			 NULL);
	Freezed=False;
	UpdateRc();
	return;
      }
    printf ("Unknown message received: %X\n",event->xclient.message_type);
}


/*
 * Parse initialization file and create icons
 */
int ParseIniFile (void)
{
    char ini_file[MAX_PATH];
    FILE *iconrc;
    char *str, line[MAX_LINE];
    char tmpline[MAX_LINE];
    char *junk;
    int num=0, line_num=1, i,k, active=0;
    char **icondata;

    /*
     * Try to open ini-file
     */ 
    strcpy(ini_file, getenv("HOME"));
    strcat(ini_file, INI_FILE);
    if ((iconrc=fopen(ini_file,"rt")) == NULL)
	{
	    perror ("open ini-file");
	    return -1;
	}

    while (!feof(iconrc))
	{
	    /*
	     * Read line
	     */
	    fgets (line, MAX_LINE-1, iconrc);

	    if (feof(iconrc))
		break;

	    line[strlen(line)-1] = 0;

	    /*
	     * Get command name
	     */
	    str = strtok(line, " ");
	    if (strcmp(str, "Freezed") == 0)
	      {
		Freezed=True;
		continue;
	      }
	    /*
	     * Add icon command - read icon parameters
	     */
	    if (strcmp(str, "Icon") == 0 || 
		strcmp(str, "Active") == 0)
		{
		    if (strcmp(str, "Active") == 0)
		      active = num;
		    
		    if ((str=strtok(NULL, " ")) == NULL)
			goto ERROR;
		    Item[num].x = atoi (str);

		    if ((str=(junk=strtok(NULL, " "))) == NULL)
			goto ERROR;
		    Item[num].y = atoi (str);

	    /* Dough. Now parsing quoted string */

		    if ((str=(junk=strtok(junk+strlen(junk)+1, "\""))) == NULL)
			goto ERROR;
		    strcpy (tmpline, str);

	    /* Now take care of multi-line labels. Yuck */

		    for (i=0,k=0;tmpline[i]!=0;i++,k++)
		      {
			Item[num].label[k]=tmpline[i];
			if (tmpline[i]=='\\' && 
			    tmpline[i+1]=='n') /* \n sequence */
			  {
			    Item[num].label[k]='\n';
			    i++;
			  }
		      }
	    /* Blech. Now we parsing blank-separated string again */

		    if ((str=strtok(junk+strlen(junk)+1," ")) == NULL)
			goto ERROR;
		    strcpy (Item[num].icon, str);

		    /*
		     * Read execution command (the rest of this line)
		     */
		    str += strlen(str) + 1;
		    while (*str == ' ') ++str;
		    strcpy (Item[num].cmdline, str);

		    num++;
		    line_num++;
		    continue;
		}
ERROR:	    
	    fprintf (stderr, "Syntax error in line %d\n", line_num);
	}

    fclose(iconrc);
    num_icons = num;

    /*
     * Create icons themselfs
     */ 
    for (i=0; i<num; i++)
	{
	    /*
	     * Read pixmap file
	     */
	    if (XpmReadFileToData (Item[i].icon,&icondata) < 0)
		icondata=cry_xpm;

	    /*
	     * Create icon
	     */
	    dialog=XtVaCreatePopupShell("tycoon", wiconShellWidgetClass,
					toplevel,
					XtNx, Item[i].x,
					XtNy, Item[i].y,
					XtNfreezeIcon,Freezed,
					XtNtagLabel, Item[i].label,
					XtNtransientFor,toplevel,
					XtNpixmapData, icondata,
					NULL);

	    Item[i].shell = dialog;
	    current_item = dialog;
	    
	    /*
	     * Add callbacks
	     */
	    XtAddCallback(dialog, XtNiconClickCallback, ClickCallback,
			  (XtPointer)i);      
	    
	    XtAddCallback(dialog, XtNiconDropCallback, DropCallback,
			  (XtPointer)i);
	    
	    XtAddCallback(dialog,
			  XtNiconDoubleClickCallback, DoubleClickCallback,
			  (XtPointer)i);
	    
	    XtPopup (dialog, XtGrabNone);
	}

    /*
     * Set an appropriate active icon
     */
    if (num>0) WiconSetActive(current_item=Item[active].shell);
        
    return 0;
}



