/*
 *  Permission hereby granted to use and change this software, and make
 *  derivative works based on this code, as long as it mentions initial
 *  authors - Roman Mitnitski (mitnits@shani.net) and Vladimir Lobak
 *  (vels@spider.cs.biu.ac.il).
 * 
 *  ROMAN MITNITSKI AND VLADIMIR LOBAK MAKE NO WARRANTY OF ANY KIND 
 *  WITH REGARD TO THIS SOFWARE, INCLUDING, BUT NOT LIMITED TO, THE 
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 *  PURPOSE.  Roman Mitnitski and Vladimir Lobak will not be liable 
 *  for errors contained herein or direct, indirect, special, incidental 
 *  or consequential damages in connection with the furnishing,
 *  performance, or use of this program.               
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/cursorfont.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/Xatom.h>
#include <X11/XWDFile.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>  
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdlib.h>
#include "wiconsh.h"
#include "config.h"

#include "dummy.xpm"


/*
 * Global widgets and atoms
 */
Atom  XA_TYCOON;
Atom  XA_KILL_ACTIVE;
Atom  XA_ADD_ICON;
Atom  XA_EDIT_ICON;
Atom  XA_KILL;
Atom  XA_ALIGN;
Atom  XA_FREEZE;
Atom  XA_UNFREEZE;
Atom  XA_LOWER;
Atom  XA_RAISE;

Widget toplevel, current_item, dialog;

/*
 * Local stuff
 */ 
static XtAppContext context;
#define INSTANCE_NAME     "TYCOON"

/*
 * Local functions
 */ 
void Usage (void);
void MakeAtoms (Display *);
static Window FindSomeIconWin (Display *);

/*
 * External functions
 */
void HandleClientMsg (Widget, Widget, XEvent *, Boolean *);
int ParseIniFile (void);


void main(argc,argv)
   int argc;
   char *argv[];
{
    Arg al[20];
    int ac,i;
    XpmAttributes attributes;
    Widget control;
    Pixmap pixmap,mask;
    XEvent event;
    Display *dpy;
    Window window;
    
    /* 
     * Create toplevel (it'll never be realized)
     */
    ac=0;
    XtSetArg(al[ac], XtNheight, 40); ac++;
    XtSetArg(al[ac], XtNwidth, 40); ac++;
    toplevel = XtAppInitialize(&context, "Tycoon", NULL, 0,
			       &argc, argv, NULL, al, ac);
    
    /*
     * Create atoms 
     * (objects that will be passed between tycoon instances)
     */ 
    MakeAtoms (XtDisplay(toplevel));    
    
    
    /*
     * If there are no arguments we'll have to become a main instance
     */
    if (argc == 1)
	{
	    /*
	     * Check if we already have tycoon running
	     */
	    if (FindSomeIconWin (XtDisplay(toplevel)) != 0)
		{
		    fprintf (stderr, 
			     "tycoon is already running on display %s\n",
			     DisplayString(XtDisplay(toplevel)));
		    exit(1);
		}
	    
	    /*
	     * Try to parse '.tycoon'
	     */
	    if (ParseIniFile () < 0)
		{
		    puts ("Waiting for icons...");
		    current_item = NULL;
		}
	    
	    /* 
	     * Build control link with tycoon command line utility 
	     * Create control shell and put it out of sight.
	     */
	    control = XtVaCreatePopupShell ("control", shellWidgetClass,
					    toplevel, 
					    XtNx, 4000,
					    XtNy, 2,
					    XtNheight, 2,
					    XtNwidth, 2,
					    XtNoverrideRedirect, True,
					    NULL);
	    XtPopup(control, XtGrabNone);
	    
	    /* 
	     * Make the control shell transparent
	     */
	    attributes.valuemask = 0; 
	    XpmCreatePixmapFromData (XtDisplay(control), XtWindow(control),
				     dummy,
				     &pixmap, &mask, &attributes);
	    
	    XShapeCombineMask (XtDisplay(control), XtWindow(control), 
			       ShapeBounding, 0, 0,
			       mask, ShapeSet);                   
	    
	    XChangeProperty (XtDisplay(control), 
			     XtWindow(control), XA_TYCOON, XA_STRING, 32, 
			     PropModeAppend,
			     (unsigned char *)VERSION, 1);
	    
	    XtAddEventHandler (control, ClientMessage, True,
			       (XtPointer)HandleClientMsg, NULL); 
	    
	    XtAppMainLoop (context);
	}
    
    
    /*
     * Otherwise - we have to communicate with previosly started 
     * main instance. 
     * First - let's check if it's running
     */
    if ((window=FindSomeIconWin (XtDisplay(toplevel))) == 0)
	{
	    fprintf (stderr, "tycoon is not running on display %s\n",
		     DisplayString(XtDisplay(toplevel)));
	    Usage ();
	    exit(1);
	}
    
    /*
     * Default values for each message (XEvent)
     */ 
    event.xany.type = ClientMessage;
    event.xclient.display = dpy = XtDisplay (toplevel);
    event.xclient.window = window;
    event.xclient.format = 32;
    
    /*
     * And parse command line
     */ 
    for (i=1; i<argc; i++)
      switch (argv[i][0])
	{
	 case '-':
	    /* 
	     * Show user some help
	     */
	    if (strcmp (argv[i], "-h") == 0)
		{
		    Usage ();
		    exit (0);
		}
	    /* 
	     * Send message to main instance to kill current icon
	     */
	    if (strcmp (argv[i], "-rm") == 0)
		{
		    event.xclient.message_type =
		      XInternAtom (dpy, "_KILL_ACTIVE", False);
		    break;
		}
	    /* 
	     * Send message to main instance to raise all icons
	     */
	    if (strcmp (argv[i], "-raise") == 0)
		{
		    event.xclient.message_type =XA_RAISE;
		    break;
		}
	    /* 
	     * Send message to main instance to lower all icons
	     */
	    if (strcmp (argv[i], "-lower") == 0)
		{
		    event.xclient.message_type =XA_LOWER;
		    break;
		}
	    /* 
	     * Send message to main instance to freeze all icons
	     */
	    if (strcmp (argv[i], "-freeze") == 0)
		{
		    event.xclient.message_type =XA_FREEZE;
		    break;
		}
	    /* 
	     * Send message to main instance to unfreeze all icons
	     */
	    if (strcmp (argv[i], "-unfreeze") == 0)
		{
		    event.xclient.message_type =XA_UNFREEZE;
		    break;
		}
	    /* 
	     * Send message to main instance to exit
	     */
	    if (strcmp (argv[i],"-kill") == 0) 
		{
		  char bytes[200];
		  strcpy(bytes,"Test of the cut buffer");
		    event.xclient.message_type =
		      XInternAtom (dpy, "_KILL", False);
		    XStoreBuffer(dpy, bytes, strlen(bytes)+1,0);

		    break;
		}
	    /* 
	     * Send message to main instance to add new icon
	     */
	    if (strcmp(argv[1],"-add") == 0) 
		{
		  /*
		   * Check for number of '-add' arguments
		   */ 
		  if (argc-i >= 5)
		    {
		      XStoreBuffer(dpy,argv[i+1],
				   strlen(argv[i+1])+1,X_COORD);
		      XStoreBuffer(dpy,argv[i+2], 
				   strlen(argv[i+2])+1,Y_COORD);
		      XStoreBuffer(dpy,argv[i+3], 
				   strlen(argv[i+3])+1,LABEL);
		      XStoreBuffer(dpy,argv[i+4], 
				   strlen(argv[i+4])+1,XPMFILE);
		      XStoreBuffer(dpy,argv[i+5], 
				   strlen(argv[i+5])+1,COMMAND);
		      event.xclient.message_type = 
			XInternAtom (dpy, "_ADD_ICON", False);
		      i += 5;  
		    }
		  else
		    {
		      fprintf (stderr, 
			       "-add requires 5 arguments\n");
		      Usage ();
		      exit (1);
		    }
		  break;
		}
	    /* 
	     * Send message to main instance to add new icon
	     */
	    if (strcmp(argv[1],"-edit") == 0) 
		{
		  /*
		   * Check for number of '-add' arguments
		   */ 
		  if (argc-i >= 5)
		    {
		      XStoreBuffer(dpy,argv[i+1],
				   strlen(argv[i+1])+1,X_COORD);
		      XStoreBuffer(dpy,argv[i+2], 
				   strlen(argv[i+2])+1,Y_COORD);
		      XStoreBuffer(dpy,argv[i+3], 
				   strlen(argv[i+3])+1,LABEL);
		      XStoreBuffer(dpy,argv[i+4], 
				   strlen(argv[i+4])+1,XPMFILE);
		      XStoreBuffer(dpy,argv[i+5], 
				   strlen(argv[i+5])+1,COMMAND);
		      event.xclient.message_type = 
			XInternAtom (dpy, "_EDIT_ICON", False);
		      i += 5;  
		    }
		  else
		    {
		      fprintf (stderr, 
			       "-edit requires 5 arguments\n");
		      Usage ();
		      exit (1);
		    }
		  break;
		}

	    /* 
	     * Send message to main instance to realign icons
	     */
	    if (strcmp(argv[1],"-align") == 0)
		{
		  /*
		   * Check for number of '-align' arguments
		   */ 
		  if (argc-i >= 3)
		    {
		      char tmpline[MAX_LINE];
		      /*
		       * Write '-align' arguments to file
		       */ 
		      sprintf (tmpline, "%s %s %s",
			       argv[i+1], argv[i+2], argv[i+3]);
		      XStoreBuffer(dpy,tmpline, 
				   strlen(tmpline)+1,COMMAND);
		      event.xclient.message_type =
			XInternAtom (dpy, "_ALIGN", False);
		      i += 3;
		      break;
		    }
		  else
		    {
		      fprintf (stderr, 
			       "-align requires 3 arguments\n");
		      Usage ();
		      exit (1);
		    }
		  break;
		}

	    /*
	     * If we came to this point - we've got wrong argument
	     */
	 default:
	    Usage ();
	    exit (1);
	} /* switch */
    
    /*
     * Send created message
     */ 
    if (XSendEvent (dpy, window, False, 0L, &event) == 0)
	{
	    fprintf (stderr,
		     "tycoon: XSendEvent(dpy, 0x%x ...) failed.\n",
		     (unsigned int) window);
	    exit (1);
	}
    XSync (dpy, 0);
    exit(0);
}

/*
 * Print short help
 */
void Usage (void)
{
    printf ("Tycoon (v. %s) Desktop icon tools\n", VERSION);
    printf ("Copyright (c) 1994-97  Roman Mitnitsky & Vladimir Lobak\n\n");
    puts("Usage:");
    puts("tycoon -h                           - show this help");
    puts("tycoon (no command-line options)    - run tycoon utility");
    puts("tycoon -rm                          - remove selected icon");
    puts("tycoon -kill                        - terminate tycoon");
    puts("tycoon -raise                       - raise all icons");
    puts("tycoon -lower                       - lower all icons");
    puts("tycoon -freeze                      - stick icons to the screen");
    puts("tycoon -unfreeze                    - unstick icons - enable drag again");
    puts("tycoon -add  X Y LABEL ICON CMDLINE - add new icon at X,Y using LABEL as the");
    puts("                                      label, CMDLINE as command line to execute");
    puts("                                      and ICON as .xpm file with icon picture.");
    puts("tycoon -edit X Y LABEL ICON CMDLINE - change selected icon properties to X,Y");
    puts("                                      LABEL, ICON and CMDLINE");
    puts("tycoon -align X Y ORIENTATION       - align icons on desktop starting at X, Y.");
    puts("                                      ORIENTATION can be h (horizontal) or");
    puts("                                      v (vertical)");
    
    exit(1);
}

/*
 * Create atoms to pass between instances
 */ 
void MakeAtoms (Display * dpy)
{
    XA_TYCOON      = XInternAtom (dpy, INSTANCE_NAME, False);
    XA_KILL_ACTIVE = XInternAtom (dpy, "_KILL_ACTIVE", False);
    XA_ADD_ICON    = XInternAtom (dpy, "_ADD_ICON", False);
    XA_EDIT_ICON   = XInternAtom (dpy, "_EDIT_ICON", False);
    XA_KILL        = XInternAtom (dpy, "_KILL", False);
    XA_ALIGN       = XInternAtom (dpy, "_ALIGN", False);
    XA_FREEZE      = XInternAtom (dpy, "_FREEZE", False);
    XA_UNFREEZE    = XInternAtom (dpy, "_UNFREEZE", False);
    XA_RAISE       = XInternAtom (dpy, "_RAISE", False);
    XA_LOWER       = XInternAtom (dpy, "_LOWER", False);
}

/*
 * Check for presence of tycoon on this display
 */ 
static Window FindSomeIconWin (dpy)
Display *dpy;
{
    int i;
    Window root = RootWindowOfScreen (DefaultScreenOfDisplay (dpy));
    Window root2, parent, *kids;
    unsigned int nkids;
    
    /*
     * Get the whole window tree (starting from root window)
     */ 
    if (! XQueryTree (dpy, root, &root2, &parent, &kids, &nkids))
      abort ();
    if (root != root2)
      abort ();
    if (parent)
      abort ();
    if (! (kids && nkids))
      abort ();
    
    /*
     * Check each kid
     */ 
    for (i = 0; i < nkids; i++)
	{
	    Atom type;
	    int format;
	    unsigned long nitems, bytesafter;
	    char *version;
	    
	    if (XGetWindowProperty (dpy, kids[i],
				    XInternAtom (dpy, INSTANCE_NAME, False),
				    0, 1, False, XA_STRING,
				    &type, &format, &nitems, &bytesafter,
				    (unsigned char **) &version)
		== Success && type != None)
	      
	      /*
	       * Ok - found tycoon
	       */ 
	      return kids[i];
	}
    
    /*
     * Tycoon wasn't detected
     */ 
    return 0;
}
