#include <stdio.h>
#include "forms.h"
#include "newicon.h"

FD_dialog *fd_dialog;
char * icon_place;

#ifndef ICON_DIR
#define ICON_DIR /usr/include/X11/pixmaps
#endif

char X[10];
char Y[10];
char ICON[1024];
char NAME[1024];
char COMMAND[1024];

usage(char * name)
{
  fprintf(stderr,"Usage: %s [form-toolkit-options] [IconDir]\n",name);
  exit(1);
}

int main(int argc, char *argv[])
{
  FL_IOPT flopt;

  char * junk, * str;

  char line[1024];
  int  WasActive=0;
  FILE * iconrc;
  char ini_file[1024];

  flopt.debug=0;
  flopt.borderWidth=-2;


  fl_set_defaults(FL_PDDebug| FL_PDBorderWidth/*|FL_PDButtonLabelSize*/,
		  &flopt);
  fl_initialize(argv[0], "NewIcon" , 0, 0, &argc, argv);
   fl_show_errors(0);
  fl_set_goodies_font(FL_NORMAL_STYLE,14);

  if (argc==1) icon_place=ICON_DIR;
   else if (argc!=2) usage(argv[0]);
  if (argc==2) icon_place=argv[1];

  strcpy(ini_file, getenv("HOME"));
  strcat(ini_file, "/.tycoon");
  if ((iconrc=fopen(ini_file,"r")) == NULL)
    {
      perror ("open ini-file");
      return -1;
    }

  while (!feof(iconrc))
    {
      /*
       * Read line
       */
      fgets (line, 1024-1, iconrc);
      
      if (feof(iconrc))
	break;
      
      line[strlen(line)-1] = 0;
      
      /*
       * Get command name
       */
      str = strtok(line, " ");
      if (strcmp(str, "Freezed") == 0)
	{
	  continue;
	}
      /*
       * Add icon command - read icon parameters
       */
      if (strcmp(str, "Active") == 0)
	{
	  if ((str=strtok(NULL, " ")) == NULL)
	    goto ERROR;
	  strcpy(X,str);
	  
	  if ((str=(junk=strtok(NULL, " "))) == NULL)
	    goto ERROR;
	  strcpy(Y,str);
	  /* Dough. Now parsing quoted string */
	  
	  if ((str=(junk=strtok(junk+strlen(junk)+1, "\""))) == NULL)
	    goto ERROR;
	  strcpy (NAME, str);
	  
	  /* Blech. Now we are parsing blank-separated string again */
	  
	  if ((str=strtok(junk+strlen(junk)+1," ")) == NULL)
	    goto ERROR;
	  strcpy (ICON, str);
	  
	  /*
	   * Read execution command (the rest of this line)
	   */
	  str += strlen(str) + 1;
	  while (*str == ' ') ++str;
	  strcpy (COMMAND, str);
	  
	  WasActive=1;
	  continue;
	}
    ERROR:	    
    }
  
  fclose(iconrc);
  if (!WasActive) 
    {
     fl_show_alert("Please select some icon",NULL,NULL,1);
     exit(0);
    }
  
  fd_dialog = create_form_dialog();
  
   /* fill-in form initialization code */

   /* show the first form */
   XWarpPointer(fl_get_display(),None,
		fl_show_form(fd_dialog->dialog,FL_PLACE_CENTER,
			     FL_FULLBORDER,
			     "Edit icon properties"),
		0,0,0,0,120,70);
   fl_do_forms();
   return 0;
}
