/*
 *  Permission hereby granted to use and change this software, and make
 *  derivative works based on this code, as long as it mentions initial
 *  authors - Roman Mitnitski (mitnits@shani.net) and Vladimir Lobak
 *  (vels@spider.cs.biu.ac.il).
 * 
 *  ROMAN MITNITSKI AND VLADIMIR LOBAK MAKE NO WARRANTY OF ANY KIND 
 *  WITH REGARD TO THIS SOFWARE, INCLUDING, BUT NOT LIMITED TO, THE 
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 *  PURPOSE.  Roman Mitnitski and Vladimir Lobak will not be liable 
 *  for errors contained herein or direct, indirect, special, incidental 
 *  or consequential damages in connection with the furnishing,
 *  performance, or use of this program.               
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/cursorfont.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/Xatom.h>
#include <X11/XWDFile.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>  
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <stdlib.h>
#include "rays1.xpm"
#include "rays2.xpm"
#include "rays3.xpm"
#include "rays4.xpm"
#include "blank.xpm"

#ifdef STANDALONE_TEST
static Widget toplevel;
static XtAppContext context;        
#endif

typedef struct _xy
{
  Dimension x,y;
  int popit;
  int blips;
} XY_type;



static XY_type XY;
static Widget blip;
static Initialized=0;

static Pixmap rays[4];
static Pixmap mask[4];
static Pixmap maskall;
int _Blip_Is_Working=0;

#define BlipInterval 150

static void Blip();


static void Blip(client_data, id)
    XtPointer client_data;
    XtIntervalId *id;               
{
  Arg al[20];
  int ac,i;

  XY_type *XY=(XY_type *)client_data;

/*  for (i=0;i<4;i++) XtPopdown(blip[i]);*/

  ac=0;
  XtSetArg(al[ac],XtNx,XY->x); ac++; 
  XtSetArg(al[ac],XtNy,XY->y); ac++;
  XtSetValues(blip,al,ac);

  if (!_Blip_Is_Working)
    {
      XtPopup(blip,XtGrabNone);
      _Blip_Is_Working=1;
    }

/* XShapeCombineMask(XtDisplay(blip),XtWindow(blip), 
		    ShapeBounding, 0, 0,
		    maskall, ShapeSet);
*/
  XSetWindowBackgroundPixmap(XtDisplay(blip),XtWindow(blip),
			     rays[XY->popit]);
  XShapeCombineMask(XtDisplay(blip),XtWindow(blip), 
		    ShapeBounding, 0, 0,
		    mask[XY->popit], ShapeSet);

  XY->popit++;

  if (XY->popit>2) XY->popit=0;
  if ((XY->blips--)>0)
    XtAppAddTimeOut(XtWidgetToApplicationContext((Widget)blip),
		    (unsigned long) BlipInterval, (XtPointer)Blip, 
		    (XtPointer)XY);
  else
    {
      XtPopdown(blip);
      XSetWindowBackgroundPixmap(XtDisplay(blip),XtWindow(blip),
				 rays[0]);
      XShapeCombineMask(XtDisplay(blip),XtWindow(blip), 
			ShapeBounding, 0, 0,
			mask[0], ShapeSet);
      _Blip_Is_Working=0;
    }
}

void BlipPoint(x,y,Times)
int x,y,Times;
{
  if (Initialized==0) return;

  XY.x=x-20;
  XY.y=y-20;
  XY.popit=0;
  XY.blips=Times;
  
  XtAppAddTimeOut(XtWidgetToApplicationContext((Widget)blip),
		  (unsigned long) BlipInterval, 
		  (XtPointer)Blip, (XtPointer)&XY);      
  
}

void InitBlip(toplevel)
     Widget toplevel;
{
  Arg al[20];
  int ac,i;
  int x,y;
  XpmAttributes attributes;
  Pixmap pixmap,pmask;
  char **blip_pic[4];
  
  if (Initialized) return;
  Initialized=1;
  
  blip_pic[0]=rays1_xpm;
  blip_pic[1]=rays2_xpm;
  blip_pic[2]=rays3_xpm;
  blip_pic[3]=rays4_xpm;
  
  x=10000;y=20;
  
  
  /* make blip window */
  ac=0;
  XtSetArg(al[ac],XtNheight,41); ac++;
  XtSetArg(al[ac],XtNwidth,41); ac++;
  XtSetArg(al[ac],XtNx,x); ac++; 
  XtSetArg(al[ac],XtNy,y); ac++;
  XtSetArg(al[ac],XtNoverrideRedirect,True);ac++;
  blip=XtCreatePopupShell("control", shellWidgetClass,
			     toplevel , al, ac);
  XtPopup(blip,XtGrabNone);
  
  
  attributes.valuemask = 0; 
  
  /* Make the blip masks */
  for (i=0;i<4;i++)
    {
      XpmCreatePixmapFromData(XtDisplay(blip),XtWindow(blip),
			      blip_pic[i],
			      &pixmap,&pmask,&attributes);
      rays[i]=pixmap;
      mask[i]=pmask;
    }
  
  XSetWindowBackgroundPixmap(XtDisplay(blip),XtWindow(blip),
			     rays[0]);
  XShapeCombineMask(XtDisplay(blip),XtWindow(blip), 
		    ShapeBounding, 0, 0,
		    mask[0], ShapeSet);
  XtPopdown(blip);

  XpmCreatePixmapFromData(XtDisplay(blip),XtWindow(blip),
			blank_xpm,
			&pixmap,&pmask,&attributes);
  maskall=pmask;
  XFreePixmap(XtDisplay(blip),pixmap);
}

#ifdef STANDALONE_TEST
void main(argc,argv)
    int argc;
    char *argv[];
{
    Arg al[20];
    int ac,i,k;

    toplevel=XtAppInitialize(&context,"",NULL,0,&argc,argv,NULL,NULL,0);
    ac=0;
    XtSetArg(al[ac],XtNheight,40); ac++;
    XtSetArg(al[ac],XtNwidth,40); ac++;
    XtSetValues(toplevel,al,ac);
    InitBlip(toplevel);
    BlipPoint(900,20,20);
    XtAppMainLoop(context);
}
#endif
