/*********************************************************
 Copyright (C) 1994 Patrick Voigt
*********************************************************/

#include <sys/stat.h>
#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <time.h>
#include "mdir.h"

/********************************************************************************
 bestimmt String mit Zugriffsberechtigungen eines Files in cperms,
 Filetyp ist type und mode sind der Integerwert der Zugriffsberechtigungen
********************************************************************************/
char *permissions (int mode, int type)
{
 int  iperms = mode;
 int i;
 static char cperms[11];

 strcpy (cperms, " rwxrwxrwx");

 for (i = 9; i >= 1; i--)
 {
  if (!(iperms & 01)) cperms[i] = '-';
  iperms >>= 1; 
 }

 switch (type)
 {
  case IS_DIR:  cperms[0] = 'd'; break;
  case IS_CHR:  cperms[0] = 'c'; break;
  case IS_BLK:  cperms[0] = 'b'; break;
  case IS_FIFO: cperms[0] = 'p'; break;
  case IS_SOCK: cperms[0] = 's';
 }

 if (type >= 7)
  cperms[0] = 'l';

 if (mode & S_ISVTX)
 {
  if (cperms[9] == 'x') cperms[9] = 't';
  else cperms[9] = 'T';
 }
 
 if (mode & S_ISGID)
 {
  if (cperms[6] == 'x') cperms[6] = 's';
  else cperms[6] = 'S';
 }

 if (mode & S_ISUID) 
 {
  if (cperms[3] == 'x') cperms[3] = 's';
  else cperms[3] = 'S';
 }
 return cperms;
};

/********************************************************************************
 bestimmt String mit Zeistempel (last modification time)
********************************************************************************/
char *mtime (time_t time)
{
 static char got[25];
 static char zeit[15];

 strcpy (got, asctime (localtime (&time)));
 
 for (int i = 4; i <= 9; i++)
  zeit[i-2] = got[i];

 zeit[0] = ' ';
 zeit[1] = ' ';
 zeit[14] = '\0';
 return zeit;
};


/********************************************************************************
 liest Datei .pfminit aus dem Home-Verzeichnis des "users";
 legt Tabelle mit Erweiterungen und zugehoerigen Files an 
 *******************************************************************************/
int table_anz = 0;
char **table;

void read_fmex (void)
{
  FILE *fd;
  const int SIZE = 512;
  char buf[SIZE];
  int i, j, k;
  char *contents;

  strcpy (buf, getenv ("HOME"));
  strcat (buf, "/.pfminit");

  if (fd = fopen (buf, "r"))
  {
    while (fgets (buf, SIZE, fd))
      if (buf[0] == '.')
        table_anz++;
 
    rewind (fd);
    table = new char* [2 * table_anz + 4];
    table[0] = table[1] = table[2] = table[3] = NULL;
    table_anz = 2;
    while (fgets (buf, SIZE, fd))
    {
      if (strncmp (buf, "pfm_", 4) == 0)
      {
        j = 13;
        while (buf[j] != '\n' && buf[j] != '\0')
          j++;
        buf[j] = '\0';

        if (strncmp (buf, "pfm_xterm_cmd:", 14) == 0)
        {
          i = 0;
          j = 14;
        }
        else
          if (strncmp (buf, "pfm_editor_cmd:", 15) == 0)
          {
            i = 1;
            j = 15;
          }
          else
            if (strncmp (buf, "pfm_view_cmd:", 13) == 0)
	    {
              i = 2;
              j = 13;
            }
            else
	    {
              i = 3;
              j = 14;
            }

        while (buf[j] != '/' && buf[j] != '\0')
          j++;
        if (buf[j] != '/')
          continue;

        if (table[i])
          delete[]table[i];
        table[i] = new char [strlen (&buf[j]) + 1];
        strcpy (table[i], &buf[j]);

        k = j;
        while (buf[j] != ' ' && buf[j] != '\0')
          j++;
        buf[j] = '\0';

        if (access (&buf[k], X_OK) == -1)
        {
          perror (&buf[k]);
          delete []table[i];
          table[i] = NULL;
          continue;
        }
      }

      if (buf[0] != '.')
        continue;
      j = 1;
      while (buf[j] != '\n' && buf[j] != '\0')
        j++;
      buf[j] = '\0';

      j = 1;
      while (buf[j] != ':' && j < 10)
        j++;
      if (j == 10) 
        continue;

      buf[j] = '\0';

      contents = new char [11]; 
      strcpy (contents, &buf[1]);
      table[2 * table_anz] = contents;

      j = strlen(&buf[1]);
      while (buf[j] != '/' && j < 512)
        j++;

      contents = new char [strlen (&buf[j]) + 1];
      strcpy (contents, &buf[j]);
      table[2 * table_anz + 1] = contents;

      k = j;
      while (buf[j] != ' ' && buf[j] != '\0')
        j++;
      buf[j] = '\0';

      if (access (&buf[k], X_OK) == -1)
      {
        perror (&buf[k]);
        delete (table[2 * table_anz]);
        delete (table[2 * table_anz + 1]);
        continue;
      }
      table_anz++;
    }
    fclose (fd);
  }
  else
  {
    fprintf (stderr, "No configuration file ~/.pfminit found!\n");
    exit (-1);
  }

  if (table[0] == NULL)
  {
    fprintf (stderr, "Please set the variable pfm_xterm_cmd in the configuration file ~/.pfminit !\n");
    exit (-1);
  }
}

/*********************************************************
 testet, ob regulaerer Ausdruck pattern auf file passt
 only a fast hack (doesn't work correct), I should use the regex stuff ..
*********************************************************/
int fname_match (char *file, char *pattern)
{
  int special = 0;
  char *c;

  if (!strcmp (file, pattern))
    return 1;

  while (*file && *pattern)
  {
    switch (*pattern)
    {
      case '*':  pattern++;
                 if (!*pattern)
                   return 1;

                 while (*file != *pattern && *file)
                   file++;

                 if (*file)
                 {
                   special = 1;
                   c = pattern;
		 }
                 else
                   return 0;

                 break;

      case '?':  file++;
                 pattern++;
                 break;

      default:   if (*file == *pattern)
	         {
                   file++;
                   pattern++;
                   if (!*pattern && special)
		   {
                     pattern--;
                     while (*file)
                       file++;
                     file--;
                     if (*file == *pattern)
                       return 1;
                     else
                       return 0;
                   }
                   continue;
                 }

                 if (special)
                 {
                   pattern = c;
                   while (*file != *pattern && *file)
                     file++;
		 }
                 else
                   return 0;

                 break;
    } 
  }

  if (!*file && !*pattern ||
      !*file && *pattern == '*')
    return 1;
  else 
    return 0;
}

