/*
Copyright Rob Ryan and Carnegie Mellon University 1993  - All Rights Reserved

Permission to use, copy, modify, and distribute this software and its    
documentation for any purpose is hereby granted without fee, provided
that the above copyright notice appear in all copies and that both that 
copyright notice, this permission notice, and the following disclaimer 
appear in supporting documentation, and that the name Carnegie Mellon
University, not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.
                                  
CARNEGIE MELLON UNIVERSITY AND ROB RYAN
DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, 
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR ANY PARTICULAR PURPOSE.  
IN NO EVENT SHALL CARNEGIE MELLON UNIVERSITY, OR
ROB RYAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
RESULTING FROM LOSS OF USE, DATA, OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE, OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.    
*/

/* The Silly X protocol compressor gateway. (A Really Gross Hack)

 TODO:
This program compresses the X protocol by replacing repeated occurrences
of 4 byte values with a one or two byte index into the most recent values
sent.  The lookup for recent values is a simple linear search, this limits
the amount of history which can be kept without making computation the
dominating time factor.  A possible solution for this is to switch to a
circular history buffer, with a hash table of the longs which contains
the index of each long in the history list  (This proposal also calls
for bringing old values to the most recent position without copying all
the values which WERE more recent than the old value down.  Thus a gap
will be left, making values older than that age more quickly.  Thus it
will require twice as much history space to ensure the same number of
historic values are available.)

 Find and use a real compression algorithm.

 Allow for different blocking factors.  (Otherwise there is a pause before
 a redraw while most or all of the data is sent over.)  ~250 is probably
 good for cslip. 
 
 -Rob Ryan (robr@cmu.edu)
 Sept, 1993.
 */

/* use -DMAXPACKET=1022 or whatever if you want a larger or smaller
 packet size over the slow link.  Note that a 2 byte header will be sent in
 addition to upto MAXPACKET bytes of data. */
#ifndef MAXPACKET
#define MAXPACKET 254
#endif

#include "patchlevel.h"

#include <X11/Xos.h>

#if defined(__STDC__) && !defined(ibm032) && !defined(NOSTDLIBPLEASE)
#include <stdlib.h>
#else
#ifdef _POSIX_SOURCE
#include <unistd.h>
#else
extern char *getenv();
#endif
#endif

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/file.h>
#include <netdb.h>
#if defined(_IBMR2) || defined(AIXV3)
#include <sys/select.h>
#endif
#include <errno.h>
#include <string.h>
#include <signal.h>
#include <sys/resource.h>
#include <sys/wait.h>
#include <ctype.h>

int compression=0; /* -1 uncompress, 0 no compression, 1 compress */
struct sockaddr_in servaddr; 
extern int errno;


#if defined(__hpux) || defined(hpux)
int getdtablesize() {
    return 32; /* should do the right thing here, but I don't have the
POSIX book handy */
}
#endif


int client()
{
    int sock;
    unsigned char *iaddr=(unsigned char *)&servaddr.sin_addr;
    if ((sock = socket(AF_INET, SOCK_STREAM, PF_UNSPEC)) == -1) {
	perror("socket");
	return -1;
    }

    if (connect(sock, (struct sockaddr *)&servaddr, sizeof(servaddr)) == -1) {
	fprintf(stderr, "port:%d\n",ntohs(servaddr.sin_port));
	fprintf(stderr, "addr:%d.%d.%d.%d\n", iaddr[0], iaddr[1], iaddr[2],
iaddr[3]);
	perror("connect");
	return -1;
    }

    return sock;
}

#define MAXTRANBUF 65536

int reallywrite(fd, buf, len)
int fd;
unsigned char *buf;
int len;
{
    int r;
    while(len>0) {
	r=write(fd, buf, len);
	if(r<0) {
	    perror("write");
	    exit(-1);
	}
	buf+=r;
	len-=r;
    }
}

typedef unsigned long thet;
#define NTOH(x) ntohl(x)
#define HTON(x) htonl(x)
#define WRITE(x) OUTBYTE((x)&0xff);OUTBYTE((x)>>8);OUTBYTE((x)>>16);OUTBYTE((x)>>24);
#define READ(w,x,y,z) (((thet)w)|(((thet)x)<<8)|(((thet)y)<<16)|(((thet)z)<<24))

#define HISTORY 2048
#define SCOUNTMAX 128
#define COUNTBASE 192
static thet chistory[HISTORY];
static int cnext=0;
static thet uhistory[HISTORY];
static int unext=0;

#define OUTBYTE(blah)  do { *out++=((blah)&0xff); csize--, size++;} while (0)
int scompress(cbuf, csize, buf, len)
unsigned char *cbuf;
int csize;
unsigned char **buf;
int *len;
{
    thet *p=(thet *)*buf;
    unsigned char *out=cbuf;
    unsigned char *prev=NULL;
    int i;
    int scan=0;
    int size=0;
    if(*len&1) {
	fprintf(stderr, "WARNING WARNING WARNING, odd packet size...\n");
	exit(-1);
    }
#ifdef LOGDATA
    fprintf(stderr,"sending: ");
    for(i=0;i<len;i++) fprintf(stderr, "%x ",*buf[i]);
    fprintf(stderr,"\n");
#endif
    
    while(*len>0 && csize>0) {
	thet sh=HTON(*p);
	for(scan=cnext-1;scan>=0;scan--) {
	    if(sh==chistory[scan]) {
		int scanx=cnext-1-scan;
		prev=NULL;
		if(scanx>=SCOUNTMAX) {
		    if(csize<2) return size;
		    OUTBYTE(((scanx>>8)&0x7)+SCOUNTMAX);
		    OUTBYTE(scanx&0xff);
		} else OUTBYTE(scanx);
		for(i=scan+1;i<cnext;i++) {
		    chistory[i-1]=chistory[i];
		}
		chistory[cnext-1]=sh;
		p++;
		*len-=sizeof(thet);
		*buf+=sizeof(thet);
		break;
	    }
	}
	if(scan>=0) continue;
	if(csize<sizeof(thet)) return size;
	if(prev && *prev<0xff) {
	    (*prev)++;
	} else {
	    if(csize<sizeof(thet)+1) return size;
	    prev=out;
	    OUTBYTE(COUNTBASE);
	}
	WRITE(sh);
	p++;
	*len-=sizeof(thet);
	*buf+=sizeof(thet);
	if(cnext<HISTORY) {
	    chistory[cnext]=sh;
	    cnext++;
	   
	} else {
	    bcopy(&chistory[1], &chistory[0], sizeof(chistory)-sizeof(chistory[0]));
	    chistory[cnext-1]=sh;
	}
    }
    return size;
}

static unsigned char c2buf[65538];
static unsigned char c3buf[65538];
	
int unscompress(src, len, dest)
unsigned char *src;
int len;
unsigned char *dest;
{
    int ulen=0;
    int i;
#ifdef LOGDATA
    unsigned char *odest=dest;
    fprintf(stderr, "uncompressing: ");
    for(i=0;i<len;i++) {
	fprintf(stderr, "%x ", src[i]);
    }
    fprintf(stderr, "\n");
#endif
    while(len>0) {
	thet sh=0;
	if(*src>=COUNTBASE) {
	    int shorts=(*src-(COUNTBASE-1));
	    
	    len--;
	    src++;

	    while(shorts>0) {

		sh=READ(src[0], src[1], src[2], src[3]);
		sh=NTOH(sh);
		if(unext<HISTORY) {
		    uhistory[unext]=sh;
		    unext++;
		} else {
		    bcopy(&uhistory[1], &uhistory[0], sizeof(uhistory)-sizeof(uhistory[0]));
		    uhistory[unext-1]=sh;
		}
		*((thet *)dest)=(sh);
		ulen+=sizeof(thet);
		dest+=sizeof(thet);
		src+=sizeof(thet);
		len-=sizeof(thet);
		shorts--;
	    }
	} else if(*src<SCOUNTMAX+8) {
	    int scanx;
	    if(*src>=SCOUNTMAX) {
		scanx=(((src[0])-SCOUNTMAX)<<8)+src[1];
		len--;
		src++;
	    } else scanx=(*src);
	    scanx=unext-1-scanx;
	    sh=(uhistory[scanx]);
	    *((thet *)dest)=sh;
	    for(i=scanx+1;i<unext;i++) {
		uhistory[i-1]=uhistory[i];
	    }
	    uhistory[unext-1]=sh;
	    ulen+=sizeof(thet);
	    dest+=sizeof(thet);
	    len--;
	    src++;
	} else {
	    fprintf(stderr, "Bad data!!! %d\n", *src);
	}
    }

#ifdef LOGDATA
    fprintf(stderr, "received: ");
    for(i=0;i<ulen;i++) fprintf(stderr, "%x ", odest[i]);
    fprintf(stderr, "\n");
#endif
    return ulen;
}

static unsigned char mbuf[MAXTRANBUF];
#undef MAX
#define MAX(x,y) ((x<y)?(y):(x))

int dosstuff(fd)
int fd;
{
    fd_set rfs;
    int xfd;
    xfd=client();
    if(xfd<0) {
	perror("client");
	exit(-1);
    }
    while(1) {
	int nfds;
	FD_ZERO(&rfs);
	FD_SET(fd, &rfs);
	FD_SET(xfd, &rfs);
#if defined(__hpux) || defined(hpux)
#define CASTREADMASK(x) ((int *)(x))
#else
#define CASTREADMASK(x) (x)
#endif
	
	nfds=select(MAX(fd, xfd)+1, CASTREADMASK(&rfs), NULL, NULL, NULL);
	if(nfds==0) continue;
	if(nfds<0) {
	    if(errno==EINTR) continue;
	    perror("select");
	    continue;
	}
	if(FD_ISSET(fd, &rfs)) {
	    if(compression==-1) {
		unsigned short readlen;
		int len=0;
		while(len<2) {
		    int r=read(fd, ((char *)&readlen)+len, 2-len);
		    if(r<=0) {
			exit(-1);
		    }
		    len+=r;
		}
		len=0;
		readlen=ntohs(readlen);
		while(len<readlen) {
		    int r=read(fd, mbuf+len, readlen-len);
		    if(r<=0) {
			exit(-1);
		    }
		    len+=r;
		}
		len=unscompress(mbuf, len, c2buf);
		reallywrite(xfd, c2buf, len);

	    } else if(compression==1) {
		unsigned char *ptr=mbuf;
		int len=read(fd, mbuf, sizeof(mbuf));
		int j;
		if(len<=0) {
		    exit(-1);
		}
		while(len>0) {
		    int oldlen=len;
		    j=scompress(c3buf+2, MAXPACKET, &ptr, &len);
		/* printf("compressed %d to %d\n", oldlen-len, j+2); */
		    *((unsigned short *)c3buf)=htons(j);
		    reallywrite(xfd, c3buf, j+2);
		}
	    }
	}
	if(FD_ISSET(xfd, &rfs)) {
	    if(compression==1) {
		unsigned short readlen;
		int len=0;
		while(len<2) {
		    int r=read(xfd, ((char *)&readlen)+len, 2-len);
		    if(r<=0) {
			exit(-1);
		    }
		    len+=r;
		}
		len=0;
		readlen=ntohs(readlen);
		while(len<readlen) {
		    int r=read(xfd, mbuf+len, readlen-len);
		    if(r<=0) {
			exit(-1);
		    }
		    len+=r;
		}
		len=unscompress(mbuf, len, c2buf);
		reallywrite(fd, c2buf, len);
	    } else if(compression==-1) {
		unsigned char *ptr=mbuf;
		int len=read(xfd, mbuf, sizeof(mbuf));
		int j;
		if(len<=0) {
		    exit(-1);
		}
		while(len>0) {
		    int oldlen=len;
		    j=scompress(c3buf+2, MAXPACKET, &ptr, &len);
		/* printf("compressed %d to %d\n", oldlen-len, j+2); */
		    *((unsigned short *)c3buf)=htons(j);
		    reallywrite(fd, c3buf, j+2);
		}
	    }
	    
	}
    }   
}

#ifdef SO_LINGER
struct linger blah={
    0,
    0
};
#endif

int server(portnum)
short portnum;
{
    int one=1;
    int servsock, clientsock;
    struct sockaddr_in servsockaddr, clientsockaddr;
    int clientsockaddrlen;
    int pid;

    if ((servsock = socket(AF_INET, SOCK_STREAM, PF_UNSPEC)) == -1) {
	perror("socket");
	return -1;
    }

#ifdef SO_REUSEADDR
    setsockopt(servsock,SOL_SOCKET, SO_REUSEADDR, &one, sizeof(one));
#endif

#ifdef SO_LINGER
    setsockopt(servsock, SOL_SOCKET, SO_LINGER, &blah, sizeof(blah));
#endif

    servsockaddr.sin_family = AF_INET;
    servsockaddr.sin_port = htons(portnum);
    servsockaddr.sin_addr.s_addr = 0;

    if (bind(servsock, (struct sockaddr *)&servsockaddr,
sizeof(servsockaddr)) == -1) {
	perror("bind");
	return -1;
    }

    if (listen(servsock, 5) == -1) {
	perror("listen");
	return -1;
    }

    if(pid=fork()) {
	if(pid<0) perror("fork");
	else exit(0);
    }
    close(1);
    close(0);
    dup2(2, 1);
    for (;;) {
	clientsockaddrlen = sizeof(clientsockaddr);
	clientsock = accept(servsock, &clientsockaddr, &clientsockaddrlen);
	if (clientsock == -1) {
	    if(errno!=EINTR) perror("accept");
	    continue;
	}
	if(fork()==0) {
	    int i;
	    int count=getdtablesize();
	    for(i=3;i<count;i++) {
		if(i!=clientsock) close(i);
	    }
	    dosstuff(clientsock);
	} else close(clientsock);
    }
}

static int GetXServAddr(dname)
char *dname;
{
    struct hostent *hp;
    char *hostname;
    char *p;
    unsigned char inetaddr[4];
    int dnum=0;
    int count=0;
    
    p=strchr(dname, ':');
    if(p==NULL || !(isascii(*(p+1)) && isdigit(*(p+1)))) {
	fprintf(stderr, "DISPLAY must be of the form:
[HostnameOrUnix]:DisplayNumber[.ScreenNumber]\n");
	exit(-1);
    }
    *p='\0';
    dnum=atoi(p+1);
    
    if(dname[0]=='\0' || strcmp(dname, "unix")==0) hostname="localhost";
    else hostname=dname;
    if(isascii(hostname[0]) && isdigit(hostname[0])) {
	inetaddr[0]=atoi(hostname);
	count++;
	p=strchr(hostname, '.');
	if(p) {
	    inetaddr[1]=atoi(p+1);
	    count++;
	    p=strchr(p+1, '.');
	    if(p) {
		inetaddr[2]=atoi(p+1);
		count++;
		p=strchr(p+1, '.');
		if(p) {
		    inetaddr[3]=atoi(p+1);
		    count++;
		}
	    }
	}
	if(count!=4) {
	    fprintf(stderr, "Badly formed IP address %s\n", hostname);
	    exit(-1);
	}
	bcopy(inetaddr, (char *)&servaddr.sin_addr, sizeof(servaddr.sin_addr));
    } else {
	hp = gethostbyname(hostname);
	if (hp == NULL) {
	    fprintf(stderr, "Can't find address for host %s\n", hostname);
	    exit(-1);
	}
	bcopy(hp->h_addr, (char *)&servaddr.sin_addr, sizeof(servaddr.sin_addr));
    }

    servaddr.sin_family = AF_INET;
    servaddr.sin_port = htons(6000 + dnum);
    return dnum;
}

static int GetGatewayServAddr(dname, clientbase, serverbase)
char *dname;
int clientbase;
int serverbase;
{
    struct hostent *hp;
    char *hostname;
    char *p;
    unsigned char inetaddr[4];
    int dnum=0;
    int count=0;
    int snum=0;
        
    p=strchr(dname, ':');
    if(p==NULL || !(isascii(*(p+1)) && isdigit(*(p+1)))) {
	fprintf(stderr, "DISPLAY must be of the form:
[HostnameOrUnix]:DisplayNumber[.ScreenNumber]\n");
	exit(-1);
    }
    *p='\0';
    dnum=atoi(p+1);
    p=strchr(p+1, '.');
    if(p) snum=atoi(p+1);
    
    if(dname[0]=='\0' || strcmp(dname, "unix")==0) hostname="localhost";
    else hostname=dname;
    if(isascii(hostname[0]) && isdigit(hostname[0])) {
	inetaddr[0]=atoi(hostname);
	count++;
	p=strchr(hostname, '.');
	if(p) {
	    inetaddr[1]=atoi(p+1);
	    count++;
	    p=strchr(p+1, '.');
	    if(p) {
		inetaddr[2]=atoi(p+1);
		count++;
		p=strchr(p+1, '.');
		if(p) {
		    inetaddr[3]=atoi(p+1);
		    count++;
		}
	    }
	}
	if(count!=4) {
	    fprintf(stderr, "Badly formed IP address %s\n", hostname);
	    exit(-1);
	}
	bcopy(inetaddr, (char *)&servaddr.sin_addr, sizeof(servaddr.sin_addr));
    } else {
	hp = gethostbyname(hostname);
	if (hp == NULL) {
	    fprintf(stderr, "Can't find address for host %s\n", hostname);
	    exit(-1);
	}
	bcopy(hp->h_addr, (char *)&servaddr.sin_addr, sizeof(servaddr.sin_addr));
    }
    printf("localhost:%d.%d\n",clientbase-6000+dnum, snum);
    servaddr.sin_family = AF_INET;
    servaddr.sin_port = htons(serverbase + dnum);
    return dnum;
}

#if defined(_POSIX_SOURCE) || defined(SYSV)
void Reaper(n)
int n;
{
    while(waitpid(-1, NULL, WNOHANG)>0);
#ifdef SYSV
    signal(SIGCHLD, Reaper);
#endif
}
#else
int Reaper(n)
int n;
{
    union wait status;
    while(wait3(&status, WNOHANG, NULL)>0);
    return 0;
}
#endif

int main(argc, argv)
int argc;
char **argv;
{
    char *p=getenv("XCOMPGATEPORT");
    char *q=getenv("XCLIENTGATEPORT");
    int clientbase=6008;
    int serverbase=4000;

    if(p) serverbase=atoi(p);
    if(serverbase==0) serverbase=4000;

    if(q) clientbase=atoi(q);
    if(clientbase==0) clientbase=6008;
    
    signal(SIGCHLD, Reaper);
    
    if(argc<3) {
	fprintf(stderr, "%s\n", VersionString);
	fprintf(stderr, "On the X server host:\n\tsxpc local $DISPLAY\nOn the
 clients' host:\n\tsetenv DISPLAY `sxpc remote $REMOTEDISPLAY`\n(Where
$REMOTEDISPLAY is the DISPLAY variable setting which would otherwise be
used.)\n");
	exit(-1);
    }
    
    compression=(argv[1][0]=='l')?-1:1;
    if(compression==-1) {
	server(GetXServAddr(argv[2])+serverbase);
    } else {
	server(clientbase+GetGatewayServAddr(argv[2], clientbase, serverbase));
    }
}

