/* > xscope.c */
/* Daniel F. Smith, 1994 */
/* Becomes an oscilloscope of stdin (unsigned char data) */
/* Will multiplex stdin into multiple channels from the first argument */

#include <stdio.h>
#include <stdlib.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include "Chart.h"

#define TIMEOUT 10 /* ms */
#define XTWTAC(a) XtWidgetToApplicationContext(a)
typedef unsigned char uchar;

extern void exit(int);

Widget *chart;
int channels=1;
static String resources[]={
	"*quit.label: Quit",
	"*charts.fromVert: buttonbox",
	NULL};

static void TimeOut(Widget w,XtIntervalId *id) {
	static int l,i;
	static Dimension width=0,oldwidth;
	static uchar *buffer=NULL;
	
	oldwidth=width;
	XtVaGetValues(w,XtNwidth,&width,NULL);
	if (width!=oldwidth) {
		if (buffer) free(buffer);
		buffer=(uchar *)malloc(channels*width*sizeof(uchar));
		for(i=0;i<channels;i++) {
			XtVaSetValues(chart[i],XtNdatap,buffer+i,
					       XtNndata,width,
					       NULL);
			}
		}
	l=fread((void *)buffer,sizeof(uchar),channels*width,stdin);
	for(i=0;i<channels;i++)
		XtVaSetValues(chart[i],XtNredraw,True,NULL);
	if (l!=channels*width*sizeof(uchar))
		return;
	XtAppAddTimeOut(XTWTAC(w),TIMEOUT,(XtTimerCallbackProc)TimeOut,w);
	}

int main(int argc,char *argv[]) {
	XtAppContext app_context;
	Widget topLevel,bbox,quit,charts,form;
	int i;
	char wname[10];
	
	topLevel=XtVaAppInitialize(&app_context,
				   "XScope",
				   NULL,0,
				   &argc,argv,
				   resources,NULL);
	/* There should be some filenames left in argc/argv */
	if (argc>2) {
		fprintf(stderr,"Syntax: %s [channels]\n"
			"Where channels is the no. channels to be displayed\n",
			argv[0]);
		exit(1);
		}
	if (argc>1) channels=atoi(argv[1]);
	if (channels<=0 || channels>8) {
		fprintf(stderr,"%s: %d channels is out of range\n",
			argv[0],channels);
		exit(2);
		}

	form=XtCreateManagedWidget("form",formWidgetClass,topLevel,NULL,0);
	bbox=XtCreateManagedWidget("buttonbox",boxWidgetClass,form,NULL,0);
	quit   =XtCreateManagedWidget("quit",commandWidgetClass,bbox,NULL,0);
	charts=XtVaCreateManagedWidget("charts",formWidgetClass,form,NULL);
	
	chart=(Widget *)malloc(sizeof(Widget)*channels);
	/* Bring up main charts */
	for(i=0;i<channels;i++) {
		sprintf(wname,"chart%d",i);
		chart[i]=XtVaCreateManagedWidget(wname,
						 chartWidgetClass,charts,
						 XtNdatap,NULL,
						 XtNndata,100,
						 XtNskip,channels,
						 NULL);
		if (i>0)
			XtVaSetValues(chart[i],XtNfromVert,chart[i-1],NULL);
		}

	/* command callbacks */
	XtAddCallback(quit,XtNcallback,(XtCallbackProc)exit,NULL);
	XtAppAddTimeOut(XTWTAC(form),TIMEOUT,(XtTimerCallbackProc)TimeOut,form);

	XtRealizeWidget(topLevel);
	XtAppMainLoop(app_context);
	return 0;
	}
