#define BARCODE_G
#include "barcode.h"

#define boolean int 
#define true    1
#define false   0

static char beta[256], aha[256], delta[256], gamma[256], BildName[256];
static char Referenz[125][7];
static char Code128[256][3][7];
char strgz[512];


boolean EAN13(CharText, CodeText)
char *CharText;
char *CodeText;
{
  char Zeichensatz_C[10][8];
  char Zeichensatz_AB[2][10][8];
  char Anordung[10][7];
  unsigned char t;
  boolean OK;
  long u, w, e, i;

  OK = false;
  u = 0;
  i = 0;
  if (strlen(CharText) != 13)
    return OK;
  OK = true;
  for (t = 0; t <= 12; t++) {
    if (CharText[t] < '0' || CharText[t] > '9')
      OK = false;
  }
  if (OK != true)
    return OK;
  strcpy(Zeichensatz_C[0], "1110010");
  strcpy(Zeichensatz_C[1], "1100110");
  strcpy(Zeichensatz_C[2], "1101100");
  strcpy(Zeichensatz_C[3], "1000010");
  strcpy(Zeichensatz_C[4], "1011100");
  strcpy(Zeichensatz_C[5], "1001110");
  strcpy(Zeichensatz_C[6], "1010000");
  strcpy(Zeichensatz_C[7], "1000100");
  strcpy(Zeichensatz_C[8], "1001000");
  strcpy(Zeichensatz_C[9], "1110100");
  strcpy(Zeichensatz_AB[1][0], "0100111");
  strcpy(Zeichensatz_AB[1][1], "0110011");
  strcpy(Zeichensatz_AB[1][2], "0011011");
  strcpy(Zeichensatz_AB[1][3], "0100001");
  strcpy(Zeichensatz_AB[1][4], "0011101");
  strcpy(Zeichensatz_AB[1][5], "0111001");
  strcpy(Zeichensatz_AB[1][6], "0000101");
  strcpy(Zeichensatz_AB[1][7], "0010001");
  strcpy(Zeichensatz_AB[1][8], "0001001");
  strcpy(Zeichensatz_AB[1][9], "0010111");
  strcpy(Zeichensatz_AB[0][0], "0001101");
  strcpy(Zeichensatz_AB[0][1], "0011001");
  strcpy(Zeichensatz_AB[0][2], "0010011");
  strcpy(Zeichensatz_AB[0][3], "0111101");
  strcpy(Zeichensatz_AB[0][4], "0100011");
  strcpy(Zeichensatz_AB[0][5], "0110001");
  strcpy(Zeichensatz_AB[0][6], "0101111");
  strcpy(Zeichensatz_AB[0][7], "0111011");
  strcpy(Zeichensatz_AB[0][8], "0110111");
  strcpy(Zeichensatz_AB[0][9], "0001011");
  strcpy(Anordung[0], "AAAAAA");
  strcpy(Anordung[1], "AABABB");
  strcpy(Anordung[2], "AABBAB");
  strcpy(Anordung[3], "AABBBA");
  strcpy(Anordung[4], "ABAABB");
  strcpy(Anordung[5], "ABBAAB");
  strcpy(Anordung[6], "ABBBAA");
  strcpy(Anordung[7], "ABABAB");
  strcpy(Anordung[8], "ABABBA");
  strcpy(Anordung[9], "ABBABA");

  strcpy(CodeText, "101");   /* linkes Randzeichen */
  /* linker Abschnitt , AB-Zeichensatz  */
  for (t = 2; t <= 7; t++) {
    e = CharText[0] - '0';
    w = Anordung[e][t - 2];
    u = w - 'A';
    i = CharText[t - 1] - '0';
    strcat(CodeText, Zeichensatz_AB[u][i]);
  }
  strcat(CodeText, "01010");
  /* Rechter Abschnitt, C-Zeichensatz */
  for (t = 7; t <= 12; t++)
    strcat(CodeText, Zeichensatz_C[CharText[t] - 48]);
  strcat(CodeText, "101");   /* rechtes Zeichen */
  return OK;
}


boolean UPC(CharText_, CodeText)
char *CharText_;
char *CodeText;
{
  char CharText[256];
  char Zeichensatz_C[10][8];
  char Zeichensatz_A[10][8];
  unsigned char t;
  boolean OK;
  char ck[256];
  long ungerade, gerade, u, i;
  char STR1[256];

  strcpy(CharText, CharText_);
  OK = false;
  u = 0;
  i = 0;
  if (strlen(CharText) == 11) {
    OK = true;
    ungerade = 0;
    gerade = 0;
    for (t = 0; t <= 10; t++) {
      if (CharText[t] < '0' || CharText[t] > '9')
	OK = false;
    }
    if (OK == true) {
      for (t = 1; t <= 11; t++) {
	if (t & 1)
	  gerade += CharText[t - 1] - '0';
	else
	  ungerade += CharText[t - 1] - '0';
      }
      sprintf(ck, "%c", (char)('0' - (ungerade + gerade * 3) % 10 + 10));
      if (!strcmp(ck, ":"))
	strcpy(ck, "0");
      strcat(CharText, ck);
    }
  }
  OK = false;
  if (strlen(CharText) != 12)
    return OK;
  OK = true;
  for (t = 0; t <= 11; t++) {
    if (CharText[t] < '0' || CharText[t] > '9')
      OK = false;
  }
  if (OK != true)
    return OK;
  strcpy(Zeichensatz_C[0], "1110010");
  strcpy(Zeichensatz_C[1], "1100110");
  strcpy(Zeichensatz_C[2], "1101100");
  strcpy(Zeichensatz_C[3], "1000010");
  strcpy(Zeichensatz_C[4], "1011100");
  strcpy(Zeichensatz_C[5], "1001110");
  strcpy(Zeichensatz_C[6], "1010000");
  strcpy(Zeichensatz_C[7], "1000100");
  strcpy(Zeichensatz_C[8], "1001000");
  strcpy(Zeichensatz_C[9], "1110100");
  strcpy(Zeichensatz_A[0], "0001101");
  strcpy(Zeichensatz_A[1], "0011001");
  strcpy(Zeichensatz_A[2], "0010011");
  strcpy(Zeichensatz_A[3], "0111101");
  strcpy(Zeichensatz_A[4], "0100011");
  strcpy(Zeichensatz_A[5], "0110001");
  strcpy(Zeichensatz_A[6], "0101111");
  strcpy(Zeichensatz_A[7], "0111011");
  strcpy(Zeichensatz_A[8], "0110111");
  strcpy(Zeichensatz_A[9], "0001011");
  OK = true;
  /* ********* */
  strcpy(CodeText, "101");   /* linkes Randzeichen */
  /* linker Abschnitt , A-Zeichensatz  */
  for (t = 0; t <= 5; t++)
    strcat(CodeText, Zeichensatz_A[CharText[t] - 48]);
  strcat(CodeText, "01010");
  /* Rechter Abschnitt, C-Zeichensatz */
  for (t = 6; t <= 11; t++)
    strcat(CodeText, Zeichensatz_C[CharText[t] - 48]);
  strcat(CodeText, "101");   /* rechtes Zeichen */
  return OK;
}


boolean EAN12(CharText, CodeText)
char *CharText;
char *CodeText;
{
  boolean OK;
  char Ck[2];
  long ungerade, Gerade;
  unsigned char t;
  int k;
  char STR1[256];

  *CodeText = '\0';
  ungerade = 0;
  Gerade = 0;
  OK = false;
  if (strlen(CharText) != 12)
    return OK;

  OK = true;
  for (t = 0; t <= 11; t++) {
    if (CharText[t] < '0' || CharText[t] > '9')
      OK = false;
  }
  if (OK != true)
    return OK;
  for (t = 1; t <= 12; t++) {
    if (t & 1)
      Gerade += CharText[t - 1] - '0';
    else
      ungerade += CharText[t - 1] - '0';
  }
  k = (10 - (ungerade + Gerade * 3) % 10 + '0');
  strcpy(Ck," ");
  sprintf(STR1, "%c%s", Ck, CharText);
  if (k==58) k=48;
  STR1[0]=k;
  OK = EAN13(STR1, CodeText);
  return OK;
}


char *Wandle(Result, Text)
char *Result;
char *Text;
{
  long t;
  char Puffer[4][2][7];

  strcpy(Puffer[0][0], "0");
  strcpy(Puffer[1][0], "00");
  strcpy(Puffer[2][0], "000");
  strcpy(Puffer[3][0], "0000");
  strcpy(Puffer[0][1], "1");
  strcpy(Puffer[1][1], "11");
  strcpy(Puffer[2][1], "111");
  strcpy(Puffer[3][1], "1111");
  *strgz = '\0';
  for (t = 1; t <= 3; t++) {
    strcat(strgz, Puffer[Text[t * 2 - 2] - '0' - 1][1]);
    strcat(strgz, Puffer[Text[t * 2 - 1] - '0' - 1][0]);
  }
  Result = strgz;
  return Result;
}


boolean QCODE128(beginner, CharText_, CodeText)
long beginner;
char *CharText_;
char *CodeText;
{
  boolean Result;
  char CharText[256];
  long e, wert, zaehler, summe, status, t;
  char zwei[256], drei[256], vier[256], ins[256], starta[256], startb[256],
       stopabc[256];
  long FORLIM;
  char STR1[256];

  strcpy(CharText, CharText_);
  strcpy(Referenz[0], "212222");
  strcpy(Referenz[1], "222122");
  strcpy(Referenz[2], "222221");
  strcpy(Referenz[3], "121223");
  strcpy(Referenz[4], "121322");
  strcpy(Referenz[5], "131222");
  strcpy(Referenz[6], "122213");
  strcpy(Referenz[7], "122312");
  strcpy(Referenz[8], "132212");
  strcpy(Referenz[9], "221213");

  strcpy(Referenz[10], "221312");
  strcpy(Referenz[11], "231212");
  strcpy(Referenz[12], "112232");
  strcpy(Referenz[13], "122132");
  strcpy(Referenz[14], "122231");
  strcpy(Referenz[15], "113222");
  strcpy(Referenz[16], "123122");
  strcpy(Referenz[17], "123221");
  strcpy(Referenz[18], "223211");
  strcpy(Referenz[19], "221132");

  strcpy(Referenz[20], "221231");
  strcpy(Referenz[21], "213212");
  strcpy(Referenz[22], "223112");
  strcpy(Referenz[23], "312131");
  strcpy(Referenz[24], "311222");
  strcpy(Referenz[25], "321122");
  strcpy(Referenz[26], "321221");
  strcpy(Referenz[27], "312212");
  strcpy(Referenz[28], "322112");
  strcpy(Referenz[29], "322211");

  strcpy(Referenz[30], "212123");
  strcpy(Referenz[31], "212321");
  strcpy(Referenz[32], "232121");
  strcpy(Referenz[33], "111323");
  strcpy(Referenz[34], "131123");
  strcpy(Referenz[35], "131321");
  strcpy(Referenz[36], "112313");
  strcpy(Referenz[37], "132113");
  strcpy(Referenz[38], "132311");
  strcpy(Referenz[39], "211313");

  strcpy(Referenz[40], "231113");
  strcpy(Referenz[41], "231311");
  strcpy(Referenz[42], "112133");
  strcpy(Referenz[43], "112331");
  strcpy(Referenz[44], "132131");
  strcpy(Referenz[45], "113123");
  strcpy(Referenz[46], "113321");
  strcpy(Referenz[47], "133121");
  strcpy(Referenz[48], "313121");
  strcpy(Referenz[49], "211331");

  strcpy(Referenz[50], "231131");
  strcpy(Referenz[51], "213113");
  strcpy(Referenz[52], "213311");
  strcpy(Referenz[53], "213131");
  strcpy(Referenz[54], "311123");
  strcpy(Referenz[55], "311321");
  strcpy(Referenz[56], "331121");
  strcpy(Referenz[57], "312113");
  strcpy(Referenz[58], "312311");
  strcpy(Referenz[59], "332111");

  strcpy(Referenz[60], "314111");
  strcpy(Referenz[61], "221411");
  strcpy(Referenz[62], "431111");
  strcpy(Referenz[63], "111224");
  strcpy(Referenz[64], "111422");
  strcpy(Referenz[65], "121124");
  strcpy(Referenz[66], "121421");
  strcpy(Referenz[67], "141122");
  strcpy(Referenz[68], "141221");
  strcpy(Referenz[69], "112214");

  strcpy(Referenz[70], "112412");
  strcpy(Referenz[71], "122114");
  strcpy(Referenz[72], "122411");
  strcpy(Referenz[73], "142112");
  strcpy(Referenz[74], "142211");
  strcpy(Referenz[75], "241211");
  strcpy(Referenz[76], "221114");
  strcpy(Referenz[77], "413111");
  strcpy(Referenz[78], "241112");
  strcpy(Referenz[79], "134111");

  strcpy(Referenz[80], "111242");
  strcpy(Referenz[81], "121142");
  strcpy(Referenz[82], "121241");
  strcpy(Referenz[83], "114212");
  strcpy(Referenz[84], "124112");
  strcpy(Referenz[85], "124211");
  strcpy(Referenz[86], "411212");
  strcpy(Referenz[87], "421112");
  strcpy(Referenz[88], "421211");
  strcpy(Referenz[89], "212141");

  strcpy(Referenz[90], "214121");
  strcpy(Referenz[91], "412121");
  strcpy(Referenz[92], "111143");
  strcpy(Referenz[93], "111341");
  strcpy(Referenz[94], "131141");
  strcpy(Referenz[95], "114113");
  strcpy(Referenz[96], "114311");
  strcpy(Referenz[97], "411113");
  strcpy(Referenz[98], "411311");
  strcpy(Referenz[99], "113141");

  strcpy(Referenz[100], "114131");
  strcpy(Referenz[101], "311141");
  strcpy(Referenz[102], "411131");


  strcpy(Code128[0][0], "111422");   /* NUL */
  *Code128[1][1] = '\0';

  strcpy(Code128[1][0], "121124");   /* SOH */
  *Code128[1][1] = '\0';

  strcpy(Code128[2][0], "121421");   /* STX */
  *Code128[2][1] = '\0';

  strcpy(Code128[3][0], "141122");   /* ETX */
  *Code128[3][1] = '\0';

  strcpy(Code128[4][0], "141221");   /* EOT*/
  *Code128[4][1] = '\0';

  strcpy(Code128[5][0], "112241");   /* ENQ */
  *Code128[5][1] = '\0';

  strcpy(Code128[6][0], "112412");   /* ACK */
  *Code128[6][1] = '\0';

  strcpy(Code128[7][0], "112114");   /* BEL */
  *Code128[7][1] = '\0';

  strcpy(Code128[8][0], "122411");   /* BS */
  *Code128[8][1] = '\0';

  strcpy(Code128[9][0], "142112");   /* HT */
  *Code128[9][1] = '\0';

  strcpy(Code128[10][0], "142211");   /* LF */
  *Code128[10][1] = '\0';

  strcpy(Code128[11][0], "241211");   /* VT */
  *Code128[11][1] = '\0';

  strcpy(Code128[12][0], "221114");   /* FF */
  *Code128[12][1] = '\0';
  *Code128[12][2] = '\0';

  strcpy(Code128[13][0], "413111");   /* CR */
  *Code128[13][1] = '\0';
  *Code128[13][2] = '\0';

  strcpy(Code128[14][0], "241112");   /* SO */
  *Code128[14][1] = '\0';
  *Code128[14][2] = '\0';

  strcpy(Code128[15][0], "134111");   /* SI */
  *Code128[15][1] = '\0';
  *Code128[15][2] = '\0';

  strcpy(Code128[16][0], "111242");   /* DLE */
  *Code128[16][1] = '\0';
  *Code128[16][2] = '\0';

  strcpy(Code128[17][0], "121142");   /* DC1 */
  *Code128[17][1] = '\0';
  *Code128[17][2] = '\0';

  strcpy(Code128[18][0], "121241");   /* DC2 */
  *Code128[18][1] = '\0';
  *Code128[18][2] = '\0';


  strcpy(Code128[19][0], "114212");   /* DC3 */
  *Code128[19][1] = '\0';
  *Code128[19][2] = '\0';

  strcpy(Code128[20][0], "124112");   /* DC4 */
  *Code128[20][1] = '\0';
  *Code128[20][2] = '\0';

  strcpy(Code128[21][0], "124211");   /* NAK */
  *Code128[21][1] = '\0';
  *Code128[21][2] = '\0';

  strcpy(Code128[22][0], "411212");   /* SYN */
  *Code128[22][1] = '\0';
  *Code128[22][2] = '\0';

  strcpy(Code128[23][0], "421112");   /* ETB */
  *Code128[23][1] = '\0';
  *Code128[23][2] = '\0';

  strcpy(Code128[24][0], "421211");   /* CAN */
  *Code128[24][1] = '\0';
  *Code128[24][2] = '\0';

  strcpy(Code128[25][0], "212141");   /* EM */
  *Code128[25][1] = '\0';
  *Code128[25][2] = '\0';

  strcpy(Code128[26][0], "214121");   /* SUB */
  *Code128[26][1] = '\0';
  *Code128[26][2] = '\0';

  strcpy(Code128[27][0], "412121");   /* ESC */
  *Code128[27][1] = '\0';
  *Code128[27][2] = '\0';

  strcpy(Code128[28][0], "111143");   /* FS */
  *Code128[28][1] = '\0';
  *Code128[28][2] = '\0';

  strcpy(Code128[29][0], "111341");   /* GS */
  *Code128[29][1] = '\0';
  *Code128[29][2] = '\0';

  strcpy(Code128[30][0], "131141");   /* RS */
  *Code128[30][1] = '\0';
  *Code128[30][2] = '\0';

  strcpy(Code128[31][0], "114113");   /* US */
  *Code128[31][1] = '\0';
  *Code128[31][2] = '\0';

  strcpy(Code128[32][0], "212222");   /* Space */
  strcpy(Code128[32][1], "212222");
  strcpy(Code128[32][2], "212222");

  strcpy(Code128[33][0], "222122");   /* ! */
  strcpy(Code128[33][1], "222122");
  strcpy(Code128[33][2], "222122");

  strcpy(Code128[34][0], "222221");   /* " */
  strcpy(Code128[34][1], "222221");
  strcpy(Code128[34][2], "222221");

  strcpy(Code128[35][0], "121223");   /* # */
  strcpy(Code128[35][1], "121223");
  strcpy(Code128[35][2], "121223");

  strcpy(Code128[36][0], "121322");   /* $ */
  strcpy(Code128[36][1], "121322");
  strcpy(Code128[36][2], "121322");

  strcpy(Code128[37][0], "131222");   /* % */
  strcpy(Code128[37][1], "131222");
  strcpy(Code128[37][2], "131222");

  strcpy(Code128[38][0], "122213");   /* & */
  strcpy(Code128[38][1], "122213");
  strcpy(Code128[38][2], "122213");

  strcpy(Code128[39][0], "122312");   /* ' */
  strcpy(Code128[39][1], "122312");
  strcpy(Code128[39][2], "122312");

  strcpy(Code128[40][0], "132212");   /* ( */
  strcpy(Code128[40][1], "132212");
  strcpy(Code128[40][2], "132212");

  strcpy(Code128[41][0], "221213");   /* ) */
  strcpy(Code128[41][1], "221213");
  strcpy(Code128[41][2], "221213");

  strcpy(Code128[42][0], "221312");   /* * */
  strcpy(Code128[42][1], "221312");
  strcpy(Code128[42][2], "221312");

  strcpy(Code128[43][0], "231212");   /* + */
  strcpy(Code128[43][1], "231212");
  strcpy(Code128[43][2], "231212");

  strcpy(Code128[44][0], "112232");   /* , */
  strcpy(Code128[44][1], "112232");
  strcpy(Code128[44][2], "112232");

  strcpy(Code128[45][0], "122132");   /* - */
  strcpy(Code128[45][1], "122132");
  strcpy(Code128[45][2], "122132");

  strcpy(Code128[46][0], "122231");   /* . */
  strcpy(Code128[46][1], "122231");
  strcpy(Code128[46][2], "122231");

  strcpy(Code128[47][0], "113222");   /* / */
  strcpy(Code128[47][1], "113222");
  strcpy(Code128[47][2], "113222");

  strcpy(Code128[48][0], "123122");   /* 0 */
  strcpy(Code128[48][1], "123122");
  strcpy(Code128[48][2], "123122");

  strcpy(Code128[49][0], "123221");   /* 1 */
  strcpy(Code128[49][1], "123221");
  strcpy(Code128[49][2], "123221");

  strcpy(Code128[50][0], "223211");   /* 2 */
  strcpy(Code128[50][1], "223211");
  strcpy(Code128[50][2], "223211");

  strcpy(Code128[51][0], "221132");   /* 3 */
  strcpy(Code128[51][1], "221132");
  strcpy(Code128[51][2], "221132");

  strcpy(Code128[52][0], "221231");   /* 4 */
  strcpy(Code128[52][1], "221231");
  strcpy(Code128[52][2], "221231");

  strcpy(Code128[53][0], "213212");   /* 5 */
  strcpy(Code128[53][1], "213212");
  strcpy(Code128[53][2], "213212");

  strcpy(Code128[54][0], "223112");   /* 6 */
  strcpy(Code128[54][1], "223112");
  strcpy(Code128[54][2], "223112");

  strcpy(Code128[55][0], "312131");   /* 7 */
  strcpy(Code128[55][1], "312131");
  strcpy(Code128[55][2], "312131");

  strcpy(Code128[56][0], "311222");   /* 8 */
  strcpy(Code128[56][1], "311222");
  strcpy(Code128[56][2], "311222");

  strcpy(Code128[57][0], "321122");   /* 9 */
  strcpy(Code128[57][1], "321122");
  strcpy(Code128[57][2], "321122");

  strcpy(Code128[58][0], "321221");   /* : */
  strcpy(Code128[58][1], "321221");
  strcpy(Code128[58][2], "321221");

  strcpy(Code128[59][0], "312212");   /* ; */
  strcpy(Code128[59][1], "312212");
  strcpy(Code128[59][2], "312212");

  strcpy(Code128[60][0], "322112");   /* < */
  strcpy(Code128[60][1], "322112");
  strcpy(Code128[60][2], "322112");

  strcpy(Code128[61][0], "322211");   /* =  */
  strcpy(Code128[61][1], "322211");

  strcpy(Code128[62][0], "212123");   /* > */
  strcpy(Code128[62][1], "212123");

  strcpy(Code128[63][0], "212321");   /* ? */
  strcpy(Code128[63][1], "212321");

  strcpy(Code128[64][0], "232121");   /* @ */
  strcpy(Code128[64][1], "232121");

  strcpy(Code128[65][0], "111323");   /* A */
  strcpy(Code128[65][1], "111323");

  strcpy(Code128[66][0], "131123");   /* B */
  strcpy(Code128[66][1], "131123");

  strcpy(Code128[67][0], "131321");   /* C */
  strcpy(Code128[67][1], "131321");

  strcpy(Code128[68][0], "112313");   /* D */
  strcpy(Code128[68][1], "112313");

  strcpy(Code128[69][0], "132113");   /* E */
  strcpy(Code128[69][1], "132113");

  strcpy(Code128[70][0], "132311");   /* F*/
  strcpy(Code128[70][1], "132311");

  strcpy(Code128[71][0], "211313");   /* G*/
  strcpy(Code128[71][1], "211313");

  strcpy(Code128[72][0], "231113");   /* H*/
  strcpy(Code128[72][1], "231113");

  strcpy(Code128[73][0], "231311");   /* I */
  strcpy(Code128[73][1], "231311");

  strcpy(Code128[74][0], "112133");   /* J */
  strcpy(Code128[74][1], "112133");

  strcpy(Code128[75][0], "112311");   /* K */
  strcpy(Code128[75][1], "112311");

  strcpy(Code128[76][0], "132131");   /* L */
  strcpy(Code128[76][1], "132131");

  strcpy(Code128[77][0], "113123");   /* M */
  strcpy(Code128[77][1], "113123");

  strcpy(Code128[78][0], "113321");   /* N */
  strcpy(Code128[78][1], "113321");

  strcpy(Code128[79][0], "133121");   /* O */
  strcpy(Code128[79][1], "133121");

  strcpy(Code128[80][0], "313121");   /* P */
  strcpy(Code128[80][1], "313121");

  strcpy(Code128[81][0], "211331");   /* Q */
  strcpy(Code128[81][1], "211331");

  strcpy(Code128[82][0], "231131");   /* R */
  strcpy(Code128[82][1], "231131");

  strcpy(Code128[83][0], "213113");   /* S */
  strcpy(Code128[83][1], "213113");

  strcpy(Code128[84][0], "213311");   /* T */
  strcpy(Code128[84][1], "213311");

  strcpy(Code128[85][0], "213131");   /* U */
  strcpy(Code128[85][1], "213131");

  strcpy(Code128[86][0], "311123");   /*V  */
  strcpy(Code128[86][1], "311123");

  strcpy(Code128[87][0], "311321");   /* W*/
  strcpy(Code128[87][1], "311321");

  strcpy(Code128[88][0], "331121");   /* X */
  strcpy(Code128[88][1], "331121");

  strcpy(Code128[89][0], "312113");   /* Y */
  strcpy(Code128[89][1], "312113");

  strcpy(Code128[90][0], "312311");   /* Z */
  strcpy(Code128[90][1], "312311");

  strcpy(Code128[91][0], "332111");   /* [ */
  strcpy(Code128[91][1], "332111");

  strcpy(Code128[92][0], "314111");   /* \ */
  strcpy(Code128[92][1], "314111");

  strcpy(Code128[93][0], "221411");   /* ]  */
  strcpy(Code128[93][1], "221411");

  strcpy(Code128[94][0], "431111");   /* ^ */
  strcpy(Code128[94][1], "431111");

  strcpy(Code128[95][0], "111224");   /* _ */
  strcpy(Code128[95][1], "111224");

  *Code128[96][0] = '\0';   /* ` */
  strcpy(Code128[96][1], "111422");

  *Code128[97][0] = '\0';   /* a */
  strcpy(Code128[97][1], "121124");

  *Code128[98][0] = '\0';   /* b */
  strcpy(Code128[98][1], "121421");

  *Code128[99][0] = '\0';   /* c */
  strcpy(Code128[99][1], "141122");

  *Code128[100][0] = '\0';   /* d */
  strcpy(Code128[100][1], "141221");

  *Code128[101][0] = '\0';   /* e */
  strcpy(Code128[101][1], "112214");

  *Code128[102][0] = '\0';   /* f */
  strcpy(Code128[102][1], "112412");

  *Code128[103][0] = '\0';   /* g */
  strcpy(Code128[103][1], "122114");

  *Code128[104][0] = '\0';   /* h */
  strcpy(Code128[104][1], "122411");

  *Code128[105][0] = '\0';   /* i  */
  strcpy(Code128[105][1], "142112");

  *Code128[106][0] = '\0';   /* j */
  strcpy(Code128[106][1], "142211");

  *Code128[107][0] = '\0';   /* k */
  strcpy(Code128[107][1], "241211");

  *Code128[108][0] = '\0';   /* l */
  strcpy(Code128[108][1], "221114");

  *Code128[109][0] = '\0';   /* m */
  strcpy(Code128[109][1], "413111");

  *Code128[110][0] = '\0';   /* n */
  strcpy(Code128[110][1], "241112");

  *Code128[111][0] = '\0';   /* o */
  strcpy(Code128[111][1], "134111");

  *Code128[112][0] = '\0';   /* p */
  strcpy(Code128[112][1], "111242");

  *Code128[113][0] = '\0';   /* q */
  strcpy(Code128[113][1], "121142");

  *Code128[114][0] = '\0';   /* r */
  strcpy(Code128[114][1], "121241");

  *Code128[115][0] = '\0';   /* s */
  strcpy(Code128[115][1], "114212");

  *Code128[116][0] = '\0';   /* t */
  strcpy(Code128[116][1], "124112");

  *Code128[117][0] = '\0';   /* u */
  strcpy(Code128[117][1], "124211");

  *Code128[118][0] = '\0';   /* v */
  strcpy(Code128[118][1], "411212");

  *Code128[119][0] = '\0';   /* w */
  strcpy(Code128[119][1], "421112");

  *Code128[120][0] = '\0';   /* x */
  strcpy(Code128[120][1], "421211");

  *Code128[121][0] = '\0';   /* y */
  strcpy(Code128[121][1], "212141");

  *Code128[122][0] = '\0';   /* z */
  strcpy(Code128[122][1], "214121");

  *Code128[123][0] = '\0';
  strcpy(Code128[123][1], "412121");   /* (, */
  *Code128[123][2] = '\0';

  *Code128[124][0] = '\0';
  strcpy(Code128[124][1], "111143");   /* | */
  *Code128[124][2] = '\0';

  *Code128[125][0] = '\0';
  strcpy(Code128[125][1], "111341");   /* ,) */
  *Code128[125][2] = '\0';

  *Code128[126][0] = '\0';
  strcpy(Code128[126][1], "131141");   /* ~ */
  *Code128[126][2] = '\0';

  *Code128[127][0] = '\0';
  strcpy(Code128[127][1], "114113");   /* DEL */
  *Code128[127][2] = '\0';

  strcpy(Code128[128][0], "114311");   /* FNC3 */
  strcpy(Code128[128][1], "114311");

  strcpy(Code128[129][0], "411113");   /* FNC2 */
  strcpy(Code128[129][1], "411113");

  strcpy(Code128[130][0], "411131");   /* FNC1 */
  strcpy(Code128[130][1], "411131");

  strcpy(Code128[131][0], "311141");   /* FNC4 */
  strcpy(Code128[131][1], "114131");

  strcpy(starta, "11010000100");
  strcpy(startb, "11010010000");
  strcpy(stopabc, "1100011101011");

  Result = false;
  status = 0;   /* 0=A-zeichensatz */
  strcpy(CodeText, starta);
  summe = 0;
  zaehler = 0;
  e = 0;
  *ins = '\0';
  if (*CharText == '\0')
    return Result;
  wert = CharText[0];
  if (wert > 127)
    Result = false;

  if (beginner == 2) {
    summe = 104;

    status = 1;   /* 1=B-zeichensatz */
    strcpy(CodeText, startb);
  }

  if (beginner == 1) {
    summe = 103;
    status = 0;   /* 0=A-zeichensatz */
    strcpy(CodeText, starta);
  }

  Result = true;

  FORLIM = strlen(CharText);
  for (t = 1; t <= FORLIM; t++) {
    if (strlen(CharText) != t && CharText[t - 1] == '#') {
      if (CharText[t] != '#') {
	sprintf(zwei, "%c%c", CharText[t], CharText[t + 1]);
	sprintf(drei, "%s%c", zwei, CharText[t + 2]);
	sprintf(vier, "%s%c", drei, CharText[t + 3]);
	if (!strcmp(zwei, "BS")) {
	  t += 2;
	  CharText[t - 1] = '\b';
	}
	if (!strcmp(zwei, "HT")) {
	  t += 2;
	  CharText[t - 1] = '\t';
	}
	if (!strcmp(zwei, "LF")) {
	  t += 2;
	  CharText[t - 1] = '\n';
	}
	if (!strcmp(zwei, "VT")) {
	  t += 2;
	  CharText[t - 1] = '\013';
	}
	if (!strcmp(zwei, "FF")) {
	  t += 2;
	  CharText[t - 1] = '\f';
	}
	if (!strcmp(zwei, "CR")) {
	  t += 2;
	  CharText[t - 1] = '\015';
	}
	if (!strcmp(zwei, "SO")) {
	  t += 2;
	  CharText[t - 1] = '\016';
	}
	if (!strcmp(zwei, "SI")) {
	  t += 2;
	  CharText[t - 1] = '\017';
	}
	if (!strcmp(zwei, "FS")) {
	  t += 2;
	  CharText[t - 1] = '\034';
	}
	if (!strcmp(zwei, "EM")) {
	  t += 2;
	  CharText[t - 1] = '\031';
	}

	if (!strcmp(zwei, "GS")) {
	  t += 2;
	  CharText[t - 1] = '\035';
	}
	if (!strcmp(zwei, "RS")) {
	  t += 2;
	  CharText[t - 1] = '\036';
	}
	if (!strcmp(zwei, "US")) {
	  t += 2;
	  CharText[t - 1] = '\037';
	}

	if (!strcmp(drei, "NUL")) {
	  t += 3;
	  CharText[t - 1] = '\0';
	}
	if (!strcmp(drei, "SOH")) {
	  t += 3;
	  CharText[t - 1] = (Char)1;
	}

	if (!strcmp(drei, "STX")) {
	  t += 3;
	  CharText[t - 1] = '\002';
	}
	if (!strcmp(drei, "ETX")) {
	  t += 3;
	  CharText[t - 1] = (Char)3;
	}

	if (!strcmp(drei, "EOT")) {
	  t += 3;
	  CharText[t - 1] = '\004';
	}
	if (!strcmp(drei, "ENQ")) {
	  t += 3;
	  CharText[t - 1] = (Char)5;
	}

	if (!strcmp(drei, "ACK")) {
	  t += 3;
	  CharText[t - 1] = '\006';
	}
	if (!strcmp(drei, "BEL")) {
	  t += 3;
	  CharText[t - 1] = (Char)7;
	}
	if (!strcmp(drei, "DLE")) {
	  t += 3;
	  CharText[t - 1] = '\020';
	}
	if (!strcmp(drei, "DC1")) {
	  t += 3;
	  CharText[t - 1] = (Char)17;
	}
	if (!strcmp(drei, "DC2")) {
	  t += 3;
	  CharText[t - 1] = '\022';
	}
	if (!strcmp(drei, "DC3")) {
	  t += 3;
	  CharText[t - 1] = (Char)19;
	}
	if (!strcmp(drei, "DC4")) {
	  t += 3;
	  CharText[t - 1] = '\024';
	}
	if (!strcmp(drei, "NAK")) {
	  t += 3;
	  CharText[t - 1] = (Char)21;
	}


	if (!strcmp(drei, "SYN")) {
	  t += 3;
	  CharText[t - 1] = '\026';
	}
	if (!strcmp(drei, "ETB")) {
	  t += 3;
	  CharText[t - 1] = (Char)23;
	}
	if (!strcmp(drei, "CAN")) {
	  t += 3;
	  CharText[t - 1] = '\030';
	}

	if (!strcmp(drei, "SUB")) {
	  t += 3;
	  CharText[t - 1] = '\032';
	}
	if (!strcmp(drei, "ESC")) {
	  t += 3;
	  CharText[t - 1] = (Char)27;
	}

	if (!strcmp(vier, "FNC1")) {
	  t += 4;
	  CharText[t - 1] = 130;
	}
	if (!strcmp(vier, "FNC2")) {
	  t += 4;
	  CharText[t - 1] = 129;
	}
	if (!strcmp(vier, "FNC3")) {
	  t += 4;
	  CharText[t - 1] = 128;
	}
	if (!strcmp(vier, "FNC4")) {
	  t += 4;
	  CharText[t - 1] = 131;
	}

      } else {
	if (t != strlen(CharText))
	  t++;
      }
    }

    if (*Code128[CharText[t - 1]][status] == '\0') {
	  /* aha, modus wechseln */
	    status = labs(status - 1);
      if (status == 1) {
	strcat(CodeText, Wandle(STR1, "114131"));
	zaehler++;
	summe += zaehler * 100;
      }

      if (status == 0) {
	zaehler++;
	strcat(CodeText, Wandle(STR1, "311141"));
	summe += zaehler * 101;
      }
    }
    zaehler++;
    strcpy(ins, Code128[CharText[t - 1]][status]);
    for (e = 0; e <= 102; e++) {
      if (!strcmp(ins, Referenz[e]))
	summe += e * zaehler;
    }
    strcat(CodeText, Wandle(STR1, ins));
  }

  strcat(CodeText, Wandle(STR1, Referenz[summe % 103]));
  if (strlen(CodeText) + strlen(stopabc) > 256)
    Result = false;
  strcat(CodeText, stopabc);
  return Result;
}


boolean CODE25M(CharText, CodeText)
char *CharText;
char *CodeText;
{
  char CODE[10][14];
  boolean ok;
  long t, FORLIM;

  ok = true;
  FORLIM = strlen(CharText);
  for (t = 0; t < FORLIM; t++) {
    if (CharText[t] < '0' || CharText[t] > '9')
      ok = false;
  }
  if (ok != true)
    return ok;
  strcpy(CODE[0], "1011001");
  strcpy(CODE[1], "1101011");
  strcpy(CODE[2], "1001011");
  strcpy(CODE[3], "1100101");
  strcpy(CODE[4], "1011011");
  strcpy(CODE[5], "1101101");
  strcpy(CODE[6], "1001101");
  strcpy(CODE[7], "1010011");
  strcpy(CODE[8], "1101001");
  strcpy(CODE[9], "1001001");
  strcpy(CodeText, "1110101");

  FORLIM = strlen(CharText);
  for (t = 0; t < FORLIM; t++)
    sprintf(CodeText + strlen(CodeText), "0%s", CODE[CharText[t] - 48]);
  strcat(CodeText, "01110101");
  return ok;
}


boolean EAN8(CharText_, CodeText)
char *CharText_;
char *CodeText;
{
  char CharText[256];
  char Zeichensatz_C[10][8];
  char Zeichensatz_A[10][8];
  unsigned char t;
  boolean OK;
  char st[256];
  long u, i, ge, un;

  strcpy(CharText, CharText_);
  OK = false;
  u = 0;
  i = 0;
  if (strlen(CharText) == 7) {
    OK = true;
    /* berechne Prfziffer */
    for (t = 0; t <= 6; t++) {
      if (CharText[t] < '0' || CharText[t] > '9')
	OK = false;
    }
    if (OK == true) {
      ge = 0;
      un = 0;
      for (t = 0; t <= 6; t++) {
	if (CharText[t] & 1)
	  un += CharText[t] - '0';
	else
	  ge += CharText[t] - '0';
      }
      sprintf(st, "%c", (Char)('0' - (un * 3 + ge) % 10 + 10));
      if (!strcmp(st, ":"))
	strcpy(st, "0");
      strcat(CharText, st);
    }
  }
  OK = false;
  if (strlen(CharText) != 8)
    return OK;
  OK = true;
  for (t = 0; t <= 7; t++) {
    if (CharText[t] < '0' || CharText[t] > '9')
      OK = false;
  }
  if (OK != true)
    return OK;
  strcpy(Zeichensatz_C[0], "1110010");
  strcpy(Zeichensatz_C[1], "1100110");
  strcpy(Zeichensatz_C[2], "1101100");
  strcpy(Zeichensatz_C[3], "1000010");
  strcpy(Zeichensatz_C[4], "1011100");
  strcpy(Zeichensatz_C[5], "1001110");
  strcpy(Zeichensatz_C[6], "1010000");
  strcpy(Zeichensatz_C[7], "1000100");
  strcpy(Zeichensatz_C[8], "1001000");
  strcpy(Zeichensatz_C[9], "1110100");
  strcpy(Zeichensatz_A[0], "0001101");
  strcpy(Zeichensatz_A[1], "0011001");
  strcpy(Zeichensatz_A[2], "0010011");
  strcpy(Zeichensatz_A[3], "0111101");
  strcpy(Zeichensatz_A[4], "0100011");
  strcpy(Zeichensatz_A[5], "0110001");
  strcpy(Zeichensatz_A[6], "0101111");
  strcpy(Zeichensatz_A[7], "0111011");
  strcpy(Zeichensatz_A[8], "0110111");
  strcpy(Zeichensatz_A[9], "0001011");
  strcpy(CodeText, "101");   /* linkes Randzeichen */
  /* linker Abschnitt , AB-Zeichensatz  */
  for (t = 0; t <= 3; t++) {
    i = CharText[t] - '0';
    strcat(CodeText, Zeichensatz_A[i]);
  }
  strcat(CodeText, "01010");
  /* Rechter Abschnitt, C-Zeichensatz */
  for (t = 4; t <= 7; t++)
    strcat(CodeText, Zeichensatz_C[CharText[t] - 48]);
  strcat(CodeText, "101");   /* rechtes Zeichen */
  return OK;
}


boolean CODE39(CharText_, CodeText)
char *CharText_;
char *CodeText;
{
  boolean Result;
  char CharText[256];
  char Code[43][13];
  long t, Nr, FORLIM;

  strcpy(CharText, CharText_);
  strcpy(Code[0], "101001101101");   /* 0..  */
  strcpy(Code[1], "110100101011");
  strcpy(Code[2], "101100101011");
  strcpy(Code[3], "110110010101");
  strcpy(Code[4], "101001101011");
  strcpy(Code[5], "110100110101");
  strcpy(Code[6], "101100110101");
  strcpy(Code[7], "101001011011");
  strcpy(Code[8], "110100101101");
  strcpy(Code[9], "101100101101");   /* .. 9 */
  strcpy(Code[10], "110101001011");   /* A .. */
  strcpy(Code[11], "101101001011");
  strcpy(Code[12], "110110100101");
  strcpy(Code[13], "101011001011");
  strcpy(Code[14], "110101100101");
  strcpy(Code[15], "101101100101");
  strcpy(Code[16], "101010011011");
  strcpy(Code[17], "110101001101");
  strcpy(Code[18], "101101001101");
  strcpy(Code[19], "101011001101");   /* .. J */
  strcpy(Code[20], "100100100101");   /* $ */
  strcpy(Code[21], "100100101001");   /* / */
  strcpy(Code[22], "110101010011");   /* K .. */
  strcpy(Code[23], "101101010011");
  strcpy(Code[24], "110110101001");
  strcpy(Code[25], "101011010011");
  strcpy(Code[26], "110101101001");
  strcpy(Code[27], "101101101001");
  strcpy(Code[28], "101010110011");
  strcpy(Code[29], "110101011001");
  strcpy(Code[30], "101101011001");   /* S */
  strcpy(Code[31], "101011011001");
  strcpy(Code[32], "110010101011");
  strcpy(Code[33], "100110101011");
  strcpy(Code[34], "110011010101");
  strcpy(Code[35], "100101101011");
  strcpy(Code[36], "110010110101");
  strcpy(Code[37], "100110110101");   /* .. Z */
  strcpy(Code[38], "100101011011");   /* - */
  strcpy(Code[39], "100101001001");   /* + */
  strcpy(Code[40], "101001001001");   /* % */
  strcpy(Code[41], "110010101101");   /* . */
  strcpy(Code[42], "100110101101");   /* Space */
  Result = true;
  strcpy(CodeText, "1001011011010");
  FORLIM = strlen(CharText);
  for (t = 0; t < FORLIM; t++) {
    CharText[t] = toupper(CharText[t]);
    switch (CharText[t]) {

    case '-':
      Nr = 38;
      break;

    case '$':
      Nr = 20;
      break;

    case '/':
      Nr = 21;
      break;

    case '%':
      Nr = 40;
      break;

    case '+':
      Nr = 39;
      break;

    case ' ':
      Nr = 42;
      break;

    case '.':
      Nr = 41;
      break;

    default:
      if (isdigit(CharText[t]))
	Nr = CharText[t] - '0';
      else if (CharText[t] >= 'A' && CharText[t] <= 'J')
	Nr = CharText[t] - 'A' + 10;
      else if (CharText[t] >= 'K' && CharText[t] <= 'Z')
	Nr = CharText[t] - 'K' + 22;
      else {
	*CodeText = '\0';
	return false;
      }
      break;
    }
    sprintf(CodeText + strlen(CodeText), "%s0", Code[Nr]);
  }
  strcat(CodeText, "100101101101");
  return Result;
}


boolean CODE25(CharText, CodeText)
char *CharText;
char *CodeText;
{
  char CODE[10][14];
  boolean ok;
  long t, FORLIM;

  ok = true;
  FORLIM = strlen(CharText);
  for (t = 0; t < FORLIM; t++) {
    if (CharText[t] < '0' || CharText[t] > '9')
      ok = false;
  }
  if (ok != true)
    return ok;
  strcpy(CODE[0], "101110001");
  strcpy(CODE[1], "111010111");
  strcpy(CODE[2], "100010111");
  strcpy(CODE[3], "111000101");
  strcpy(CODE[4], "101110111");
  strcpy(CODE[5], "111011101");
  strcpy(CODE[6], "100011101");
  strcpy(CODE[7], "101000111");
  strcpy(CODE[8], "111010001");
  strcpy(CODE[9], "100010001");
  strcpy(CodeText, "101");
  FORLIM = strlen(CharText);
  for (t = 0; t < FORLIM; t++)
    sprintf(CodeText + strlen(CodeText), "0%s", CODE[CharText[t] - 48]);
  strcat(CodeText, "011101");
  return ok;
}


boolean CODE25I(CharText, CodeText)
char *CharText;
char *CodeText;
{
  boolean Result;
  char Code[10][6];
  long t;
  unsigned char z, FirstChar, SecondChar;
  long FORLIM;

  strcpy(Code[1], "10001");
  strcpy(Code[2], "01001");
  strcpy(Code[3], "11000");
  strcpy(Code[4], "00101");
  strcpy(Code[5], "10100");
  strcpy(Code[6], "01100");
  strcpy(Code[7], "00011");
  strcpy(Code[8], "10010");
  strcpy(Code[9], "01010");
  strcpy(Code[0], "00110");
  Result = false;
  if (strlen(CharText) & 1)
    return Result;
  FORLIM = strlen(CharText);
  for (t = 0; t < FORLIM; t++) {
    if (CharText[t] < '0' || CharText[t] > '9')
      return false;
  }
  Result = true;
  strcpy(CodeText, "1010");
  FORLIM = strlen(CharText);
  for (t = 1; t <= FORLIM; t++) {
    if (t & 1) {
      FirstChar = CharText[t - 1] - '0';
      SecondChar = CharText[t] - '0';
      for (z = 0; z <= 4; z++) {
	if (Code[FirstChar][z] == '1')
	  strcat(CodeText, "11");
	if (Code[FirstChar][z] == '0')
	  strcat(CodeText, "1");
	if (Code[SecondChar][z] == '1')
	  strcat(CodeText, "00");
	if (Code[SecondChar][z] == '0')
	  strcat(CodeText, "0");
      }
    }
  }
  strcat(CodeText, "1101");
  return Result;
}


boolean CODEA(CharText_, CodeText)
char *CharText_;
char *CodeText;
{
  boolean Result;
  char CharText[256];
  char CodeABar[24][14];
  long t, Nr, FORLIM;

  strcpy(CharText, CharText_);
  strcpy(CodeABar[1], "10101110001");
  strcpy(CodeABar[2], "10100010111");
  strcpy(CodeABar[3], "11100010101");
  strcpy(CodeABar[4], "10111010001");
  strcpy(CodeABar[5], "11101010001");
  strcpy(CodeABar[6], "10001010111");
  strcpy(CodeABar[7], "10001011101");
  strcpy(CodeABar[8], "10001110101");
  strcpy(CodeABar[9], "11101000101");
  strcpy(CodeABar[0], "10101000111");
  strcpy(CodeABar[10], "10100011101");   /* - */
  strcpy(CodeABar[11], "10111000101");   /* $ */
  strcpy(CodeABar[12], "11101011101");   /* = */
  strcpy(CodeABar[13], "11101110101");   /* / */
  strcpy(CodeABar[14], "1110111011101");   /* . */
  strcpy(CodeABar[15], "1011101110111");   /* + */
  strcpy(CodeABar[16], "1011100010001");   /* A */
  strcpy(CodeABar[17], "1000100010111");   /* B */
  strcpy(CodeABar[18], "1010001000111");   /* C */
  strcpy(CodeABar[19], "1010001110001");   /* D */
  strcpy(CodeABar[20], "1011100010001");   /* T */
  strcpy(CodeABar[21], "1000100010111");   /* N */
  strcpy(CodeABar[22], "1010001000111");   /* * */
  strcpy(CodeABar[23], "1010001110001");   /* E */
  Result = true;
  *CodeText = '\0';
  FORLIM = strlen(CharText);
  for (t = 0; t < FORLIM; t++) {
    CharText[t] = toupper(CharText[t]);
    switch (CharText[t]) {

    case '-':
      Nr = 10;
      break;

    case '$':
      Nr = 11;
      break;

    case '=':
      Nr = 12;
      break;

    case '/':
      Nr = 13;
      break;

    case '.':
      Nr = 14;
      break;

    case '+':
      Nr = 15;
      break;

    case 'A':
    case 'B':
    case 'C':
    case 'D':
      Nr = CharText[t] - 'A' + 16;
      break;

    case 'T':
      Nr = 20;
      break;

    case 'N':
      Nr = 21;
      break;

    case '*':
      Nr = 22;
      break;

    case 'E':
      Nr = 23;
      break;

    default:
      if (!isdigit(CharText[t])) {
	*CodeText = '\0';
	return false;
      }
      Nr = CharText[t] - '0';
      break;
    }
    sprintf(CodeText + strlen(CodeText), "%s0", CodeABar[Nr]);
  }
  return Result;
}


/* void _Barcode_init()
{
  static int _was_initialized = 0;
  if (_was_initialized++)
    return;
}
*/