/*
 *
SURF: an X application to fine-tune, monitor, and control numerical simulations.
 *		Version 1.02
 *    Copyright (C) 1994 Weimin Zhao
 *
 * $Id$
 *
*/
/*
    This program and upon which the library is built are free software;
    you can redistribute it and/or modify it under the terms of the GNU
    General Public License (GPL) and Library General Public License (LGPL)
    as published by the Free Software Foundation; either version 2 of the
    License, or any later version.

    This program and the library are distributed in the hope that it will
    be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
    of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/*
 *	Bug reports to 		wzhao@mcs.kent.edu
 *		Weimin Zhao
 *		Liquid Crystal Institute, Kent State University, Kent, OH 44242, USA
*/
/*
#define		N_COLORS	32
#define		POLAR		1
#define		CARTESIAN	0
*/

#define     DIE(msg)        {printf(msg); exit(1);}
#define     SQR(x)          ((x)*(x))

#include    <math.h>
#include    <stdio.h>
#include    <stdlib.h>
#include	<string.h>

#include    <X11/Xlib.h>
#include    <X11/Xutil.h>
#include    <X11/keysym.h>
#include    <X11/Xresource.h>
#include	<X11/Xcms.h>

typedef	struct {
	double	x;
	double	y;
	double	z;
}	Position3D	;

typedef	struct {
	int		type;
	int		x_min;
	int		x_max;
	int		y_min;
	int		y_max;
	int		x_div;
	int		y_div;
}	Frame	;

typedef	struct {
	int		from;
	int		now;
	int		to;
}	Steps	;

typedef struct {
	char	name[20];
	int		value;
}	IntParm;

/*
typedef struct {
	char	name[20];
	double	value;
}	DblParm;
*/

extern char			*progname;
extern Frame		frame;
extern Steps		steps;
extern Position3D	maxPnt;
extern Position3D	minPnt;
extern int			colorNow;
extern double		hueColor, chromColor, minColorV, maxColorV;
extern int			nColors;
extern double		hotV;
extern long			pxlBW[], pxlBG[];
extern double		pntrX, pntrY;
extern Window		infoWin;
extern int			popWidth, popHeight;
#ifdef HPUX
extern clock_t		timeU;
#else
extern time_t		timeU;
#endif

/*
extern long			pixels[];
extern Colormap		cmap;
extern XcmsColor	color;
extern int			bar_h, colorNow;
*/

/*
extern Window		pop_win;
extern int			start_x, start_y, sizeChunk, pop_width, pop_height;
extern char			pop_name, pop_str[], popVar[];
extern Bool			NeedsRefresh, popped, saveLastChunk;
extern Position3D	*copy;
extern Steps		refresh;
extern double		*xChunk, *yChunk, *zChunk;
*/

extern Display		*display;
extern Window		win;
extern int			screen_num;
extern unsigned		width, height; 
extern XFontStruct	*font;
extern GC			gc;

extern void			ScreenSetup();
extern void			PlaceFrame();
extern void			UpdateSteps(char);
extern void			DrawPoint(Position3D, int);
extern void			popInfoWin();
extern void			quadPlot(int, int, double *, double *);
extern void			dblPlot(int, int, double*, double*);
extern void			DrawString(char *, int, int, int, char);
extern void			initParm(FILE *);
extern void			processQuit(char*);
extern int			rndInt(double);
