/*
 *
SURF: an X application to fine-tune, monitor, and control numerical simulations.
 *		Version 1.02
 *
 *    Copyright (C) 1994 Weimin Zhao
 *
 * $Id$
 * 
*/
/*
    This program and the library built upon it are free software;
    you can redistribute it and/or modify it under the terms of the GNU
    General Public License (GPL) and Library General Public License (LGPL)
    as published by the Free Software Foundation; either version 2 of the
    License, or any later version.

    This program and the library are distributed in the hope that it will
    be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
    of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/*
 *	Bug reports to 		wzhao@mcs.kent.edu
 *		Weimin Zhao
 *		Liquid Crystal Institute, Kent State University, Kent, OH 44240
*/
/******************************************************************************
 *  This is the template for the user-supplied fortransub subroutine for
 *  simulation.  For the purpose of demostration, this subroutine is written
 *  in C, keeping in mind also the package was mainly developed on a i486/Linux
 *  where no native Fortran compiler exists yet :-(
 *
 *  Fortran passes arguments by reference, so here follows C.
 *
 *  Use SAVE in Fortran to save your intermediate data, like the "static"
 *  in C, as with the variable avg in the following subroutine.
 *
 *	The program would like less ugly if you set tab stops to be 4 ;-)  This
 *  can be done in vi with :set ts=4 
 *
*******************************************************************************/


#include	"surf.h"

void fortransub(int *ip, double *x, double *y, double *z,
	int *intP, double *dblP, double *hot, double *hotArray ) {
int				i, j;
double			amp;
static double	avg;

	avg = *hot;
	i = *ip*intP[5];
	amp = (intP[4] == 15 || intP[4] == 16) ? floor(1.*i/intP[2])*0.015+1. :
		*ip*.015+1.;
	for(j=0;j<intP[5]; j++) {
		if(intP[4] == 0) {
			x[j] = dblP[3]+floor((i+j)/intP[3])*(dblP[0]-dblP[3])
				/intP[2];
			y[j] = dblP[4]+(double)(((i+j)%intP[3])*(dblP[1]-dblP[4])/intP[3]);
			z[j] = (dblP[2]+dblP[5])*.5+.5*(dblP[2]-dblP[5])*cos(x[j]*2.0*M_PI);
			avg += z[j]/intP[5];
		}
		else if(intP[4] == 1) {
			x[j] = dblP[3]+(double)(((i+j)%intP[2])*(dblP[0]-dblP[3])/intP[2]);
			y[j] = dblP[4] + (floor((i*1.+j*1.)/intP[2])
				*(dblP[1]-dblP[4])/intP[3]);
			z[j] = (dblP[2]+dblP[5])*.5+.5*(dblP[2]-dblP[5])*cos(x[j]*2.0*M_PI)
				* cos(M_PI*y[j]/180.0);	
			avg += z[j]/intP[5];
		}
		else if(intP[4] ==10) {
			x[j] = dblP[3] + floor((i*1.+j*1.)/intP[3])
				*(dblP[0]-dblP[3])/intP[2];
			y[j] = dblP[4] + (double)(((i+j)%intP[3])
				*(dblP[1]-dblP[4])/intP[3]);
			z[j] = sqrt(fabs(1.0 - SQR(x[j]*2.0/(dblP[0]-dblP[3]))
				- SQR(y[j]*2.0/(dblP[1]-dblP[4]))));
			avg += z[j]/intP[5];
		}
		else if(intP[4] ==11) {
			x[j] = dblP[3] + (double)(((i+j)%intP[2])
				*(dblP[0]-dblP[3])/intP[2]);
			y[j] = dblP[4] + (floor((i*1.+j*1.)/intP[2])
				*(dblP[1]-dblP[4])/intP[3]);
			z[j] = sqrt(fabs(1.0 - SQR(x[j]*2.0/(dblP[0]-dblP[3]))
				- SQR(y[j]*2.0/(dblP[1]-dblP[4]))));
			avg += z[j]/intP[5];
		}
		else if(intP[4] == 15) {
			x[j] = dblP[3] + (double)(((i+j)%intP[2])
				*(dblP[0]-dblP[3])/intP[2]);
			y[j] = dblP[4] + .5*amp*(dblP[1]-dblP[4])/SQR(cosh(x[j]*amp));
			avg += y[j]/intP[5];
		}
	}
	if(intP[4] == 16) {
		for(j=0; j<intP[5]/2; j++) {
			x[2*j] = (dblP[0]+dblP[3])*.5 + 0.5*(double)(((i+2*j)%intP[2])
				*(dblP[0]-dblP[3])/intP[2]);
			x[2*j+1] = (dblP[0]+dblP[3])*.5 + 0.5*(double)(((i+2*j)%intP[2])
				*(dblP[3]-dblP[0])/intP[2]);
			y[2*j] = dblP[4] + .5*amp*(dblP[1]-dblP[4])/SQR(cosh(x[2*j]*amp));
			y[2*j+1] = dblP[4] + .5*amp*(dblP[1]-dblP[4])/SQR(cosh(x[2*j+1]*amp));
			avg += (y[2*j]+y[2*j-1])/intP[5];
		}
	}
	/*
	printf("%d: (%.2f, %.2f, %.2f)\n", i+j, x[j], y[j], z[j]);
	printf("%d: %d, %f\n", *ip, intP[5], z[intP[5]-1]);
	*/
	*hot = avg;
	for(j=0; j<intP[8]; j++) 
		hotArray[j] = dblP[2]*amp*exp(-SQR((j-0.5*intP[8])*6.0/intP[7])*amp);
	for(j=intP[8]; j<intP[7]; j++)
		hotArray[j] = dblP[2]*
			SQR(amp*tanh((j-0.5*(intP[7]+intP[8]))*8.0*amp/(intP[7]-intP[8])));
}
