/*
.nf
.SZ12
*/
#include "image.h"
#include "params.h"

extern Display *theDisplay;

#include "dots.h"
/***********************************************************/
#define delta 595
#define modX 1278
#define modY 1873
#define limit3	265519

void
plot( function, win, gc1, gc2, window_width, window_height )
	int (*function)();
	Window win;
	GC gc1, gc2;
	unsigned int window_width, window_height;

{
	XEvent    click;
	int  
		new_picture,
		value,
		chosen_x, chosen_y,
		percent_done,
		x, y, xy,
		max_iter = modX * modY, thresh,
		i_max = window_width,
		j_max = window_height,
		i_center = i_max / 2,
		j_center = j_max / 2,
		x_rel, y_rel, 
		w, wide;

	double	scaler;
	complex o, /* origin */ z;

	x_origin = i_center;
	y_origin = j_center;

	scaler = radius / window_width;

	o.real = o.imag = 0.0;

	while(1) {

		/* paint the whole window a solid color */
		XFillRectangle(theDisplay,
			win, gc1, 0, 0,
			window_width, window_height);

		xy = 0; 
		x = y = delta;
		thresh = 0;
		wide = WIDE;
		w = 2 * wide + 1;

		while( x + y > 0 ) {

#define	NEW 111

#ifdef NEW

			{ int xx, yy;

				xx = min( x, modX - x );
				yy = min( y, modY - y ); /* move me down one line */

				NOBUG
				if( ( xy > 152685 ) && ( xy < 152700 ) ) {
					printf( "Wide = %d at %d, |x|=%d, |y|=%d\n",
						wide, xy, xx, yy );
				}

				if( xx <= wide ) {
					if( yy <= wide ) {
						wide = max( xx, yy ) - 1;
						w = 2 * wide + 1;
						if( print_wide )
							printf( "Wide = %d at %d\n", wide, xy );
					}
				}

			}
#endif
			if( ( x < window_width ) && ( y < window_height ) ) {

#ifdef OLD
				/* adjust the size of the fat pixels */
				if( xy < 27201 ) { wide = 3;
					}
				else if( xy < 152692 ) { wide = 2;
					}
				else if( xy < 265519 ) { wide = 1;
					}
				else wide = 0;
				w = 2 * wide + 1;
#endif

				/* relative to the origin -- in the center */

				z.real = scaler * (x - x_origin);
				z.imag = scaler * (y - y_origin);
				ADD(o,z,z);

				NOBUG printf("plot:\tkr: %g\tki: %g\n",
				    z.real, z.imag );

				value = function( z );
				if( negate ) value = 1 - value;
				XFillRectangle(
				    theDisplay, win,
				    ( value % 2 ) ? gc1 : gc2,
				    x-wide, y-wide, w, w
				    );

			}
			x = ( x + delta ) % modX;
			y = ( y + delta ) % modY;
			xy++;

			if( (percent_done = (100 * xy / max_iter)) > thresh ) {
				static int times = 0;
				char title[100];

				if( XCheckWindowEvent(
					theDisplay, win, ButtonPress, &click ) ) {

					times++;

					chosen_x = click.xbutton.x; 
					chosen_y = click.xbutton.y;

					/* the z I clicked on is "o" */
					z.real = scaler * (chosen_x - x_origin);
					z.imag = scaler * (chosen_y - y_origin);
					ADD(z,o,o); 
					BF( o.real ); BF( o.imag ); BUG printf("\n");
					scaler *= scale_mod;

					new_picture = 1;
					break;
				} else {
					new_picture = 0;
				}

				/* plot the thermometer slider */
#				define THICK 3
				XFillRectangle( theDisplay, win, gc1,
				    0, 0, window_width * thresh / 100, THICK);

				XFillRectangle( theDisplay, win, gc2,
				    0, THICK, window_width * thresh / 100, THICK);

#ifdef TITLE
				XSetStandardProperties( theDisplay, win,
				    title, "basicwin", icon_pixmap, "", 0, &size_hints);
#else
				printf( "%s - scaled %d\tat (%7.5f,%7.5f)\t%d%%\n",
					window_name, times, o.real, o.imag, percent_done);

#endif
				thresh++;
			}

		}
		if( await && (! new_picture) ) { char dummy; 
			printf( "Press enter to continue.\n" );
			scanf( "%c", &dummy );
		}
		new_picture = 0;
	}
}
/*****************************************************************/
