
/************************************************************************/
/* Video Digitiser Program for the VIDEO-1000 VGA card.			*/
/* Copyright Nov 1994 by Jan Laitenberger. Read the doc and the faq ...	*/
/* If you like it, feel free to tell me:  bug fixes, comments, etc.     */
/* to: laitenjn@minnie.informatik.uni-stuttgart.de			*/
/************************************************************************/

#include <stdlib.h>

#include <signal.h>
#include <unistd.h>

#include <X11/X.h>
#include <X11/Xlib.h>
#include <xview/xview.h>
#include <xview/frame.h>
#include <xview/panel.h>
#include <xview/defaults.h>
#include <xview/canvas.h>
#include <xview/font.h>
#include <xview/xv_xrect.h>
#include <xview/win_input.h>
#include <xview/textsw.h>
#include <xview/notice.h>
#include <xview/win_event.h>
#include <xview/scrollbar.h>
#include <xview/cms.h>


/************************************************************************/
/* direct port access							*/
/************************************************************************/

inline static void
port_out(char value, unsigned short port)
{
  __asm__ volatile ("outb %0,%1"
		    ::"a" ((char) value), "d"((unsigned short) port));
}

inline static char
port_in(unsigned short port)
{
  char _v;
  __asm__ volatile ("inb %1,%0"
		    :"=a" ((char) _v):"d"((unsigned short) port));
  return _v;
}


/************************************************************************/
/* Variable & procedures for communication with the video-digitiser	*/
/************************************************************************/

static unsigned short Clock = 0x318, Flop = 0x31a, rv = 0x31c, Inn = 0x31e;
static unsigned char PicBuffer[64001] = {
206,204,206,205,206,206,205,206,205,207,205,205,206,205,207,205,206,206,206,207,205,207,206,207,207,206,208,206,209,206,208,208,207,208,206,208,206,208,208,207,209,207,209,207,208,208,207,208,206,208,207,207,208,206,209,206,208,208,207,208,207,209,206,208,208,207,209,206,209,207,208,208,208,208,207,208,207,208,208,208,209,207,208,208,208,209,208,210,208,208,209,208,210,208,209,208,208,209,208,210,208,209,209,209,209,208,210,209,209,209,209,210,208,210,209,209,209,209,210,209,210,209,209,210,209,211,209,210,210,210,210,209,211,209,210,210,210,211,209,211,209,210,210,210,211,209,211,210,210,211,210,212,210,212,210,211,211,210,212,210,212,211,211,211,210,213,211,212,212,211,213,211,213,211,212,213,212,213,212,213,212,213,213,211,214,212,213,213,213,213,212,214,212,213,213,213,214,212,214,212,213,213,212,214,212,214,213,213,213,212,214,213,214,213,213,214,213,215,213,214,214,213,214,213,215,213,214,214,213,215,214,215,214,214,215,214,215,213,215,214,214,215,214,216,214,216,215,215,216,214,217,215,216,216,216,217,215,217,215,217,217,216,217,216,217,216,217,217,216,218,216,217,216,217,217,216,218,216,217,217,217,217,216,218,216,217,217,216,218,216,218,217,217,217,216,218,216,218,217,217,218,216,218,217,218,217,217,218,217,219,217,218,218,218,219,217,219,218,219,219,206,208,206,208,207,207,207,206,208,207,208,207,206,208,206,208,206,207,207,206,208,207,208,206,206,207,206,209,207,208,207,207,208,207,210,207,208,208,208,209,207,209,207,208,208,208,209,207,208,207,208,208,208,209,207,208,208,208,209,208,210,208,208,209,208,209,208,210,208,208,209,208,210,208,209,209,208,210,208,210,209,209,209,209,210,208,210,208,209,209,208,210,208,210,209,209,209,208,210,207,210,208,209,210,209,211,208,210,210,209,210,209,211,209,210,210,210,211,209,211,210,210,211,210,211,209,212,210,211,211,210,212,211,213,211,211,213,211,213,211,212,212,212,213,211,213,211,212,212,212,213,211,213,212,212,213,212,213,212,213,212,212,213,211,213,211,213,212,212,213,211,213,211,213,212,212,213,212,213,212,212,213,212,214,212,213,213,213,213,212,214,213,213,213,213,214,212,215,213,214,214,214,215,213,215,213,214,215,214,215,214,215,214,215,216,214,216,214,216,215,215,216,214,217,215,216,215,215,216,215,217,215,216,216,215,217,215,217,215,216,216,216,216,215,216,216,216,216,215,217,215,217,216,216,217,216,217,216,216,216,216,218,215,217,216,217,217,216,218,216,217,217,216,217,217,218,216,218,218,217,219,217,219,218,218,218,218,219,217,219,218,218,219,218,219,218,219,218,218,219,218,220,218,219,219,218,219,218,219,218,219,219,218,220,218,219,218,218,219,218,205,206,205,207,205,207,206,206,206,205,207,206,207,206,206,207,206,207,206,207,207,206,207,206,208,206,208,207,207,208,206,209,206,207,207,206,208,207,209,206,207,208,206,209,206,208,207,207,208,206,209,206,207,207,207,209,207,209,206,207,207,207,209,207,209,206,207,208,207,209,206,208,208,208,208,207,209,207,209,208,208,209,208,209,208,209,209,208,210,208,209,208,209,209,208,210,208,209,209,209,209,208,210,208,209,209,208,210,208,210,208,209,209,209,211,208,210,210,210,210,209,211,209,210,210,210,210,209,211,209,210,210,210,211,209,211,209,210,210,210,210,209,211,209,210,210,209,211,210,211,210,210,211,210,212,210,211,210,211,212,210,212,210,211,211,211,212,210,213,211,211,212,211,213,211,213,211,213,213,212,213,212,213,213,213,213,212,214,213,213,213,213,214,213,214,212,213,213,213,214,212,214,213,213,213,212,214,212,214,212,213,214,213,214,213,214,213,213,214,213,215,213,214,214,214,215,213,215,214,214,214,214,215,213,215,214,214,215,214,216,214,216,214,214,215,214,216,215,216,215,215,216,215,217,215,216,216,216,217,215,217,215,216,216,216,217,216,217,216,216,217,216,217,215,217,216,216,217,215,217,215,217,216,216,218,216,218,216,216,217,216,218,216,217,216,217,217,216,218,217,218,217,217,218,216,219,217,218,218,217,219,217,219,218,218,219,218,219,217,219,206,206,209,206,208,206,207,207,207,208,206,209,206,207,208,206,209,206,207,206,206,208,206,209,205,207,207,207,209,207,208,206,208,207,207,208,206,209,207,208,208,207,209,207,209,208,208,209,208,209,208,209,209,208,210,208,210,208,209,209,208,210,208,210,209,209,209,208,210,208,210,209,209,210,208,210,208,210,210,209,210,208,210,208,210,209,208,210,208,210,209,209,209,208,210,208,210,209,209,210,209,211,208,210,209,209,210,208,211,209,210,209,209,211,209,211,210,210,210,210,211,209,211,210,210,211,210,212,210,212,211,211,212,210,213,210,212,211,211,213,211,213,211,212,212,212,213,211,213,212,212,212,211,213,212,213,212,212,213,211,213,211,212,212,212,212,211,213,211,212,212,212,213,211,213,211,212,213,212,213,212,213,212,213,214,212,214,212,214,213,213,214,212,215,213,214,214,214,215,213,215,214,214,214,213,215,214,215,214,214,215,214,216,214,216,215,215,216,215,217,214,216,216,215,216,215,217,215,216,216,216,217,215,216,215,216,216,215,217,215,217,215,215,216,215,217,215,216,216,216,217,215,217,215,216,216,216,217,215,217,216,216,217,216,218,216,217,217,217,218,216,218,216,218,217,217,219,217,219,217,218,218,218,219,217,219,218,218,219,218,219,218,219,218,219,219,218,219,218,219,219,219,219,218,220,218,219,219,218,220,219,220,219,219,219,219,220,218,220,219,204,206,205,206,206,206,207,206,208,207,207,207,206,208,207,208,206,207,207,206,208,206,207,206,206,208,207,209,206,208,208,207,209,207,209,207,208,208,208,209,206,208,207,207,207,206,208,206,208,206,206,208,206,209,206,207,207,206,209,207,209,206,208,208,208,209,206,208,207,207,208,207,210,206,208,208,208,208,207,209,207,208,208,208,209,208,209,208,208,209,208,210,208,209,208,209,210,208,210,208,210,209,209,210,208,211,209,210,210,209,211,209,210,209,210,210,209,211,209,210,209,210,210,209,210,209,210,209,209,210,209,211,209,210,210,210,211,209,211,210,210,210,210,211,209,211,210,210,211,210,212,210,212,211,211,211,211,213,211,212,212,212,212,211,213,211,212,212,212,213,212,213,212,212,213,211,213,211,213,212,212,213,212,214,212,213,213,213,213,212,214,212,213,213,213,214,212,214,212,213,213,212,214,212,214,213,213,213,212,214,213,214,213,213,214,213,215,213,214,214,214,215,213,215,213,214,214,213,215,213,214,214,214,214,214,216,214,216,214,215,215,214,216,215,216,215,215,216,215,217,215,216,215,215,217,215,217,215,216,216,216,217,216,217,216,216,217,215,217,216,217,216,216,217,216,217,215,217,216,216,217,215,217,216,217,217,216,218,216,218,216,217,217,216,218,216,218,217,217,218,216,218,216,218,218,217,218,217,219,217,218,218,218,219,217,219,218,218,219,218,206,208,206,208,206,207,207,206,208,206,208,206,207,207,206,208,206,208,206,206,208,206,209,206,208,208,207,208,206,209,206,208,208,207,208,206,208,207,208,208,208,209,207,209,208,208,209,207,210,207,209,208,208,209,207,209,207,209,209,209,210,208,210,208,209,210,208,210,208,210,209,209,210,208,210,209,209,209,209,210,208,210,208,209,209,208,210,208,209,208,209,209,208,210,208,209,208,209,209,208,210,208,209,209,209,210,208,211,209,210,210,210,211,209,211,210,210,211,210,211,210,211,210,211,211,210,212,210,212,211,211,212,211,213,211,212,212,212,212,211,213,211,212,212,211,213,211,213,211,212,213,212,213,211,213,212,212,213,211,213,211,213,212,212,213,211,213,211,212,212,212,213,211,213,211,212,212,212,213,211,214,212,213,213,212,214,213,214,213,213,214,212,215,213,214,213,213,215,213,215,214,214,215,214,215,213,215,214,214,215,214,216,214,216,214,215,216,214,217,215,216,215,215,216,214,217,214,216,216,215,216,214,217,214,216,216,215,217,215,216,215,216,216,215,217,215,217,216,216,217,215,217,215,217,217,217,218,216,218,216,217,217,216,218,216,218,217,217,218,217,219,217,218,218,218,218,217,219,217,218,218,218,219,217,219,218,218,219,218,220,218,219,218,218,219,218,220,218,219,218,218,219,218,220,218,219,219,218,219,218,219,218,219,219,218,220,218,220,218,219,207,205,206,206,205,207,205,207,206,206,207,206,207,206,207,207,207,207,206,208,206,208,207,207,208,206,209,206,208,207,207,209,206,209,207,207,207,207,209,207,209,207,207,208,206,209,206,208,207,207,208,206,209,206,208,208,207,209,207,209,207,208,208,208,209,207,208,208,208,208,207,209,207,209,208,208,209,207,209,207,209,208,209,209,208,210,208,209,209,208,210,208,210,209,209,210,208,210,209,210,209,209,210,209,211,209,210,210,210,211,209,211,209,210,210,209,210,209,211,209,210,210,209,210,209,210,209,209,210,209,211,209,210,210,210,210,209,211,210,210,210,210,211,209,211,210,210,211,210,212,210,212,210,211,212,210,213,210,212,212,211,212,211,213,211,212,212,212,213,211,213,212,212,213,212,213,211,213,212,212,213,212,213,212,213,213,212,213,212,213,212,213,213,212,213,212,213,212,213,213,212,214,212,214,213,213,213,212,214,212,214,213,212,214,212,214,213,214,214,214,214,213,215,214,214,214,214,215,214,216,214,215,215,214,216,214,216,214,215,215,214,216,215,216,215,215,216,214,218,215,216,215,216,216,215,217,215,216,216,216,217,215,217,215,215,216,215,218,215,216,216,216,217,215,217,215,217,216,216,217,215,217,216,216,216,216,218,216,217,216,217,217,216,218,216,217,217,217,217,216,218,217,218,218,217,219,217,219,218,218,218,218,219,218,219,218,219,219,218,220,208,206,209,206,207,207,206,208,206,208,206,206,207,206,208,206,208,206,207,207,206,209,207,208,207,207,208,207,210,207,208,208,208,209,207,208,207,208,208,208,209,207,209,208,208,209,208,210,208,209,209,208,210,208,210,208,209,209,209,210,208,210,209,209,209,208,211,208,210,209,209,210,208,210,208,209,209,208,210,208,210,208,209,209,209,210,208,210,209,209,210,208,210,208,210,209,209,210,208,210,209,210,209,209,211,209,211,209,210,210,210,211,209,211,210,210,211,210,212,210,212,210,211,211,210,212,211,212,211,211,212,210,213,210,212,212,211,212,211,213,211,212,212,212,213,211,213,211,212,212,212,213,211,213,212,212,213,211,213,211,213,212,212,213,211,213,211,213,213,212,213,212,213,212,213,213,212,214,212,214,213,213,213,212,214,213,214,213,213,214,213,215,213,214,214,214,215,213,215,214,214,214,214,216,214,216,214,215,215,214,217,214,216,215,215,216,214,217,214,216,215,215,216,214,217,214,215,215,215,217,214,216,214,215,215,215,216,214,217,215,215,216,215,217,214,216,216,216,217,215,217,215,217,216,216,218,216,218,216,217,217,216,218,216,218,217,217,218,216,219,216,218,218,218,218,217,219,218,219,218,218,219,218,219,218,219,219,218,220,218,220,218,219,219,218,220,218,219,219,218,219,218,220,218,219,219,218,219,218,220,218,219,219,218,220,218,220,218,219,219,205,206,207,206,207,205,207,206,207,207,206,208,206,208,207,207,208,206,209,206,208,207,207,208,206,209,206,207,207,206,209,207,208,206,207,207,207,209,207,209,207,207,208,207,210,206,208,207,208,208,207,208,206,208,207,207,208,206,209,207,208,207,207,209,207,209,208,208,208,207,209,207,208,208,208,209,207,209,207,209,208,208,210,208,209,208,209,209,208,210,208,210,209,209,210,208,211,209,210,209,209,210,208,211,209,210,209,209,210,208,210,208,209,209,209,210,209,210,209,209,210,209,211,209,210,210,210,211,209,211,209,210,210,210,211,209,211,210,210,210,210,211,209,211,210,210,211,210,212,210,211,211,211,212,211,213,211,212,212,212,213,211,213,211,212,212,211,213,211,213,211,212,212,211,213,211,213,212,212,213,212,214,212,213,213,212,213,212,214,212,212,212,212,213,212,213,212,213,213,212,213,212,213,212,213,213,212,214,212,214,213,213,214,213,214,213,214,214,213,214,213,215,213,214,214,214,215,213,215,214,215,215,214,216,214,216,215,215,215,214,217,215,216,215,215,216,215,217,215,216,216,216,217,215,217,215,216,216,216,217,215,217,216,216,217,215,217,215,217,216,216,217,215,217,215,217,216,216,218,215,217,216,217,217,216,218,216,217,216,217,217,216,218,216,218,217,217,218,216,218,217,218,218,217,219,217,219,218,218,219,218,219,218,219,218,219,219,218,219,218,207,206,206,208,206,209,206,207,207,207,209,207,209,206,207,208,207,210,207,208,207,208,208,207,208,207,208,208,208,209,207,209,207,208,208,208,209,207,209,208,208,209,208,210,208,209,209,208,209,208,210,208,209,209,208,210,208,210,208,209,209,208,210,208,210,209,208,209,208,209,208,209,208,208,209,208,210,208,209,209,208,210,208,210,208,209,209,208,210,208,210,209,209,210,208,211,209,210,209,209,210,209,210,209,210,210,209,211,209,211,210,211,211,210,212,210,212,211,211,212,210,213,210,212,211,211,212,211,213,211,212,212,212,213,211,213,211,212,212,212,213,211,213,211,212,212,211,213,211,213,211,212,212,211,213,211,212,212,212,212,211,213,211,212,212,212,213,211,213,212,213,213,212,213,212,213,212,212,213,211,213,212,213,213,213,214,213,215,213,214,214,213,215,213,215,214,214,214,213,215,214,215,214,214,215,214,216,214,215,215,215,215,214,216,215,216,215,215,216,214,217,214,216,215,215,216,214,216,215,215,215,215,216,215,217,215,215,216,215,218,215,216,215,216,217,215,217,215,217,216,216,217,215,218,216,217,217,216,218,216,218,217,217,218,217,219,217,218,218,218,218,217,219,218,218,218,218,219,217,219,218,218,219,218,219,217,219,218,218,219,217,219,218,219,218,218,219,218,219,218,219,219,218,219,217,219,218,219,219,218,219,218,219,218,218,219,218,219,218,219,207,205,208,207,207,207,205,208,206,208,206,206,207,206,208,207,208,206,207,208,206,209,206,207,207,207,209,207,209,206,207,208,207,209,206,208,207,207,207,206,208,206,208,206,207,208,206,209,206,208,207,207,208,206,209,207,208,208,207,209,207,208,207,207,208,207,210,207,208,208,208,209,207,209,208,209,209,208,210,208,210,208,209,210,208,210,208,210,209,209,210,208,210,209,210,210,210,210,209,211,209,210,210,209,210,209,210,209,210,210,209,210,209,210,209,209,210,208,210,209,210,209,209,210,209,211,209,210,210,209,211,209,211,209,210,210,210,211,209,211,210,210,211,210,211,210,211,210,210,212,210,212,210,212,211,211,212,210,213,211,212,212,212,213,211,213,211,213,213,212,213,212,213,212,212,213,211,214,211,213,212,212,213,211,213,211,213,212,212,213,211,213,211,213,213,212,213,212,213,212,213,213,212,214,212,214,213,213,214,212,214,213,214,214,213,215,213,215,214,214,214,214,215,214,215,214,214,215,214,216,214,216,215,215,215,214,217,215,217,215,215,217,215,217,215,216,216,216,217,215,217,215,216,216,216,217,214,217,215,216,216,215,217,215,217,215,216,217,215,217,215,217,216,216,217,215,217,215,216,216,216,217,215,217,216,217,217,216,218,216,217,217,217,218,217,219,217,218,218,218,219,217,219,218,218,219,218,219,218,219,218,219,219,218,220,218,220,219,219,219,206,207,206,206,207,206,207,205,207,206,207,207,206,208,206,208,207,207,208,206,209,207,208,207,207,209,207,210,207,208,208,208,209,207,209,208,208,209,207,210,207,209,208,209,209,208,210,208,209,209,208,209,208,209,208,209,209,208,210,208,210,209,209,209,208,210,208,209,209,208,209,208,210,208,209,209,208,210,208,209,208,209,209,208,210,208,210,209,209,210,208,210,208,210,209,209,210,209,211,209,210,210,210,211,209,211,210,210,210,210,211,210,212,210,211,211,210,212,210,212,210,211,212,210,213,210,212,211,211,212,211,213,211,212,212,211,212,211,213,211,212,212,212,213,210,213,211,212,212,211,213,211,212,211,211,212,211,213,211,212,212,212,213,211,213,211,212,212,212,213,211,213,212,213,213,212,214,212,214,213,213,214,213,215,213,214,214,214,214,213,215,213,214,214,214,216,214,216,214,215,215,214,216,214,216,214,214,215,214,216,214,216,215,215,216,214,217,214,215,215,214,216,214,216,214,215,215,215,216,214,216,214,215,215,214,216,215,216,214,215,216,214,217,215,216,215,216,217,215,217,216,217,217,216,217,216,217,216,217,217,216,218,216,218,217,217,218,216,218,217,218,218,218,218,217,219,218,218,218,218,219,217,219,218,219,219,218,220,218,219,218,218,219,218,219,217,219,218,218,219,217,219,218,219,218,218,220,218,219,218,219,219,218,220,218,220,219,219,220,218,206,206,206,208,205,208,206,207,207,206,208,207,208,207,207,208,207,210,207,208,207,207,208,207,209,207,207,207,207,209,206,208,206,207,207,206,208,206,208,206,206,208,206,209,206,207,207,206,208,207,209,206,207,208,207,209,206,208,207,208,208,208,209,207,208,208,208,208,207,209,207,209,208,208,209,207,209,208,209,209,208,210,208,210,208,209,210,208,210,208,209,209,209,209,208,210,208,209,209,209,210,208,210,208,209,209,209,210,208,210,209,209,210,208,210,208,210,209,209,210,208,210,209,210,210,209,210,209,211,209,210,210,210,211,209,211,210,211,211,210,212,210,212,210,210,211,210,212,210,212,210,211,212,210,213,211,212,212,212,212,211,213,211,212,212,212,213,211,213,212,212,213,212,213,212,213,212,212,212,211,213,211,212,212,212,213,211,213,211,213,213,213,213,212,214,212,212,213,212,213,212,213,212,212,213,212,214,212,214,213,213,214,213,215,213,214,214,214,215,213,215,214,214,215,214,215,213,215,214,214,214,214,216,214,216,214,215,216,214,217,214,216,215,215,216,215,217,215,216,216,216,217,215,217,215,216,216,216,217,215,217,215,216,216,216,217,215,216,216,216,217,215,217,216,216,216,216,217,215,217,215,217,217,217,217,216,218,217,217,218,216,218,217,218,217,217,218,217,219,217,218,218,218,219,217,219,218,218,219,218,219,218,219,218,218,219,217,219,218,219,208,206,207,207,206,208,206,208,206,207,207,207,209,207,209,207,207,208,207,210,206,208,208,208,209,207,209,207,208,208,208,209,207,208,207,208,208,208,209,207,209,208,208,209,208,210,208,209,209,208,209,208,209,208,208,208,208,209,208,209,207,208,208,208,209,207,209,208,208,209,207,209,208,209,208,208,210,208,210,208,209,209,208,210,208,210,208,209,209,208,210,208,210,209,209,210,209,211,209,210,210,210,211,210,211,210,210,210,210,211,210,212,210,211,211,210,212,210,212,210,211,212,211,213,210,212,211,211,212,210,213,211,212,212,211,212,211,213,211,212,212,211,212,209,210,208,209,210,209,211,209,211,210,211,212,210,213,211,212,212,212,213,211,213,211,212,212,211,213,211,213,212,212,213,212,214,212,213,213,213,213,212,214,212,214,213,213,215,213,215,213,214,214,214,215,213,215,214,214,214,214,215,213,216,214,215,215,214,216,214,216,214,214,216,214,216,214,215,214,214,216,214,216,214,215,215,215,216,214,217,214,215,216,215,217,214,216,215,216,216,215,217,215,216,216,216,217,215,217,215,217,217,216,217,216,218,216,217,217,216,218,216,218,217,217,218,217,219,217,218,218,217,218,217,218,217,218,218,217,219,217,219,217,218,218,218,219,217,219,218,218,218,217,219,217,218,218,218,218,217,219,217,218,218,218,219,218,219,218,219,219,218,220,218,220,219,219,219,218,220,206,206,208,205,208,206,207,207,206,208,207,208,206,207,207,206,208,207,208,207,207,207,206,208,207,207,206,205,208,206,208,205,206,207,206,208,206,208,206,206,207,206,208,206,207,206,206,208,206,208,205,207,207,206,208,207,208,206,207,208,207,210,207,208,207,208,209,208,209,207,209,208,208,209,208,210,208,209,209,208,210,208,210,208,209,209,208,210,208,210,209,209,210,208,211,209,210,209,209,210,208,210,209,209,209,208,210,208,210,208,209,209,208,210,208,210,209,209,210,208,210,208,210,209,209,210,208,210,209,210,210,209,211,209,211,210,210,210,210,211,209,211,209,209,208,206,208,207,210,209,209,211,209,211,210,211,211,211,212,211,213,211,212,212,212,213,211,213,211,212,213,212,212,211,213,212,212,212,211,213,211,213,212,212,213,211,213,211,213,213,212,214,212,213,212,213,213,212,214,212,214,213,213,214,213,215,213,214,213,213,214,213,215,213,214,214,214,215,214,215,214,214,215,214,216,214,216,214,215,215,214,216,214,216,214,214,215,214,216,214,216,215,215,216,214,217,215,216,215,215,216,214,217,215,215,215,214,217,215,216,215,215,216,215,217,215,216,216,216,217,215,217,215,216,216,216,217,215,217,216,216,217,216,218,216,217,217,217,218,216,218,217,218,218,217,218,217,219,217,218,218,218,219,218,219,218,219,219,218,219,218,219,219,219,219,218,220,218,219,219,206,207,206,207,206,207,207,206,208,206,208,206,207,207,206,209,207,208,207,207,208,207,210,207,208,208,208,209,207,209,207,209,208,208,209,207,209,208,208,209,208,209,207,208,208,208,209,208,210,207,209,209,209,210,208,210,208,209,209,208,209,208,209,208,208,209,208,210,207,209,208,208,209,208,210,208,209,209,208,210,208,210,208,209,209,208,210,208,210,209,209,210,209,210,209,210,210,210,211,209,211,210,211,210,210,211,209,211,210,211,211,210,211,209,212,210,210,211,210,212,210,212,210,211,211,210,212,211,212,211,211,212,210,213,211,211,211,210,213,211,212,210,211,210,208,208,206,208,208,210,210,209,211,210,211,211,211,212,211,213,211,212,212,212,213,211,213,211,213,213,212,213,212,214,212,213,213,212,214,212,214,213,213,214,213,215,213,214,214,214,215,213,215,214,215,214,214,216,213,215,213,214,215,214,215,213,215,214,214,215,214,215,213,215,214,214,215,213,215,214,215,215,214,216,214,216,214,215,215,214,216,215,216,215,215,215,215,217,215,216,215,215,216,215,218,215,217,216,216,218,216,218,215,217,217,217,218,216,218,217,217,218,217,219,217,218,217,218,218,217,219,217,219,218,218,219,217,219,218,218,218,218,219,217,219,218,218,218,217,219,217,219,218,218,219,217,219,217,219,218,218,219,217,219,218,218,218,218,219,217,219,218,219,219,218,220,218,219,218,219,207,206,207,207,206,208,206,208,206,207,207,206,208,206,208,206,206,207,206,208,207,207,207,206,208,207,208,206,206,207,206,208,206,208,205,206,207,206,208,206,208,206,206,207,206,208,206,208,206,206,208,206,209,206,207,207,206,209,207,208,207,207,208,207,210,207,208,207,208,209,208,209,208,209,208,208,209,207,209,208,209,209,208,209,208,209,208,209,209,208,210,208,209,209,208,209,208,210,208,209,209,208,210,208,210,209,209,209,208,210,208,210,209,209,210,208,210,209,210,209,209,210,209,211,209,210,210,210,211,209,211,209,210,211,210,211,210,211,210,210,211,210,211,208,208,205,205,208,208,211,209,211,211,211,212,211,213,211,212,212,211,212,210,212,210,211,211,210,212,211,212,211,211,212,210,213,210,212,211,211,213,211,213,211,212,212,212,212,212,213,212,213,213,212,214,212,213,213,213,213,212,214,212,214,213,213,214,212,214,213,213,213,213,214,213,215,213,214,214,214,215,213,215,214,214,215,214,216,214,216,214,214,215,214,216,214,216,214,215,216,214,216,214,215,215,214,216,215,217,214,215,216,215,217,215,216,215,216,216,215,217,215,217,216,216,217,215,217,215,216,216,216,217,216,217,216,216,217,216,218,216,217,217,217,217,216,218,216,218,217,217,218,217,218,217,218,218,217,219,217,219,217,218,218,218,219,217,219,218,218,219,218,219,217,219,218,218,219,218,219,208,206,208,206,206,207,206,208,206,208,206,207,207,206,209,207,209,207,207,209,207,210,207,208,208,208,210,208,209,208,208,209,208,209,207,208,208,208,208,207,209,207,208,208,208,209,207,209,207,209,208,208,210,207,209,207,208,208,208,208,207,208,207,208,208,208,210,208,209,209,208,209,209,210,208,209,209,208,210,208,210,208,209,209,208,210,208,210,209,210,210,209,211,210,211,210,210,211,209,211,209,210,210,210,211,209,211,210,211,211,210,212,210,212,210,211,211,210,212,210,211,210,210,212,210,213,210,212,211,211,212,210,213,210,211,211,210,212,210,212,210,210,209,206,207,205,207,207,209,210,210,210,209,211,211,211,212,210,213,211,212,212,211,213,211,212,211,212,212,211,213,211,213,211,211,212,211,214,211,213,212,213,214,212,214,213,214,214,214,215,213,215,214,215,215,214,215,214,216,214,214,214,213,215,214,215,214,214,215,213,215,213,214,214,214,215,213,216,214,215,214,214,216,214,216,214,215,215,215,217,215,217,215,216,216,215,217,215,216,216,216,217,215,217,215,217,216,216,218,216,217,216,217,217,216,218,216,218,217,217,217,216,218,216,218,217,217,219,217,219,218,219,219,218,219,217,219,217,218,218,217,219,217,219,217,218,218,217,219,217,218,218,218,218,217,219,217,219,218,218,219,217,219,218,218,219,218,219,218,219,218,219,219,218,219,218,219,219,219,219,206,206,207,205,208,206,208,206,207,207,206,208,207,208,206,206,207,206,208,207,207,206,206,208,206,208,206,206,206,206,208,206,207,205,205,207,206,207,205,206,207,206,208,206,208,205,207,207,206,208,206,208,206,207,207,207,209,207,208,207,208,208,208,209,207,208,208,208,209,208,209,208,208,208,208,210,208,210,208,209,209,208,210,208,209,208,208,210,208,210,208,209,208,208,209,208,209,208,209,209,208,209,208,209,208,209,209,208,210,208,209,208,209,209,208,210,208,209,209,208,209,208,210,208,210,209,209,210,208,210,209,210,210,209,211,210,211,210,210,211,210,210,208,209,208,208,209,208,210,209,210,210,209,211,210,211,210,210,209,209,211,209,211,210,210,211,209,210,208,210,209,209,209,204,204,203,205,208,209,211,209,212,211,212,212,212,213,212,214,212,213,213,213,214,212,214,213,213,214,212,215,213,214,213,213,215,213,214,213,214,214,214,215,213,215,214,214,215,214,215,214,215,214,214,215,214,216,214,216,214,215,215,214,216,215,216,215,215,216,214,217,214,215,215,214,216,215,216,214,215,215,214,217,214,216,215,215,216,215,217,214,216,216,216,216,215,217,215,216,216,216,217,215,217,215,216,217,216,217,215,217,216,217,218,216,218,216,218,217,217,218,216,219,217,218,218,218,219,217,219,218,218,218,218,219,217,219,218,218,219,218,219,218,219,218,218,219,217,219,218,206,207,206,207,206,207,207,207,208,206,209,206,208,208,208,209,207,208,207,208,208,208,209,207,209,207,208,208,208,209,207,208,207,208,208,208,209,207,208,208,208,209,207,209,207,209,208,208,209,207,209,207,208,208,208,209,207,209,207,208,208,208,209,207,209,208,208,209,207,210,208,209,208,208,210,208,209,208,209,209,208,210,208,209,209,209,209,208,210,209,210,209,209,211,209,211,210,210,210,210,211,209,211,210,211,210,210,211,209,211,210,210,211,210,211,209,211,210,210,211,210,211,209,211,210,210,211,209,211,210,211,210,210,211,209,211,210,210,211,210,211,208,210,208,208,210,208,210,208,209,208,207,207,205,207,206,207,207,206,208,208,211,209,210,210,209,208,205,205,203,204,206,204,203,202,205,205,207,209,208,212,210,212,213,213,214,213,215,214,215,215,214,216,214,216,214,214,215,214,215,214,215,214,214,215,213,215,213,215,214,214,215,213,215,213,215,214,214,215,213,215,214,214,215,214,215,213,215,214,214,216,214,216,214,216,215,215,216,215,217,215,217,216,216,217,216,217,216,216,216,216,217,216,217,216,217,217,216,218,217,218,217,217,218,217,219,217,218,218,218,219,217,219,217,218,218,217,218,217,218,217,217,218,217,219,216,218,217,217,218,216,219,217,218,218,218,218,217,219,218,218,218,218,219,218,219,218,218,219,218,220,218,219,219,218,219,219,220,218,220,207,205,207,207,207,207,206,208,206,208,206,206,207,206,208,206,208,206,206,207,206,208,206,207,206,205,208,206,208,205,206,207,206,208,206,207,206,205,207,206,208,206,207,206,206,208,206,208,205,207,207,206,208,207,208,206,207,207,207,209,207,208,207,207,208,207,210,207,208,208,208,209,208,209,208,208,209,208,210,208,209,208,208,209,208,209,208,209,208,208,209,208,209,207,209,208,208,209,207,209,208,209,209,208,209,208,209,208,208,209,208,210,208,209,209,209,209,208,209,208,209,209,208,209,208,210,208,209,209,209,210,209,211,210,210,210,209,211,209,211,210,210,210,208,210,208,209,209,208,208,203,201,197,197,197,199,202,200,204,204,206,208,208,210,206,203,197,196,194,192,195,194,194,194,198,204,206,208,206,209,209,210,211,210,213,212,213,213,212,214,212,214,213,213,214,212,214,212,214,213,213,214,212,214,213,214,213,213,214,213,215,213,214,214,214,215,213,215,214,214,215,214,216,214,216,214,215,215,214,215,214,215,214,214,216,214,216,214,215,214,214,216,214,216,214,215,215,214,216,214,216,214,214,215,214,216,214,216,215,215,216,215,217,215,216,215,215,216,214,217,215,216,216,216,217,215,217,216,217,217,216,217,216,217,216,217,217,216,218,217,218,217,217,218,217,219,217,218,218,217,219,217,219,218,218,218,217,219,217,219,218,218,218,217,219,217,218,218,218,219,206,207,206,207,207,206,208,206,208,207,207,207,206,209,207,209,207,207,209,207,210,207,208,208,208,209,207,209,207,208,208,208,209,207,208,207,207,208,207,209,206,208,207,207,208,207,209,206,208,208,207,208,206,209,206,208,208,207,208,206,208,207,207,208,207,209,207,208,207,208,209,208,209,208,209,209,208,209,208,210,209,209,210,208,210,208,210,209,209,210,208,211,209,210,210,210,210,209,211,210,210,211,210,211,210,211,210,211,211,210,211,210,211,210,210,210,209,211,209,210,210,210,210,208,210,209,210,209,209,211,209,210,209,210,210,209,209,207,208,207,208,207,207,208,206,208,204,204,204,202,201,197,196,194,195,198,198,202,201,203,204,205,209,208,208,200,197,195,192,193,193,193,192,192,197,202,209,209,210,210,211,213,212,214,213,215,215,214,216,214,216,214,215,215,214,216,214,216,214,215,215,214,215,214,215,214,214,215,214,215,214,215,215,214,215,214,215,214,215,215,214,215,214,216,214,215,215,214,216,215,217,215,215,216,215,218,215,217,216,216,217,215,217,215,217,216,216,217,215,217,215,217,217,216,218,216,217,217,217,218,217,218,216,218,217,217,218,216,218,216,217,217,216,218,216,218,217,217,217,217,218,217,218,217,217,218,217,219,217,218,217,217,218,217,219,217,218,218,217,218,217,219,217,218,218,218,219,217,219,218,219,219,218,220,219,220,219,219,220,219,206,207,205,207,205,207,206,206,207,205,207,206,207,207,206,207,206,207,205,206,206,205,207,206,206,206,206,206,205,207,205,206,206,206,206,205,207,205,206,206,206,207,205,207,206,207,207,206,208,206,208,206,207,207,206,208,206,208,206,206,207,206,208,207,208,207,207,208,207,210,207,209,208,208,210,208,209,207,208,209,208,209,208,209,208,208,209,208,209,207,208,208,208,209,207,209,207,209,208,208,209,208,209,207,208,209,208,209,208,209,208,208,208,206,208,206,208,207,207,206,204,207,206,207,207,207,209,208,210,208,209,209,209,210,207,207,204,203,203,202,204,202,201,198,198,198,195,198,198,198,196,195,195,193,195,195,199,201,203,205,203,206,206,209,207,202,199,195,195,193,193,193,192,192,194,200,204,206,208,208,211,210,212,212,212,214,212,214,213,214,214,213,215,213,214,214,214,214,213,215,213,215,214,214,215,213,215,213,215,214,214,215,213,215,214,215,215,214,215,214,215,214,214,215,214,215,214,215,214,214,215,213,215,214,215,214,214,215,214,215,214,215,215,214,216,214,216,214,215,215,214,216,214,216,215,215,215,214,216,215,216,215,215,216,215,217,215,216,216,216,217,216,217,216,216,217,216,218,216,218,217,217,218,217,219,217,218,217,217,218,217,218,217,218,218,217,218,217,219,217,217,218,217,219,217,218,217,218,218,217,218,217,219,218,218,219,217,219,217,218,208,206,208,207,206,208,207,209,207,207,209,207,210,207,208,207,207,208,207,209,206,208,208,207,209,207,209,207,208,208,208,209,207,208,208,208,208,207,208,206,208,207,207,208,206,209,206,208,207,206,205,203,206,205,205,206,204,206,204,206,206,206,207,206,207,206,208,207,208,208,207,209,207,209,208,208,209,208,210,208,208,209,208,210,208,210,209,209,210,209,211,209,210,209,209,210,209,211,209,210,210,210,211,209,211,210,210,211,209,210,207,208,206,206,205,204,206,203,201,198,197,199,198,201,200,203,205,207,209,208,211,209,211,209,204,202,199,199,197,198,200,198,197,193,194,193,193,196,196,198,196,197,196,195,197,196,199,200,203,205,205,207,207,210,208,206,202,198,197,195,195,193,194,197,199,203,203,207,209,210,213,211,214,213,215,215,214,216,214,216,214,215,215,214,215,214,215,213,214,214,213,215,213,214,214,214,215,213,215,213,215,215,214,215,214,216,214,215,215,214,216,214,216,214,215,215,214,216,215,216,214,215,216,215,217,215,216,215,216,217,216,217,215,217,217,216,217,216,218,216,217,217,216,218,216,218,217,217,218,217,219,217,218,217,217,218,216,218,217,217,217,217,218,216,219,217,217,218,217,219,217,218,217,218,218,217,218,217,218,217,217,218,217,219,217,218,218,217,219,217,219,217,218,218,218,219,217,219,218,218,219,218,220,218,220,219,219,220,218,221,207,206,207,206,207,206,206,207,205,208,206,207,206,205,207,206,207,206,206,207,205,207,205,207,206,206,207,206,207,205,207,206,206,207,205,207,205,206,206,206,207,205,207,205,206,206,205,206,204,204,200,199,200,200,201,198,200,200,202,204,203,206,205,207,207,207,208,207,209,207,209,208,208,210,207,209,207,209,209,208,209,207,209,207,208,208,208,209,207,209,208,208,209,208,210,208,208,209,208,209,208,209,208,209,209,208,210,208,209,205,200,198,196,196,194,196,195,195,193,192,193,192,192,192,192,195,197,202,203,206,207,208,210,208,204,198,196,194,192,193,193,195,194,193,195,193,194,194,197,197,197,196,194,195,194,195,196,198,201,200,203,202,203,205,203,202,197,197,195,194,194,193,195,195,198,200,201,204,205,209,209,211,211,211,213,212,214,212,213,214,213,215,213,214,213,214,214,213,215,213,214,214,214,214,213,215,213,214,214,213,215,213,215,214,214,214,214,215,213,215,214,214,215,214,216,214,215,214,214,215,214,215,214,215,214,214,215,213,215,213,214,214,214,215,213,215,214,215,215,214,216,214,216,215,215,215,214,217,215,217,215,215,217,215,217,215,217,216,216,218,215,217,216,216,217,216,218,215,217,216,217,217,216,218,216,218,217,217,218,216,218,216,218,217,217,218,216,218,217,218,218,217,218,217,218,217,217,218,217,219,217,218,217,217,218,217,218,217,218,218,206,208,207,208,207,207,208,206,209,207,208,207,208,208,207,208,207,208,207,207,208,206,209,207,208,208,208,209,207,209,207,207,208,207,209,206,207,206,206,207,205,207,205,205,206,205,205,202,202,198,194,193,192,192,192,192,192,193,198,200,205,205,207,207,208,209,208,210,208,210,210,209,210,208,210,209,209,210,208,210,209,210,209,210,210,209,211,209,210,210,210,211,209,211,209,211,210,210,211,209,211,210,210,210,209,211,209,211,209,206,201,195,194,192,192,192,192,192,192,192,192,192,192,192,192,192,194,194,196,197,200,205,207,207,202,198,197,194,194,192,194,194,193,192,192,193,192,194,196,196,197,195,197,195,196,196,197,200,199,202,201,201,201,200,201,197,196,195,195,196,194,197,195,197,198,199,202,203,208,209,212,212,213,214,213,216,214,215,215,214,216,214,216,214,214,214,214,215,213,215,214,214,215,213,215,213,215,214,214,216,214,216,214,215,215,214,216,214,216,214,215,215,214,216,215,216,215,215,216,215,218,215,217,216,216,217,216,217,215,217,216,216,217,215,217,216,217,217,216,218,216,217,216,216,217,216,218,216,217,217,216,217,216,218,216,217,217,216,217,216,218,216,217,217,216,218,216,218,217,217,217,216,218,216,218,217,217,218,217,219,217,218,218,217,218,217,219,217,218,218,218,219,217,219,218,218,219,218,220,218,219,219,219,219,218,220,219,220,220,219,207,206,206,207,205,207,205,206,206,206,206,205,207,206,206,206,206,207,205,207,206,206,207,206,207,205,207,206,206,207,205,207,205,206,204,204,204,201,202,198,197,197,198,201,199,201,198,200,198,194,192,192,192,192,192,192,192,194,197,202,205,206,207,207,209,207,209,209,209,209,208,210,208,208,209,208,210,208,209,208,208,209,207,209,207,209,207,209,209,208,209,208,209,209,208,209,208,209,208,208,209,208,209,207,209,208,209,209,207,206,199,196,193,193,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,197,200,204,204,199,197,193,194,192,193,193,192,192,192,192,192,192,195,195,197,196,196,195,193,195,193,196,196,197,197,197,197,194,194,192,192,192,192,192,192,193,194,196,198,197,199,199,201,204,207,209,209,213,212,213,214,213,215,213,215,214,214,215,213,215,213,215,214,214,214,213,215,213,214,214,214,215,213,215,214,214,215,214,215,214,215,214,214,215,214,215,213,215,214,214,215,213,215,213,214,214,214,215,213,215,214,214,214,214,215,213,215,214,214,215,214,215,214,215,214,214,216,214,216,214,216,215,215,216,215,217,215,216,216,216,217,215,217,215,217,217,217,217,216,218,217,217,218,216,218,217,218,217,217,218,217,219,217,218,218,217,218,217,219,217,218,218,217,218,217,219,217,217,218,217,219,217,218,217,217,218,217,219,217,218,218,217,218,217,219,208,206,208,207,207,208,207,210,207,208,208,208,208,207,209,207,208,208,208,209,207,209,207,208,208,207,209,206,208,207,207,208,206,205,197,195,192,192,192,192,192,192,192,193,194,196,194,194,192,192,192,192,192,192,192,192,192,196,198,203,203,206,206,207,209,207,209,207,209,209,209,210,208,211,209,209,210,209,211,209,210,210,210,210,209,211,209,210,210,210,210,209,211,209,210,210,210,210,209,211,209,210,210,208,209,208,209,207,205,202,196,196,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,194,196,199,198,195,194,192,194,192,193,193,193,194,193,195,194,196,198,199,200,198,199,196,196,197,196,199,198,199,197,197,195,193,193,192,192,192,192,192,192,195,197,199,200,200,202,200,203,203,207,210,210,213,211,214,213,214,214,214,215,214,216,214,215,215,213,215,214,215,214,214,215,213,215,213,214,214,214,215,213,215,213,214,214,214,215,213,215,214,215,215,214,216,215,217,215,215,216,215,217,215,216,215,216,217,215,217,216,217,217,216,217,216,218,216,217,217,216,218,216,218,217,217,218,216,218,216,218,217,217,218,216,218,216,217,217,216,218,216,218,216,217,217,217,218,216,218,217,217,218,217,219,217,218,218,217,218,217,219,217,218,218,218,219,217,219,218,219,218,218,220,218,219,218,219,219,218,220,218,220,219,219,220,218,221,219,220,219,219,220,206,206,207,205,207,206,207,206,206,208,205,207,205,206,207,206,207,205,207,206,206,207,205,207,206,207,206,206,207,205,207,204,203,197,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,193,193,198,200,202,204,204,206,205,206,207,206,208,207,210,207,209,209,208,210,208,209,208,208,208,207,209,207,209,208,208,209,207,209,207,209,208,208,209,207,209,208,209,209,208,209,206,205,203,204,205,204,203,197,194,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,194,192,194,193,193,195,195,196,195,197,196,195,195,194,197,198,198,198,197,197,194,194,192,192,192,192,192,192,192,192,194,196,195,200,199,201,201,203,206,207,210,210,212,212,212,214,212,214,213,213,214,213,215,213,214,214,214,215,213,215,213,215,214,214,215,214,215,214,215,215,214,215,214,215,214,214,215,214,216,214,216,214,214,215,214,215,214,215,215,214,215,214,215,214,215,215,214,216,214,216,214,215,215,214,216,215,216,215,215,216,215,217,215,216,215,216,217,215,217,215,217,216,216,217,215,217,216,217,217,217,218,216,218,217,217,218,216,218,216,217,217,217,218,216,218,216,217,217,217,218,216,218,217,217,217,216,218,216,218,217,217,218,216,218,216,218,217,217,218,217,219,217,218,218,218,219,217,219,218,207,207,206,209,207,209,207,207,208,207,210,207,208,208,208,209,207,209,207,208,208,208,209,207,208,207,208,208,207,208,205,205,199,194,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,194,196,198,200,199,203,201,203,205,205,208,207,210,208,210,210,210,211,209,211,210,210,211,210,211,209,210,210,210,210,209,211,209,210,210,210,211,209,211,209,210,210,209,209,205,205,202,202,204,203,203,199,197,194,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,193,192,193,193,192,193,193,194,193,195,196,196,199,196,198,199,201,201,201,201,200,200,198,196,196,195,195,194,194,195,195,195,195,199,200,202,203,203,205,205,209,208,210,211,211,213,212,214,213,213,214,213,215,214,215,214,214,215,214,216,213,215,214,214,215,214,215,214,215,215,214,215,214,216,214,215,215,214,216,214,216,214,216,216,215,217,215,217,215,216,217,216,217,216,217,216,216,218,216,217,216,217,217,216,218,216,217,216,216,217,216,218,216,217,216,216,217,216,218,216,217,217,216,217,216,218,216,217,217,216,218,216,218,217,217,217,217,218,216,218,217,217,218,217,218,217,218,218,217,219,217,219,217,218,218,218,219,217,219,218,218,219,218,220,218,219,218,219,219,218,220,219,220,219,219,220,219,221,219,220,207,205,206,206,206,207,205,207,205,206,206,206,207,205,207,206,206,206,205,207,206,207,206,206,207,205,207,205,206,205,203,201,196,194,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,194,193,194,194,195,199,200,204,206,207,208,208,211,208,210,209,209,210,209,210,208,209,209,209,209,208,209,208,209,208,207,206,204,206,206,207,207,207,208,207,209,203,201,200,199,201,200,202,200,198,196,193,193,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,194,194,195,196,196,198,197,198,198,198,198,196,197,196,196,195,194,196,195,196,195,196,196,198,201,200,203,201,203,205,207,210,209,213,212,213,214,213,215,213,215,214,214,215,214,215,214,215,214,214,215,213,215,214,215,215,214,215,214,215,214,214,215,213,215,213,215,214,214,215,213,215,214,214,214,214,215,213,215,213,214,214,214,215,213,215,214,215,215,214,216,214,216,214,215,216,214,217,214,216,215,215,216,215,218,215,217,216,216,217,215,217,215,217,217,216,217,216,217,216,217,217,216,218,216,217,217,217,218,216,218,216,217,217,217,218,216,218,217,217,218,217,219,217,218,217,217,218,217,219,217,218,217,217,218,216,218,217,218,218,217,218,217,219,217,218,218,218,219,207,207,209,207,209,207,207,208,207,210,207,208,208,208,210,207,209,207,208,208,208,209,207,208,207,207,207,204,205,202,200,196,193,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,197,200,203,206,206,209,208,211,210,209,211,210,212,210,210,210,209,210,209,209,208,208,209,208,210,207,205,200,198,200,200,206,206,208,209,209,208,204,204,202,202,202,201,202,199,199,196,195,194,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,193,194,196,195,197,197,198,198,198,199,197,199,198,198,198,197,198,197,198,198,198,198,197,199,198,199,200,201,204,202,205,205,208,210,211,212,211,214,213,214,214,213,215,214,215,214,214,215,213,215,214,215,214,214,215,213,215,214,215,215,214,216,214,216,214,215,215,214,216,215,217,215,215,216,215,217,215,216,215,216,217,216,217,215,217,216,216,217,216,218,216,217,217,216,218,216,218,216,217,217,216,218,216,218,217,217,217,216,218,216,217,216,216,217,216,218,216,217,217,216,218,216,218,216,217,217,216,218,216,218,217,217,218,217,218,217,218,218,218,218,217,219,218,218,219,218,220,218,220,218,219,219,218,220,218,220,219,219,219,218,220,219,220,219,219,220,219,221,219,220,219,205,207,206,206,207,205,207,206,207,207,206,208,206,208,205,207,207,206,208,206,208,205,206,207,206,207,205,205,201,198,196,193,193,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,198,200,204,205,207,208,207,210,207,210,208,210,210,208,209,206,206,203,201,203,202,204,204,206,206,206,204,196,193,192,195,201,205,208,208,211,209,209,208,206,205,202,202,200,199,199,196,196,194,193,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,194,194,195,195,195,197,195,197,195,195,196,195,197,195,196,195,196,197,196,198,198,199,199,199,201,200,203,202,203,205,206,210,209,212,211,213,213,213,214,213,215,214,214,215,213,215,213,214,214,214,215,213,215,214,214,214,214,215,213,215,214,214,215,213,215,213,215,214,214,215,213,215,213,214,214,214,214,213,215,214,214,215,214,216,214,216,214,215,215,214,216,214,216,215,215,216,214,217,215,216,215,216,216,215,217,215,217,216,216,218,215,217,216,217,217,216,218,216,217,216,216,217,216,218,216,217,217,216,218,216,218,216,217,217,217,218,216,218,217,217,217,217,218,216,218,217,217,218,216,218,217,218,217,217,218,217,219,217,218,218,217,219,217,219,218,218,218,218,218,217,207,210,207,208,207,208,209,208,209,208,208,208,207,209,206,209,207,208,208,207,208,206,208,207,207,207,205,205,200,196,193,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,197,201,204,208,207,210,208,210,210,209,211,210,211,210,210,209,205,203,198,199,201,204,206,205,208,206,205,199,193,193,192,196,199,204,206,208,209,209,209,209,208,205,202,200,197,197,195,194,194,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,194,193,194,195,195,198,197,199,198,199,199,198,199,197,198,197,197,198,197,199,198,199,200,201,204,202,204,203,205,205,205,206,205,207,207,209,211,211,213,211,214,213,214,214,214,215,214,215,214,214,215,214,215,213,215,214,214,215,214,215,214,215,215,214,216,215,217,214,216,216,215,217,215,217,215,216,216,215,217,215,217,216,216,217,215,217,215,217,216,216,218,216,218,216,217,217,216,218,216,218,217,217,217,216,218,216,217,217,216,217,216,217,215,217,216,216,217,216,218,216,217,217,216,218,216,218,217,217,218,216,219,216,218,217,217,218,217,219,217,218,218,218,219,218,219,218,219,219,218,220,218,220,218,219,219,218,220,219,220,219,219,220,219,221,219,220,220,220,221,219,221,219,221,220,220,206,206,206,207,205,207,205,206,206,206,207,205,207,206,206,207,206,208,206,208,206,206,207,205,208,206,207,202,197,195,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,196,198,204,205,207,208,207,209,205,206,205,207,208,206,208,203,202,196,193,193,194,199,202,204,204,200,196,192,192,192,192,194,197,203,205,208,208,209,209,209,209,205,202,198,197,196,194,195,193,193,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,194,195,195,197,196,199,199,199,199,199,200,198,200,197,196,196,196,196,195,196,196,198,201,201,205,205,206,206,207,209,207,209,208,209,209,209,211,210,212,211,212,213,212,214,212,214,214,214,214,213,215,213,214,214,214,215,213,215,214,214,215,214,215,213,215,214,214,215,213,215,213,214,214,213,214,213,214,213,214,214,213,215,213,215,214,214,215,214,215,214,215,214,215,215,214,216,214,216,215,215,216,215,217,215,216,216,216,217,215,217,215,217,216,216,218,216,217,216,217,217,216,218,216,217,217,217,217,216,218,216,218,217,217,218,216,218,216,218,217,217,218,216,218,217,217,217,216,218,216,218,217,217,218,217,219,217,218,218,218,218,217,219,217,218,218,218,218,217,219,218,218,218,218,219,217,219,207,207,208,207,210,207,208,208,208,209,207,209,207,208,208,208,209,207,208,207,208,208,207,208,206,207,206,203,200,193,192,192,192,192,192,192,192,192,192,192,192,192,194,193,194,194,194,193,192,193,192,192,192,192,193,192,194,193,194,194,193,195,196,200,203,206,207,207,208,204,204,200,200,203,204,206,203,201,197,194,192,192,194,195,199,202,199,196,192,192,192,192,192,192,196,197,202,204,207,207,207,209,208,209,204,200,199,196,197,195,194,193,192,193,192,192,192,192,192,192,192,192,192,192,192,192,192,194,192,195,194,194,195,194,196,195,196,195,196,196,195,196,195,197,198,200,203,203,205,204,206,206,206,206,203,204,201,201,199,197,199,198,198,199,200,203,203,205,205,209,209,210,211,210,212,211,212,212,211,212,211,213,211,212,213,212,214,212,214,213,213,214,213,215,213,214,214,213,214,213,215,213,214,214,214,215,213,215,214,215,215,214,216,214,216,214,215,215,214,216,215,216,215,215,216,215,218,215,217,216,216,218,215,217,216,217,217,216,217,216,217,216,216,217,216,218,216,217,216,216,218,215,217,216,217,216,216,218,215,217,216,217,217,216,218,216,217,217,217,218,217,219,216,218,217,217,218,216,218,217,218,218,218,218,217,219,218,219,219,218,219,218,219,218,219,219,218,220,218,220,219,219,219,218,221,219,220,219,219,220,218,220,218,219,219,218,220,219,220,218,206,206,207,206,207,206,207,207,206,208,206,208,206,207,207,206,208,206,208,206,206,207,206,208,206,207,204,202,198,192,192,192,192,192,192,192,192,192,192,192,193,194,196,195,196,195,195,194,192,194,192,192,192,192,194,193,194,193,193,193,192,195,195,199,201,203,204,203,202,197,196,194,195,197,197,197,193,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,195,198,203,206,206,209,207,208,205,204,203,199,199,196,196,195,193,193,192,192,192,192,192,192,192,192,192,192,192,192,193,196,195,196,196,196,197,196,197,196,197,197,196,196,195,196,196,198,199,201,204,204,206,205,205,206,205,205,201,200,199,198,198,197,199,198,200,201,203,205,205,208,208,210,210,209,211,210,212,211,212,212,211,213,211,213,212,213,213,212,214,213,214,213,213,214,213,214,213,214,214,213,214,213,214,213,213,213,213,215,213,214,213,213,214,213,215,213,214,214,214,214,213,215,213,214,214,214,215,213,215,214,214,215,214,216,214,216,214,215,215,214,216,215,216,215,215,216,215,217,215,217,216,216,217,216,217,215,216,216,216,217,216,217,216,216,217,216,218,216,217,216,217,218,216,218,216,217,217,216,217,216,218,216,216,217,216,217,216,217,216,217,217,216,217,216,217,217,217,217,216,218,217,218,217,217,218,217,219,217,218,218,217,219,217,219,217,218,219,218,219,218,219,219,208,208,208,209,207,208,208,208,208,207,209,207,208,208,208,208,207,208,207,207,207,206,209,207,207,206,204,203,197,194,192,192,192,192,192,192,192,192,192,192,194,197,196,198,198,198,199,197,198,196,197,196,196,196,196,197,196,197,196,195,197,196,198,199,202,203,202,201,197,198,196,196,197,196,196,193,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,195,198,200,204,204,205,204,204,205,202,201,199,199,196,194,195,192,193,192,192,192,192,192,192,192,192,193,195,195,197,197,199,198,199,200,199,201,198,200,199,200,200,199,200,199,201,202,204,205,204,206,205,206,206,204,204,202,202,200,200,201,200,202,201,203,204,205,208,207,210,208,211,211,211,212,211,213,211,212,213,212,213,212,213,212,213,213,212,214,213,214,213,213,214,213,215,213,214,214,214,215,213,215,214,215,215,214,216,214,216,214,215,215,214,216,215,217,215,215,216,215,218,215,216,215,216,217,216,217,215,217,216,216,217,215,217,215,217,216,216,217,215,217,215,216,216,215,217,215,217,216,216,217,216,217,215,216,216,216,217,215,217,216,217,217,216,218,216,218,217,216,218,217,218,217,218,217,217,219,217,219,217,219,218,218,219,217,219,218,218,219,218,219,218,219,218,219,219,218,220,219,220,219,219,220,219,221,219,220,219,219,220,219,221,219,220,220,219,220,218,220,219,219,207,205,207,207,206,207,206,207,206,207,207,206,208,206,208,206,207,207,206,208,206,208,206,206,207,206,207,203,200,197,195,193,192,192,192,192,192,192,193,193,196,196,198,199,198,200,199,200,198,198,198,197,198,197,197,197,196,197,196,196,195,196,197,198,201,200,201,196,193,192,192,193,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,193,192,194,196,198,200,197,200,200,202,200,199,199,196,196,195,194,193,192,192,192,192,192,192,192,192,194,194,197,197,198,199,199,200,198,200,198,198,199,198,200,199,200,199,200,201,202,203,203,203,204,203,205,202,203,202,201,201,199,200,199,203,203,203,205,206,209,208,210,210,210,212,211,213,211,212,213,212,213,212,213,212,212,213,212,214,212,213,213,213,213,213,214,212,214,213,213,214,212,214,213,213,213,213,214,212,214,213,213,214,213,214,213,214,213,213,214,213,214,213,214,214,213,214,213,215,213,214,214,214,215,213,215,214,214,215,214,215,214,216,215,215,216,214,217,215,216,215,216,216,215,217,215,216,216,216,217,215,217,216,216,217,216,217,215,217,216,217,217,216,218,216,217,217,216,217,216,218,216,217,217,216,218,216,218,216,217,217,216,218,216,218,216,217,217,216,218,216,218,217,217,218,217,218,216,218,218,217,218,217,218,217,218,218,217,218,217,219,218,218,219,218,219,208,207,209,207,208,208,208,208,207,208,206,207,207,207,208,206,209,206,207,208,206,209,206,207,207,206,207,205,204,200,198,196,195,195,193,194,194,196,198,198,199,199,202,201,202,202,201,203,202,203,202,202,202,200,202,201,201,201,200,202,200,202,200,201,201,200,198,194,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,193,192,192,192,192,193,192,193,193,195,195,196,198,200,202,200,200,199,198,198,195,195,194,194,194,192,193,192,194,193,194,196,196,199,199,202,202,202,201,200,201,199,201,200,200,202,201,203,203,204,204,205,206,205,207,206,206,205,205,206,204,205,203,204,204,203,205,205,206,206,208,210,209,211,210,212,212,211,212,211,213,211,213,213,212,213,211,213,212,213,213,212,214,212,214,213,213,214,212,214,213,214,214,213,214,213,215,213,214,214,214,215,214,215,214,215,215,214,216,214,216,214,215,215,214,217,215,216,215,215,216,215,217,215,216,216,216,217,215,217,215,217,216,216,217,215,217,215,216,216,216,217,215,217,215,216,216,216,217,215,217,216,216,217,215,218,216,217,216,216,218,216,217,216,217,217,216,218,216,218,217,217,218,217,219,217,218,218,218,218,217,219,218,218,218,218,219,217,219,218,219,219,218,219,218,219,218,218,219,218,219,218,219,219,218,219,218,220,218,219,219,218,220,218,220,219,219,219,206,207,207,206,208,206,208,206,207,207,206,208,206,208,206,206,207,206,208,206,208,206,206,207,206,207,205,205,204,201,199,195,196,195,197,197,197,199,199,201,200,201,202,201,204,202,204,203,203,204,202,205,203,203,203,203,204,202,204,202,203,203,201,201,197,196,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,193,193,193,194,193,194,193,194,195,195,197,198,201,201,202,202,200,200,198,197,196,195,196,194,195,194,194,194,193,195,195,197,197,199,201,201,202,198,199,198,198,200,198,201,200,202,203,203,205,204,205,204,205,205,205,206,204,206,205,206,207,206,207,205,207,206,207,208,207,210,208,210,210,210,211,210,212,210,212,212,211,213,211,213,212,212,213,212,213,212,213,213,213,213,212,214,212,213,213,213,214,212,214,213,213,213,213,214,212,214,212,213,213,212,214,212,214,213,213,214,212,214,213,214,213,213,214,213,215,213,214,214,214,215,213,215,214,214,215,214,216,214,216,214,215,215,214,216,214,216,215,215,216,214,217,215,216,215,216,216,215,217,215,216,216,216,217,216,217,216,216,217,216,217,216,217,216,216,217,215,217,215,217,216,216,217,215,217,216,216,217,216,217,216,217,216,216,217,216,217,216,217,217,217,217,216,218,217,218,218,217,218,217,219,217,218,218,218,219,217,219,218,218,219,218,219,218,206,209,207,208,207,207,208,206,209,206,207,207,206,208,206,208,205,206,207,206,208,206,207,205,205,206,203,203,199,198,196,195,197,196,199,199,201,203,203,204,202,205,204,206,206,205,207,206,207,207,207,208,206,208,206,207,206,206,208,206,208,204,204,201,198,197,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,194,193,194,193,193,193,193,194,193,194,194,193,194,194,195,194,196,196,196,198,199,201,201,203,202,202,203,201,201,200,200,200,199,200,198,200,197,198,198,198,200,199,203,203,205,205,203,203,202,202,203,204,206,205,208,208,209,208,209,210,208,210,209,209,209,208,210,208,210,209,209,210,209,210,209,211,210,210,211,210,212,210,212,211,211,212,211,213,211,212,212,212,213,212,213,212,213,213,212,214,212,214,213,213,214,213,215,213,214,214,214,215,213,215,214,214,214,214,215,213,215,214,215,215,214,216,214,216,214,215,215,214,216,214,216,215,215,216,214,217,214,216,215,215,216,215,217,215,216,215,215,217,215,217,215,216,216,215,217,215,217,215,216,216,215,217,215,217,216,216,217,215,217,215,217,216,216,218,216,218,217,217,218,217,219,217,218,217,217,218,217,219,217,218,218,217,218,217,219,217,218,218,218,218,217,219,218,218,219,218,220,218,220,219,219,219,218,220,218,219,219,219,219,218,220,218,219,218,218,219,218,219,218,218,219,218,206,206,206,208,206,208,206,207,207,206,208,207,208,206,207,207,206,209,206,208,206,206,207,205,206,204,204,202,198,197,194,197,197,198,199,200,203,203,204,204,205,206,205,206,205,207,207,206,207,206,207,206,207,206,206,207,205,205,205,206,206,204,204,198,196,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,195,195,196,196,195,195,193,194,194,194,194,193,195,193,195,195,195,195,195,197,197,200,200,201,202,201,203,202,202,201,200,202,200,202,202,202,201,200,200,199,200,200,201,203,203,205,204,205,204,204,205,204,206,205,206,207,207,209,208,210,208,209,209,208,210,209,210,208,209,210,209,211,210,210,210,210,211,210,211,210,211,211,210,212,210,212,211,211,212,211,213,211,213,212,212,213,212,213,212,213,212,212,213,212,214,212,213,213,212,213,211,213,211,212,212,212,213,212,213,212,212,213,212,214,212,213,213,213,213,212,214,213,214,213,213,214,213,215,213,214,214,214,216,214,216,214,215,215,214,216,214,216,215,215,215,214,216,215,216,215,215,216,215,218,215,216,216,216,217,215,217,215,216,216,216,217,216,217,216,216,217,216,217,215,216,216,216,217,215,217,215,216,216,216,217,215,217,215,217,217,216,217,216,218,217,217,217,216,218,216,218,217,217,218,216,219,217,218,218,217,218,217,219,217,218,218,218,219,217,219,218,218,219,217,219,217,219,207,207,208,207,209,207,208,208,207,209,207,208,207,208,208,207,208,206,208,206,207,207,205,207,204,203,203,201,200,197,198,198,200,201,201,204,203,206,204,206,206,206,208,206,208,207,207,209,207,210,207,209,207,208,209,208,209,207,208,208,208,207,204,203,198,195,194,192,192,192,192,192,192,192,192,192,192,192,192,192,194,194,197,196,197,197,196,196,195,195,194,194,196,194,196,195,197,196,196,197,196,198,197,199,199,199,201,201,204,202,204,203,203,204,203,205,204,205,206,205,206,204,205,204,205,206,206,207,205,207,207,207,208,207,210,208,210,209,209,211,209,211,210,211,211,210,212,210,212,210,211,211,211,212,210,212,211,211,211,210,213,211,212,211,211,212,210,213,211,212,211,211,213,211,213,212,212,212,212,214,211,213,212,212,213,212,214,212,213,213,213,214,213,215,213,214,214,214,214,213,215,214,214,214,214,215,213,215,214,214,215,214,215,214,215,215,215,216,214,217,214,216,215,215,216,214,217,215,216,215,215,217,214,217,215,216,216,215,217,215,217,215,216,216,216,217,215,217,216,216,217,215,217,215,217,216,216,218,216,218,216,217,217,217,218,216,218,217,217,218,217,219,217,218,218,218,218,217,219,217,218,218,217,218,217,219,217,218,218,218,218,217,219,218,218,219,218,219,218,219,218,218,219,218,219,218,219,218,218,219,217,219,218,218,219,218,219,218,219,218,206,208,206,207,207,206,208,206,208,206,207,207,206,208,206,208,206,206,207,206,208,206,207,205,204,205,203,203,200,199,200,200,203,201,203,203,204,205,205,206,204,206,206,205,206,205,207,206,207,207,206,208,206,208,205,207,206,206,208,206,207,204,203,200,195,195,192,192,192,192,192,192,193,192,193,193,193,194,193,195,194,196,196,196,197,196,197,195,195,195,194,195,194,196,195,196,197,197,198,197,199,199,199,200,199,201,197,200,201,201,203,201,203,203,203,204,204,206,204,206,205,205,206,204,206,204,205,205,205,206,205,207,206,207,208,208,210,207,209,208,210,210,209,210,209,210,209,210,211,209,211,210,211,210,210,211,209,211,210,211,211,210,212,210,212,210,212,211,211,212,210,213,211,212,212,211,213,211,213,212,212,213,211,213,211,213,212,212,213,211,213,211,213,212,212,213,211,213,212,212,212,211,213,211,213,212,213,213,212,213,212,214,213,213,214,213,215,213,214,214,214,215,213,215,214,214,214,213,215,214,215,214,215,215,214,216,215,216,215,215,216,215,218,215,216,215,215,217,215,217,215,216,216,215,216,214,217,215,216,216,216,217,215,216,216,216,216,215,217,215,216,215,215,217,214,217,215,216,215,215,216,215,217,215,216,216,216,217,215,217,216,216,217,216,218,216,217,217,217,218,216,218,217,217,218,217,218,217,218,217,218,218,218,219,217,219,218,218,219,217,206,207,206,208,207,207,207,205,208,207,208,206,206,206,206,208,206,208,206,206,207,206,208,206,206,205,204,205,203,204,202,204,204,204,206,204,206,205,206,207,206,208,206,208,207,207,208,207,210,207,209,208,208,209,208,209,207,208,208,208,208,205,203,198,196,196,195,196,194,196,195,195,197,195,197,195,196,196,196,196,196,198,196,197,197,196,197,196,196,195,195,196,195,197,196,198,198,199,200,200,203,201,203,203,202,202,201,203,203,204,204,204,206,205,207,206,207,208,207,209,207,209,207,208,208,207,208,206,209,208,209,210,209,210,209,210,210,210,211,210,212,210,211,211,210,212,210,212,211,211,211,210,212,211,211,210,210,212,210,212,210,211,210,210,212,210,213,210,211,212,211,213,211,213,211,213,213,212,213,212,213,212,213,213,212,214,212,214,213,213,214,213,215,213,214,214,214,215,213,215,214,214,215,214,215,214,215,214,214,215,214,215,214,214,214,214,215,214,216,214,216,215,215,215,214,216,215,215,214,214,216,214,216,214,214,215,214,216,214,216,214,215,215,215,216,215,217,215,215,216,215,217,215,216,216,216,217,215,217,216,216,217,216,218,216,217,217,217,218,216,218,217,218,217,217,218,217,219,217,218,218,218,219,217,219,217,218,218,218,218,217,219,218,218,218,217,219,218,218,218,218,218,217,219,217,218,218,218,218,217,219,217,218,218,217,218,217,218,217,217,207,206,207,207,206,208,206,208,206,207,207,206,208,206,208,206,206,207,206,208,206,207,206,206,207,206,207,204,204,205,203,205,203,205,204,205,205,205,206,205,206,206,206,206,205,207,205,206,206,206,207,206,207,206,207,207,206,207,206,207,206,205,204,200,199,197,197,197,198,199,198,199,198,199,199,198,199,198,199,198,198,198,197,198,197,198,197,197,198,196,198,196,197,197,198,200,201,202,201,203,203,203,205,204,205,203,204,204,204,205,203,205,204,205,205,205,207,205,207,206,206,208,206,208,206,207,206,207,209,207,209,207,209,208,209,210,208,210,209,209,210,210,211,209,211,210,210,211,210,211,210,211,211,211,211,210,212,210,211,211,210,212,210,212,210,211,212,211,213,210,212,211,212,212,211,213,211,213,212,212,213,211,213,211,212,212,212,212,211,213,211,212,212,212,213,211,213,212,212,212,211,213,211,213,212,212,213,212,213,212,213,213,213,213,212,214,213,214,213,213,215,213,215,214,214,214,213,215,213,215,214,214,215,214,215,214,215,215,215,215,214,216,215,216,215,215,216,214,217,215,216,216,216,217,215,217,215,216,216,216,217,215,216,215,216,216,215,216,215,217,215,215,217,215,217,215,216,216,216,217,215,217,215,216,216,216,217,215,217,216,216,217,216,218,216,217,217,217,218,216,218,217,217,217,217,218,217,219,217,217,218,218,219,217,218,217,217,218,216,216,205,206,207,206,207,206,208,206,207,207,206,208,206,208,206,206,207,206,208,206,208,206,206,207,206,208,206,206,205,205,207,205,207,205,206,206,206,207,206,207,207,207,207,207,209,207,209,207,208,208,208,209,207,208,208,208,209,207,209,207,208,207,206,206,204,205,204,204,204,203,204,202,203,202,202,203,201,202,200,201,200,200,201,199,200,199,200,199,199,200,198,201,199,200,201,202,204,204,206,205,206,207,206,208,206,207,205,205,207,206,207,206,207,207,206,208,207,209,207,209,209,209,210,209,210,209,209,211,209,211,209,210,210,210,211,209,211,210,211,210,209,211,210,211,210,211,211,210,211,210,211,210,210,211,210,212,210,211,210,210,212,210,212,210,212,211,210,212,210,212,210,212,211,211,213,211,213,212,212,212,212,213,211,213,212,212,213,212,214,212,213,213,213,214,213,215,213,214,214,214,215,213,215,214,214,214,214,215,213,215,214,214,215,214,215,214,215,214,214,215,214,215,214,214,214,214,215,213,215,214,215,215,214,216,214,216,214,215,215,214,216,214,216,214,215,215,214,216,215,216,215,215,216,215,218,215,216,216,216,218,216,217,216,216,217,216,218,216,217,217,217,218,216,218,216,217,217,217,218,217,219,217,218,218,217,218,217,218,217,218,218,217,218,217,218,217,217,218,217,219,217,218,218,217,218,217,218,217,218,218,217,219,217,219,218,218,218,216,215,213,204,206,205,207,206,206,207,206,208,206,207,206,206,207,206,207,206,207,206,206,207,205,207,205,206,206,205,206,204,206,205,205,205,204,206,204,205,205,205,205,204,206,205,206,206,206,207,205,207,206,206,206,206,207,206,207,206,206,207,206,207,205,207,206,206,207,205,206,205,206,205,205,206,204,206,204,204,204,203,204,202,204,202,203,202,201,203,201,202,201,201,202,201,204,203,204,205,205,206,205,207,206,207,207,206,207,206,207,206,207,207,206,207,205,207,206,206,207,206,208,206,208,207,207,208,207,210,207,208,208,208,209,208,209,208,209,209,208,210,208,210,209,209,210,209,211,209,211,210,210,211,210,211,210,211,211,210,211,210,212,210,211,211,210,212,210,212,210,211,211,211,212,210,212,211,211,212,210,213,211,212,211,211,213,211,213,211,212,212,212,213,211,213,212,212,213,212,213,212,213,212,212,213,211,213,211,213,212,212,213,212,213,212,213,213,213,214,213,215,213,214,214,214,215,214,215,214,215,215,214,216,214,216,214,215,215,214,216,214,216,215,214,216,214,216,214,215,215,214,216,215,217,214,215,215,215,217,215,215,214,215,216,215,216,214,216,215,215,216,214,216,214,215,215,215,216,215,217,215,215,216,215,218,215,217,215,217,217,216,217,216,218,216,216,218,216,218,217,217,217,217,218,217,218,217,218,218,217,219,217,218,218,218,218,217,218,215,214,211,210,205,206,205,207,205,207,206,206,207,205,207,205,207,206,206,207,205,207,206,207,207,206,207,206,207,206,206,206,206,207,205,207,206,206,207,206,207,206,208,207,208,208,207,209,207,209,208,208,209,207,209,207,209,208,208,209,207,209,207,208,208,208,208,206,208,206,207,207,206,208,206,207,206,206,207,206,207,205,206,205,205,205,203,205,203,203,203,202,204,203,204,203,204,205,205,206,205,207,207,207,208,207,210,207,209,208,208,209,207,209,208,209,209,208,209,208,209,208,209,210,208,210,208,210,209,209,210,209,211,209,210,210,210,211,209,211,210,211,211,210,211,210,211,210,210,211,210,211,209,211,210,210,211,210,212,210,211,211,211,211,210,212,211,211,211,211,212,211,213,211,211,212,211,213,211,213,211,213,213,212,214,212,213,213,213,214,212,214,212,214,213,213,214,213,214,213,214,214,213,215,213,214,213,214,214,213,215,213,215,214,214,215,213,215,213,214,214,214,214,213,215,213,214,214,213,215,213,214,213,214,214,214,215,214,215,214,214,215,214,216,214,216,215,215,216,215,217,215,216,215,216,217,215,217,215,217,216,216,217,215,217,216,217,217,216,218,216,218,217,217,218,217,218,217,218,217,217,218,216,218,217,217,217,216,218,217,218,217,217,218,216,218,217,218,217,217,219,217,218,217,218,217,217,218,217,219,217,218,218,217,218,217,218,217,218,217,213,211,207,206,207,205,207,206,206,207,205,207,206,207,206,206,207,205,207,205,206,206,206,206,205,207,205,205,206,205,207,204,206,205,205,206,204,206,204,206,205,205,206,205,207,205,206,206,206,207,205,207,206,206,207,206,207,206,207,206,207,207,206,208,206,208,206,206,207,206,208,206,207,206,205,207,206,207,206,206,206,206,207,205,205,203,203,204,202,204,202,204,203,203,204,203,206,204,206,206,206,207,206,208,206,208,207,207,207,206,208,207,208,206,206,207,206,208,207,207,207,206,209,208,209,207,207,209,207,210,208,209,208,208,210,208,210,208,209,210,209,211,209,210,210,210,210,210,211,209,211,210,210,211,210,211,210,211,211,210,211,210,211,210,211,211,210,211,210,211,211,211,211,210,212,210,211,210,210,212,210,212,210,212,211,211,212,210,212,210,212,211,211,212,210,212,211,212,212,211,213,211,213,212,212,213,212,213,212,212,212,212,213,212,213,212,213,213,213,214,212,214,213,213,214,213,215,213,214,214,214,214,213,215,213,215,214,214,215,214,215,214,215,215,214,215,214,215,214,215,215,214,216,214,216,214,215,215,214,216,215,216,215,215,215,214,216,215,216,215,215,215,214,216,215,216,215,215,217,215,217,216,216,216,215,217,215,217,216,216,217,216,217,215,217,216,217,218,216,218,216,217,217,217,218,216,218,217,217,218,217,219,217,218,218,218,218,217,218,214,211,206,204,201,205,207,206,206,207,206,207,206,207,206,206,207,206,208,206,207,206,206,207,205,207,206,206,206,206,208,206,208,205,207,207,206,208,206,208,206,207,207,206,208,207,208,206,207,208,207,210,207,208,208,208,209,207,209,207,209,208,208,209,207,209,207,208,208,207,208,207,208,206,207,207,206,207,206,207,206,206,207,206,207,204,203,203,202,203,202,203,203,204,204,204,206,204,207,207,207,207,207,209,208,209,208,208,209,208,210,208,208,209,208,209,208,209,208,209,209,208,210,208,210,209,209,210,209,211,209,210,210,210,210,209,211,209,211,210,210,211,210,211,210,211,211,210,212,210,212,210,211,211,210,212,210,211,210,210,211,210,212,210,211,210,210,212,210,212,211,212,212,211,212,211,213,211,212,212,212,213,211,213,212,212,213,212,214,212,213,213,213,214,212,214,213,213,213,213,214,213,214,213,213,214,213,214,213,214,213,214,214,213,215,213,214,214,214,214,213,215,214,214,214,214,215,213,215,213,214,214,213,215,213,214,213,214,215,213,215,214,215,215,215,215,214,216,215,216,215,215,216,215,218,215,217,216,216,218,215,217,216,216,216,216,218,215,217,216,216,217,216,218,216,217,217,217,218,216,218,216,217,217,217,218,216,218,217,217,217,216,218,217,218,216,217,218,216,218,216,218,217,217,218,216,218,217,217,217,217,218,217,219,217,217,218,217,218,215,213,207,204,203,200,206,207,206,207,205,207,206,206,207,206,207,205,206,206,205,206,205,206,205,206,206,205,206,204,206,205,205,206,204,206,204,205,205,205,205,204,206,204,205,205,205,207,205,207,205,206,206,206,207,205,207,206,207,207,206,208,206,208,207,207,207,206,208,207,208,206,206,208,207,209,206,207,207,206,208,207,208,206,207,207,206,207,205,206,204,204,205,203,205,204,205,205,205,206,205,207,206,207,207,207,208,206,209,206,208,208,208,208,207,208,207,208,208,207,208,206,208,206,207,208,207,209,207,209,208,208,209,208,210,208,209,209,209,210,208,210,209,210,210,209,211,209,211,210,210,211,209,211,210,211,210,210,211,210,211,209,211,211,210,211,210,211,210,210,211,210,211,210,211,210,210,211,210,212,210,211,211,210,211,210,212,210,211,211,211,212,211,213,211,211,212,211,213,211,213,211,212,212,212,213,211,213,212,212,213,212,213,212,213,213,213,214,212,214,213,213,213,213,214,213,214,213,213,214,213,215,213,214,214,214,215,213,215,214,215,214,214,215,213,215,214,214,214,214,215,213,215,214,214,215,213,215,213,215,214,214,215,214,215,214,215,215,214,215,214,216,214,215,215,215,216,215,217,215,215,216,215,217,215,217,215,216,216,216,217,215,217,216,217,218,216,218,217,217,217,217,218,217,218,217,218,218,217,218,217,219,217,218,218,218,218,216,218,216,213,210,205,204,200,200,206,205,207,205,206,205,206,207,205,207,206,207,206,206,207,206,208,206,207,206,206,207,206,208,206,207,207,206,207,206,208,206,207,207,206,208,206,208,206,207,207,207,209,207,209,207,207,208,207,210,207,208,207,208,209,207,208,207,209,208,207,209,207,209,207,208,208,207,208,207,208,207,207,208,206,209,206,208,207,207,208,206,209,206,207,207,205,206,204,206,205,205,207,206,208,207,209,207,208,209,209,210,208,210,209,209,210,208,210,209,209,209,209,210,208,210,209,209,210,209,211,209,210,209,209,210,209,211,209,210,210,210,210,209,211,209,210,210,210,211,209,211,210,210,211,210,211,210,212,210,211,211,210,212,210,211,210,210,211,210,212,210,211,211,211,212,211,213,211,212,212,212,213,211,213,212,212,213,212,213,212,213,212,212,214,212,213,212,213,213,213,214,213,215,213,213,213,213,214,212,214,213,213,213,212,214,212,214,213,213,213,212,214,212,213,213,212,214,213,214,213,213,213,213,215,213,214,213,214,214,213,215,213,215,214,214,215,214,215,214,215,215,215,216,214,216,214,216,215,215,217,215,217,215,217,216,216,218,216,217,216,217,217,216,218,216,217,216,217,218,216,218,216,217,217,217,218,216,218,216,217,217,216,217,216,217,216,216,217,216,218,216,217,217,217,218,216,218,216,218,218,217,218,217,218,217,218,218,217,218,217,217,215,215,212,208,207,203,202,200,206,205,207,205,206,206,206,206,205,206,205,206,206,205,206,205,206,205,205,205,205,206,204,206,205,205,205,204,206,204,206,205,205,206,204,206,204,206,206,205,206,205,207,205,206,206,206,207,205,207,206,206,207,206,208,206,208,206,207,207,206,208,207,208,206,206,207,206,208,206,207,206,206,208,207,208,206,207,207,206,208,207,208,206,206,206,205,206,204,205,204,204,206,205,206,205,206,206,206,208,206,208,206,208,207,207,208,207,209,207,208,208,208,209,207,208,207,208,208,207,209,207,209,208,208,210,208,209,208,209,209,209,210,209,210,209,210,210,209,211,209,211,210,210,211,209,211,210,211,210,210,211,210,212,210,211,211,210,211,210,211,210,210,211,210,211,210,211,210,210,211,210,211,210,211,210,210,211,209,211,210,211,211,210,212,210,212,210,211,211,210,212,211,212,211,211,212,211,214,211,213,212,212,213,212,214,212,213,213,213,214,212,214,213,213,213,212,214,212,214,213,213,213,212,214,213,214,213,213,214,213,215,213,214,214,214,215,214,215,214,215,214,214,215,213,215,214,214,214,213,215,213,215,214,214,215,213,215,214,215,214,214,216,214,216,214,215,215,215,217,215,217,215,216,216,216,216,215,216,215,216,216,215,217,215,217,216,216,217,216,217,216,217,217,217,218,216,218,217,217,217,217,218,216,218,217,217,218,216,217,216,216,213,210,208,205,204,201,200,199,205,207,205,207,206,206,206,205,207,205,206,206,206,207,205,207,205,207,207,206,207,206,207,206,207,207,206,207,206,207,206,207,207,206,207,206,207,206,206,207,206,208,206,208,207,207,207,206,208,207,208,207,207,207,207,209,207,207,207,206,209,207,208,206,207,207,206,208,207,208,206,207,207,207,209,207,208,207,207,208,207,209,207,207,207,206,208,206,208,206,206,207,207,209,207,209,207,208,209,208,210,208,209,209,209,210,208,210,209,209,209,209,210,208,210,209,209,210,209,210,208,210,209,209,210,208,210,209,210,210,209,210,209,210,209,210,210,209,210,209,210,209,210,210,210,211,209,211,210,210,211,209,211,210,211,210,210,211,209,211,210,211,211,211,212,210,213,211,212,212,212,213,211,213,212,212,213,212,213,212,213,212,212,213,211,213,212,213,212,213,214,212,214,213,213,213,213,214,212,214,213,213,214,212,214,213,214,213,213,214,212,214,213,213,213,213,214,212,214,213,213,214,213,214,213,214,213,214,214,213,215,214,215,214,214,215,214,215,214,215,215,215,215,214,216,214,216,215,215,216,214,217,215,216,216,215,217,215,217,215,217,217,216,217,216,217,216,216,217,216,218,216,216,216,216,217,216,217,216,216,217,216,217,216,217,216,217,217,216,217,216,217,217,216,217,216,218,216,217,217,216,218,217,218,217,218,218,217,218,217,218,216,214,210,206,205,203,203,201,201,205,206,205,206,205,205,206,204,206,204,205,205,204,205,204,205,204,205,204,204,206,203,205,204,204,205,204,205,203,205,204,205,205,204,206,204,205,205,205,206,205,207,205,206,206,206,207,205,207,206,206,207,206,207,206,208,207,207,207,206,208,207,209,207,207,208,207,210,206,208,207,207,208,206,209,206,207,207,206,208,207,208,206,207,207,205,207,206,206,205,206,207,206,207,206,207,207,207,208,206,209,206,207,207,206,208,207,209,206,207,208,207,210,206,208,207,208,208,207,208,207,209,208,208,209,208,209,208,208,209,208,210,208,210,209,209,210,209,211,209,211,210,210,211,210,211,210,211,211,210,211,210,211,210,211,210,210,211,209,211,210,210,210,210,211,209,211,210,210,211,210,211,210,211,210,210,211,209,211,210,211,211,210,211,210,212,210,211,211,210,212,210,213,211,211,212,211,213,211,212,212,212,213,211,213,212,213,213,213,213,212,214,212,213,213,212,214,212,214,213,213,214,213,214,213,214,213,213,214,212,214,213,214,214,213,214,213,215,213,214,214,214,214,213,215,213,214,214,213,214,213,215,213,213,215,213,215,214,215,214,214,215,213,215,214,214,215,214,216,214,216,214,215,215,215,216,215,217,215,216,216,216,217,215,217,216,216,217,216,217,216,217,217,216,218,216,218,216,217,217,216,218,216,218,217,217,217,217,218,216,216,212,208,207,203,202,200,201,201,200,205,206,206,205,207,205,206,206,206,206,205,207,205,206,206,206,206,205,207,206,206,206,206,207,206,207,206,207,207,206,208,206,208,206,206,207,206,208,206,208,206,206,207,206,208,207,208,206,207,208,206,209,206,208,208,207,208,207,208,206,208,208,207,208,206,208,206,207,207,206,208,206,208,207,207,208,206,209,207,208,207,208,208,207,208,207,208,208,208,208,207,209,207,208,208,208,210,208,209,209,208,210,209,210,208,209,209,209,210,208,210,208,209,210,208,210,208,209,208,208,209,208,209,208,209,209,209,209,208,210,208,209,209,209,210,209,210,209,210,210,209,211,209,211,209,210,211,210,211,210,211,210,211,211,210,212,210,211,211,210,211,210,212,210,212,211,211,212,211,213,211,211,212,211,213,211,213,211,212,212,212,213,211,213,212,212,213,212,213,212,213,213,212,213,212,213,212,213,213,212,213,212,213,212,212,213,212,213,212,213,212,212,213,212,213,212,213,213,212,214,212,214,213,213,213,212,214,213,214,213,214,215,214,215,213,215,214,214,215,214,216,214,216,215,215,215,214,217,215,216,215,215,216,215,217,215,216,216,216,217,216,217,216,216,217,216,217,216,216,216,216,217,216,217,216,216,216,216,217,215,217,216,217,217,216,217,215,217,216,216,217,216,218,216,217,217,216,218,216,218,216,218,217,217,218,216,218,217,217,217,215,215,210,208,205,204,203,202,204,204,205,205,206,204,206,204,205,205,205,206,204,206,204,205,205,204,206,204,206,204,205,205,204,205,204,205,204,204,205,204,206,204,205,205,205,206,205,206,205,206,206,206,206,205,207,206,206,207,206,207,205,207,206,207,207,206,208,206,208,206,207,207,206,208,207,208,206,206,207,206,208,207,207,206,206,208,207,209,206,207,207,207,208,206,208,205,206,207,206,208,206,208,206,206,207,206,208,207,207,207,206,208,207,209,206,207,208,207,209,206,208,207,208,208,208,209,207,208,208,208,209,207,210,208,209,209,209,210,208,210,208,209,210,209,211,208,210,209,210,210,209,211,209,210,210,210,211,209,211,210,210,210,210,211,209,211,209,210,210,209,210,209,210,209,209,210,209,211,209,210,210,210,210,209,210,209,210,209,208,209,208,211,209,210,210,210,212,210,212,210,211,212,210,213,211,212,211,212,212,211,213,212,213,212,212,213,212,213,212,212,212,212,213,211,213,212,213,213,213,214,212,214,213,213,214,213,214,213,214,213,213,214,213,214,213,214,213,213,214,213,214,213,213,214,213,215,213,215,214,214,215,214,215,214,215,215,214,215,214,215,214,215,215,214,215,214,215,214,215,215,214,216,215,216,215,216,216,215,217,215,217,215,216,217,216,217,216,217,216,216,217,215,217,216,217,216,216,217,215,217,216,217,217,216,218,216,217,216,216,215,213,210,205,204,202,202,202,201,203,204,205,206,205,207,205,206,206,206,207,205,207,205,206,206,206,206,205,207,205,206,206,205,207,205,207,206,206,207,206,207,206,207,206,206,207,206,207,206,207,206,206,207,206,207,206,207,207,206,208,206,208,206,207,207,206,208,207,209,206,207,208,207,209,206,208,207,207,207,206,208,207,208,207,207,208,207,210,207,208,208,208,209,208,208,207,208,208,208,209,208,209,208,208,209,208,210,208,209,209,209,209,208,210,209,209,209,209,210,209,210,209,209,210,208,210,208,209,209,209,209,208,210,208,209,209,209,210,208,210,208,209,209,209,210,208,210,209,209,210,209,210,209,210,209,209,210,209,211,209,211,210,210,211,209,211,210,211,211,210,211,210,212,210,211,211,211,212,211,212,211,211,211,210,211,210,211,210,210,210,207,209,209,211,210,211,213,211,213,212,213,213,212,213,212,214,212,213,213,212,213,212,213,212,212,213,212,213,212,213,212,212,213,212,214,212,213,213,212,213,212,214,212,213,214,213,214,213,214,213,214,214,213,215,214,215,214,214,215,214,216,214,216,215,215,215,214,216,215,216,215,215,216,215,217,215,216,216,216,216,215,216,215,216,216,215,217,215,217,215,216,216,216,217,215,216,216,216,216,215,217,215,215,215,215,217,215,216,215,215,216,215,218,215,217,216,216,218,216,218,217,217,218,217,219,217,218,218,218,218,217,216,210,207,205,204,205,204,206,206,208,204,205,204,205,203,205,204,203,205,203,205,203,205,205,204,205,204,205,204,204,205,204,205,203,205,204,204,205,204,206,204,205,205,205,206,204,206,205,205,205,205,207,205,207,206,206,206,206,207,206,207,206,206,207,206,208,206,208,206,207,207,206,208,207,208,207,207,207,206,209,207,207,207,206,208,207,209,206,206,207,206,208,206,208,205,206,207,206,208,206,207,206,206,208,206,208,206,207,207,206,208,207,208,206,207,208,207,209,207,208,207,208,208,207,209,207,208,208,208,208,207,209,207,209,208,208,209,207,209,208,209,209,208,210,208,210,209,209,210,209,210,208,210,209,209,210,208,210,209,210,210,209,210,209,210,209,209,209,209,210,208,210,209,209,210,209,210,209,210,210,209,209,206,206,206,208,208,208,206,204,205,206,209,210,210,211,210,212,211,212,212,212,213,211,213,212,212,213,212,214,212,213,213,212,213,212,213,212,213,213,212,213,212,213,212,212,213,212,213,212,213,212,212,213,212,213,212,213,213,213,213,212,214,212,213,213,213,214,212,214,213,213,213,212,214,213,213,213,213,214,213,215,213,214,214,214,215,214,216,214,215,215,214,216,214,216,215,215,215,214,216,215,216,215,215,215,215,217,215,216,214,214,215,214,216,214,215,215,215,216,215,218,215,216,216,216,217,216,217,216,216,217,216,217,216,217,216,216,216,214,212,207,206,204,204,206,205,207,207,209,204,205,205,205,206,204,207,205,205,205,205,206,205,207,205,206,206,206,207,205,207,206,206,207,206,207,205,207,206,206,207,206,207,206,207,207,206,207,206,207,206,207,207,206,207,206,208,206,208,207,206,207,206,208,207,207,207,206,208,207,208,206,207,207,206,209,207,208,207,207,208,207,210,207,208,207,208,208,207,208,207,208,208,208,209,207,209,207,208,208,208,209,207,209,208,208,209,208,210,208,208,208,208,209,208,210,208,209,209,209,209,208,210,209,209,209,208,210,208,209,208,208,209,208,210,208,209,208,208,209,208,209,208,209,209,208,210,208,210,209,210,210,209,211,210,211,210,210,211,210,212,210,211,211,211,212,210,212,210,211,211,210,212,210,212,210,211,211,211,212,210,210,207,206,207,207,208,207,208,205,205,207,207,210,210,211,211,211,212,211,213,211,213,213,212,213,212,213,212,212,213,212,213,211,213,212,212,213,212,213,211,213,212,212,213,211,213,212,213,213,213,214,213,214,213,213,214,213,215,213,215,214,214,215,214,215,214,214,214,214,215,214,215,214,215,215,215,215,214,216,215,216,215,215,216,214,217,215,216,216,215,217,215,217,215,215,216,215,218,215,217,216,216,217,215,217,215,216,216,216,216,214,215,214,213,214,214,215,214,215,215,215,216,215,218,215,217,217,217,218,217,218,217,218,218,217,219,217,218,217,216,213,209,209,207,208,208,209,209,210,203,204,204,204,204,203,205,203,204,204,204,205,203,205,203,204,204,204,205,203,205,204,204,205,204,205,204,205,205,205,206,205,206,204,206,205,205,206,204,206,205,206,206,205,207,205,206,206,206,206,206,207,205,207,206,206,208,206,208,206,207,207,206,208,206,208,205,207,206,206,208,205,207,205,205,207,206,207,205,207,206,206,208,206,208,205,207,206,206,208,206,208,205,207,206,206,208,206,208,206,207,207,207,209,207,209,207,208,208,208,209,207,209,208,208,209,208,209,208,208,208,208,209,207,209,207,209,209,208,210,208,209,208,209,210,209,210,209,210,209,209,210,208,210,208,209,209,209,209,208,210,208,209,209,209,210,208,210,209,209,210,209,211,209,210,209,209,210,208,210,208,208,206,206,206,204,206,204,204,204,203,205,206,209,209,210,210,210,212,211,212,211,212,212,212,213,211,213,212,212,213,211,213,211,213,212,212,213,212,213,212,212,213,212,213,212,213,212,212,213,212,213,212,213,213,212,213,212,213,212,213,213,212,213,212,214,212,213,213,213,214,212,214,213,213,214,213,215,213,214,214,214,214,213,215,213,214,214,214,215,214,215,214,215,215,214,216,214,216,215,216,216,215,216,215,216,215,215,216,215,217,214,215,214,214,216,214,216,214,215,215,215,217,215,217,215,216,216,216,217,215,217,215,216,216,216,217,215,216,215,215,213,209,210,207,208,207,208,209,209,206,205,205,206,204,206,205,206,206,205,206,205,207,205,206,206,206,207,205,207,206,206,207,206,207,205,207,206,206,207,205,207,205,206,206,206,206,205,207,205,206,206,206,207,205,207,206,206,207,206,207,206,207,206,206,207,206,208,206,208,206,207,207,207,208,207,208,207,207,208,207,210,207,208,207,208,208,207,209,207,208,208,208,209,208,209,208,208,209,207,209,207,209,208,208,209,208,209,208,209,208,208,210,207,209,208,209,209,208,210,208,209,208,208,209,208,210,208,209,209,209,209,208,209,208,209,208,208,209,208,210,208,209,209,208,210,208,210,209,209,210,209,211,209,211,210,210,211,209,211,209,211,210,210,212,210,212,210,211,211,210,212,210,212,210,211,211,210,212,211,211,209,208,208,207,208,206,207,206,206,207,206,208,208,210,210,210,212,211,213,211,212,212,212,213,212,213,212,212,213,211,213,211,213,212,212,213,212,213,212,213,212,212,213,212,214,212,213,213,212,214,213,214,213,214,214,213,215,213,214,214,214,215,214,216,214,215,214,214,216,214,216,214,215,215,214,216,215,216,214,215,215,214,216,215,216,214,215,215,215,217,215,216,215,215,215,214,216,215,216,215,215,216,215,217,215,216,216,216,217,215,216,214,215,215,214,216,215,216,215,216,216,216,218,216,217,217,216,218,217,218,217,218,218,217,218,217,218,217,217,217,216,216,213,212,210,210,212,211,213,204,203,203,204,202,205,203,204,203,203,205,203,205,203,204,204,203,205,203,205,204,204,205,204,205,204,205,204,204,206,204,206,205,206,206,205,206,205,207,206,206,206,205,207,205,207,206,206,207,206,207,205,207,207,206,207,206,207,206,207,207,206,207,206,207,206,206,207,206,207,206,207,206,206,207,205,207,205,207,206,206,207,205,207,206,206,206,206,207,205,207,206,206,206,206,207,206,207,206,206,207,206,208,206,208,207,207,208,207,209,207,209,208,208,209,208,209,207,208,208,208,209,207,209,208,208,208,208,209,207,209,208,209,209,208,210,208,209,209,209,210,208,210,208,209,209,208,210,208,210,209,209,209,208,210,208,210,209,209,210,209,211,209,210,209,209,210,209,210,209,209,207,206,206,204,206,205,206,206,205,206,206,208,208,210,210,209,211,210,212,211,211,212,211,213,211,212,212,212,212,211,213,211,212,212,212,213,211,213,212,212,213,212,213,212,213,212,212,213,212,213,212,213,212,212,213,212,213,212,213,213,212,213,212,213,212,213,213,212,214,212,213,213,213,213,212,214,213,214,213,213,215,213,215,214,214,214,214,216,214,215,213,214,215,214,216,214,216,214,215,215,214,216,215,216,215,215,216,215,217,215,216,215,215,215,214,216,215,216,215,215,216,215,217,215,216,216,216,217,215,217,215,216,217,216,217,216,216,216,215,216,214,215,212,211,210,210,210,209,211,205,205,206,204,206,205,206,205,205,206,204,206,205,205,205,205,206,205,207,205,206,206,205,206,205,206,205,205,206,205,207,205,206,206,206,206,205,207,205,206,206,206,206,205,207,205,206,206,206,207,205,207,206,206,207,206,208,206,208,206,206,207,206,208,207,208,207,207,208,207,209,207,208,208,208,209,207,209,207,208,208,208,209,207,209,207,208,208,208,209,207,208,207,208,208,208,209,207,208,208,208,209,207,209,208,209,209,208,209,208,209,208,208,209,208,209,208,209,208,208,209,207,209,208,209,209,208,209,208,209,208,209,209,208,210,208,210,209,209,210,209,211,209,210,210,210,210,209,211,210,210,210,210,211,210,212,210,211,211,210,212,210,212,210,211,211,210,212,211,211,210,209,209,208,209,207,208,208,208,209,208,209,209,210,210,210,211,210,212,211,212,212,211,213,211,213,212,212,212,211,213,211,212,212,212,212,211,213,211,213,212,212,214,212,213,212,213,213,213,214,212,214,213,213,214,213,215,213,214,214,214,214,213,215,214,215,215,214,216,214,216,214,215,215,214,216,214,216,215,215,215,214,216,215,216,215,215,216,215,217,215,216,215,216,216,215,216,215,216,215,215,216,214,217,215,215,216,215,217,215,216,215,216,216,215,217,215,217,216,216,217,216,218,216,217,217,217,218,216,218,217,218,217,217,218,216,218,217,217,217,216,218,216,216,215,213,213,212,213,212,202,202,204,202,204,202,203,203,203,204,203,204,203,203,204,203,205,203,204,203,204,205,203,205,204,205,205,204,205,204,206,205,205,206,205,207,205,206,205,206,206,205,207,205,207,206,206,207,205,207,206,207,207,206,207,205,207,206,206,206,206,207,205,207,205,206,206,205,206,205,207,206,205,207,205,207,205,206,206,205,206,205,207,205,205,206,205,207,205,207,206,206,207,206,207,206,207,206,207,207,206,208,207,208,207,208,208,207,209,207,208,208,208,209,208,209,208,208,209,208,210,208,209,208,208,209,208,209,208,209,208,208,209,207,209,207,209,208,208,209,208,209,208,209,209,208,209,208,209,208,209,209,208,210,208,209,209,209,209,208,210,208,209,209,208,209,208,210,208,208,208,207,208,207,209,207,209,209,209,209,208,210,209,209,211,210,211,210,212,211,211,212,211,213,211,212,212,212,213,211,213,212,212,212,211,213,211,213,212,212,213,211,213,211,213,212,212,213,211,213,211,213,212,212,213,211,213,212,212,213,212,213,212,213,212,213,213,212,213,212,213,213,213,213,212,214,213,213,213,213,214,213,215,214,214,215,214,216,214,216,214,215,215,214,216,214,216,214,215,215,214,216,215,216,215,215,216,215,217,214,216,215,215,216,215,217,215,216,216,216,216,215,216,215,216,215,215,216,215,216,215,215,216,215,217,215,216,215,216,216,215,216,214,215,213,211,212,211,212,211,205,206,205,207,205,205,205,205,206,204,206,205,205,206,205,206,205,206,205,206,206,205,206,205,206,205,205,206,204,206,205,205,205,205,206,205,207,205,206,206,205,206,205,206,205,206,206,206,207,205,207,206,206,207,205,207,206,207,207,207,207,206,208,207,208,207,207,208,207,209,207,207,207,207,209,207,209,207,208,208,208,209,207,208,208,208,208,207,209,207,208,208,208,209,207,209,207,208,208,208,209,207,208,207,209,208,208,209,207,209,208,208,209,208,209,207,208,208,208,208,208,209,207,208,208,208,209,208,209,208,208,209,208,209,208,210,209,209,210,208,210,209,210,210,210,210,209,211,210,210,210,210,211,210,212,210,211,211,210,212,210,212,210,211,211,210,212,210,211,210,210,210,209,210,209,210,210,209,210,210,211,210,211,211,210,212,211,212,211,212,212,211,213,211,212,212,212,212,211,213,211,212,212,212,213,212,213,212,213,213,212,214,212,214,212,213,213,213,214,213,214,213,213,214,213,215,213,214,214,214,215,213,215,213,214,214,214,215,213,215,214,214,215,214,215,214,215,214,214,215,214,215,214,215,214,214,215,214,216,214,215,215,214,215,215,216,214,216,215,215,216,214,216,214,215,215,214,216,215,216,215,215,216,215,218,215,217,216,216,217,216,218,216,217,217,216,218,217,218,217,218,218,217,219,217,218,218,218,218,217,218,216,217,217,215,213,210,211,210,211,204,202,203,203,203,204,202,204,202,203,204,203,205,203,204,204,204,205,203,205,203,205,204,204,205,204,205,204,205,205,204,206,205,205,205,205,205,205,206,205,207,206,206,207,206,207,205,207,206,206,207,205,207,205,206,206,206,206,204,207,205,206,206,205,207,206,207,206,206,207,205,207,205,206,206,206,206,205,207,206,206,206,205,206,205,207,205,206,206,206,207,205,207,206,206,207,206,207,206,207,207,207,208,206,209,206,208,207,208,208,207,208,207,209,208,208,209,208,209,208,208,208,208,209,207,209,208,208,208,208,209,207,208,207,208,209,208,209,207,208,208,208,209,208,209,208,208,209,208,210,208,210,209,209,210,208,210,208,210,209,209,209,208,210,208,209,209,209,210,209,210,209,209,209,209,211,209,211,210,210,211,210,212,210,212,211,211,211,210,212,211,212,211,211,212,210,213,211,212,212,212,213,211,213,211,212,212,212,213,211,213,212,212,212,211,213,211,212,212,212,212,211,212,211,211,211,211,213,211,213,211,212,213,212,213,212,213,212,213,213,212,213,212,214,213,213,214,212,214,213,214,214,213,215,214,215,214,215,215,214,216,214,216,214,215,215,214,216,215,216,214,214,216,215,216,214,215,214,215,216,215,217,214,215,215,215,216,215,217,214,215,216,215,217,214,216,215,216,216,215,216,215,216,215,216,217,215,217,215,217,215,215,216,213,213,209,208,208,208,210,205,204,206,204,205,205,205,205,204,206,204,205,205,205,205,204,206,204,205,205,204,206,204,206,205,205,206,204,206,204,206,205,205,206,204,206,205,206,206,205,206,205,207,205,206,206,205,207,205,206,206,206,206,205,207,205,207,206,206,208,206,208,206,208,207,207,208,206,209,207,207,207,207,208,207,209,206,207,207,207,208,206,208,206,207,208,206,209,207,208,207,208,209,208,208,207,208,208,207,208,207,209,207,208,208,208,209,207,209,208,208,209,207,209,207,209,208,208,210,208,209,207,208,208,209,209,208,209,208,209,209,208,210,208,210,209,209,210,209,211,209,210,210,210,211,210,211,210,210,210,210,211,210,211,210,211,210,209,212,210,211,210,210,211,210,211,209,211,210,210,211,210,211,210,211,211,210,211,210,211,210,211,211,210,212,210,212,211,211,211,210,212,211,212,211,211,212,211,213,211,212,212,212,213,212,213,212,213,213,212,214,212,213,212,213,214,213,214,213,214,213,214,214,213,215,213,214,214,214,214,213,215,213,214,214,214,214,213,215,213,214,214,214,215,213,215,214,214,215,213,215,214,215,214,214,215,214,215,214,215,215,214,215,214,216,214,216,216,215,216,215,217,215,216,216,215,216,215,217,215,216,217,216,217,215,217,216,216,217,215,217,216,217,216,216,218,216,218,217,217,217,217,218,217,218,217,217,218,217,218,216,216,215,214,213,210,210,209,209,211,202,203,203,203,204,202,204,202,203,203,203,204,203,205,203,203,204,204,206,203,205,204,204,205,204,206,204,205,205,205,206,204,206,205,205,205,204,206,205,205,205,205,205,205,206,204,206,205,205,206,204,206,205,205,205,205,206,204,206,205,205,206,205,206,205,206,205,205,206,205,206,205,206,206,206,206,205,207,205,205,205,205,206,205,207,205,206,206,206,207,205,207,206,206,207,206,207,206,207,207,207,207,206,208,207,209,207,207,208,207,210,207,208,208,208,209,207,209,207,208,208,208,209,207,208,207,208,208,208,209,207,208,207,208,208,208,209,207,208,208,208,209,208,209,207,208,208,208,209,208,209,208,208,209,208,209,208,209,209,209,209,209,210,208,210,209,209,210,209,211,209,210,210,209,211,210,211,210,210,211,210,212,210,212,211,211,212,211,213,210,212,211,211,212,211,213,211,212,211,211,212,210,213,211,212,212,211,213,211,213,211,212,212,211,213,211,212,212,212,212,211,213,211,212,212,212,213,211,213,212,212,212,212,213,212,213,212,212,213,212,214,212,214,213,213,214,213,214,213,214,214,213,214,213,215,213,214,215,214,215,214,215,214,215,215,214,215,214,216,214,215,215,214,216,214,216,215,215,215,214,216,215,215,215,214,216,215,216,214,215,215,215,216,214,216,214,215,215,214,216,215,216,215,215,216,215,217,214,216,215,215,216,213,213,210,210,210,209,210,209,205,204,205,205,204,206,204,205,204,204,205,204,205,204,205,205,204,205,204,205,204,205,205,204,205,204,205,205,205,205,204,206,204,205,205,205,206,205,206,205,205,205,205,206,205,206,205,206,206,205,207,205,206,206,206,207,206,207,206,207,207,206,207,206,208,207,207,207,207,208,207,209,207,208,208,208,209,207,208,207,208,208,207,208,206,208,207,207,208,207,209,206,208,207,207,208,207,209,207,208,207,207,208,206,209,207,208,208,207,209,207,209,207,208,209,208,209,208,208,208,208,209,208,209,208,209,209,208,209,208,210,208,209,209,209,210,208,210,209,209,210,209,211,209,210,210,210,210,209,211,210,210,210,210,211,209,211,210,210,211,210,212,210,211,210,210,211,210,211,210,211,210,210,211,210,211,210,211,211,210,211,210,212,211,211,211,210,212,210,212,211,211,211,211,212,211,213,211,211,213,211,213,212,213,213,212,214,212,214,212,213,213,213,214,213,214,213,213,213,213,214,213,214,213,213,214,212,215,213,214,213,214,214,213,215,213,214,214,214,214,213,215,213,213,214,213,215,213,214,214,214,214,213,215,213,214,214,214,215,214,215,214,215,215,214,215,214,216,214,215,215,214,216,215,217,215,215,216,215,218,215,217,216,216,217,216,217,216,216,216,216,218,216,217,216,217,217,216,218,216,218,217,217,218,217,218,217,218,217,217,218,216,216,213,213,212,211,212,211,213,203,201,203,202,203,203,202,204,202,205,203,203,204,203,205,203,205,204,205,205,204,205,204,205,204,204,205,203,205,204,205,205,204,206,205,205,205,205,206,205,206,205,206,205,205,206,204,206,204,205,205,205,205,204,206,204,205,205,204,206,205,206,205,206,206,205,207,205,206,205,206,206,205,206,205,206,205,205,206,205,207,205,206,206,206,207,205,207,206,207,207,206,207,206,207,206,207,207,206,208,206,208,206,207,207,206,208,207,208,207,207,208,207,210,207,208,208,208,209,207,209,207,208,208,208,209,207,208,207,208,208,208,209,207,208,207,208,208,208,209,208,208,208,207,209,207,209,207,209,209,208,209,208,209,208,209,209,208,210,209,209,209,209,210,209,211,209,209,210,210,211,209,210,209,210,211,210,211,210,212,211,211,211,210,212,211,212,211,211,212,210,212,210,211,211,210,212,211,212,210,211,211,211,212,210,212,211,211,211,211,212,210,212,211,211,212,210,213,211,212,211,211,212,210,213,211,212,212,212,213,211,213,212,212,213,212,214,212,213,213,213,214,213,215,213,214,214,214,214,213,215,213,214,214,214,215,213,215,214,214,214,214,215,214,215,214,215,215,214,215,214,215,215,215,215,214,216,215,216,215,214,215,214,216,214,216,215,214,215,214,216,215,215,215,214,216,215,216,215,215,216,215,217,215,216,215,216,216,215,217,216,216,215,214,214,213,215,214,214,215,204,204,205,204,205,204,204,205,204,206,204,205,204,204,205,204,205,204,205,205,205,205,204,206,204,205,205,205,206,204,206,204,205,205,205,206,204,206,205,205,205,205,206,205,207,205,205,206,205,207,205,206,206,206,206,206,207,205,207,207,206,207,206,207,206,207,207,207,208,206,208,206,207,207,207,208,206,208,206,207,207,206,208,207,208,206,207,207,206,208,207,208,207,207,208,207,209,206,207,207,207,209,207,209,207,208,208,208,209,207,208,207,208,208,208,209,208,208,208,208,209,208,210,208,209,209,208,210,209,209,209,209,210,209,210,208,210,209,209,210,209,211,209,210,210,210,210,209,211,210,210,210,210,211,209,211,210,210,210,210,211,209,211,210,210,211,210,211,210,210,210,210,211,209,211,210,211,211,210,211,210,211,210,211,211,210,211,210,211,210,210,211,210,212,210,212,211,211,212,211,213,211,213,212,212,212,210,212,211,212,212,212,213,212,213,212,213,213,212,214,213,213,213,213,214,213,214,213,214,213,213,215,213,215,213,214,214,213,214,213,214,213,214,214,214,215,213,215,214,214,215,214,215,214,215,214,214,216,214,216,214,215,215,214,216,214,216,214,215,215,215,216,215,217,215,215,216,215,218,215,217,216,216,217,216,217,216,217,217,216,217,216,218,216,217,217,216,218,216,218,217,217,217,216,218,216,217,217,216,217,216,217,216,216,216,216,217,215,216,215,201,203,203,203,203,203,204,202,204,203,203,204,203,205,203,204,204,204,205,203,205,203,204,204,204,205,203,205,204,205,205,204,205,204,205,204,204,205,204,205,204,205,205,204,205,204,205,204,205,204,204,205,204,205,204,205,205,204,206,204,205,205,205,205,205,206,204,206,205,205,205,205,207,205,206,206,206,206,205,207,205,206,206,206,207,205,207,206,206,207,206,208,206,208,206,207,207,206,208,207,208,207,207,207,207,209,207,208,207,207,208,207,210,207,208,208,208,209,207,208,207,208,208,208,209,207,208,207,207,208,207,209,207,207,207,207,209,207,209,207,208,208,208,209,207,208,207,209,209,208,209,208,209,208,209,209,208,210,209,209,209,209,210,209,211,209,209,210,209,211,209,210,209,210,211,210,211,210,211,210,210,211,210,211,210,211,210,210,212,210,212,210,211,211,210,211,210,212,211,211,211,211,212,210,212,210,210,211,210,212,209,211,211,211,212,211,213,211,212,212,212,213,211,213,211,212,212,212,213,211,213,212,212,213,212,213,212,213,213,213,214,213,214,213,214,214,214,215,213,215,213,214,214,214,215,213,215,214,214,214,214,215,213,215,214,214,214,213,215,214,214,214,214,215,214,215,214,214,215,214,215,214,215,214,215,215,214,216,214,215,214,214,215,214,216,214,215,214,214,216,215,217,214,216,216,216,217,216,217,216,216,216,216,217,216,217,216,216,217,216,203,204,203,205,203,204,204,204,204,203,205,204,204,205,203,205,204,205,204,204,205,204,205,204,205,205,204,205,204,205,204,205,205,204,205,204,205,205,205,205,205,206,204,206,205,205,206,205,207,205,206,206,206,206,205,207,206,207,207,206,207,206,207,206,207,207,206,208,206,208,206,207,207,207,208,207,208,207,207,207,206,208,207,208,206,207,207,206,208,207,208,207,207,208,207,209,206,207,207,207,209,207,208,207,207,207,207,209,207,209,207,208,208,208,209,208,208,208,208,209,208,209,208,208,209,208,210,208,209,209,209,209,208,210,208,210,209,209,210,209,210,209,210,210,209,210,209,210,209,210,210,209,210,210,210,209,210,210,209,211,210,211,210,210,211,209,211,210,210,210,210,211,210,211,210,210,211,210,211,210,211,210,211,211,210,212,210,212,211,211,212,211,213,211,212,212,212,212,211,213,211,212,212,212,213,211,213,212,213,213,212,213,212,214,213,213,214,213,215,213,214,213,213,214,213,214,213,213,213,213,214,212,214,213,213,213,213,214,213,214,213,214,214,213,214,213,214,213,213,214,213,215,213,214,214,214,214,213,215,214,214,215,214,215,214,216,215,215,215,214,216,215,217,215,215,216,215,218,215,216,216,216,217,216,217,215,217,217,217,217,216,218,216,217,217,216,218,216,218,217,217,217,217,218,217,218,217,217,218,217,218,217,217,217,217,218,216,218,216,217,203,202,204,202,204,202,203,203,203,204,203,205,203,204,204,204,205,203,204,204,204,205,203,205,204,205,205,204,205,204,205,204,204,205,204,205,204,205,204,204,205,204,205,204,205,205,204,205,204,206,204,205,205,204,205,204,205,204,205,205,204,205,204,205,205,205,205,204,206,205,206,205,205,206,205,207,205,206,206,205,207,206,206,205,206,206,206,207,205,207,206,206,207,206,207,206,207,207,207,207,207,208,207,208,207,207,208,207,209,207,208,207,207,208,207,209,207,208,208,208,209,207,208,207,208,208,208,208,207,208,207,207,208,207,209,207,208,207,208,208,208,208,207,208,208,208,208,208,209,208,208,209,208,210,208,209,209,209,209,209,211,209,210,210,210,210,209,211,209,210,210,210,211,210,211,210,210,210,210,211,210,211,210,210,211,210,211,210,211,211,210,211,210,211,210,211,211,210,211,210,211,211,211,211,210,212,210,211,210,210,211,210,211,210,211,211,211,212,211,212,211,212,211,211,213,211,213,211,212,212,212,213,212,213,212,212,213,212,214,212,213,213,213,214,213,214,213,213,213,213,214,213,215,213,214,214,214,215,214,215,214,214,215,213,215,214,214,214,214,215,213,215,214,214,215,214,215,214,215,214,215,215,214,215,214,216,214,215,215,214,216,214,216,214,215,215,214,216,215,216,215,215,216,215,217,215,217,216,216,218,216,217,216,216,217,216,217,215,216,216,203,204,204,204,204,203,205,203,204,204,204,205,204,205,204,204,205,203,205,203,205,203,204,205,204,205,203,205,205,205,205,204,205,204,205,205,204,206,205,206,205,205,206,205,207,205,206,206,206,206,205,207,206,206,206,206,207,206,207,206,207,207,206,207,206,208,206,207,207,206,207,206,207,206,206,207,206,207,206,207,206,206,207,206,207,206,207,207,206,207,206,207,206,207,207,206,208,206,208,206,207,207,206,208,207,209,207,207,208,208,210,207,208,208,209,209,208,210,208,208,209,209,210,208,210,209,209,210,209,210,209,210,209,209,210,209,210,209,210,209,209,210,208,210,209,209,209,209,210,208,210,209,209,210,209,210,209,210,210,210,210,209,211,209,210,210,210,211,209,211,210,210,210,209,211,209,210,210,210,210,210,211,210,211,210,211,212,211,213,211,212,212,212,212,211,213,211,213,212,212,213,211,213,211,212,213,212,213,211,213,212,212,213,212,214,212,213,213,213,213,212,214,213,213,213,213,213,212,214,212,213,213,212,214,213,214,212,213,214,213,214,213,214,213,214,215,213,215,214,214,214,214,215,214,215,214,214,215,214,215,214,215,214,215,215,214,216,215,216,215,216,215,215,216,215,217,216,216,216,215,217,215,216,216,216,217,215,217,215,217,217,216,217,216,217,216,216,217,216,218,216,217,216,216,217,216,217,216,217,217,216,217,216,217,216,217,217,216,217,216,202,203,204,203,204,203,204,203,204,204,203,204,203,204,203,204,204,203,205,204,204,204,204,205,203,205,204,204,204,204,205,203,205,204,204,205,203,205,204,204,204,204,204,203,205,203,204,204,204,205,203,205,204,205,205,204,205,204,205,204,204,205,204,205,204,205,204,205,205,204,206,205,206,206,206,206,205,207,206,206,206,206,207,206,207,206,206,207,206,207,206,207,206,206,207,206,207,206,207,207,207,207,206,208,207,208,207,207,208,207,209,207,207,207,207,209,207,209,207,207,208,207,210,207,208,207,208,208,207,208,207,208,207,208,208,207,208,207,208,208,208,208,207,209,207,208,208,208,209,208,209,208,208,209,208,209,208,209,209,209,210,209,210,209,209,210,209,211,209,211,209,210,210,210,210,209,210,210,210,210,209,211,210,210,210,210,211,210,211,210,211,211,210,211,210,211,210,210,211,210,211,210,211,210,210,211,210,212,210,212,211,211,212,210,213,211,212,212,212,213,211,213,211,212,212,212,213,211,213,212,212,213,212,213,212,213,212,212,214,212,214,213,213,213,213,214,213,214,213,214,214,213,214,213,214,213,214,214,213,214,213,214,213,214,214,213,215,214,214,214,214,215,213,215,214,214,214,214,215,213,215,214,214,215,214,215,214,215,215,215,215,214,216,214,216,215,215,216,215,217,215,216,216,216,216,215,217,215,216,216,216,217,216,217,216,216,217,216,218,216,204,203,204,204,203,205,203,204,204,204,204,203,204,203,203,204,203,206,203,204,204,204,205,203,205,204,204,204,204,205,204,205,204,205,205,205,206,204,206,205,205,206,205,206,205,206,206,206,206,205,207,205,206,206,206,207,205,207,206,206,206,206,207,206,207,206,207,207,206,207,206,207,207,206,207,206,208,206,207,206,206,208,206,208,205,207,206,206,208,206,208,206,208,207,207,208,206,209,207,207,207,207,209,207,209,207,207,208,207,210,207,209,208,208,210,208,209,208,208,209,208,210,208,209,209,209,209,208,210,208,210,209,208,210,208,209,208,209,209,209,210,208,210,209,209,210,209,210,209,210,209,210,210,209,210,209,210,210,210,210,209,211,209,210,210,210,211,209,211,210,210,210,210,211,209,211,210,210,210,210,212,210,212,211,211,212,211,213,211,212,212,212,212,212,213,211,213,212,212,213,212,213,212,212,212,212,213,211,213,212,212,213,212,213,211,213,212,213,213,212,213,212,213,213,212,213,211,212,211,212,212,211,212,211,213,211,213,213,212,214,212,213,213,213,214,213,214,213,214,214,214,214,213,215,214,214,214,214,215,214,215,214,215,215,215,216,214,216,215,215,215,215,217,215,217,215,216,216,216,217,215,217,216,216,217,216,217,215,216,216,216,217,216,217,216,216,216,216,217,216,217,216,216,217,216,217,215,217,216,216,217,216,218,216,217,217,216,218,216,218,203,202,204,203,203,203,203,204,203,205,203,203,204,203,205,203,204,204,204,205,203,205,203,204,204,204,205,203,205,204,204,205,204,206,203,205,204,204,205,204,205,204,205,204,204,205,204,205,204,205,205,204,205,204,205,204,205,205,204,206,204,205,205,205,205,205,206,204,206,206,205,206,205,207,205,206,206,206,207,205,207,206,206,207,206,207,206,207,206,207,207,206,207,206,207,206,206,207,206,207,206,207,206,206,208,206,208,206,207,207,207,208,207,209,207,207,208,207,210,206,208,207,208,208,207,208,207,209,207,208,208,207,208,207,208,207,207,208,207,209,207,208,208,208,209,208,209,208,208,209,208,210,208,209,209,209,210,209,210,209,210,210,210,211,209,211,210,210,210,209,211,209,210,210,210,210,209,211,209,210,210,210,211,210,211,210,210,210,210,211,210,211,210,211,211,210,211,210,211,210,210,211,210,211,210,211,210,210,211,210,211,210,211,211,210,211,210,212,211,212,212,211,213,211,213,211,210,210,209,210,209,211,211,211,212,211,213,212,213,213,213,214,213,214,213,214,214,213,214,213,214,213,213,214,213,214,213,214,213,214,214,213,215,213,215,214,214,215,213,215,214,214,214,214,215,213,215,214,215,215,214,215,214,215,214,215,215,214,215,214,216,215,215,215,214,216,215,216,215,215,216,215,217,215,216,215,215,217,215,217,216,216,216,216,217,216,217,216,216,217,204,203,204,203,205,203,204,204,203,204,203,205,204,204,205,204,205,204,205,204,204,205,204,205,204,205,204,204,206,204,206,205,205,206,204,206,204,206,205,205,206,205,207,205,206,205,205,206,205,207,205,206,206,206,207,205,207,206,206,206,206,206,205,207,206,206,206,205,207,205,206,206,206,206,205,207,206,207,206,206,207,206,207,206,207,207,206,207,206,207,206,207,207,206,208,206,208,206,207,207,206,208,207,208,207,208,208,208,209,208,209,208,208,209,208,209,208,209,209,208,210,208,209,208,209,209,208,210,208,210,209,209,210,208,210,208,210,209,208,210,208,209,209,209,208,208,210,208,209,208,209,209,208,210,209,210,209,209,210,209,211,209,210,210,210,210,209,211,209,210,210,210,210,209,211,209,210,211,210,211,210,211,211,211,211,211,213,211,212,212,212,212,211,213,211,212,212,212,212,211,213,212,212,212,212,213,211,213,212,212,213,212,213,211,213,212,212,212,212,213,211,213,213,213,213,211,212,210,210,209,209,211,210,212,211,212,212,212,213,212,213,213,213,213,212,214,213,214,213,213,215,213,215,214,214,214,214,215,214,216,215,215,215,214,216,215,216,214,215,215,214,216,215,216,215,216,216,215,217,215,217,216,216,217,216,217,216,216,217,216,217,216,217,216,216,217,215,217,215,217,216,216,217,215,217,215,217,216,216,217,216,217,216,217,217,217,217,216,218,217,203,204,203,204,204,204,205,203,205,204,204,204,204,205,203,204,204,204,204,203,204,203,204,203,203,205,203,204,203,204,204,203,205,203,205,204,204,205,203,205,204,205,204,204,205,203,205,204,205,205,204,205,204,205,204,204,205,204,205,204,205,204,205,206,205,206,205,206,206,206,206,205,207,206,206,206,206,207,205,207,206,206,207,206,207,206,207,206,207,207,206,208,206,208,206,207,207,206,208,207,208,206,206,207,206,208,207,207,207,206,208,207,209,206,207,208,207,210,206,208,207,208,208,207,208,207,208,207,207,208,207,209,207,208,207,208,208,207,208,207,208,208,208,209,208,209,208,208,209,208,209,208,209,208,208,210,208,210,209,209,209,209,210,209,211,209,209,210,210,210,209,210,210,210,210,209,211,209,210,210,210,210,209,211,210,210,210,210,211,210,211,210,210,211,210,211,210,211,210,210,211,210,211,209,211,210,210,211,209,211,210,211,211,211,212,211,213,211,211,212,211,213,211,212,212,212,211,210,210,208,209,209,210,211,211,213,211,213,213,212,213,213,213,213,214,213,213,214,213,214,213,213,214,213,214,213,214,213,213,214,213,214,213,214,213,213,214,213,214,213,214,214,213,215,213,215,214,214,215,214,215,214,215,214,214,215,214,215,214,215,214,215,215,214,216,215,216,215,215,216,215,217,215,216,216,216,217,216,217,216,216,217,216,218,216,217,216,217,217,216,203,204,203,205,203,204,204,204,204,203,204,204,204,204,203,205,203,205,204,204,205,204,205,204,205,205,205,206,205,206,205,206,206,205,207,205,206,206,206,206,205,207,205,206,206,206,207,205,207,206,207,206,206,207,206,207,206,206,206,206,207,205,207,206,206,207,206,207,205,207,206,206,207,206,207,206,207,207,206,208,206,208,206,207,207,206,208,207,208,206,207,207,207,208,207,208,206,207,207,207,209,207,208,207,208,208,208,209,208,208,208,208,209,208,209,208,209,209,208,210,208,210,209,209,210,208,210,209,209,209,209,209,208,210,208,209,209,208,209,208,209,208,209,209,208,209,208,209,208,209,209,208,210,209,210,209,209,210,209,211,209,210,210,210,211,209,211,210,210,210,210,211,209,211,210,211,211,210,212,210,211,211,211,212,211,213,211,212,212,212,213,211,213,211,213,212,212,212,211,211,211,210,210,210,211,210,211,210,211,212,211,213,211,213,212,212,213,212,213,212,213,213,212,213,211,213,212,212,211,210,210,209,210,210,212,212,211,213,212,213,213,213,214,212,214,213,214,214,214,214,213,215,214,214,215,214,215,214,215,214,215,215,214,216,215,216,215,215,216,215,218,215,217,216,216,217,216,218,216,216,217,216,217,216,217,216,216,216,216,217,215,216,215,216,216,216,217,215,216,216,216,216,215,217,215,216,216,216,217,216,217,216,217,217,217,218,216,218,217,217,204,202,204,204,203,205,203,204,203,204,205,203,205,203,204,204,204,204,203,205,203,204,204,204,205,203,205,204,204,204,204,205,203,204,204,204,204,204,205,203,205,204,204,205,203,205,204,204,204,204,205,203,205,204,204,205,204,205,204,205,205,205,205,205,206,204,206,205,205,207,205,206,205,206,206,206,207,205,207,206,206,207,206,208,206,208,206,206,207,206,208,206,208,206,206,207,206,208,206,207,206,206,208,206,208,206,207,207,206,208,207,208,206,207,207,207,209,207,208,206,207,207,207,208,207,208,207,207,208,207,210,207,208,208,208,208,207,209,207,208,208,208,209,208,209,208,208,209,208,210,208,209,209,209,210,208,210,209,209,210,209,210,208,210,209,209,210,209,210,209,210,209,209,210,209,211,209,210,210,210,211,209,211,210,210,210,210,211,209,211,210,210,211,210,211,209,211,209,207,207,206,206,205,206,206,206,207,208,210,209,210,210,210,212,210,212,211,212,212,212,213,211,213,212,212,213,212,213,210,209,208,208,208,208,210,210,211,211,211,213,212,213,212,213,213,212,214,213,213,213,213,213,213,214,213,214,213,214,214,213,214,213,214,213,213,214,213,215,213,213,214,213,214,213,215,214,214,215,214,215,214,215,214,214,215,214,216,214,216,215,215,215,214,216,215,216,215,215,216,215,217,215,216,216,216,217,216,217,216,216,217,216,217,216,217,216,216,217,216,217,203,204,204,204,205,203,205,204,204,205,204,205,203,205,204,204,205,204,205,203,204,204,204,205,204,206,204,205,205,205,206,204,206,205,205,206,205,206,205,206,205,205,206,205,207,205,207,206,205,207,205,206,205,207,206,205,207,205,206,205,206,206,205,206,205,206,205,206,206,205,207,205,206,206,206,206,205,207,206,206,206,206,207,206,207,206,207,207,207,208,206,209,207,207,207,207,208,207,209,206,207,208,207,210,207,208,208,208,209,208,209,208,209,209,208,210,208,210,208,209,209,208,210,208,209,209,209,209,208,210,208,209,208,208,209,208,209,208,208,208,208,209,207,209,208,209,209,208,210,208,209,208,209,209,208,210,208,209,209,209,210,209,210,209,210,210,210,210,210,211,210,210,211,210,212,210,212,211,211,211,210,212,211,212,211,211,212,211,213,211,212,212,212,213,212,213,212,212,210,208,208,206,207,206,207,208,207,210,208,210,210,211,212,211,213,211,213,213,213,213,212,214,213,213,213,212,213,212,211,208,208,209,208,209,208,210,210,211,212,211,213,212,213,213,213,214,213,215,214,214,214,214,215,214,215,214,215,215,214,216,214,216,215,215,215,214,217,215,216,215,215,216,215,217,215,216,216,216,216,215,217,215,216,216,216,216,215,216,215,215,216,215,217,215,216,215,216,216,216,217,215,216,216,216,216,215,217,216,216,216,216,217,216,217,216,217,217,217,218,217,203,203,204,203,205,203,204,203,204,204,203,204,203,204,203,203,204,203,205,203,203,203,203,205,203,204,203,204,204,203,205,203,205,204,204,204,203,205,203,204,204,204,205,203,205,204,204,205,204,205,204,205,204,205,205,204,205,204,205,205,205,206,204,206,205,205,205,205,206,205,207,205,206,206,206,207,205,207,206,206,207,206,207,206,207,206,207,207,206,207,206,207,206,206,207,206,207,206,206,206,206,207,206,207,206,207,207,206,208,206,208,206,207,207,206,208,207,208,206,207,207,207,208,207,208,207,207,208,207,210,207,208,207,208,209,208,208,208,208,208,208,209,207,209,208,208,209,208,209,208,209,208,208,209,208,210,208,209,209,209,210,208,210,209,209,210,208,210,209,210,209,210,210,209,211,209,210,210,210,210,209,211,210,210,210,210,211,210,211,210,210,211,210,212,210,211,210,210,210,208,208,207,207,207,207,207,207,209,208,209,209,209,211,210,211,211,211,212,212,213,211,212,212,212,213,212,213,211,211,208,208,210,209,210,210,210,210,210,212,211,213,212,212,212,212,214,212,213,213,213,213,213,214,212,214,213,213,214,213,214,213,214,213,213,215,213,215,214,214,214,214,215,213,214,214,214,214,214,215,214,215,214,214,215,214,216,214,216,215,215,215,215,216,215,216,215,215,216,215,218,216,216,216,216,217,216,217,216,216,217,216,217,216,217,216,217,217,216,217,216,203,203,203,204,203,205,203,203,204,203,205,203,204,204,204,205,204,205,204,205,205,204,205,204,206,204,205,205,204,205,205,206,204,206,206,205,206,205,206,205,206,206,205,207,205,206,206,206,206,205,206,205,206,206,205,206,205,206,205,206,206,205,207,205,206,205,206,206,205,207,205,206,206,206,206,206,207,205,207,207,206,207,206,207,206,207,207,206,208,206,208,206,207,207,206,208,207,208,206,207,208,207,209,207,208,208,208,209,207,209,207,208,208,209,209,208,209,208,209,209,208,209,208,209,208,208,209,208,209,208,208,208,208,209,207,209,208,209,209,208,209,208,210,208,209,209,208,209,208,210,208,209,209,208,210,209,209,209,209,210,209,211,209,210,210,210,211,210,211,210,211,211,210,212,210,212,211,211,211,211,213,211,212,211,211,212,211,213,211,212,212,212,213,212,213,212,212,212,212,212,209,210,209,209,209,208,209,208,208,208,209,210,210,211,209,211,211,211,212,210,212,210,212,211,211,212,211,212,210,208,208,208,210,209,210,209,209,211,211,213,212,213,213,213,214,213,215,214,214,214,214,215,214,216,214,215,215,215,216,214,216,215,215,216,215,217,215,216,215,216,216,216,216,215,216,216,216,216,215,217,215,216,216,216,216,215,217,215,216,216,216,217,215,216,216,216,216,216,217,216,217,216,216,217,216,217,216,217,217,216,217,216,217,216,217,217,216,218,216,218,204,202,205,203,203,204,203,205,203,204,203,204,204,203,204,203,204,204,203,204,203,205,203,203,204,203,205,203,204,203,204,205,203,204,203,205,203,203,205,203,205,203,205,204,204,205,203,205,204,205,205,204,205,204,205,204,204,205,204,206,204,205,205,205,206,204,206,205,205,205,205,206,205,207,205,206,206,206,207,205,207,206,206,207,206,207,205,206,206,206,206,205,207,205,205,206,205,206,205,206,206,206,206,206,207,206,207,206,207,207,206,208,206,208,206,206,207,206,208,207,208,207,207,208,207,209,207,208,207,207,209,207,209,207,208,208,208,209,207,208,208,208,208,208,209,207,208,208,208,209,208,210,208,209,209,208,210,208,210,208,209,209,209,210,208,210,209,209,210,209,211,209,210,210,209,210,209,210,209,210,210,209,211,210,211,210,210,210,210,211,210,211,210,210,211,210,211,210,211,210,209,209,208,208,208,208,208,207,207,206,208,208,210,209,207,208,207,209,207,208,207,207,208,207,210,208,209,209,207,208,206,208,207,208,209,209,209,209,211,211,211,212,211,213,212,212,213,212,213,212,213,213,213,213,213,214,212,214,213,213,214,213,214,213,214,214,213,215,213,214,214,214,214,214,215,213,215,214,214,215,214,215,214,215,215,215,216,215,216,214,216,215,215,216,215,217,215,216,216,216,216,215,216,215,216,216,216,217,216,217,216,216,217,216,217,216,217,217,216,217,203,204,203,204,204,203,204,203,204,204,204,204,203,205,204,204,204,204,206,204,206,204,205,205,204,205,204,206,204,205,205,205,206,204,206,205,205,206,205,207,205,206,205,205,206,205,207,205,205,205,205,207,205,206,205,206,206,206,206,205,206,206,206,206,205,207,205,206,206,206,206,206,207,205,207,206,206,207,205,207,206,206,207,206,207,206,207,207,207,207,207,208,206,209,206,207,208,207,209,207,208,208,208,208,207,209,207,209,208,208,210,208,209,208,208,209,208,209,208,209,208,208,209,208,209,208,209,208,208,209,208,209,208,208,208,208,209,207,209,207,208,208,208,209,208,209,208,208,209,208,210,208,209,209,209,209,208,210,209,209,209,209,210,209,210,209,210,210,210,211,210,211,210,210,211,211,211,210,212,211,211,212,211,213,211,212,212,212,212,211,213,211,212,212,212,213,211,212,211,212,212,211,212,210,211,210,209,209,208,208,208,209,209,207,207,206,208,207,207,206,205,207,207,207,207,207,208,207,207,205,206,207,208,208,209,210,210,211,211,211,212,211,213,211,213,213,213,214,213,215,214,214,214,214,215,214,215,214,215,215,214,216,215,216,215,215,216,215,217,215,215,215,215,216,215,216,215,215,215,215,217,215,216,215,216,216,216,217,215,216,215,216,216,216,217,215,217,216,216,217,216,217,216,216,216,216,218,216,217,216,217,218,217,218,217,218,218,218,218,218,202,204,203,203,204,203,204,202,204,203,203,204,202,204,203,203,203,203,204,203,204,203,203,204,202,205,202,204,203,203,204,203,205,203,204,204,204,205,203,205,203,204,204,204,205,203,205,204,204,205,204,205,204,205,205,205,206,205,206,204,206,206,205,206,205,206,205,206,206,205,206,205,206,205,206,206,205,207,205,206,206,206,206,205,207,205,206,206,206,207,206,207,206,206,206,206,207,206,207,206,207,207,206,207,206,207,206,206,207,206,208,206,208,206,207,207,206,208,207,208,207,207,207,207,209,207,208,207,207,208,207,210,207,208,208,208,209,207,209,207,208,209,208,209,208,208,208,208,209,208,209,208,209,209,209,209,208,209,209,209,209,208,210,208,209,209,209,209,208,210,208,209,209,209,210,209,210,209,209,210,210,211,209,211,210,210,211,210,211,210,211,210,210,211,210,212,210,212,211,211,211,210,211,210,211,210,207,208,207,208,207,207,207,205,207,207,208,207,207,207,207,209,208,209,208,208,208,206,206,205,206,206,207,208,207,210,209,211,211,211,212,210,212,211,211,212,212,214,211,213,213,213,213,213,214,213,214,213,213,214,213,214,213,213,213,213,214,213,214,213,214,214,214,215,214,215,214,215,215,215,216,215,216,215,215,215,215,217,215,216,215,215,216,215,217,215,216,216,216,217,215,217,216,216,216,216,217,216,217,216,216,217,216,217,216,216,216,216,217,216,204,203,204,204,203,205,203,204,204,204,205,204,205,204,204,204,204,205,204,205,204,205,205,204,206,204,205,205,205,205,205,206,204,206,205,205,206,204,206,205,205,205,205,206,205,206,205,205,205,205,206,205,206,205,206,206,205,207,205,206,205,206,206,205,206,205,206,205,205,207,205,207,206,206,206,206,207,206,207,206,207,207,206,207,206,207,206,207,207,206,208,206,208,206,207,207,207,209,207,208,207,208,208,207,209,207,208,207,208,209,208,208,208,208,208,207,209,207,209,208,208,209,208,209,208,208,208,208,209,208,209,208,208,209,208,209,207,209,208,209,209,208,209,208,208,208,208,209,208,209,208,209,209,209,210,208,210,209,210,210,210,211,209,211,210,210,210,210,211,210,211,210,211,211,211,212,211,212,211,211,212,211,213,211,212,212,212,213,211,213,211,212,212,212,212,211,212,211,211,211,210,211,209,209,209,209,209,207,208,207,209,207,207,207,206,209,208,209,208,208,210,210,210,210,210,210,209,208,207,207,207,207,209,209,211,209,211,211,212,213,213,213,213,214,214,214,214,213,215,214,214,214,214,216,214,216,215,215,215,215,216,215,216,215,215,216,215,217,214,216,215,215,216,215,217,215,216,216,216,216,215,216,215,216,216,216,217,215,217,216,216,217,216,217,216,216,216,216,217,215,217,216,217,217,216,217,216,218,217,217,218,217,218,217,218,218,218,218,218,219,203,202,202,204,202,204,202,203,203,203,204,202,204,202,203,203,203,205,203,204,203,204,204,203,204,203,204,203,204,204,203,204,203,205,204,204,205,203,205,203,205,205,204,205,204,205,204,204,205,204,206,204,205,204,204,205,204,206,204,205,205,205,205,204,206,204,205,205,205,206,204,206,205,205,206,205,207,205,206,205,206,206,205,207,206,206,206,206,207,205,207,206,206,206,206,207,205,207,206,206,207,206,207,206,207,206,206,207,206,207,206,207,207,207,207,206,208,207,208,207,207,208,207,209,207,208,208,208,209,208,209,207,208,208,208,209,207,209,208,208,209,208,210,208,208,208,208,209,207,209,207,209,208,208,209,208,209,208,209,209,208,210,208,209,209,209,209,209,210,209,210,209,209,210,209,211,209,210,210,210,211,209,211,210,210,210,210,211,209,211,210,210,211,210,211,210,211,210,209,210,208,208,206,207,206,205,206,206,207,206,206,206,206,207,207,208,208,209,209,209,211,210,211,211,210,210,208,208,207,207,208,208,210,209,211,210,210,212,212,213,211,213,212,212,213,212,213,212,213,212,212,213,212,214,212,213,213,213,214,213,214,213,214,214,213,214,213,215,214,214,215,214,215,214,215,214,214,215,214,215,214,215,215,215,215,215,216,215,216,215,215,216,215,217,215,216,216,216,216,215,216,215,216,216,216,217,215,217,216,216,217,216,218,216,217,216,216,218,216,217,203,203,204,203,205,203,205,204,204,205,204,205,203,205,204,204,205,203,205,204,205,205,204,205,204,206,205,205,205,205,206,204,206,205,205,206,204,206,204,205,205,205,205,204,206,205,205,205,205,206,205,206,205,205,205,205,206,205,206,205,205,206,205,206,205,206,205,205,206,205,206,205,206,206,206,207,206,207,206,207,207,207,208,206,208,206,208,207,207,208,206,209,207,208,208,208,209,207,208,208,208,208,208,209,207,208,208,208,209,208,209,208,208,208,208,209,208,209,208,208,209,208,209,207,209,208,208,208,208,209,208,208,208,208,209,208,209,208,208,208,208,209,207,209,208,209,209,208,209,207,208,208,209,209,208,210,209,209,209,210,211,209,211,210,210,211,210,211,210,211,210,211,211,210,212,210,212,211,211,212,211,213,211,212,212,212,212,211,213,211,212,212,212,212,211,212,211,211,210,209,210,208,207,207,206,207,207,208,207,208,207,208,208,208,209,208,209,209,209,210,210,212,211,212,211,210,210,209,209,209,210,211,211,213,212,213,213,213,214,213,215,214,214,214,214,214,212,213,213,213,213,213,214,213,214,213,214,215,214,215,214,215,214,215,216,215,216,214,216,215,215,216,215,217,215,216,215,215,216,215,217,215,216,216,216,217,216,217,216,216,217,216,218,216,217,217,216,217,216,218,216,217,217,217,218,216,218,217,217,218,217,218,217,218,218,218,218,218,219,218,203,202,203,202,203,202,203,202,202,204,202,204,202,203,203,202,204,202,204,202,203,204,203,205,203,204,203,204,204,203,204,203,205,204,204,205,203,205,204,205,205,204,205,204,205,205,205,205,204,206,204,205,205,205,205,204,206,205,206,205,205,206,205,206,205,206,206,205,206,205,207,205,206,206,205,207,205,206,206,206,206,206,207,205,207,206,206,207,205,207,206,206,206,206,207,206,207,206,207,207,206,207,206,207,206,207,207,206,208,206,208,206,207,207,206,208,207,208,207,207,208,207,210,207,208,208,208,209,208,209,207,207,208,207,210,207,208,208,209,209,208,208,207,208,208,208,208,208,209,207,208,208,208,209,208,210,208,209,209,208,210,208,209,209,209,209,208,210,209,210,209,209,210,209,210,209,209,210,209,211,209,211,210,210,211,210,211,210,211,211,210,211,210,210,209,210,210,209,209,208,208,208,208,207,207,208,207,209,208,208,207,207,208,207,209,208,209,209,209,210,210,211,211,211,211,210,211,210,209,209,210,212,211,213,211,212,212,212,213,211,213,212,212,212,211,212,210,212,211,211,212,211,213,211,213,213,213,213,213,214,213,214,214,213,215,214,214,214,215,215,214,216,215,216,215,215,216,215,217,215,216,216,216,216,215,217,215,216,216,216,217,215,217,216,217,217,216,217,216,217,216,216,217,216,217,216,217,216,216,217,216,217,216,217,217,216,217,216,218,216,203,204,203,205,204,205,204,204,205,204,206,204,205,205,205,205,204,206,204,205,205,204,205,205,205,204,205,205,204,206,205,206,205,205,205,204,206,204,205,205,205,205,204,206,204,205,205,205,206,205,206,205,205,205,205,206,204,206,205,205,205,205,206,205,206,205,205,206,205,207,205,206,206,206,207,205,207,206,207,207,206,208,206,208,206,207,207,208,211,211,210,208,209,209,208,209,207,208,208,208,208,207,209,207,208,208,208,208,207,209,207,208,208,208,209,207,208,207,208,208,208,209,207,208,208,208,208,208,209,208,208,208,208,209,208,209,208,209,209,208,209,208,209,208,209,209,208,210,208,209,209,209,210,209,211,209,210,210,210,211,209,211,210,210,211,210,211,210,211,211,211,212,211,212,211,212,211,212,212,211,212,211,212,211,211,212,210,212,211,212,211,211,211,209,210,209,209,209,208,209,208,208,207,207,208,207,210,207,208,207,208,208,207,208,207,209,208,209,211,210,212,212,212,213,212,213,212,213,212,212,213,212,213,212,213,213,212,212,212,213,212,213,213,213,214,213,214,213,214,214,214,215,214,215,215,215,215,214,216,214,216,214,215,215,214,216,215,216,215,215,216,215,217,215,216,216,216,217,216,217,216,216,216,216,217,215,216,216,216,216,216,217,216,216,216,216,217,216,217,216,217,217,217,218,217,219,217,218,218,218,218,217,218,218,218,218,218,219,218,219,203,203,203,204,202,204,203,202,204,202,204,202,203,203,203,204,203,204,203,203,204,203,205,203,204,203,204,204,204,204,203,204,204,204,204,203,205,204,204,204,204,205,203,205,204,204,205,204,206,204,205,205,205,205,204,206,204,205,205,205,206,204,206,204,205,205,205,206,204,206,205,205,206,205,206,205,206,205,205,206,205,207,205,206,206,206,209,213,220,219,219,215,212,210,208,208,207,207,206,205,207,206,206,206,206,206,206,208,206,208,207,207,207,207,208,207,208,207,207,208,207,209,207,208,208,208,209,208,208,208,208,208,208,209,208,209,208,208,209,207,209,208,209,208,208,209,207,208,207,209,208,208,209,208,209,208,209,209,208,210,208,210,209,209,210,208,210,209,209,209,209,210,209,210,209,209,210,209,211,209,211,210,210,211,210,211,210,211,211,211,211,210,210,208,208,208,207,208,207,208,206,207,207,207,208,207,209,207,208,208,208,208,207,207,207,207,209,209,211,209,211,211,212,213,212,213,212,212,212,212,212,211,213,212,212,212,211,212,210,212,211,212,212,212,213,211,213,213,213,213,213,214,213,213,213,213,214,213,214,213,214,214,214,214,214,215,214,215,215,214,216,214,216,215,215,215,215,217,215,216,215,215,216,215,217,215,216,216,216,216,215,217,215,216,216,216,216,215,216,215,216,216,216,217,216,217,216,216,217,216,217,216,217,217,216,217,216,218,217,217,204,204,205,203,205,204,204,205,203,205,204,204,204,204,205,204,205,204,205,205,204,205,204,205,204,205,205,204,206,204,205,205,204,205,204,205,204,205,205,204,205,204,205,204,205,205,204,206,204,205,204,205,205,204,206,204,205,205,205,205,205,206,205,206,205,205,207,205,207,206,207,207,206,207,206,208,206,207,207,206,208,207,208,207,208,211,216,222,224,227,227,227,225,218,215,212,210,210,209,209,208,208,207,207,208,207,209,206,208,207,208,208,208,208,207,209,208,208,208,208,209,207,208,208,208,208,208,210,208,208,208,208,209,208,209,208,208,209,208,209,208,209,208,209,209,207,209,208,209,209,209,209,209,210,209,210,210,210,211,210,211,210,211,211,210,212,211,211,211,211,211,211,212,210,212,211,211,212,211,213,211,212,211,212,212,211,212,211,212,212,211,211,209,209,208,208,209,208,209,207,208,208,208,208,207,209,207,208,208,208,208,207,208,207,208,207,208,210,210,212,212,214,214,213,214,214,215,214,214,215,214,215,214,214,214,213,213,212,213,212,213,213,213,214,213,215,214,214,215,214,215,214,215,214,214,215,214,215,214,215,214,214,215,214,216,214,215,215,214,216,215,216,215,216,215,216,217,216,217,216,217,217,216,218,216,217,217,217,217,216,218,216,217,217,216,217,217,217,216,218,218,217,218,217,219,218,218,219,218,219,218,219,219,219,219,219,219,218,219,220,203,202,203,202,203,203,203,203,202,204,203,203,203,203,204,203,204,203,203,204,203,205,203,204,204,204,204,203,205,203,204,204,204,205,203,205,204,204,205,204,205,204,205,204,204,205,204,205,204,205,204,204,205,204,205,204,205,205,205,205,205,206,205,206,206,205,206,205,206,205,206,206,205,206,205,206,205,206,206,205,207,206,208,211,217,220,222,226,226,228,228,228,227,221,216,211,210,208,207,208,205,207,205,206,207,206,207,206,206,206,206,207,206,207,206,208,208,208,208,207,208,207,208,208,208,208,207,208,208,208,208,207,208,207,208,207,208,208,208,208,207,208,207,208,207,207,207,206,207,208,209,213,214,216,216,217,218,219,221,219,217,213,212,212,210,211,210,210,210,210,210,209,210,209,210,210,210,211,210,211,210,210,211,210,211,211,212,211,211,211,210,210,209,210,209,208,209,208,209,208,208,207,207,208,207,208,206,208,207,207,207,206,208,208,208,207,207,210,210,212,212,212,213,212,213,213,213,213,213,213,212,213,212,212,212,211,212,210,212,211,211,211,211,212,211,213,212,212,213,213,214,213,214,213,213,214,213,214,213,214,214,214,215,214,215,214,215,215,214,216,215,216,215,216,216,216,217,216,219,222,224,224,222,222,219,218,218,218,218,216,217,216,216,216,216,216,215,216,215,216,216,216,217,216,217,216,216,217,216,218,216,217,217,217,218,217,218,217,218,218,204,205,203,205,204,204,205,204,205,204,205,205,204,206,204,205,205,205,205,204,206,204,205,204,205,205,204,205,204,205,205,205,205,204,205,204,205,204,204,205,204,205,204,205,205,204,206,204,206,204,205,205,204,204,203,204,204,204,205,204,206,206,206,205,206,207,206,207,206,207,207,206,207,206,208,207,208,207,207,208,207,211,213,219,224,226,229,228,230,230,230,231,230,230,227,223,217,213,211,209,209,207,207,207,206,207,206,207,206,206,207,206,208,206,208,206,207,207,207,209,208,209,208,208,209,208,210,208,209,209,208,209,208,209,208,208,209,208,209,207,208,207,207,207,206,207,207,208,209,213,218,222,227,227,229,230,230,231,230,231,230,226,220,216,215,212,212,211,210,211,209,211,210,210,210,210,211,210,211,210,211,211,211,211,211,212,211,211,211,210,211,210,211,209,209,209,209,209,208,209,208,208,208,207,208,207,208,208,208,208,208,209,208,209,209,209,210,210,212,212,213,214,213,215,214,214,214,214,215,214,214,213,214,214,213,213,212,213,213,213,213,213,214,213,214,214,214,214,214,215,213,215,214,214,215,214,216,214,216,215,215,216,215,217,215,216,215,216,216,215,216,215,216,216,216,216,216,220,223,228,231,232,234,232,228,223,220,220,218,218,217,217,217,217,217,216,218,217,217,217,217,218,217,218,218,218,218,218,219,218,218,218,218,219,218,219,219,222,223,224,202,204,203,204,203,203,204,203,205,203,203,204,203,205,203,204,203,204,204,203,204,203,205,204,204,205,203,205,203,204,204,204,204,203,205,204,204,204,204,205,203,205,204,204,205,204,205,204,205,204,204,205,203,203,202,202,202,202,204,203,205,204,205,205,205,206,204,207,209,209,208,207,208,208,212,212,210,208,207,208,209,215,220,223,226,226,228,228,229,229,229,230,229,230,229,229,224,217,213,209,208,207,206,206,206,206,205,206,206,206,207,206,207,206,207,207,207,208,207,209,207,208,208,208,209,208,210,210,210,212,211,211,208,208,208,207,208,206,207,204,205,205,204,204,205,209,212,217,219,221,224,225,227,227,228,229,229,230,229,230,230,229,226,219,216,212,212,210,210,210,209,210,209,209,209,209,210,209,210,210,210,210,210,211,210,211,210,210,210,209,210,209,210,209,209,210,208,209,208,209,209,208,209,208,209,208,209,209,209,210,209,210,209,209,210,209,210,210,211,211,211,212,211,212,211,211,211,211,213,211,212,211,212,212,211,212,211,212,211,212,212,212,213,212,213,213,213,214,213,215,213,214,214,214,215,214,215,214,214,215,214,215,214,216,215,215,216,215,217,215,216,216,216,216,216,218,221,227,229,232,233,234,235,234,233,227,222,220,218,218,216,216,216,215,216,214,216,215,216,216,216,216,215,217,216,216,217,216,217,216,217,217,219,221,220,223,226,229,231,231,205,204,205,205,205,205,204,205,204,205,205,204,205,204,205,204,204,205,204,205,204,205,204,204,205,204,205,204,205,204,204,205,204,205,203,205,204,204,204,204,205,204,204,204,204,205,204,205,205,205,205,205,205,204,204,204,204,203,202,205,204,205,205,206,206,206,208,210,217,220,220,219,220,223,223,224,223,220,219,218,222,224,225,227,227,229,228,230,230,230,230,230,231,230,231,230,230,229,223,218,212,210,209,207,207,206,207,206,206,207,206,207,206,207,207,207,208,207,209,207,208,207,208,209,212,218,221,224,225,226,227,226,225,221,217,213,210,209,207,208,209,214,218,219,222,223,226,227,228,229,229,230,230,230,231,231,232,231,232,231,231,231,230,230,226,222,217,214,213,211,212,210,211,209,209,210,210,211,209,210,210,210,210,210,210,209,209,210,209,210,209,210,209,209,209,208,210,209,209,209,209,209,209,210,209,210,210,210,211,210,211,210,210,211,210,211,210,211,211,212,212,212,213,212,213,213,213,213,212,214,213,213,213,213,213,212,213,213,214,214,214,215,214,215,214,215,215,214,215,215,215,214,214,215,215,216,214,216,215,215,215,215,217,215,217,216,218,221,222,224,221,220,219,219,221,223,228,230,232,233,233,235,235,236,235,234,229,223,223,220,219,219,219,218,217,218,217,217,217,217,218,217,218,217,217,218,218,219,218,218,218,220,225,229,232,232,234,235,235,236,205,204,205,203,204,203,203,203,202,204,202,204,203,203,204,203,205,203,204,204,204,204,203,205,204,204,204,204,205,203,204,202,204,203,203,203,201,201,201,202,203,203,204,203,205,204,205,205,204,206,205,205,205,204,205,204,205,203,203,203,202,203,202,204,204,206,209,213,220,221,224,224,226,226,226,227,226,227,226,227,227,226,228,227,228,228,228,228,228,229,228,229,229,229,230,229,230,229,228,225,218,213,209,208,206,206,206,205,206,205,206,206,206,207,205,207,206,207,207,207,208,207,209,209,215,221,224,227,227,229,229,229,230,229,229,225,223,220,219,218,218,222,224,225,226,226,227,227,228,228,229,229,229,230,229,230,229,229,230,229,230,229,230,229,229,228,224,220,214,213,211,210,210,209,209,208,208,209,208,209,208,210,209,209,210,209,210,209,209,209,209,210,209,209,208,209,209,209,209,209,210,209,209,210,209,210,209,210,210,210,210,210,210,209,210,209,209,210,210,211,210,211,211,211,212,211,213,211,212,212,212,212,211,212,212,212,212,212,214,213,214,214,214,215,215,216,214,216,215,215,216,215,217,215,216,216,216,216,215,216,215,217,218,220,222,223,226,227,229,230,230,231,228,228,227,229,231,231,232,232,234,234,234,235,234,235,234,230,223,219,219,216,217,216,216,215,214,216,214,216,215,215,215,215,217,216,217,216,216,217,218,222,226,231,233,234,236,235,237,236,220,219,216,214,213,209,209,206,207,206,205,206,208,211,209,208,209,210,210,209,209,208,207,207,205,206,205,206,205,204,203,201,202,200,201,200,199,200,199,201,201,203,203,203,205,204,206,205,205,206,205,206,205,206,205,206,207,206,205,203,204,204,205,209,213,219,221,224,226,227,228,228,230,229,230,230,229,230,230,231,230,230,230,230,231,230,231,230,230,231,230,231,230,230,230,230,230,229,230,229,227,222,215,213,210,210,207,207,207,206,207,206,207,207,207,207,207,210,208,209,208,208,211,216,222,225,228,229,229,231,230,232,231,232,232,231,231,230,231,230,230,230,230,230,230,230,230,230,230,230,231,230,230,231,230,231,230,231,230,231,231,231,231,230,231,230,230,229,225,222,216,214,211,210,210,209,210,209,209,209,209,210,208,210,209,209,210,209,210,209,209,209,209,210,209,210,209,209,209,209,210,209,210,209,210,210,210,210,209,211,210,210,211,211,212,211,212,211,213,214,214,217,217,219,220,222,223,221,221,221,221,220,219,219,218,218,217,218,218,218,218,218,219,220,221,221,221,223,222,224,225,226,226,224,224,223,223,221,221,223,224,227,227,229,229,230,232,231,232,232,233,233,234,234,234,234,234,234,235,234,235,234,236,235,235,236,235,234,227,223,220,219,219,217,218,217,217,217,216,217,217,218,217,217,218,217,219,220,221,222,225,229,231,233,234,236,236,236,237,237,223,224,223,224,221,218,212,207,208,208,212,210,212,217,218,218,218,220,219,220,220,218,216,211,209,206,205,205,203,203,201,201,201,199,199,198,199,199,199,200,199,202,201,204,204,204,205,204,205,204,205,205,204,204,202,204,203,204,203,201,203,205,211,216,221,223,225,227,227,228,228,229,229,228,229,229,229,229,229,230,229,230,229,230,230,230,230,229,230,229,229,229,229,230,229,230,229,229,229,228,230,227,223,216,212,211,208,208,207,207,206,206,207,206,207,206,210,215,218,219,218,218,219,223,227,227,229,229,230,230,230,231,230,231,230,230,230,230,230,229,230,229,229,229,228,229,228,229,228,229,229,228,229,228,229,229,229,229,229,230,229,230,229,229,230,229,230,229,229,228,226,222,215,213,210,210,210,209,209,208,209,209,209,209,209,210,208,209,209,209,209,208,209,208,208,208,208,209,208,210,209,209,210,209,211,210,211,210,210,211,211,213,213,214,214,215,216,216,219,219,223,224,226,227,227,229,229,230,229,228,229,228,228,227,226,223,221,221,220,221,221,223,225,225,228,228,229,229,229,231,230,232,231,232,231,230,231,230,231,231,231,231,231,232,231,232,232,232,232,232,234,232,233,233,232,234,233,234,233,234,234,234,235,234,235,234,234,234,231,226,220,219,218,217,217,216,216,215,216,215,215,216,215,216,216,219,221,224,228,229,231,232,233,234,234,235,235,236,236,236,226,226,226,226,224,224,218,214,213,216,220,220,222,222,223,223,222,224,223,224,222,222,222,217,212,208,206,203,201,201,200,201,200,200,200,200,201,201,203,202,202,202,202,204,203,204,203,204,204,204,205,203,204,203,203,204,204,207,206,207,210,216,223,225,227,228,229,230,230,231,230,231,231,231,231,230,231,230,231,231,231,231,231,232,231,232,232,232,232,231,232,231,231,230,230,231,230,230,229,229,230,229,229,225,223,218,214,211,209,209,207,207,206,206,207,207,214,220,225,226,228,229,229,230,230,230,230,230,231,230,231,230,231,231,230,232,231,231,230,230,231,230,232,230,231,230,230,231,230,231,230,230,230,230,231,230,231,230,230,231,230,231,230,231,230,230,231,230,231,230,230,228,224,219,214,213,211,211,211,210,210,209,210,209,209,210,209,210,209,210,210,210,210,210,210,209,210,210,210,211,210,212,211,212,212,212,214,214,218,221,223,225,226,229,228,229,229,230,231,231,232,231,232,232,232,232,232,233,232,232,232,232,232,231,232,231,231,231,230,231,230,231,230,231,232,231,232,231,233,232,232,233,232,233,232,233,233,233,233,233,233,233,233,233,233,233,232,233,233,233,233,233,234,234,234,234,234,235,234,235,234,235,235,235,236,235,236,235,235,233,230,230,228,228,228,226,223,220,220,218,218,219,219,221,223,228,230,233,233,235,236,236,237,237,237,237,237,238,237,238,225,224,225,224,224,224,223,223,221,222,222,222,222,222,222,221,222,222,222,222,221,223,221,222,220,215,211,206,204,202,201,201,200,201,201,202,202,203,204,204,206,204,203,203,203,203,203,204,202,203,201,200,201,200,201,201,205,211,216,219,220,223,225,226,227,227,229,228,229,229,229,229,228,230,228,229,229,228,230,229,230,229,230,230,230,231,230,231,230,230,230,230,231,229,230,230,230,230,229,230,229,229,229,229,229,228,227,222,216,211,209,208,206,207,205,208,214,221,225,226,228,228,229,230,229,230,229,230,230,230,230,230,230,229,230,230,229,230,229,230,229,229,229,229,230,229,230,229,229,229,229,230,228,230,229,229,230,229,230,229,230,230,230,230,230,231,230,230,230,230,231,230,230,227,223,218,213,213,211,210,209,209,209,208,209,208,209,209,209,210,209,210,210,210,210,210,210,209,210,210,210,210,209,211,211,214,218,222,225,226,229,228,230,230,230,231,231,232,231,232,231,231,231,230,231,230,231,230,230,231,230,231,230,231,231,231,232,231,232,231,231,232,231,233,232,232,232,232,233,232,233,232,233,233,233,233,232,233,233,233,233,233,233,232,233,232,232,233,232,233,233,233,233,233,234,233,234,234,234,234,234,234,234,235,234,235,235,235,235,235,235,234,234,234,233,234,232,230,228,226,224,223,226,227,229,230,232,233,233,234,234,235,235,235,236,235,236,236,236,236,226,225,226,225,225,224,224,224,224,224,223,224,223,223,223,222,224,223,224,222,222,223,223,224,223,222,218,211,208,204,204,200,200,200,200,202,201,203,204,204,206,205,206,203,204,204,204,203,202,202,201,201,201,203,208,213,220,222,224,226,227,228,228,230,229,230,230,230,230,229,230,230,229,229,229,230,230,230,230,230,231,231,232,231,232,231,231,232,231,232,231,231,231,230,231,230,231,230,230,230,230,230,229,230,229,230,230,228,227,221,217,212,209,208,207,211,217,224,226,228,230,230,231,230,231,231,231,232,231,232,231,231,231,231,232,231,232,231,231,231,230,232,231,231,230,230,231,230,231,230,230,230,230,231,230,231,230,230,231,230,231,230,231,231,230,231,230,231,230,231,230,230,231,230,229,225,220,216,213,211,210,210,209,209,209,208,209,209,209,209,209,210,209,210,209,210,210,210,210,210,212,213,216,219,222,225,226,229,229,231,231,231,233,232,233,232,232,233,232,233,232,233,232,232,233,232,232,232,232,232,232,232,232,233,232,232,233,232,233,232,233,232,232,233,232,233,232,233,233,233,233,233,234,233,234,233,233,234,233,234,233,233,234,233,234,233,233,233,233,233,233,235,234,234,234,234,235,234,235,235,235,235,235,236,235,236,236,236,236,236,237,236,236,236,236,236,235,236,234,234,233,233,234,234,234,234,234,235,235,235,235,235,235,236,236,235,236,235,236,235,224,225,224,224,224,223,224,223,224,223,223,224,223,225,223,224,223,223,223,222,224,222,223,222,222,223,222,221,215,210,205,202,202,200,200,200,201,202,202,203,202,204,203,203,201,200,202,200,200,199,199,201,203,210,215,221,223,225,226,226,227,227,228,228,228,229,228,228,228,228,228,228,229,228,229,229,229,230,229,230,230,230,230,230,232,231,232,231,231,231,231,232,231,232,230,230,230,230,231,230,230,229,229,230,229,230,229,229,229,228,228,225,223,220,218,218,221,226,226,228,227,228,229,228,229,228,229,229,229,229,229,230,229,229,229,229,229,229,230,229,229,229,229,229,229,229,228,229,229,228,229,228,230,229,229,229,229,230,229,230,229,229,230,229,231,230,230,230,230,231,230,231,230,230,230,229,229,226,222,215,212,211,209,209,208,209,208,208,209,208,209,208,209,209,208,209,209,213,214,217,220,223,225,225,228,228,229,230,230,231,230,231,231,231,231,231,232,231,231,231,230,231,231,232,231,231,231,230,232,231,232,231,231,231,232,232,232,232,232,232,233,232,233,232,233,233,233,233,233,234,233,234,234,233,234,233,234,233,234,234,233,233,233,233,232,232,232,232,233,232,232,233,233,234,233,234,234,234,234,234,235,234,235,234,234,234,234,235,234,235,234,234,234,234,235,234,234,234,234,234,234,234,234,235,234,234,234,234,235,234,235,234,234,235,234,235,235,235,235,235,225,225,225,225,224,225,224,223,225,223,224,223,224,224,223,223,222,223,223,223,223,222,223,222,223,223,222,223,222,221,215,210,207,205,204,203,203,202,203,202,202,203,202,203,202,202,202,201,203,206,213,218,222,225,225,228,227,229,229,229,230,229,230,229,229,229,229,229,229,230,229,230,230,230,231,230,232,231,231,231,230,232,231,232,231,231,231,231,232,232,232,232,231,232,231,231,230,231,231,230,231,230,230,230,230,230,229,230,229,229,229,229,229,228,228,227,228,228,228,228,228,229,228,229,229,229,230,229,230,230,230,230,230,231,230,231,230,230,231,230,231,230,231,230,230,231,230,231,230,230,230,230,231,230,230,230,230,231,230,231,230,231,230,230,231,230,231,230,231,231,230,231,230,231,230,230,230,230,228,222,218,214,212,211,210,210,209,209,209,209,210,210,211,210,213,215,221,225,227,229,229,231,231,231,233,232,233,232,233,233,232,233,232,233,232,233,233,232,233,232,232,232,232,232,231,232,231,232,232,231,232,232,233,232,233,233,232,233,232,233,233,233,233,232,234,232,233,232,233,233,233,234,233,233,233,233,234,233,234,233,233,233,233,234,233,233,233,233,233,233,234,233,234,233,234,235,234,235,234,235,235,235,236,235,236,235,236,236,236,236,236,237,236,236,236,236,236,236,236,236,236,236,235,236,235,236,235,235,236,235,236,235,235,236,236,236,235,236,236,236,225,224,224,224,223,224,223,224,223,223,224,223,225,222,224,223,223,223,222,224,223,223,222,222,223,223,224,222,223,222,222,221,218,215,210,207,206,205,205,203,203,202,202,202,201,202,201,204,207,213,220,223,225,226,228,228,228,229,228,229,228,228,228,227,228,227,227,227,228,229,229,230,229,230,230,230,230,230,231,230,231,230,230,231,230,231,230,231,231,231,231,231,232,231,231,231,230,231,230,231,230,230,230,229,230,229,229,228,228,229,228,229,228,228,228,228,229,228,228,228,228,228,228,229,228,229,228,228,229,228,229,228,229,229,228,229,228,229,228,229,229,228,229,228,230,229,229,229,229,230,229,230,229,229,230,230,230,229,230,230,230,230,230,231,230,230,230,230,231,230,231,230,231,231,230,231,230,231,230,230,228,225,221,217,216,215,215,214,212,213,214,217,220,222,223,223,226,227,228,228,229,230,229,231,230,230,231,230,231,230,231,230,230,231,230,231,230,231,230,230,230,229,230,230,230,230,230,231,230,231,231,231,232,231,232,231,232,231,232,232,232,233,232,233,232,233,233,232,233,233,233,233,233,234,233,234,233,233,233,233,233,232,233,232,232,232,232,233,232,232,232,232,232,232,233,232,233,233,233,233,233,234,234,234,234,234,235,234,235,234,234,234,234,235,234,234,234,234,235,234,235,234,235,235,234,235,235,235,234,235,235,235,235,235,236,235,235,235,235,236,225,225,225,224,224,224,223,224,223,224,223,224,223,223,224,223,225,223,223,223,223,224,223,224,222,222,223,222,224,223,223,222,222,223,221,219,215,212,210,208,208,206,207,206,208,211,214,218,220,223,225,226,227,227,228,228,229,228,228,228,228,228,228,229,229,228,229,229,230,229,229,230,229,231,230,231,230,231,231,230,232,231,231,231,230,232,231,232,230,231,231,231,232,232,232,231,232,232,231,231,230,230,230,230,230,229,230,229,229,229,229,230,229,230,229,230,230,230,231,230,230,230,230,230,230,231,230,230,230,230,231,230,231,230,231,230,230,231,230,231,230,231,230,230,231,230,231,230,230,230,230,231,230,230,230,230,230,230,231,230,230,230,230,230,230,231,230,231,231,230,231,230,231,230,231,231,230,231,230,231,230,230,230,228,228,228,228,227,227,227,227,229,228,229,229,229,230,229,231,230,230,230,231,231,231,231,231,231,232,231,232,231,232,231,232,232,231,232,231,231,230,230,231,231,232,231,232,232,232,232,232,233,232,232,232,232,233,232,233,232,233,233,232,234,233,233,233,233,233,233,233,233,233,233,233,233,232,233,233,233,233,233,233,232,233,233,233,233,233,233,232,233,233,233,233,233,234,234,234,234,234,235,235,236,235,236,236,235,236,236,236,236,236,236,236,236,235,236,235,235,235,234,236,235,235,234,234,235,234,235,234,235,235,235,236,235,236,235,235,236,223,224,224,224,224,223,224,223,223,223,223,224,223,224,223,223,223,223,224,223,223,222,221,223,223,223,222,222,223,222,223,222,223,223,223,223,222,222,220,220,219,219,219,219,220,220,221,221,222,223,223,225,224,226,225,225,226,225,226,225,226,226,227,228,227,228,228,228,229,228,230,229,229,229,229,230,230,230,230,231,230,230,231,230,231,230,231,231,231,232,231,232,231,231,231,231,232,231,232,230,230,230,230,231,230,230,229,229,230,229,229,228,229,229,228,229,228,229,228,229,229,229,230,229,230,229,229,229,229,230,229,229,229,229,229,229,230,229,229,229,229,230,229,230,229,229,230,229,230,229,230,229,229,230,229,230,229,230,230,230,230,229,230,230,230,230,230,231,230,231,230,230,230,230,231,230,231,230,230,230,230,231,230,230,230,230,230,229,230,229,229,229,229,229,229,230,229,229,229,229,230,229,230,230,230,230,230,230,230,231,230,230,231,230,231,230,231,230,230,230,230,231,230,230,230,230,231,230,231,230,231,231,231,232,231,232,232,232,232,232,233,232,233,232,232,233,232,233,232,232,232,232,233,232,232,232,232,232,232,232,231,232,231,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,233,232,233,233,233,234,234,234,234,235,234,234,235,234,235,235,235,234,235,235,234,235,234,235,234,234,235,234,235,234,235,235,234,235,234,235,235,235,235,235,236,235,223,225,223,224,224,224,224,223,224,223,223,223,223,224,223,224,222,222,223,223,223,222,223,223,224,225,224,224,224,225,225,224,225,224,226,225,225,226,225,226,225,225,225,225,226,225,226,225,226,226,226,227,226,228,226,227,227,226,227,226,228,228,229,229,229,230,230,230,230,230,231,230,231,230,230,230,230,231,230,231,230,230,230,230,231,230,231,230,230,231,231,231,230,231,231,231,231,230,232,230,231,230,230,230,230,230,229,229,229,229,230,229,230,229,229,230,229,231,230,230,230,230,231,230,231,230,231,231,230,231,230,231,230,230,230,230,231,230,230,230,230,230,230,231,230,230,230,230,230,230,230,229,230,230,230,230,230,231,230,230,230,230,230,230,231,230,230,231,230,231,230,231,230,231,231,230,231,230,231,231,231,231,230,231,231,231,231,231,231,230,231,230,231,231,230,231,230,231,230,231,231,231,232,231,232,231,231,232,231,232,231,232,231,231,232,231,232,231,232,231,231,232,231,232,231,232,231,231,232,231,232,232,232,232,232,232,232,232,232,232,232,232,233,232,232,232,232,233,232,233,232,233,233,233,234,232,233,233,233,233,233,233,233,233,233,233,233,233,233,233,233,233,233,233,233,234,233,234,234,234,234,234,235,234,235,235,234,236,235,236,235,235,236,235,237,236,236,236,236,236,235,236,235,235,235,235,236,235,236,235,235,235,234,236,235,235,234,235,235,235,224,223,224,224,223,224,223,223,223,223,224,223,224,223,223,223,223,224,223,224,223,223,225,225,227,226,226,225,224,226,224,225,224,224,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,224,226,226,226,226,227,228,227,228,228,228,229,229,230,229,229,230,230,230,230,230,230,230,230,230,230,230,231,230,230,230,230,231,230,230,230,230,231,230,230,230,230,230,230,230,229,230,229,229,229,229,229,228,229,228,228,228,228,229,228,229,229,229,229,229,230,229,230,229,229,229,229,230,229,229,229,229,230,229,230,229,229,229,229,230,229,230,229,229,229,229,230,229,229,229,229,230,229,230,229,230,230,230,230,230,230,230,230,230,230,231,230,230,230,230,231,230,231,230,230,230,230,230,230,230,230,230,230,230,230,229,230,230,230,230,230,230,229,230,230,230,230,230,230,229,230,230,230,230,230,231,230,231,230,230,230,230,231,230,230,230,230,231,230,231,230,230,231,231,231,230,232,231,231,231,231,232,231,232,232,232,232,231,233,232,232,232,232,232,232,232,232,232,232,232,233,232,232,232,232,232,232,232,231,232,231,232,232,232,232,232,232,232,232,232,232,233,232,232,232,232,233,232,233,232,233,233,233,234,233,234,234,234,234,234,235,234,235,234,234,235,234,235,234,235,234,234,235,234,235,234,235,235,234,235,234,235,234,235,235,234,235,234,235,224,223,224,224,224,224,223,224,223,223,223,223,225,223,224,223,223,223,223,225,225,227,226,227,229,228,230,228,227,227,226,227,226,227,226,226,226,226,226,225,226,226,225,226,226,226,225,226,226,226,226,225,226,225,225,225,226,227,227,228,227,228,228,228,229,229,229,229,229,230,229,230,230,230,230,230,231,230,230,230,230,230,230,231,230,231,230,230,230,230,231,230,230,230,230,231,231,231,231,232,231,231,231,230,231,230,231,230,229,230,230,230,230,230,230,230,231,230,231,231,231,231,231,232,231,232,231,231,231,231,232,231,231,230,230,231,230,231,230,230,230,230,231,230,230,229,230,230,229,230,229,230,229,229,230,229,230,230,230,230,230,230,230,231,230,230,231,230,231,230,231,231,231,231,230,231,230,231,230,230,231,230,231,230,231,231,231,231,230,232,230,231,230,230,231,230,231,231,231,231,231,232,231,232,231,231,231,231,232,231,232,231,231,232,231,232,231,231,231,231,232,231,232,231,231,231,231,233,232,233,232,232,232,232,233,232,232,232,232,233,232,233,232,233,232,232,233,232,233,232,233,232,232,233,233,233,233,233,233,233,233,233,233,233,233,234,233,234,233,234,234,233,233,233,234,233,233,233,233,234,233,234,233,233,234,234,235,234,235,235,235,235,235,235,234,235,235,235,235,234,236,235,235,235,235,235,235,235,235,235,235,234,235,234,235,234,234,235,235,236,223,223,225,224,224,223,223,223,223,224,223,224,223,223,223,222,224,223,225,225,225,227,227,229,228,228,228,228,229,228,228,227,227,227,226,227,225,226,226,225,225,225,225,224,225,225,225,225,224,225,224,224,224,224,225,225,225,225,226,227,227,228,228,229,229,229,229,229,230,229,230,230,230,230,229,230,230,230,230,230,231,230,231,230,230,230,230,231,230,230,230,230,231,230,231,230,231,231,231,231,230,231,230,230,230,230,230,229,230,228,229,229,228,229,228,230,229,230,230,230,231,230,230,230,230,230,229,230,229,229,229,229,229,229,230,229,229,229,229,230,229,230,229,229,230,229,230,229,229,229,229,229,229,230,229,230,229,229,230,229,230,230,230,230,230,230,229,230,230,230,230,230,230,229,230,230,229,229,229,230,229,230,230,230,230,230,231,230,230,230,230,230,230,230,230,230,230,230,231,229,230,230,230,230,230,231,230,231,230,230,231,230,231,230,231,231,230,231,230,231,230,231,230,230,231,230,231,231,231,232,232,232,231,232,232,232,232,232,232,231,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,233,232,232,232,232,232,232,232,231,231,231,232,232,232,232,231,232,231,231,232,231,232,232,232,232,232,234,233,234,233,233,234,234,235,234,234,234,234,235,234,235,234,235,234,234,235,234,235,234,235,235,234,235,234,235,234,234,235,235,235,234,235,235,223,224,223,225,223,223,223,223,225,224,224,222,223,223,223,224,223,225,225,226,227,227,229,229,230,230,230,231,230,230,229,229,229,228,229,228,228,227,227,227,226,227,226,227,226,226,226,225,226,226,226,225,225,226,226,227,227,228,228,228,229,228,230,229,229,230,229,230,230,230,230,230,230,230,230,230,230,230,230,231,230,231,230,230,231,230,231,230,231,230,231,231,231,231,231,232,231,231,231,230,232,231,231,231,230,231,230,231,230,230,230,230,231,230,231,230,231,231,231,232,231,232,231,231,231,231,232,231,231,231,230,231,230,231,230,230,230,230,230,230,230,229,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,231,230,230,230,230,230,230,230,230,230,230,230,231,230,231,231,231,231,231,232,231,231,231,231,232,231,232,230,232,231,231,232,231,232,231,232,231,231,232,231,232,231,231,231,230,232,231,232,231,231,231,231,232,231,232,231,231,231,230,232,231,231,231,231,232,231,232,231,231,231,231,232,232,232,231,232,232,232,232,232,232,232,232,233,232,233,232,233,233,233,233,233,234,233,233,233,232,233,232,233,232,232,232,232,233,232,233,232,232,233,233,233,233,233,233,233,234,233,233,233,233,233,233,234,234,234,234,235,235,235,235,234,235,235,235,235,235,235,235,236,235,235,235,235,236,235,235,235,235,235,235,236,235,235,235,234,235,235,236,235,235,223,225,223,225,223,223,224,223,225,223,223,223,223,224,223,225,224,225,225,227,228,227,228,227,228,229,229,230,229,230,229,228,228,227,227,226,227,226,226,226,225,226,225,225,225,225,225,224,225,224,224,224,225,226,225,226,226,227,227,227,228,228,228,228,228,229,228,229,229,229,229,229,230,230,230,229,230,230,230,230,230,230,230,230,230,229,230,229,230,229,229,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,229,230,230,230,230,229,230,230,230,230,230,230,230,231,230,231,230,231,231,230,231,231,231,231,231,231,230,231,230,230,230,230,230,229,230,229,229,230,229,230,229,230,229,230,230,229,231,230,230,230,230,230,230,230,229,230,230,229,230,229,230,229,230,230,229,230,229,230,230,230,230,230,230,230,230,230,230,230,230,230,229,230,230,229,230,230,230,229,230,230,229,230,229,230,230,230,230,230,231,230,231,230,230,231,230,231,230,230,230,230,230,230,230,230,230,230,230,231,231,231,231,232,232,232,232,231,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,231,232,232,231,232,231,232,232,232,232,232,232,231,232,231,231,231,231,232,231,232,231,231,232,231,233,232,232,232,232,234,233,234,233,234,234,234,235,234,234,234,234,234,234,235,234,235,234,235,235,234,235,234,234,234,234,235,234,235,234,234,234,234,235,234,235,235,235,223,223,223,225,224,225,223,224,224,224,224,224,224,224,225,226,226,228,227,229,229,229,230,229,231,230,230,230,230,231,230,230,229,229,229,228,229,227,228,227,227,227,226,227,226,226,226,225,226,225,226,226,226,227,227,228,227,229,228,228,229,228,229,229,229,229,229,230,229,230,229,230,230,230,230,230,231,230,230,230,230,231,230,231,230,230,230,230,231,230,231,230,230,231,231,232,230,232,231,231,231,231,232,231,231,231,230,231,231,232,230,231,231,231,232,231,232,231,231,231,231,233,232,232,232,231,232,232,232,231,232,231,231,231,230,231,231,231,230,230,231,230,230,230,230,230,230,230,229,230,230,230,230,230,230,230,230,230,230,230,229,230,230,230,230,230,230,230,230,230,230,231,230,231,230,231,230,230,231,230,231,231,231,231,231,232,231,232,231,231,231,231,231,230,231,230,230,231,230,231,230,231,230,231,231,230,231,231,231,231,231,231,230,231,230,230,230,230,231,230,231,230,231,231,231,232,231,232,232,232,232,232,233,232,232,232,232,233,232,233,232,233,232,232,233,233,233,233,233,233,233,233,232,233,233,233,233,233,234,233,234,233,233,233,233,233,233,233,233,233,233,233,233,232,233,233,232,233,232,233,233,233,233,233,234,233,233,233,233,234,234,234,234,234,234,234,234,234,235,234,234,234,234,235,234,235,234,235,235,234,235,234,235,235,235,236,235,236,235,236,224,223,225,223,223,223,223,225,223,224,222,223,223,223,225,225,227,226,226,228,228,229,228,229,229,229,229,229,229,229,229,229,229,229,228,227,226,226,226,225,225,224,224,224,224,225,224,225,224,225,225,225,227,226,228,227,228,228,228,229,228,229,228,228,229,229,229,229,229,229,229,230,229,230,229,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,229,231,230,230,230,230,230,230,231,230,230,230,230,230,230,230,230,230,230,230,230,229,230,230,230,230,229,230,230,230,229,230,230,230,231,230,231,231,231,231,230,232,231,231,231,230,231,230,230,230,230,230,229,230,229,229,229,229,229,229,230,229,229,229,229,230,229,230,229,229,229,229,230,229,230,229,229,229,229,230,228,229,229,229,229,229,230,229,229,229,229,230,229,230,230,230,230,230,230,230,230,229,230,230,229,230,229,230,230,229,230,230,230,230,231,230,230,231,230,231,230,230,230,230,230,230,231,230,230,230,230,231,231,231,231,231,232,231,232,231,232,231,232,232,231,232,231,232,231,231,231,231,232,232,232,231,231,232,230,232,231,231,231,231,232,231,232,231,231,231,231,232,231,232,231,231,231,231,232,231,232,231,231,232,232,232,232,232,232,232,232,232,232,232,232,233,232,233,233,233,233,233,234,233,234,234,234,234,234,235,234,235,234,235,235,234,235,234,235,234,234,235,234,235,234,235,234,234,235,223,224,223,224,224,224,224,223,224,224,224,225,225,226,226,227,227,228,229,229,229,229,230,230,230,230,230,230,230,230,231,230,231,230,231,230,230,229,228,229,227,227,227,227,227,227,227,227,227,227,227,228,227,229,228,228,228,228,229,228,229,228,228,229,228,229,228,229,229,229,230,229,230,230,230,230,230,231,230,231,230,230,230,230,231,230,231,230,230,231,230,231,230,231,230,231,231,231,232,231,232,231,231,231,231,232,232,232,232,231,231,231,231,231,231,232,231,232,231,231,231,231,232,231,232,231,231,231,231,232,231,232,231,232,232,231,232,231,232,231,231,232,231,232,230,231,230,230,231,230,230,229,230,230,230,230,230,230,230,230,230,230,231,230,231,230,230,230,230,231,230,231,231,230,231,230,231,230,231,231,231,231,231,232,231,232,232,231,232,231,232,231,232,231,231,231,231,232,231,231,231,230,232,231,231,231,230,231,230,231,230,230,230,230,230,229,230,230,230,230,230,231,231,231,231,232,232,232,232,231,232,232,232,232,232,233,232,233,233,232,233,232,233,232,233,233,232,233,232,233,232,232,232,232,233,232,233,232,232,233,232,233,232,233,232,232,233,232,233,232,233,233,232,233,232,233,232,232,232,232,232,232,232,232,232,232,232,233,232,233,233,234,234,234,235,234,235,235,235,235,234,236,235,235,235,235,235,235,236,235,235,235,235,236,235,236,235,235,236,235,223,224,224,224,223,223,224,223,224,224,224,225,225,227,226,227,227,227,229,228,230,229,229,229,230,230,230,230,230,230,230,230,230,229,230,229,229,229,227,228,227,227,226,226,227,226,227,227,227,227,227,228,227,228,228,228,228,228,229,228,229,228,228,229,228,229,228,229,229,229,229,229,230,229,230,230,229,230,229,230,230,230,230,229,230,229,230,229,229,230,229,230,229,230,230,230,230,230,231,230,230,230,230,230,230,230,230,230,230,230,230,229,230,230,230,230,230,231,230,231,230,230,231,230,231,230,231,231,231,232,231,232,231,231,231,231,232,231,232,231,231,231,231,232,231,231,230,230,231,230,230,229,230,229,229,229,228,230,229,229,229,229,230,229,230,229,229,229,229,230,229,230,229,229,230,229,230,229,230,229,229,230,229,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,229,230,229,229,229,229,230,229,230,230,230,230,230,232,231,232,231,231,231,231,232,231,232,231,231,232,231,232,231,232,231,231,232,232,232,232,232,232,231,232,231,232,231,231,231,231,232,231,232,231,231,231,231,232,231,232,231,231,231,231,232,231,231,231,230,231,231,231,230,231,231,231,232,231,231,231,231,232,232,233,232,233,233,233,234,233,234,234,234,234,234,235,234,235,235,235,235,235,235,234,235,234,234,234,234,235,234,234,234,234,234,234,224,225,224,225,224,224,224,224,226,225,226,227,227,228,228,229,229,230,230,230,231,230,231,231,231,231,231,232,231,231,231,231,231,231,232,230,231,230,229,229,228,229,227,228,228,228,228,227,229,228,228,228,228,229,228,228,228,228,228,228,229,228,229,228,229,229,228,230,229,229,230,229,230,229,230,230,230,230,230,231,230,231,231,231,231,231,232,231,232,230,231,231,230,232,231,231,231,231,231,231,232,231,232,231,231,232,231,232,231,231,231,231,232,232,232,231,231,231,231,232,231,231,231,231,232,231,232,231,231,231,231,232,231,232,231,231,231,231,232,231,232,231,231,231,231,232,231,231,230,230,231,230,231,230,230,230,230,230,230,231,230,230,230,230,231,230,231,230,230,231,230,231,230,231,231,230,231,231,231,230,231,231,231,232,231,232,231,231,231,231,232,231,232,230,231,231,231,232,231,231,230,230,231,231,231,230,231,230,230,230,230,230,230,230,230,230,231,230,231,231,231,231,231,232,231,232,231,231,232,232,232,232,232,232,232,232,232,233,232,233,233,232,233,232,233,232,232,232,232,232,232,232,231,232,232,231,232,231,232,232,232,232,232,232,232,232,232,232,232,231,232,231,232,232,231,232,232,232,232,232,232,232,233,232,233,233,233,233,233,234,234,234,234,234,234,234,235,234,235,234,234,234,234,235,235,235,235,235,236,235,236,235,235,235,235,236,235,236,235,235,224,222,223,223,223,225,224,225,225,225,226,226,227,226,227,227,228,229,228,229,228,230,230,230,230,230,230,230,230,230,230,230,229,230,230,230,230,229,230,229,229,229,228,229,228,228,227,228,228,228,228,227,228,227,227,228,227,229,228,228,228,228,229,229,230,229,229,229,229,230,229,230,229,229,230,230,230,230,230,230,230,230,230,230,230,230,230,230,231,230,230,230,231,230,230,230,230,231,230,231,230,230,231,230,231,230,230,230,230,231,230,231,230,230,231,230,231,230,231,230,230,230,230,231,230,230,230,230,231,230,231,230,230,231,230,231,230,231,230,231,231,231,231,231,231,231,231,231,230,231,230,230,230,230,230,229,230,229,229,229,229,230,229,229,229,229,229,229,230,229,229,229,229,230,229,230,229,229,229,230,230,229,230,229,230,230,230,230,230,231,230,231,231,230,231,230,231,230,230,231,230,231,230,230,230,230,231,230,230,230,230,230,230,230,230,230,230,230,230,230,231,230,231,231,231,231,231,232,231,232,231,231,231,231,232,231,232,231,231,231,231,232,231,231,231,230,231,231,231,230,230,231,230,231,230,231,231,231,231,230,231,230,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,232,231,232,231,231,232,232,233,232,233,233,233,234,233,234,234,234,234,234,235,234,235,234,235,235,234,235,234,235,234,234,235,234,235,234,234,234,234,235,234,234,223,223,224,224,226,225,226,226,226,227,227,228,227,229,229,229,230,230,231,230,231,231,231,232,231,232,231,231,231,231,232,231,232,231,231,231,231,232,231,231,230,229,230,230,230,229,229,229,228,230,228,229,228,228,228,228,229,228,229,228,228,229,229,229,229,230,229,229,230,229,229,229,230,230,230,231,229,231,230,231,231,230,231,230,231,231,231,231,230,232,231,231,231,230,231,231,232,231,231,231,231,232,232,232,231,232,232,231,232,231,231,231,231,232,231,232,231,231,231,231,232,231,232,230,231,231,231,231,231,232,231,232,232,231,232,231,232,231,232,232,232,232,231,232,232,232,232,231,233,232,232,231,231,232,231,232,230,231,231,231,231,230,231,230,231,231,230,231,230,231,230,230,231,230,231,230,230,230,230,231,230,231,230,231,231,231,231,230,232,231,232,231,231,232,230,232,231,231,230,230,231,230,231,230,230,230,230,231,230,230,230,230,231,230,231,230,230,231,231,231,231,231,231,231,232,231,232,231,232,231,232,232,232,233,232,233,232,232,233,232,233,232,232,232,232,232,231,232,231,232,232,232,232,232,232,232,232,232,232,232,231,232,232,232,232,232,233,232,232,232,232,232,232,232,232,232,232,232,233,232,232,232,232,233,233,233,232,233,233,234,234,234,234,234,235,235,235,235,235,235,235,235,235,235,236,235,236,235,235,235,235,236,235,236,235,235,235,235,236,235,224,224,224,224,226,225,226,226,226,227,226,227,227,227,228,228,229,229,230,229,230,230,230,230,230,230,230,230,230,229,230,229,230,230,229,230,229,230,229,230,229,229,230,229,229,228,229,229,228,229,228,228,228,228,228,227,228,227,228,227,228,228,228,229,228,229,229,229,229,229,230,229,229,230,229,230,229,230,230,230,230,230,230,230,230,229,229,230,229,230,229,230,229,229,230,229,230,230,230,230,230,231,230,230,230,230,230,230,231,230,230,230,230,231,230,231,230,231,231,231,232,231,232,230,231,231,231,231,231,231,230,230,231,230,231,230,231,231,231,231,231,232,231,232,231,231,231,231,232,231,232,231,231,231,230,231,230,231,231,230,231,230,230,229,230,230,229,230,229,229,229,228,229,229,229,228,229,229,229,229,229,230,229,229,229,229,230,230,230,230,230,230,230,231,230,231,230,230,231,230,230,229,230,230,230,230,230,231,230,230,230,230,231,230,231,230,230,230,230,231,230,231,230,231,231,231,231,230,231,231,231,231,231,232,231,232,231,231,231,231,231,230,230,230,229,230,229,230,230,230,230,230,231,230,231,230,230,231,231,231,231,231,231,231,232,231,232,231,231,231,231,232,231,232,231,231,231,231,232,231,232,231,231,232,232,233,232,233,233,233,234,233,234,234,234,234,234,235,234,235,234,234,234,234,234,234,234,234,234,234,233,234,233,233,233,234,234,233,234,233,225,226,226,227,226,227,227,227,228,227,228,227,228,228,229,230,229,230,230,230,231,231,231,230,231,231,231,231,231,231,230,231,230,230,230,230,231,230,230,230,230,230,230,230,229,230,229,229,229,228,229,229,229,228,228,228,228,228,228,228,228,228,229,228,229,228,228,229,229,230,229,230,230,230,230,230,231,230,230,231,231,231,231,232,231,231,231,230,231,231,231,231,231,231,231,232,231,232,231,231,232,232,233,232,232,231,231,231,231,231,231,231,231,230,232,231,232,231,231,231,231,232,232,232,232,231,232,231,232,231,231,231,231,232,231,232,231,231,231,231,232,231,232,231,231,232,231,233,231,232,232,232,232,232,232,231,232,232,231,232,231,232,231,231,231,231,232,230,231,230,230,230,230,231,230,230,230,230,231,230,231,230,230,231,230,231,230,231,230,231,231,230,231,230,231,230,230,231,230,231,230,231,230,230,231,230,231,230,231,231,230,231,230,231,231,231,231,231,232,231,232,231,232,232,231,232,232,232,232,232,232,232,233,232,232,232,232,233,232,232,231,232,232,231,231,231,231,231,231,231,231,232,231,232,231,231,231,231,232,231,232,231,231,231,231,232,231,232,231,231,232,231,232,232,232,231,231,232,231,232,231,231,232,231,233,232,233,233,233,234,234,235,234,235,235,235,236,235,236,235,235,235,235,236,235,236,235,235,235,235,235,235,235,235,236,236,235,236,235,235,224,225,225,226,225,226,226,226,227,226,228,226,228,228,228,228,228,229,229,229,229,229,230,230,230,230,230,230,230,230,229,230,230,230,230,229,230,230,230,230,229,231,230,230,229,230,230,229,229,229,229,228,228,228,228,228,227,228,228,228,228,228,229,228,228,228,228,229,228,229,228,229,229,229,230,229,230,229,229,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,229,230,230,229,229,230,230,230,230,230,230,231,230,231,230,231,231,230,231,230,231,230,231,231,231,231,231,232,231,232,231,231,231,231,232,232,232,231,231,232,231,232,231,231,231,231,232,231,232,231,230,231,230,231,230,231,230,230,231,230,231,230,230,230,230,231,230,230,230,230,230,230,230,229,230,230,229,229,229,230,229,230,229,229,230,229,230,229,230,230,229,230,230,230,230,230,230,230,231,230,230,230,230,230,230,230,230,230,230,230,230,229,231,230,230,230,230,231,230,231,230,230,231,230,231,230,231,230,231,231,230,231,230,231,230,230,231,231,231,230,231,231,230,231,230,231,230,230,230,229,230,229,230,229,229,230,229,230,230,230,230,230,230,230,231,230,230,230,230,231,231,231,231,232,232,231,232,231,231,231,231,232,231,232,231,231,231,231,232,232,233,232,233,233,233,233,233,234,233,234,234,234,234,233,234,234,234,234,233,234,233,234,233,233,233,233,234,233,234,234,234,234,234,235,234,234,226,226,227,226,227,226,226,228,227,228,227,228,228,229,230,229,230,230,230,231,231,231,231,232,231,231,231,231,232,231,232,231,230,230,230,231,230,230,230,230,230,230,231,230,230,230,230,230,230,230,228,228,228,227,228,227,228,227,227,228,228,229,228,229,229,229,230,229,230,229,230,230,230,231,230,230,230,231,231,230,231,231,231,231,231,231,231,232,231,231,231,231,231,231,232,231,231,231,231,232,231,232,231,231,231,231,232,232,232,231,231,232,231,232,231,232,231,231,232,231,232,231,231,231,232,232,232,232,232,232,232,232,232,232,232,232,232,232,231,232,232,232,232,232,233,232,233,232,232,232,232,233,232,233,232,232,233,232,233,232,232,231,232,232,231,231,231,232,231,232,232,231,231,231,232,231,231,231,230,231,230,231,231,230,230,230,231,230,231,230,230,231,230,231,230,231,230,230,230,230,230,229,229,230,229,230,229,230,230,229,230,230,230,230,231,231,231,231,230,231,231,231,232,231,232,231,232,231,232,232,232,233,232,232,232,232,232,231,232,231,231,231,230,231,230,231,230,231,231,231,231,231,231,231,231,231,231,232,231,231,231,231,232,231,232,231,231,231,231,232,232,232,231,232,232,232,232,232,232,232,232,233,232,233,232,234,234,234,234,234,235,234,235,235,235,235,235,236,235,235,235,234,235,235,235,235,235,235,234,235,234,235,234,234,235,234,235,234,235,235,226,226,227,226,226,226,226,227,227,228,227,228,228,228,229,229,230,229,229,229,229,230,229,230,230,230,230,230,231,230,231,230,230,231,230,230,230,230,230,230,230,229,230,230,230,230,229,230,229,230,229,229,229,228,229,228,228,228,228,228,228,228,228,228,228,228,229,228,229,228,229,229,229,230,229,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,229,230,230,229,230,230,230,230,230,230,230,231,230,231,231,231,232,231,232,231,232,231,231,232,231,232,231,231,231,231,232,232,232,231,232,232,232,232,232,232,231,231,231,231,232,231,232,231,231,231,231,233,232,232,231,231,232,231,232,230,230,230,230,231,230,231,230,230,230,230,231,230,230,230,230,230,229,230,229,230,229,229,230,229,230,229,229,230,230,230,229,230,230,230,230,230,230,230,230,230,230,230,229,230,229,229,229,229,230,229,230,229,229,230,230,230,230,230,230,230,231,230,231,230,231,231,231,231,230,231,230,231,231,230,231,230,231,230,231,231,230,231,230,230,229,230,230,229,230,229,230,229,229,230,229,230,229,230,230,230,230,230,231,230,231,230,230,231,231,231,231,232,232,231,231,231,232,232,232,232,232,232,231,232,232,232,232,232,233,232,233,232,232,234,233,234,233,234,234,233,234,233,234,233,233,234,233,234,233,234,233,233,234,233,233,233,234,233,233,233,233,234,233,233,233,228,228,227,228,228,228,228,228,229,228,229,229,229,231,230,231,231,231,231,231,232,231,232,231,231,231,230,232,231,231,230,230,231,231,231,230,230,230,230,230,230,230,229,230,230,230,230,229,230,230,230,230,230,230,229,229,229,229,229,228,229,228,229,229,229,230,230,231,230,230,230,230,231,230,231,230,231,231,231,231,231,231,231,231,232,231,232,231,231,231,231,232,232,232,231,231,231,231,232,231,232,231,231,231,231,232,231,232,231,231,231,231,232,231,232,231,231,231,231,232,232,232,232,232,232,232,232,232,232,232,232,233,232,232,232,232,232,231,232,231,232,232,232,233,232,233,232,233,233,233,233,232,233,232,233,233,232,233,232,233,232,232,232,232,232,232,232,232,232,232,231,232,231,231,231,231,231,231,231,230,231,231,231,231,230,231,230,230,230,230,230,230,230,230,230,230,229,230,229,230,230,230,230,229,230,230,230,230,230,231,230,232,231,231,231,231,232,232,232,231,231,232,231,232,231,232,231,232,232,232,232,232,232,232,232,233,232,232,231,231,231,231,231,230,231,230,230,230,230,231,230,230,230,230,231,231,231,231,231,231,231,232,231,232,231,232,231,232,232,231,232,232,232,232,232,233,232,232,232,232,233,232,233,232,233,233,233,234,233,234,234,234,235,235,235,234,235,234,235,235,234,235,234,235,235,235,235,235,236,235,235,235,235,235,234,235,234,235,234,234,226,227,226,226,226,226,227,227,228,227,228,228,228,229,229,230,230,230,230,230,230,230,231,230,230,231,230,231,230,231,230,230,231,230,231,230,230,230,230,230,230,230,229,230,230,230,230,230,230,230,230,230,230,231,230,230,230,230,230,229,230,229,229,229,228,230,229,230,229,229,229,229,230,229,230,229,229,230,229,230,229,230,230,230,230,230,231,230,230,230,230,230,230,231,230,230,230,230,231,230,231,230,230,231,231,231,230,231,231,231,231,230,232,231,232,231,231,231,230,232,231,232,231,231,232,231,232,231,232,231,231,232,231,232,230,231,231,230,232,231,231,230,230,231,231,232,231,231,231,231,232,231,232,231,231,231,231,232,231,232,231,231,231,231,232,231,231,230,230,231,230,231,230,230,230,230,231,230,230,230,230,230,230,230,230,230,230,230,230,229,230,229,230,229,229,229,229,229,229,229,229,229,229,229,230,229,230,230,229,230,230,230,230,230,230,230,231,230,231,230,230,231,230,231,230,231,230,230,230,230,231,230,230,230,230,230,229,230,229,229,229,228,229,228,228,228,228,228,228,229,229,229,229,229,230,230,230,230,231,231,231,231,231,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,233,233,233,233,234,234,233,234,233,234,233,233,234,233,234,233,234,234,234,234,234,234,233,234,234,233,234,233,233,233,233,233,233,228,228,229,228,228,228,228,229,229,230,230,230,230,230,231,230,231,231,230,231,231,231,231,231,231,231,231,230,231,231,231,231,230,231,230,231,231,230,231,231,231,230,231,230,230,231,230,230,230,230,230,230,231,230,231,230,230,231,230,231,230,230,230,230,230,230,230,229,230,230,230,230,230,231,230,230,231,230,231,230,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,230,231,231,231,231,230,232,231,231,231,231,232,232,232,231,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,233,232,233,232,233,233,233,233,233,233,233,233,233,232,233,232,233,232,232,232,232,233,232,232,232,232,232,232,232,231,232,231,231,231,231,231,231,231,231,231,231,230,231,230,230,230,230,231,230,230,230,230,229,229,230,228,229,228,228,229,229,230,229,230,230,230,231,230,231,231,231,231,231,232,231,232,231,231,231,231,232,231,232,231,231,232,231,232,231,232,231,232,232,231,231,230,230,230,230,230,230,230,230,230,230,230,230,229,230,230,230,230,230,231,230,231,231,231,232,231,232,231,232,232,232,233,232,233,232,232,232,232,233,232,233,232,233,233,232,233,232,233,233,233,234,234,234,234,234,234,234,235,235,235,234,235,235,235,235,234,235,235,235,235,234,235,234,235,234,234,235,234,235,234,234,234,234,234,227,226,227,227,227,228,227,229,228,229,229,229,230,229,230,230,230,230,230,230,230,230,230,230,231,230,231,230,230,230,230,231,230,230,230,231,230,230,231,230,230,230,230,230,230,230,230,230,230,230,230,229,230,229,230,230,229,230,229,230,229,229,229,229,230,229,230,229,229,229,229,230,228,230,229,229,229,229,230,229,230,230,230,230,229,230,230,230,230,230,230,230,231,230,230,231,230,231,230,231,230,231,231,230,231,230,231,230,230,231,230,231,230,231,231,231,231,231,232,231,232,231,231,231,231,232,231,232,231,231,232,231,232,231,231,231,231,232,231,232,231,231,231,231,232,232,232,232,232,232,232,232,232,232,232,232,232,231,232,231,231,231,231,232,231,232,230,230,231,231,231,230,231,230,230,231,230,231,230,230,230,230,231,230,230,230,230,230,229,230,229,230,229,229,229,228,229,228,229,228,228,229,228,230,229,229,230,230,231,230,230,230,230,230,230,231,230,230,230,230,230,230,230,230,230,230,230,231,230,231,230,231,231,230,230,230,230,229,229,229,229,229,229,229,228,229,229,229,229,229,230,230,229,230,230,230,230,231,231,231,231,231,231,231,232,232,232,232,231,232,231,231,231,231,232,231,232,231,231,231,231,232,232,232,232,232,233,232,233,232,232,233,233,233,232,233,232,233,233,233,233,233,234,233,233,234,233,234,233,234,233,233,234,233,234,233,233,233,232,232,228,229,229,229,230,229,230,229,230,230,230,231,230,231,230,230,231,230,231,230,230,230,230,231,230,231,230,231,231,231,231,230,231,230,231,231,230,231,231,231,230,230,231,230,231,230,231,230,230,231,230,231,230,231,231,231,231,231,231,230,231,231,231,231,230,231,230,230,230,230,231,230,231,230,230,230,230,231,230,231,231,231,231,231,232,231,232,231,231,232,231,232,231,231,231,231,231,231,231,231,231,231,231,231,230,231,231,231,231,230,232,231,231,231,231,232,231,232,231,231,231,231,233,232,232,231,232,232,232,232,232,232,232,232,232,232,233,232,232,232,232,233,232,233,232,232,232,232,233,232,233,232,233,233,233,233,233,233,233,233,233,233,233,232,233,232,232,232,232,232,232,232,231,231,231,230,231,230,230,230,230,231,230,231,230,230,230,230,230,230,230,229,229,230,229,230,229,229,229,229,229,229,230,230,230,231,230,231,231,232,231,232,232,231,232,231,232,231,231,231,231,232,231,232,231,231,231,231,232,232,232,232,231,232,231,231,230,230,230,230,230,229,230,230,229,229,229,230,229,230,230,230,230,230,231,230,231,231,231,231,231,232,231,231,231,231,232,231,232,231,231,231,231,233,232,232,232,232,233,232,233,232,233,233,233,234,234,234,234,234,234,234,234,234,234,234,234,234,234,235,234,234,234,234,234,234,235,234,235,235,235,235,234,235,234,234,234,233,233,232,227,228,228,228,229,228,229,229,229,230,229,230,229,230,230,230,230,230,231,230,230,230,230,231,230,231,230,230,230,230,231,230,230,230,230,230,230,231,230,231,231,231,231,231,231,231,231,231,231,231,230,231,230,230,230,230,231,230,231,230,230,230,230,230,229,230,229,230,230,229,230,230,230,229,229,230,229,230,229,230,230,230,230,230,231,230,230,230,230,231,230,230,230,230,231,230,231,230,231,231,231,231,231,232,231,231,231,231,231,231,231,230,231,231,231,231,231,231,231,231,231,231,231,231,232,231,231,231,231,232,231,232,231,231,231,231,232,231,231,231,230,232,231,232,230,231,231,231,232,232,232,231,232,232,232,232,232,232,232,232,232,232,232,231,232,231,231,231,231,232,231,231,230,230,231,231,231,230,231,231,230,231,230,231,230,230,230,230,230,229,230,230,229,229,229,229,228,229,229,228,229,228,229,229,229,229,229,230,230,230,230,230,230,230,231,230,230,230,230,230,230,230,230,230,230,230,230,229,231,230,230,230,230,230,229,229,229,229,229,229,229,228,229,228,228,229,229,230,230,230,230,230,231,230,231,230,231,231,231,232,231,232,231,232,232,232,232,232,232,232,232,232,232,232,231,232,231,231,232,232,233,232,232,232,232,233,232,233,232,233,233,233,233,232,233,232,232,232,232,233,232,233,232,232,233,232,233,232,233,233,233,233,233,234,233,233,233,232,232,231,229,229,229,230,229,231,230,230,230,230,231,230,231,230,231,231,231,231,230,231,231,231,231,231,232,231,232,231,231,231,231,232,232,232,231,231,232,231,232,231,231,231,231,232,231,232,231,231,231,231,232,231,232,231,231,231,231,233,232,232,232,232,232,231,232,231,231,231,231,232,231,232,231,231,231,230,232,231,231,230,230,232,231,232,231,231,231,231,232,231,232,230,231,231,231,232,231,231,230,230,231,231,231,230,231,230,231,231,230,231,230,231,231,231,232,231,232,231,231,232,232,233,232,233,232,232,232,232,233,232,233,232,232,233,232,233,232,233,233,232,233,232,233,232,233,233,232,233,233,233,233,233,233,233,233,233,234,234,233,233,233,233,233,233,232,232,232,232,232,232,232,232,231,231,230,231,231,231,231,230,231,230,231,231,231,230,230,231,230,230,230,230,230,230,230,229,230,230,229,230,230,231,230,231,230,230,231,230,231,231,231,231,231,232,231,232,231,231,231,231,232,231,232,231,231,232,231,232,231,231,231,230,232,231,231,229,229,230,229,230,229,229,229,229,229,229,230,229,230,230,230,230,230,231,231,231,231,231,232,231,232,231,231,231,231,232,231,232,231,232,232,232,232,232,232,232,232,233,232,233,232,233,233,233,234,233,234,234,234,234,234,235,233,234,233,233,233,233,233,233,233,233,233,233,233,234,233,234,233,233,234,233,233,233,233,233,232,233,232,232,228,229,229,230,229,230,230,230,231,230,231,230,231,231,230,231,230,231,230,231,230,230,231,230,231,230,231,230,230,231,230,231,231,231,231,231,231,230,231,231,231,231,230,231,230,231,230,230,230,230,231,230,230,230,230,230,230,231,230,230,230,230,230,229,230,229,229,230,229,230,229,230,229,229,230,230,230,229,230,230,230,231,230,231,231,231,231,231,231,231,232,231,232,231,231,231,231,232,231,231,231,230,231,231,231,231,231,231,231,232,231,232,231,231,231,231,232,231,232,231,231,231,231,232,232,232,231,231,232,231,232,231,231,231,230,231,231,231,231,231,232,231,232,231,231,231,231,232,232,232,231,231,232,232,232,231,232,232,232,232,232,232,232,232,232,232,232,231,232,231,231,231,231,231,231,231,230,230,231,230,231,230,231,230,230,230,230,230,230,230,230,230,230,229,230,229,229,229,229,229,229,229,229,229,229,229,230,229,230,230,230,230,230,231,230,230,230,230,230,230,230,229,230,230,229,229,229,229,229,229,229,228,229,228,229,228,228,228,228,229,228,229,228,229,229,229,230,229,230,230,230,231,230,231,230,231,231,231,231,231,231,231,231,231,231,232,231,232,231,231,231,231,232,231,232,231,231,231,230,232,231,231,231,231,232,231,232,231,231,231,231,232,232,232,231,231,232,231,232,231,232,232,232,232,232,232,231,232,232,232,232,232,233,232,232,232,231,232,231,231,230,230,230,230,231,230,230,230,230,231,231,231,230,231,231,231,231,231,231,231,231,231,230,231,230,231,231,231,231,231,231,231,231,231,231,231,231,232,231,231,231,231,232,231,232,231,231,231,231,233,232,232,232,231,232,232,232,231,232,232,232,232,231,232,231,231,230,230,232,231,232,230,231,231,231,232,231,232,231,231,231,231,232,231,232,231,231,232,231,232,231,232,231,231,232,231,232,231,231,231,231,232,232,232,232,232,233,232,233,233,233,233,233,234,233,234,234,234,234,234,234,234,234,233,234,234,233,233,233,233,233,233,233,232,232,232,232,232,232,232,232,233,232,233,233,232,233,232,233,232,233,233,233,233,232,233,233,233,233,232,233,232,232,232,232,232,232,232,231,232,231,231,231,231,232,231,231,231,230,232,231,232,231,231,231,231,231,231,231,230,230,231,230,230,230,230,230,230,230,230,231,230,230,231,231,231,231,232,231,232,232,231,232,231,232,231,231,231,231,231,231,231,231,230,231,230,230,229,230,230,229,229,229,230,229,229,229,229,229,229,230,229,229,230,229,230,230,230,230,230,231,231,231,231,231,231,231,231,231,231,231,231,231,231,232,231,232,231,231,231,231,233,232,232,232,232,232,232,232,232,232,232,232,233,232,233,232,233,233,233,233,233,233,233,233,233,233,233,233,233,233,233,233,232,233,232,233,233,232,233,232,233,232,232,232,232,232,231,232,231,230,230,230,230,231,230,230,230,230,231,230,231,231,231,231,230,231,230,231,230,230,231,230,231,231,232,231,232,232,231,232,232,232,232,232,232,231,232,231,231,231,230,231,231,231,230,230,231,230,231,230,230,230,230,231,230,231,230,231,231,230,231,230,230,230,230,230,230,230,230,230,229,230,230,229,230,229,230,230,230,231,230,231,231,232,231,231,232,231,232,231,232,231,231,232,231,232,232,232,232,232,233,232,232,232,233,233,233,234,233,234,234,234,234,234,235,234,234,234,234,234,233,234,233,233,233,233,233,232,232,232,231,231,231,231,231,231,231,230,231,230,232,231,231,231,231,232,231,232,231,231,232,232,233,232,232,232,232,232,232,233,232,232,232,232,233,232,232,231,232,232,231,232,231,231,231,231,231,231,231,230,231,230,231,231,230,231,230,231,230,230,230,230,230,229,230,230,229,229,229,230,229,229,229,229,230,228,230,229,229,229,229,230,230,230,229,229,230,228,229,228,228,228,228,228,227,228,227,228,228,228,228,228,229,228,228,229,228,229,229,229,229,229,230,229,230,230,230,230,230,231,230,231,230,231,231,231,231,230,231,230,230,231,230,231,230,231,231,231,231,231,231,230,231,231,230,231,230,231,230,231,231,230,231,231,232,231,231,231,231,232,231,232,231,231,231,231,232,231,231,231,231,231,231,232,231,231,231,231,232,231,232,230,231,230,230,231,230,231,230,231,232,231,232,231,231,231,231,232,231,232,230,231,231,231,232,231,232,231,231,231,231,232,231,232,231,231,232,231,232,231,232,231,231,232,231,232,231,231,231,231,232,232,233,232,232,232,232,233,232,232,232,232,232,232,232,232,232,232,232,232,231,232,231,231,231,231,232,231,232,230,231,231,230,231,230,231,230,231,231,231,232,231,232,231,231,232,231,232,231,231,231,231,232,232,232,232,232,232,232,233,233,233,233,234,234,234,235,234,235,235,235,235,235,236,235,236,236,235,235,235,236,235,235,235,234,235,234,234,234,233,233,233,233,232,233,232,232,232,232,233,232,232,232,232,233,232,233,232,233,233,232,233,232,233,232,232,233,232,233,232,233,233,233,233,232,233,232,232,232,232,232,232,232,231,231,231,231,231,231,231,231,231,231,231,231,231,231,230,231,231,231,231,230,231,231,230,231,230,231,230,231,230,230,231,230,231,230,231,231,231,231,231,232,231,231,231,230,230,230,230,229,229,229,228,229,228,229,229,228,230,229,230,230,230,230,230,231,230,230,230,230,230,230,231,230,230,230,230,231,230,231,230,231,231,231,231,231,232,231,231,231,231,232,231,232,231,231,231,231,232,232,232,231,231,232,231,232,231,232,232,232,232,232,233,232,232,232,232,233,232,232,232,232,232,232,232,232,232,231,232,232,231,232,231,232,231,231,231,230,232,231,231,230,230,231,230,231,230,230,230,231,230,231,230,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,232,231,232,231,231,231,231,231,231,231,230,231,231,231,231,230,231,230,231,231,230,231,231,231,230,231,231,230,231,230,230,230,230,230,230,230,229,230,229,229,230,229,230,230,230,230,230,231,231,231,231,231,231,231,232,231,232,231,231,231,231,232,232,233,232,233,233,233,234,233,234,234,234,234,234,235,234,235,235,235,235,235,235,235,235,235,235,236,235,235,234,234,234,234,234,233,233,232,232,232,231,232,230,231,231,231,231,231,232,230,232,231,231,231,231,232,231,232,232,231,232,232,232,232,232,232,232,233,232,232,232,232,232,232,232,231,232,232,231,232,231,232,231,231,231,231,232,231,231,230,230,231,231,231,230,230,230,230,230,230,230,230,230,230,230,230,229,230,230,230,230,229,230,230,230,229,230,230,230,230,230,231,230,230,230,229,230,229,229,229,229,229,228,229,228,228,228,228,229,229,229,229,229,230,229,230,229,230,229,230,230,229,230,230,230,230,230,231,230,231,230,230,230,230,230,230,230,230,230,230,230,231,230,230,230,230,230,229,230,229,230,230,230,230,230,230,230,230,230,230,231,230,231,230,231,231,230,231,230,231,231,230,230,230,231,230,231,230,230,231,230,231,230,231,231,230,231,230,231,230,230,230,230,230,229,230,229,229,231,231,231,232,231,232,231,231,231,231,232,231,231,230,230,231,231,231,230,231,231,231,231,230,231,231,231,231,231,231,231,232,231,232,232,231,232,231,232,231,232,232,232,232,232,232,232,232,232,231,232,231,232,232,232,232,232,232,232,232,232,232,232,231,232,231,231,231,230,232,230,231,230,230,231,230,231,231,231,231,231,232,231,232,230,231,231,231,232,231,232,231,232,232,232,233,233,234,233,234,234,234,235,234,235,235,235,235,235,236,235,236,235,235,236,235,236,236,236,235,235,236,235,235,235,235,235,234,235,234,234,233,233,233,232,233,232,232,232,232,233,232,233,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,231,232,232,232,232,232,232,231,231,231,231,232,231,232,231,231,231,231,232,232,232,232,231,232,232,232,231,232,231,231,232,231,231,231,231,231,231,232,230,231,230,231,231,231,232,231,232,231,231,231,230,231,230,230,230,230,230,229,230,229,229,229,229,229,229,230,229,229,230,230,230,229,230,230,230,230,229,230,229,230,230,229,230,229,230,230,230,230,230,231,231,231,231,231,231,231,232,231,232,231,231,231,231,232,231,232,231,230,231,231,232,231,232,231,231,232,232,232,232,232,232,232,232,232,232,231,232,232,231,232,231,231,231,231,231,231,232,231,231,231,231,231,231,231,231,231,230,230,230,230,230,231,230,231,230,230,230,230,231,230,231,230,230,231,230,231,230,231,231,231,231,231,232,231,232,231,231,231,231,232,232,232,231,231,232,231,232,230,231,231,230,231,231,231,230,230,231,230,231,230,231,231,231,231,230,231,231,231,231,231,231,230,231,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,231,230,231,230,230,230,230,231,230,231,230,231,231,231,232,232,232,232,232,233,233,234,233,234,234,234,234,234,235,234,234,234,234,235,234,235,234,235,235,234,235,234,235,234,234,234,234,234,234,234,233,233,233,232,232,232,232,232,231,232,231,232,231,231,231,231,232,231,232,231,231,232,231,232,232,232,232,232,232,232,233,232,232,232,232,233,232,232,232,232,232,232,232,231,232,231,231,231,230,231,230,231,230,230,231,230,231,230,230,230,230,230,230,231,230,230,230,230,230,229,230,229,229,230,228,230,229,229,229,229,229,229,229,229,229,229,229,230,229,230,230,230,230,230,230,230,230,229,229,229,229,229,229,229,229,229,229,229,230,229,230,230,230,230,229,230,230,230,230,230,230,229,230,229,229,229,229,230,229,230,229,229,230,229,230,229,230,229,229,230,229,230,229,229,229,229,230,229,230,230,230,230,230,231,230,230,230,231,231,231,231,230,231,230,230,230,230,231,230,230,230,230,230,230,231,230,231,230,230,230,230,231,230,230,230,230,231,230,230,229,229,229,231,230,231,230,231,231,231,231,231,232,231,231,231,231,231,231,232,231,231,231,231,232,231,232,231,231,231,231,232,231,232,231,232,232,232,232,232,232,232,232,232,232,232,231,232,231,232,232,231,232,232,232,232,232,232,231,232,231,231,231,231,232,231,232,230,230,231,230,231,230,230,230,230,231,230,230,229,230,230,229,230,230,230,230,230,230,230,231,231,231,232,232,233,232,233,233,234,234,234,235,234,235,235,235,235,235,236,235,236,235,236,236,236,236,236,236,236,236,236,236,237,236,236,236,236,236,235,235,234,234,234,234,234,233,234,233,233,233,233,233,232,233,232,232,232,232,232,232,232,232,232,232,231,232,232,232,232,232,232,231,232,231,232,232,232,232,232,232,232,232,232,232,232,232,232,231,231,232,231,232,231,232,231,231,231,231,232,231,231,231,230,231,231,232,231,231,231,230,231,231,231,230,230,230,230,231,230,230,230,230,231,230,231,230,231,231,231,231,230,231,230,230,230,230,230,229,229,229,229,229,229,229,229,229,228,229,230,229,229,229,230,230,229,230,229,229,229,229,229,229,230,229,230,229,230,230,229,230,230,230,230,230,230,230,231,230,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,232,231,232,231,232,231,231,232,231,232,231,231,231,230,231,230,231,230,230,230,230,231,230,230,230,230,230,230,230,229,229,230,230,230,229,229,228,230,231,230,231,231,230,231,230,231,230,230,231,230,231,230,231,231,230,231,231,231,230,231,231,230,231,231,231,230,230,231,230,230,229,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,229,231,230,230,230,230,230,230,230,230,230,230,229,230,229,230,229,229,229,229,230,230,230,229,229,230,229,229,229,229,229,230,230,229,230,230,231,231,231,232,232,233,233,233,234,234,234,234,234,234,234,235,234,235,234,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,234,234,234,234,234,233,234,233,233,233,232,233,232,232,232,232,232,232,232,231,232,231,231,231,231,232,231,232,231,231,231,231,232,231,232,231,231,232,231,233,232,232,232,232,232,231,232,231,231,231,231,231,231,231,230,230,231,230,230,230,230,230,230,230,229,230,229,229,230,229,230,229,230,229,229,230,229,229,229,229,229,229,229,229,230,229,230,229,229,230,229,230,229,230,230,230,230,229,230,229,229,229,228,229,228,229,228,228,229,229,229,228,229,229,228,229,228,229,228,229,229,228,229,228,229,228,229,229,228,229,228,229,228,229,229,228,229,228,229,229,229,229,229,230,229,230,229,229,230,229,230,230,230,230,230,230,230,230,230,230,230,230,231,230,231,230,230,230,230,231,230,230,230,230,230,230,230,230,230,230,230,230,229,230,230,230,230,230,230,229,230,230,230,230,229,230,231,230,231,230,230,230,230,231,230,231,230,230,231,230,231,230,231,230,230,231,231,231,231,231,231,231,232,231,232,231,231,231,231,232,231,232,231,231,231,231,232,231,232,231,231,232,231,232,231,231,231,231,232,231,231,230,230,231,231,231,230,231,231,231,231,231,231,230,230,230,230,230,229,230,229,229,229,229,229,229,230,229,230,230,230,231,231,232,231,232,232,232,233,233,233,233,234,235,234,235,235,235,235,235,236,235,236,235,235,235,236,236,236,236,236,236,237,236,237,236,237,237,237,236,236,236,235,235,235,234,235,234,234,233,233,233,233,233,232,233,232,232,232,232,232,231,232,231,231,231,231,232,231,232,231,231,231,231,232,232,232,232,232,232,232,232,232,232,232,232,232,231,232,231,231,232,231,232,231,232,231,231,231,231,232,231,231,230,230,231,230,231,230,230,231,230,231,230,231,230,231,230,230,231,230,230,230,230,230,230,230,230,230,230,230,230,230,230,229,230,230,229,229,228,228,228,228,228,227,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,227,228,228,228,229,228,229,228,229,229,229,230,229,230,229,230,230,230,230,230,230,230,230,231,230,231,230,231,231,231,231,231,232,231,231,231,231,232,231,232,231,231,231,231,232,231,232,230,230,231,230,231,230,230,230,230,231,230,231,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,231,230,230,230,230,231,230,231,230,230,231,230,231,230,230,230,230,230,230,231,230,230,230,230,230,230,230,230,230,230,230,230,229,230,230,230,230,230,230,229,230,230,230,230,230,230,230,230,230,230,230,230,230,229,230,230,229,229,229,230,229,230,230,229,230,230,230,229,229,230,229,229,229,229,229,229,229,228,230,229,229,230,230,230,230,231,231,231,232,232,233,232,233,233,233,233,233,234,233,234,234,233,234,234,234,233,234,234,234,234,233,235,234,234,234,234,235,235,235,235,235,235,235,235,234,235,235,234,234,234,234,233,233,233,233,233,232,233,232,233,232,232,233,232,232,232,232,232,231,232,231,231,231,231,231,231,231,231,231,231,231,232,231,232,231,232,232,232,232,231,232,231,231,231,230,231,230,231,230,230,230,229,230,229,229,229,229,229,229,229,228,229,229,228,229,228,229,228,228,228,228,229,228,228,228,228,228,228,228,228,228,228,228,229,228,229,228,229,229,229,229,228,229,228,228,228,227,228,227,228,227,228,227,227,227,227,227,227,227,227,227,227,227,227,227,227,227,227,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,229,228,229,229,229,229,229,230,229,229,229,229,230,229,230,230,230,230,230,231,230,230,230,230,230,230,231,230,230,230,230,230,230,230,229,230,230,229,230,229,230,229,229,229,229,230,229,230,229,229,230,229,230,231,230,230,230,230,231,230,230,230,231,230,230,230,230,231,230,230,230,230,231,230,231,230,231,231,231,231,231,232,231,231,231,231,232,231,232,230,230,231,231,231,231,231,231,231,231,231,232,231,231,231,230,230,230,230,229,229,229,229,230,229,229,229,229,230,229,230,229,229,229,229,230,229,230,229,229,229,230,230,229,230,230,230,230,230,231,231,232,232,232,232,232,233,232,233,233,233,234,234,234,234,235,235,235,235,235,236,235,235,235,235,236,236,236,236,236,236,236,236,236,236,236,236,236,236,236,235,236,235,235,235,234,235,234,234,234,233,233,233,233,233,233,233,232,233,232,232,232,232,232,231,232,231,231,230,231,231,231,231,231,231,231,231,232,231,232,231,231,231,231,231,231,231,231,231,231,231,232,231,231,231,231,231,231,231,230,231,230,230,230,230,230,229,230,229,229,230,229,230,229,229,229,229,230,229,229,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,227,228,227,227,227,227,227,227,227,227,227,227,227,227,226,227,226,227,226,226,227,226,227,227,227,227,228,228,228,229,228,228,229,229,229,229,230,229,229,230,229,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,231,230,230,230,230,230,230,230,230,230,230,229,230,229,229,229,229,230,229,230,229,229,229,229,230,229,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,229,229,230,229,230,229,230,229,229,229,229,229,229,229,229,229,230,229,230,229,230,229,229,230,229,230,229,229,229,228,229,228,228,228,228,228,228,229,228,229,229,229,230,229,230,229,230,230,230,230,230,231,230,230,230,230,231,230,232,231,232,232,232,232,232,232,232,232,233,232,233,233,233,233,233,234,233,234,233,234,234,234,234,234,234,233,234,234,234,234,234,235,234,234,234,234,235,234,235,234,234,234,234,235,234,234,234,234,234,233,234,233,233,233,232,233,232,233,232,232,232,232,232,231,231,231,231,231,231,231,230,231,230,230,231,230,231,230,231,231,231,231,231,231,230,231,231,230,231,230,231,230,230,230,229,231,230,230,229,229,229,228,228,228,228,228,228,228,227,229,228,228,228,228,229,228,229,228,228,228,227,228,227,227,227,227,227,227,227,227,227,227,227,228,227,227,226,226,227,226,227,226,226,226,226,226,226,226,225,225,225,225,225,224,225,225,225,225,225,226,226,227,226,227,227,227,227,227,227,227,227,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,229,228,229,228,228,229,229,230,229,229,230,229,230,229,230,230,230,231,230,230,230,230,230,230,230,229,230,229,229,229,229,230,229,230,229,229,229,229,229,229,229,229,229,229,228,229,228,230,230,230,230,230,230,231,230,231,230,230,230,230,231,230,230,230,230,230,230,231,230,230,231,231,231,230,231,230,231,231,231,231,231,231,231,231,231,231,231,230,231,231,231,231,231,231,231,231,231,231,231,230,230,229,229,229,228,229,228,229,228,228,228,228,230,229,229,230,230,230,230,231,230,230,230,230,231,230,231,230,231,231,231,232,232,232,232,232,233,233,233,233,233,233,234,234,233,234,234,234,234,234,235,234,235,235,235,235,235,236,235,236,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,234,235,234,234,234,234,234,233,233,233,233,233,232,232,232,232,232,232,232,231,232,231,231,230,231,231,231,231,230,231,231,231,231,231,232,231,232,231,231,232,231,233,232,232,232,232,233,232,232,231,231,231,231,232,230,231,230,230,230,229,230,229,229,229,229,230,229,229,229,229,229,229,229,228,229,228,228,228,227,227,227,227,226,226,227,226,226,226,226,226,226,226,225,226,225,225,226,225,226,225,226,225,225,226,225,225,225,225,225,225,226,225,226,226,226,227,227,228,227,228,228,229,229,228,229,228,229,229,229,229,229,230,229,230,230,229,229,229,230,229,229,229,229,230,229,230,229,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,229,230,229,229,230,229,230,229,229,229,229,229,229,230,229,230,229,229,230,229,229,230,230,230,230,230,230,229,230,229,229,230,229,230,229,229,229,229,230,229,230,229,230,230,229,230,229,230,229,230,230,229,230,229,230,229,229,230,229,230,229,230,229,229,230,229,230,229,229,229,229,230,229,229,229,228,228,228,228,227,228,228,228,228,228,230,229,229,229,229,230,230,230,230,230,230,230,230,230,230,230,230,230,230,231,231,231,231,232,232,232,232,232,232,232,232,232,232,233,232,233,233,233,233,233,234,233,234,233,233,234,233,234,234,234,234,234,235,234,234,234,234,234,234,235,234,234,234,234,234,234,234,234,234,234,233,234,233,233,233,233,233,232,233,232,232,232,232,232,231,232,231,231,231,231,231,230,231,230,230,230,230,231,230,230,230,230,230,230,231,230,230,230,230,230,230,231,230,230,230,230,230,229,230,229,229,229,228,229,228,228,228,228,228,227,228,227,227,227,227,228,227,228,227,227,227,227,227,227,227,226,226,226,226,226,225,226,226,226,225,225,226,225,225,225,225,225,225,226,225,225,225,225,225,224,225,224,224,224,224,225,224,225,225,225,226,226,227,226,227,227,227,227,227,228,227,228,227,228,228,227,228,227,228,227,227,227,227,227,227,227,227,227,228,227,229,228,229,229,229,230,229,230,229,229,230,229,230,230,230,230,230,230,230,230,229,230,230,229,229,229,229,228,229,229,228,228,228,229,228,228,228,228,228,228,228,228,228,228,228,230,230,230,230,230,231,230,231,230,230,231,230,231,230,231,230,230,231,230,231,230,231,231,230,231,230,231,231,231,231,231,231,231,231,231,231,231,230,231,230,230,230,230,230,229,230,229,229,229,229,230,229,229,229,229,229,228,228,227,227,227,227,228,228,229,228,229,229,229,230,230,230,230,230,230,230,230,230,231,231,231,231,231,232,232,232,232,232,232,233,233,232,233,233,233,234,233,234,233,234,234,234,234,234,235,235,235,235,235,236,235,236,235,235,235,235,236,235,236,235,235,235,235,236,235,235,235,234,235,234,235,234,234,234,234,234,233,234,233,233,233,233,233,232,232,232,232,232,231,232,231,232,231,231,231,230,231,230,230,230,230,231,230,230,230,231,231,230,231,231,231,231,231,232,231,232,231,232,231,231,231,230,232,230,230,230,230,230,230,230,229,229,229,229,229,228,229,228,228,228,228,228,227,228,228,228,228,227,228,227,227,226,226,227,226,226,225,226,226,225,226,225,226,225,226,226,225,226,225,225,225,225,226,225,226,225,225,225,225,225,225,226,226,226,227,227,227,227,228,228,228,228,228,229,228,228,228,228,228,228,228,228,228,228,228,228,227,228,227,227,227,227,228,228,228,228,228,229,229,229,228,230,229,229,229,229,230,229,230,229,229,229,229,230,229,229,229,229,229,229,229,229,229,229,229,229,228,229,228,229,229,229,229,229,229,229,229,229,229,230,230,230,230,229,230,229,229,229,229,229,229,229,229,229,229,228,230,229,229,229,229,229,229,229,229,229,229,229,230,229,229,229,229,229,229,230,229,229,229,229,229,229,229,229,229,229,229,229,229,230,229,229,229,229,229,228,229,228,227,228,227,228,228,228,228,229,229,229,230,229,230,230,230,230,230,230,230,230,230,230,231,230,232,231,231,231,231,232,232,232,232,231,232,232,232,232,232,232,232,232,232,233,232,233,233,233,233,233,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,235,234,235,234,234,234,234,234,234,234,233,233,233,232,233,232,232,232,231,232,230,231,231,231,231,231,232,230,231,230,230,230,230,230,230,230,229,229,230,229,230,229,229,230,229,230,229,230,229,229,230,229,230,229,229,230,229,229,228,229,229,229,228,228,229,228,228,228,228,228,227,228,227,228,227,227,227,227,228,227,228,227,227,227,226,227,226,226,226,226,226,225,226,225,226,226,225,226,226,226,225,225,225,225,225,224,224,224,224,224,223,224,224,224,224,224,225,225,225,225,225,225,225,226,225,226,225,225,226,225,226,225,226,226,226,226,225,226,225,225,225,225,226,226,227,226,227,227,227,229,228,229,228,229,229,229,229,229,230,229,229,230,229,230,230,230,229,229,230,229,230,229,229,229,229,229,228,229,228,229,229,228,229,228,229,228,228,229,229,229,228,229,228,231,230,230,230,231,230,231,230,230,230,230,231,230,231,230,230,231,230,231,230,230,231,230,231,230,231,230,231,231,230,231,230,231,231,231,231,231,231,231,231,231,230,231,230,230,230,230,230,229,230,229,229,228,228,228,228,228,227,228,228,228,228,228,230,229,229,230,230,230,230,231,230,230,230,230,230,230,230,230,231,231,231,232,232,233,232,233,233,233,233,233,233,233,233,234,233,234,233,233,233,233,234,234,234,234,234,234,234,235,234,235,234,234,235,235,235,234,235,235,235,235,235,235,235,235,235,235,235,234,235,234,234,233,233,234,233,234,233,233,233,233,233,232,232,232,232,232,232,232,231,232,231,231,231,231,232,232,232,231,231,231,231,232,231,231,231,230,232,231,231,230,230,231,231,232,231,232,231,231,231,230,232,231,231,230,230,231,230,230,230,230,229,229,229,228,229,228,228,228,228,229,227,228,228,228,228,227,228,227,227,227,227,227,226,227,225,226,226,225,226,226,226,225,226,226,226,226,226,226,226,226,226,225,225,225,225,225,225,226,225,226,225,225,226,226,226,226,226,226,226,226,226,227,226,227,227,227,227,227,227,226,227,227,226,227,226,227,226,227,227,227,227,227,228,228,229,229,229,229,229,230,229,229,229,229,230,229,230,229,229,230,229,230,229,230,229,229,230,229,230,229,229,229,229,230,229,230,229,229,229,229,230,229,229,229,229,230,229,230,229,230,230,230,230,230,230,230,230,230,230,229,230,229,230,230,229,230,229,230,229,229,229,229,230,229,229,229,229,230,229,230,229,230,230,230,230,229,230,229,230,229,229,230,229,230,229,229,229,229,229,229,229,228,228,228,228,228,228,228,228,228,229,228,229,229,229,229,229,230,229,230,229,229,229,229,230,229,230,229,230,230,230,231,231,232,231,232,232,231,232,231,232,231,231,232,231,232,232,232,232,232,233,232,233,232,233,233,233,233,233,234,233,234,234,234,234,234,235,234,234,234,234,235,234,235,234,234,235,234,234,234,234,234,234,234,233,234,233,233,233,233,233,233,233,232,232,232,232,232,231,232,231,231,231,230,231,231,231,230,230,231,230,230,230,230,230,230,230,229,230,229,229,229,229,230,229,229,229,229,229,229,229,229,229,229,229,229,229,229,228,228,228,228,228,227,228,227,227,227,227,228,227,228,227,227,227,227,228,227,228,227,227,227,226,227,226,226,226,226,226,225,226,225,225,226,225,226,225,226,225,225,225,225,225,225,225,225,224,225,224,224,224,224,224,224,225,224,225,224,225,225,225,225,224,225,224,225,225,224,225,225,225,225,225,226,225,226,226,226,226,226,227,227,228,228,228,228,228,229,228,229,229,229,229,229,230,229,229,229,229,230,229,230,229,229,229,229,229,229,229,228,229,229,228,229,228,229,228,228,228,228,228,228,228,228,228,228,227,229,228,231,231,231,232,231,232,231,231,231,231,232,231,232,231,231,231,231,232,232,232,231,231,232,231,232,231,231,231,230,232,231,231,230,230,231,230,231,230,230,230,230,230,230,230,229,230,230,229,230,229,229,228,228,228,227,227,226,227,227,228,228,228,229,229,229,229,229,230,229,230,230,230,230,230,231,230,231,230,231,232,232,232,232,233,233,233,233,233,234,233,233,233,233,233,233,233,233,233,233,233,234,234,234,234,234,234,234,235,234,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,234,234,234,234,234,233,234,233,233,233,233,233,233,233,233,233,233,232,233,232,232,232,232,232,232,232,231,232,232,231,232,231,232,231,231,231,231,231,231,231,230,231,231,230,231,230,231,230,230,231,230,230,230,230,230,230,230,230,230,230,230,230,229,229,228,229,228,228,228,227,228,227,228,227,227,228,227,228,227,228,227,227,228,227,228,227,227,227,227,227,227,227,226,226,227,226,227,227,227,227,227,227,227,227,227,227,227,226,227,226,227,226,226,226,226,226,226,226,226,226,226,226,227,226,227,226,226,226,226,227,226,226,226,226,227,226,227,226,227,227,227,227,227,228,228,228,228,228,229,229,229,229,229,229,229,230,229,229,229,229,229,229,229,228,230,229,229,230,229,230,229,229,230,229,230,229,230,229,230,230,229,230,229,230,230,230,230,230,231,230,231,230,230,230,230,230,230,230,230,230,229,230,229,230,230,229,230,229,230,229,229,230,229,230,228,230,229,229,230,229,230,229,230,229,229,230,229,230,230,230,230,230,230,229,230,230,229,229,229,230,229,229,228,228,228,227,228,227,227,227,227,228,228,228,227,228,228,229,229,229,229,229,230,230,230,230,230,230,230,231,231,231,232,231,232,232,232,232,232,233,232,232,232,232,232,232,232,231,232,232,232,232,232,233,232,233,233,233,233,233,234,234,234,234,234,235,234,234,234,234,235,235,235,234,235,235,235,235,234,234,234,234,233,233,233,232,233,232,232,232,232,233,232,232,232,232,232,232,232,231,231,231,231,231,231,231,231,231,231,230,231,230,230,230,230,230,229,230,229,229,229,229,230,229,230,229,230,229,229,230,229,230,229,229,229,229,230,229,230,229,229,229,229,229,228,229,228,228,228,227,228,227,228,227,227,227,227,228,227,228,227,227,228,227,228,227,227,227,227,227,227,227,226,227,227,226,227,226,227,226,226,227,226,227,226,226,226,226,226,226,226,225,226,226,225,226,226,226,225,226,226,225,226,226,226,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,226,227,226,227,227,228,228,228,229,228,229,229,229,229,229,229,228,230,229,229,229,228,230,229,229,229,229,229,229,230,229,229,229,228,229,228,229,228,228,229,228,229,228,228,228,229,229,229,230,229,230,231,231,232,231,232,231,231,231,230,232,231,231,231,230,231,231,232,231,231,231,230,232,231,232,231,231,231,230,232,231,231,230,230,231,230,231,230,230,230,230,231,230,231,230,230,230,230,230,229,229,228,228,228,228,228,227,228,228,228,228,228,229,228,229,229,229,230,230,230,230,230,230,231,231,231,232,232,232,232,232,233,233,233,233,233,233,233,234,233,233,233,233,233,233,233,232,233,233,232,233,233,233,233,233,233,233,234,233,234,234,234,234,234,235,234,234,234,234,235,235,235,235,235,235,235,235,234,234,233,233,232,232,232,231,231,231,231,232,232,232,232,232,232,232,233,232,233,232,233,233,233,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,231,232,231,231,231,230,232,231,231,230,230,230,230,231,230,230,230,230,230,230,230,229,230,230,230,230,229,229,229,228,228,228,228,227,228,227,227,227,227,228,227,228,227,227,228,227,228,227,227,227,227,228,227,228,227,227,227,227,228,227,228,227,227,227,227,228,228,228,228,228,229,229,229,229,229,229,229,230,229,229,229,229,229,229,229,228,229,228,228,228,227,227,226,227,226,226,227,226,226,226,226,227,227,227,227,228,228,228,228,228,229,229,230,229,229,229,229,230,229,230,229,229,230,229,230,229,229,229,229,230,229,230,229,229,230,229,230,229,230,229,229,230,230,230,230,230,230,231,231,231,232,231,232,231,230,229,231,230,230,230,230,230,229,230,230,230,229,230,230,229,230,230,230,230,229,230,229,230,230,230,230,230,230,229,230,230,229,230,229,230,230,230,230,230,230,230,230,229,230,230,229,229,228,229,228,228,228,228,228,227,228,227,227,227,227,229,228,229,229,229,229,229,230,230,230,230,230,230,230,231,231,231,231,231,232,232,232,232,232,232,232,232,231,232,232,231,231,231,232,231,232,232,231,231,231,232,232,232,232,232,233,233,233,233,233,234,234,234,234,234,234,234,235,234,235,234,235,235,234,234,233,232,231,231,230,230,230,229,230,230,230,230,230,232,231,232,231,232,232,232,232,232,232,232,232,232,231,232,231,231,231,231,232,231,231,230,230,230,230,230,229,230,229,229,229,228,229,228,229,229,228,229,228,229,228,229,229,228,229,228,229,228,228,229,228,229,228,229,228,228,228,228,228,227,228,228,227,228,227,228,227,228,227,227,228,227,227,227,227,227,227,228,227,227,227,227,227,227,227,226,226,226,226,227,226,227,226,227,227,227,227,227,228,228,228,228,228,228,227,228,227,227,227,227,227,226,226,226,226,226,225,226,225,226,226,226,226,226,227,226,227,227,227,228,228,229,228,228,229,229,230,229,230,229,229,230,229,230,229,230,229,229,229,229,230,229,229,229,229,229,228,229,228,228,228,228,229,228,228,228,228,229,228,229,228,229,229,230,230,229,231,230,230,230,231,232,231,232,231,231,231,231,232,231,231,231,230,232,231,232,230,231,231,230,231,230,231,230,230,231,230,231,230,230,230,230,230,230,230,230,230,230,230,230,230,230,229,230,230,229,230,229,229,228,228,228,227,228,227,228,227,227,228,228,229,228,229,229,229,230,230,230,230,231,231,231,231,231,232,232,232,232,232,233,232,233,233,233,234,234,234,233,234,234,234,234,233,234,233,233,233,233,233,233,233,233,233,233,233,233,233,234,234,234,234,234,235,234,235,234,234,235,234,235,234,234,234,234,234,232,232,231,231,230,229,230,229,229,229,230,230,230,231,231,232,232,232,233,232,233,233,233,233,233,233,232,233,232,232,232,232,232,232,232,231,232,232,231,231,231,231,231,231,231,230,231,230,230,230,230,230,229,230,229,229,229,229,229,229,229,228,229,229,229,229,228,229,229,229,229,228,229,228,229,228,228,228,228,228,228,228,228,227,228,227,228,227,227,227,227,228,227,228,227,228,228,228,228,228,228,228,228,228,228,228,228,229,229,229,229,229,230,229,229,229,229,229,228,229,228,228,228,228,228,227,227,227,227,227,227,228,227,227,227,227,228,227,228,227,228,228,228,228,228,229,228,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,230,229,230,229,229,229,229,230,229,230,229,230,230,230,230,229,230,230,230,230,230,231,230,231,231,231,232,232,233,232,233,233,233,230,230,230,230,230,230,229,230,230,229,230,229,229,229,229,229,229,229,228,229,228,229,229,229,229,229,230,229,229,230,229,230,229,230,230,229,230,230,230,230,230,230,230,230,229,230,229,229,229,229,229,228,229,228,228,228,228,228,228,228,228,228,229,228,229,229,229,229,229,230,230,230,230,231,231,231,231,231,232,232,232,232,232,232,232,232,232,232,232,232,232,231,231,231,231,232,231,232,231,231,231,231,232,232,233,232,232,233,233,233,233,234,234,234,234,234,234,233,234,234,234,233,233,233,232,231,230,229,229,229,229,228,228,228,228,230,229,230,230,229,230,231,231,231,231,231,231,232,231,232,230,231,231,230,231,230,231,230,230,230,230,230,229,230,229,229,229,229,230,229,230,229,229,229,229,230,228,229,228,228,229,228,229,228,228,228,228,229,228,229,228,229,229,228,229,228,229,228,228,229,228,229,228,228,228,228,228,228,228,228,228,228,227,228,227,227,226,227,227,227,227,226,227,227,227,227,226,227,226,227,226,226,227,227,227,227,227,227,227,227,227,227,227,227,227,226,227,226,226,226,226,227,226,227,227,228,227,228,228,228,228,228,229,229,229,229,228,230,229,229,229,229,230,229,229,229,229,229,229,230,229,229,229,229,229,229,229,228,229,229,228,229,228,229,228,229,229,228,229,228,229,228,229,229,229,229,229,230,229,229,230,230,231,230,231,231,231,231,231,232,231,230,231,230,230,230,230,231,230,231,230,230,231,230,231,230,230,231,230,231,230,230,230,230,230,230,231,230,230,230,230,230,230,231,230,230,230,230,230,230,230,229,230,230,229,229,229,230,229,229,229,229,229,228,229,228,228,228,228,229,229,229,229,230,230,230,231,230,231,231,231,232,231,232,232,232,232,233,233,233,233,233,233,234,233,233,233,233,233,233,233,232,232,232,232,232,232,232,231,232,232,232,232,232,233,232,233,232,233,233,233,233,233,233,233,233,233,233,233,233,233,233,232,232,231,231,230,230,229,229,230,228,229,229,229,230,230,231,230,231,231,231,232,232,232,232,232,232,232,232,232,232,231,232,232,231,232,231,232,231,231,231,231,231,230,231,231,230,230,230,231,230,230,230,229,230,229,229,228,228,228,228,229,228,229,228,228,228,228,229,228,229,228,229,229,228,229,228,229,228,228,229,228,229,228,228,228,228,229,228,229,228,228,228,228,228,227,228,227,228,228,228,228,228,229,228,228,228,228,229,228,228,228,229,229,229,229,229,229,229,229,229,228,229,228,228,228,228,229,228,229,228,228,229,228,229,228,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,230,229,230,229,229,229,229,230,229,229,229,229,229,229,230,229,229,229,229,230,229,230,230,230,230,230,230,230,231,230,230,231,231,232,231,232,231,232,232,232,233,232,233,232,233,233,229,229,229,228,229,229,229,228,229,229,228,229,228,229,229,229,229,229,230,229,229,229,229,230,229,230,230,230,230,230,231,230,230,230,230,230,230,230,229,229,229,229,230,229,230,229,229,229,228,229,228,228,228,228,228,227,228,227,228,228,228,229,228,229,228,229,230,229,230,230,230,230,231,231,231,231,231,232,231,232,232,231,232,232,232,231,231,232,231,232,230,230,230,230,230,230,230,230,230,230,230,231,230,231,231,231,232,232,233,232,233,233,233,233,233,233,233,233,233,233,233,232,232,231,231,230,229,230,229,229,228,228,228,228,230,229,230,230,230,230,230,231,230,231,231,231,231,231,232,231,231,230,230,230,230,230,229,230,230,229,229,229,229,229,229,229,229,229,228,229,229,229,229,228,229,228,229,228,228,228,228,228,227,228,228,227,228,227,228,227,228,228,228,229,228,228,228,228,228,228,228,227,228,227,228,228,227,228,227,227,227,227,228,227,227,226,226,226,226,227,226,227,226,226,227,227,227,227,227,227,227,228,227,228,227,228,227,227,227,227,227,227,227,227,227,228,227,228,227,227,228,227,229,228,228,228,228,229,229,229,228,229,229,229,229,229,230,229,230,230,229,229,229,230,229,229,229,229,229,229,229,228,228,228,228,229,228,228,228,228,228,228,229,228,228,228,228,229,228,229,228,229,229,229,229,229,229,229,230,230,229,230,230,230,230,230,231,230,231,231,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,229,230,229,229,229,229,230,229,229,229,229,229,229,229,228,229,229,229,229,228,229,228,228,228,228,228,228,229,228,229,229,229,230,230,231,231,231,232,232,233,232,233,233,233,233,233,234,233,233,233,233,233,233,233,233,233,233,233,233,232,232,231,231,231,231,232,231,232,231,231,231,231,232,232,232,232,232,232,232,233,232,233,232,232,233,232,233,232,232,232,232,232,231,231,230,230,230,230,230,229,230,229,230,230,230,231,230,231,231,231,231,231,232,232,232,231,231,232,232,232,231,232,231,231,231,230,231,231,231,230,230,230,230,230,230,230,230,229,230,230,230,229,229,230,229,230,229,229,229,229,229,228,228,228,228,228,228,229,228,228,228,228,228,228,229,228,229,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,229,228,229,228,228,229,228,229,228,229,228,228,229,228,229,228,228,228,228,229,228,228,228,228,229,228,229,228,229,228,229,229,229,229,228,229,229,229,229,229,230,229,230,230,229,230,230,230,229,230,230,229,230,229,230,229,229,230,229,230,229,229,229,229,230,229,230,229,229,229,229,230,230,230,229,230,230,229,230,230,230,230,231,232,231,232,231,232,232,232,232,232,233,232,233,232,232,233,234,228,228,228,228,228,228,228,228,228,228,228,229,228,229,228,228,228,228,229,228,229,229,229,229,229,230,229,230,229,229,230,229,230,229,229,229,229,230,229,230,229,229,229,229,229,229,229,228,228,229,228,228,228,228,228,228,229,228,229,229,229,229,229,230,230,231,230,231,231,231,231,231,232,231,232,231,231,231,231,232,232,232,232,231,232,232,232,231,231,231,231,231,230,230,230,230,231,230,231,230,230,230,230,231,230,231,231,231,231,231,232,232,232,232,232,232,232,232,232,232,232,231,231,231,231,230,230,230,229,230,229,229,229,229,230,229,230,229,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,229,230,229,229,229,229,229,229,229,228,229,228,228,229,228,229,228,229,229,229,229,229,229,229,229,229,228,229,228,228,228,228,228,228,228,227,228,227,227,228,227,229,227,228,228,228,228,227,228,227,227,227,226,227,227,227,226,227,227,227,227,226,227,226,226,227,226,227,226,227,226,226,227,226,227,226,227,227,227,227,227,227,226,227,227,227,227,227,227,227,227,227,227,228,228,228,228,228,229,228,229,228,229,229,229,229,229,230,229,229,229,229,230,229,230,229,229,229,229,230,229,229,229,229,229,229,229,228,228,228,228,228,228,229,228,228,228,228,229,228,229,228,228,229,229,230,229,230,230,230,230,230,231,230,230,230,230,231,231,231,231,231,232,233,236,238,230,230,229,230,229,230,229,229,230,229,230,229,230,229,229,230,229,230,229,229,229,229,230,229,230,229,230,230,230,230,230,230,229,230,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,230,230,230,230,230,231,231,231,231,231,232,232,232,232,232,232,232,233,232,233,233,233,233,233,233,233,233,233,232,233,232,232,232,231,231,231,231,230,230,230,230,230,229,230,230,230,230,230,230,230,230,230,230,231,230,231,231,231,231,231,232,232,232,231,232,232,232,232,231,232,231,231,231,231,231,231,232,231,231,231,231,232,231,232,231,231,231,231,232,231,232,231,231,232,231,233,231,232,232,232,232,232,232,231,231,231,230,231,230,230,229,229,230,229,229,228,229,229,229,229,228,229,228,229,229,228,229,228,229,228,228,228,228,228,227,228,227,227,227,227,228,227,228,227,227,227,227,228,227,227,227,227,228,227,228,227,227,227,227,228,227,228,227,228,228,228,228,227,228,228,228,228,228,229,228,228,228,228,229,228,228,228,228,228,228,228,228,229,228,228,229,228,229,228,229,229,229,229,229,230,229,229,229,229,230,229,230,229,230,230,230,230,230,230,230,230,230,229,230,229,230,229,229,230,229,230,229,230,229,229,230,229,230,229,230,230,230,230,230,231,230,230,231,230,231,231,231,231,231,232,232,232,231,232,232,232,232,232,233,232,233,234,236,238,241,242,228,228,228,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,228,229,229,229,229,229,229,229,229,229,229,229,228,229,228,229,228,228,229,229,229,228,229,229,228,229,229,229,229,229,229,228,229,228,228,228,228,228,228,229,228,229,229,229,230,230,230,230,230,230,230,231,231,232,231,232,231,231,231,231,232,232,231,231,230,231,231,231,231,230,230,230,230,230,230,229,229,230,229,229,229,229,229,229,230,229,230,230,230,230,230,231,230,231,231,231,232,231,232,231,231,231,231,232,231,232,230,230,230,230,231,230,230,230,230,230,230,230,229,230,230,229,230,229,230,229,230,230,229,230,229,230,229,230,230,229,230,229,230,229,229,229,228,229,228,229,228,228,228,228,229,228,228,228,228,229,228,229,228,228,229,228,229,228,228,228,228,228,228,228,227,228,227,227,227,226,228,227,227,227,226,227,226,227,226,226,226,226,227,226,226,226,226,226,226,227,226,226,226,226,227,226,227,226,227,226,226,227,226,226,226,227,227,226,227,226,227,227,227,227,227,227,227,228,227,228,228,228,228,228,229,229,228,228,228,229,228,229,229,229,229,229,230,229,230,230,229,230,230,230,229,229,230,229,229,229,229,229,229,229,228,229,228,228,228,228,228,227,228,227,228,228,228,228,228,228,228,229,229,229,229,229,230,230,230,230,230,231,230,231,231,231,231,231,233,233,236,239,241,242,243,244,229,229,230,229,230,229,229,229,228,229,229,229,229,229,229,228,229,228,229,228,228,229,228,229,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,229,228,229,228,228,229,229,229,229,229,229,230,230,229,230,230,231,231,231,231,231,232,231,232,232,232,232,232,233,232,232,232,232,233,232,233,232,232,232,232,232,232,232,232,231,231,230,230,230,230,230,229,230,229,229,229,229,229,229,229,229,230,230,230,230,230,230,230,231,231,230,231,231,231,231,231,231,231,231,231,232,231,231,231,230,231,231,231,230,230,231,230,231,230,231,230,230,231,231,231,230,231,231,231,231,230,231,231,231,231,231,231,230,231,230,230,230,229,230,229,229,229,228,229,228,229,228,228,228,229,229,228,229,228,229,229,229,229,229,230,229,229,229,228,228,228,228,228,228,228,227,228,227,228,227,227,227,227,228,227,228,228,227,228,227,228,227,228,228,228,228,228,228,228,228,228,228,229,228,228,228,228,228,228,228,228,228,228,228,228,228,228,227,228,228,227,228,227,228,228,228,228,228,229,228,229,228,228,229,228,229,228,228,229,229,229,229,229,229,229,229,229,230,229,230,229,229,229,229,230,229,230,229,229,229,229,230,229,230,229,229,230,229,230,229,229,229,229,230,229,230,230,230,230,230,231,230,231,231,231,232,232,233,232,232,232,232,233,233,234,235,238,241,242,243,244,245,246,227,228,227,228,227,227,227,227,228,227,227,227,227,228,228,228,227,227,228,228,228,227,228,228,228,228,227,228,227,228,228,228,228,228,229,228,228,229,228,229,228,229,228,229,229,228,229,228,228,228,228,228,228,229,228,229,229,229,229,229,230,229,230,230,229,230,230,231,230,230,230,230,231,230,231,230,230,231,230,231,230,230,230,230,231,230,230,230,230,230,230,230,229,230,229,229,229,229,230,229,229,229,229,230,229,230,229,230,230,230,230,230,230,230,230,230,230,231,230,231,230,230,230,230,230,230,230,230,230,230,229,230,229,229,229,229,230,229,229,229,229,229,229,230,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,228,229,228,228,228,228,228,228,229,228,229,229,229,229,229,230,230,230,230,229,230,229,230,228,228,228,227,228,227,227,227,227,228,227,228,226,227,227,227,227,227,227,226,227,227,226,227,226,227,226,226,226,226,227,226,227,227,227,227,226,227,227,227,226,226,227,226,227,226,227,227,227,227,227,227,227,227,227,227,228,227,228,228,228,228,228,229,228,229,228,228,229,228,229,228,228,229,229,229,228,229,229,229,229,228,230,229,229,229,229,229,228,229,228,228,228,228,228,228,228,228,228,228,228,229,228,228,228,228,229,229,229,229,230,230,230,230,230,231,230,231,231,231,231,231,232,232,234,237,239,241,242,244,244,246,246,246,228,229,229,229,228,229,228,228,228,227,228,227,227,227,227,228,227,228,227,228,228,228,228,228,228,228,228,228,227,228,227,228,228,228,229,228,229,228,228,229,229,230,228,229,229,229,229,229,230,229,230,229,229,230,230,231,230,230,230,230,231,231,231,231,232,232,232,232,231,232,231,232,232,231,232,231,232,231,231,231,231,232,231,231,230,230,231,230,230,230,230,229,229,230,229,229,229,229,229,229,230,229,229,229,229,229,229,230,229,230,230,230,230,229,231,230,230,230,230,231,230,231,230,231,231,230,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,230,231,230,231,230,230,230,230,230,229,230,229,229,229,229,229,229,229,229,229,229,229,230,229,229,229,229,230,229,230,229,229,230,229,230,229,229,228,228,228,228,228,227,228,227,227,228,227,228,227,228,228,228,228,228,228,228,228,228,228,228,227,228,227,228,228,228,229,228,229,228,228,229,228,229,228,228,228,228,228,227,228,228,228,228,227,228,227,227,227,228,228,228,229,228,229,228,229,229,228,229,228,229,229,229,229,229,230,229,230,230,229,230,229,230,229,229,230,229,230,229,230,229,230,230,229,230,230,230,230,230,230,229,230,229,230,230,229,230,230,231,230,231,231,231,232,231,232,232,232,232,232,233,232,232,233,233,235,237,240,240,242,243,244,245,245,246,246,247,227,227,228,228,227,227,227,228,227,228,227,227,227,227,228,227,228,227,227,228,228,229,228,228,228,228,228,228,228,228,228,228,228,229,228,228,228,228,229,228,228,228,228,228,228,228,227,228,227,227,228,227,228,227,228,228,228,229,228,229,229,229,229,229,230,229,230,229,229,230,230,230,229,230,230,230,230,230,230,230,230,230,230,230,230,230,229,230,229,229,229,228,229,229,228,229,229,229,228,229,229,229,229,229,230,229,230,229,229,230,229,230,230,230,230,230,230,230,230,229,230,230,230,230,229,230,230,230,229,229,230,229,230,230,229,230,229,230,229,230,230,229,230,229,229,229,229,229,229,229,228,229,229,229,229,228,229,229,229,229,229,229,229,230,229,229,229,229,229,229,229,229,229,229,229,230,229,230,229,230,230,230,230,230,230,230,230,230,229,229,228,228,227,227,227,226,226,226,227,227,227,227,227,227,227,227,227,227,227,227,227,227,227,227,226,227,226,227,227,227,227,227,227,227,227,227,227,227,226,227,227,227,227,227,227,226,228,227,227,227,227,228,227,228,228,228,228,228,229,229,229,229,229,229,228,229,228,229,229,229,229,228,229,229,229,229,229,229,228,229,229,228,228,228,229,228,228,228,228,228,227,228,227,228,228,228,228,228,229,228,228,229,229,230,229,230,230,230,231,230,231,230,231,231,233,235,238,240,240,242,243,243,245,245,246,246,247,248,248,249,228,227,228,227,227,227,227,227,227,227,227,227,227,227,227,227,227,227,227,228,227,228,227,227,227,227,228,227,228,226,227,227,227,228,227,229,228,228,228,228,229,228,228,228,228,229,229,229,228,229,229,229,230,229,230,229,230,230,230,230,230,231,231,231,231,231,231,231,232,231,231,231,231,232,231,232,231,231,231,230,232,231,231,230,230,230,230,230,229,229,229,229,229,228,229,228,228,228,228,229,229,229,228,229,229,229,230,229,230,230,229,230,229,230,230,230,230,230,231,230,231,230,230,231,231,231,230,231,231,231,231,231,231,230,231,231,231,231,230,231,231,231,231,231,231,231,231,230,231,230,230,230,230,230,230,230,230,230,230,229,230,230,229,230,229,230,229,230,229,229,230,229,229,229,229,229,229,230,229,230,230,230,230,230,231,230,231,230,230,230,230,230,229,229,229,228,229,228,229,228,228,228,228,229,229,229,229,229,229,229,229,228,229,229,229,229,228,229,228,229,229,229,229,228,229,228,228,228,228,228,227,228,227,227,227,227,228,227,228,227,228,228,228,229,228,229,228,228,229,229,229,228,229,229,229,229,229,229,229,229,229,228,229,229,229,229,229,229,229,230,229,229,229,229,230,229,229,229,229,229,229,230,229,230,229,230,230,230,230,230,231,231,231,231,231,232,231,232,232,232,232,232,233,233,236,239,242,244,244,246,246,247,247,247,248,248,248,248,249,250,227,226,227,226,226,226,226,227,226,226,226,226,226,226,227,226,227,227,227,227,227,228,227,228,227,227,228,227,228,227,228,227,227,227,227,227,227,227,227,227,227,226,227,227,227,227,227,228,227,228,228,228,228,228,229,228,229,229,229,229,229,230,229,229,229,229,230,229,229,229,229,229,229,230,229,230,229,229,230,229,230,229,230,230,229,230,229,229,229,229,229,229,229,228,229,228,229,229,228,229,229,229,229,229,229,229,230,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,228,228,229,228,229,229,229,229,229,230,229,229,230,229,229,229,230,229,230,229,229,230,229,230,229,230,230,229,230,230,230,230,230,230,230,230,229,230,230,230,230,229,230,230,230,230,230,230,229,230,230,230,230,230,230,229,230,230,230,230,230,230,230,230,230,229,230,229,229,228,228,228,227,228,226,227,226,227,227,227,227,226,227,227,227,227,227,227,227,227,227,227,227,226,228,226,227,227,227,228,227,228,227,228,227,227,228,227,228,227,227,227,227,228,227,228,227,227,228,228,229,228,228,228,228,229,228,229,228,228,229,228,229,228,229,228,228,228,228,229,228,228,228,228,228,228,228,227,228,228,228,228,228,228,227,228,227,227,228,227,229,228,229,229,229,230,229,230,230,230,230,230,231,230,231,231,231,231,232,234,237,240,241,243,244,245,246,246,247,247,247,248,248,248,248,249,250,226,227,226,226,226,226,226,225,227,226,226,226,226,227,226,227,227,227,227,227,228,227,227,227,227,228,227,228,227,227,227,227,228,227,228,227,227,227,227,228,227,228,227,228,228,228,228,228,229,229,229,229,229,230,229,230,230,230,230,230,231,230,231,230,230,231,230,231,230,230,230,230,230,230,230,230,230,230,230,230,229,230,229,229,229,229,229,228,229,229,228,228,228,229,228,229,229,228,229,229,229,229,229,230,229,230,229,230,230,230,230,230,230,229,230,230,230,230,230,231,230,231,231,230,231,230,231,230,231,231,231,231,231,232,232,232,232,231,232,231,232,231,231,231,231,231,231,231,231,230,231,230,231,230,230,230,230,230,230,230,230,230,230,230,230,229,230,230,229,229,229,229,229,229,229,229,230,229,230,230,230,230,230,231,230,231,230,231,231,230,231,230,230,230,230,230,229,229,229,229,229,229,229,228,229,228,228,228,228,229,228,229,228,228,228,228,228,228,228,228,228,228,228,229,228,228,228,228,228,228,228,227,227,227,227,227,227,228,227,227,227,227,228,228,229,229,228,229,229,229,228,229,229,228,229,228,229,228,229,229,229,229,229,229,229,229,229,229,230,229,229,229,229,229,229,230,229,229,229,229,230,229,230,229,230,230,230,230,230,232,231,231,231,231,232,232,232,232,232,232,233,235,237,240,242,243,245,245,246,246,247,247,247,248,248,248,248,248,248,248,225,225,225,226,225,226,225,225,226,226,227,226,227,226,227,227,227,227,226,227,227,226,227,226,227,226,227,227,227,227,226,227,227,227,226,226,226,226,226,226,226,226,226,226,226,226,226,226,227,227,227,227,228,228,228,228,227,228,228,228,228,228,229,228,229,228,229,229,229,229,229,229,229,229,230,229,230,229,230,230,230,230,229,230,229,229,229,229,230,229,230,229,229,230,229,230,229,229,229,230,230,229,230,229,230,230,229,230,229,230,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,230,229,230,229,230,230,230,230,229,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,229,230,230,230,230,230,230,230,230,229,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,229,230,229,229,228,228,228,227,228,227,227,227,227,227,227,227,227,227,227,227,228,226,227,226,226,227,226,227,227,227,227,227,228,227,228,227,228,228,228,228,227,228,227,227,227,227,228,227,228,228,228,228,228,229,228,228,228,228,229,228,229,228,228,228,228,229,228,228,227,228,228,227,228,227,228,228,228,228,227,228,227,227,227,227,228,227,228,227,227,227,227,228,228,228,228,229,229,229,230,229,230,230,230,231,231,232,232,235,237,240,242,242,244,245,246,246,246,247,247,247,247,247,247,247,248,247,248,226,225,225,225,225,225,225,225,225,225,225,225,226,226,226,226,226,226,226,227,226,227,226,226,227,226,227,226,227,227,227,228,227,228,227,227,227,227,228,228,228,228,228,228,228,229,228,229,229,229,230,229,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,231,230,230,231,230,231,230,230,230,230,230,229,230,229,230,230,229,229,229,229,229,229,229,229,230,229,230,230,230,230,230,230,230,230,230,230,230,230,231,230,230,230,230,231,230,231,230,230,230,230,231,230,231,230,231,231,231,231,231,231,231,231,232,231,232,231,231,231,231,232,231,231,230,230,231,231,231,230,231,230,230,231,230,231,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,229,230,230,230,230,230,231,230,231,230,231,231,231,231,231,231,231,230,231,230,230,229,229,229,228,229,228,228,228,228,228,228,229,228,229,228,228,229,228,228,228,228,228,228,228,227,228,227,228,227,227,228,227,228,227,228,228,227,228,227,228,227,227,227,227,228,227,228,228,228,228,228,229,228,228,228,228,229,228,229,228,229,229,229,229,229,229,229,229,229,228,230,229,229,229,229,229,229,229,228,228,228,228,229,228,229,229,229,230,230,230,230,231,231,231,231,231,232,231,232,231,232,233,236,239,242,243,244,244,245,245,246,246,246,247,247,247,247,247,247,247,248,248,248,225,225,225,225,225,225,225,225,225,225,226,225,226,226,226,226,226,227,226,227,226,227,227,226,227,226,227,226,227,227,226,227,226,226,226,226,226,226,227,226,227,227,227,227,227,228,227,228,227,227,228,228,229,228,229,229,228,229,229,229,229,229,229,229,230,229,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,229,230,229,229,229,229,230,230,230,229,230,230,230,230,230,230,230,230,230,230,230,229,230,230,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,230,229,229,230,229,230,229,230,230,230,230,230,231,230,230,230,230,231,230,231,230,230,230,230,230,230,230,230,230,231,230,231,230,231,230,230,230,230,230,230,230,230,230,230,229,230,230,230,230,230,230,230,230,230,230,230,230,230,229,230,230,229,229,229,230,229,229,229,229,229,229,229,228,228,228,227,227,227,227,227,227,227,226,227,226,227,226,226,227,226,227,226,227,227,227,227,227,227,227,227,227,227,228,227,228,227,227,228,227,228,227,228,227,227,228,227,228,227,228,228,228,228,228,229,228,228,228,228,228,228,228,228,228,228,228,228,227,228,227,227,227,227,227,227,227,227,227,227,226,228,227,227,227,227,228,227,228,228,228,228,229,230,229,230,230,230,230,230,231,230,231,232,234,237,240,241,242,244,244,245,245,246,246,246,247,247,247,247,247,248,248,249,249,249,249,224,224,225,225,225,225,225,225,225,226,226,226,225,227,226,226,227,226,227,226,227,227,227,227,227,228,227,228,227,227,228,227,228,227,228,228,227,228,228,228,228,228,229,229,229,228,229,229,229,230,229,230,230,230,230,230,231,230,230,230,230,231,230,231,230,230,230,230,231,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,231,230,231,230,231,231,231,231,230,231,230,230,230,230,230,230,231,230,230,231,231,231,230,231,231,231,231,231,232,231,232,231,231,231,231,232,231,231,231,231,231,231,232,231,230,230,230,231,230,230,230,230,230,230,230,230,231,230,230,230,230,230,230,230,230,230,230,229,230,230,230,230,230,230,230,230,230,230,230,230,231,230,231,231,231,231,230,231,230,231,231,230,231,231,231,230,230,230,230,230,229,229,229,229,229,228,228,228,228,228,228,228,227,228,227,228,227,227,227,227,228,227,227,227,227,227,227,228,227,227,227,227,228,227,228,227,227,228,227,229,227,228,227,228,228,228,229,228,229,229,229,229,228,229,229,229,229,228,229,228,229,228,228,229,228,229,228,229,229,228,229,228,229,228,229,229,229,229,229,230,229,229,230,230,231,230,231,230,231,231,230,232,231,232,231,233,237,240,242,243,244,244,245,246,246,246,246,246,246,247,247,247,247,247,248,248,248,249,249,224,224,225,225,225,225,225,225,225,226,226,227,226,226,227,227,227,226,228,227,227,227,226,227,226,227,226,226,227,226,227,226,226,226,226,226,226,227,226,227,227,227,227,227,228,227,228,228,228,228,228,229,228,228,228,229,229,229,229,229,230,230,230,230,229,230,230,230,230,230,230,230,230,230,230,230,230,231,230,230,230,230,231,230,231,230,230,231,230,230,230,231,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,229,230,229,229,229,228,228,228,229,228,228,229,229,230,229,230,230,230,230,230,230,230,230,230,230,230,230,231,230,230,230,230,230,230,231,230,230,230,230,230,230,230,230,230,230,230,230,229,230,230,230,230,229,230,229,229,230,229,230,229,230,229,229,230,229,230,229,229,229,229,230,229,229,229,229,229,229,230,229,229,229,229,229,229,229,228,228,228,228,228,228,229,228,228,227,227,227,227,228,227,228,227,227,227,226,227,227,227,226,226,227,226,227,226,226,226,226,227,226,227,227,227,227,227,228,227,227,227,227,227,227,228,227,227,227,227,228,227,228,227,227,227,227,228,227,228,227,227,227,227,227,227,227,226,226,227,226,227,226,226,226,226,227,226,227,226,227,227,227,227,227,228,227,228,228,228,229,229,230,230,230,230,230,231,231,233,234,238,241,242,244,244,245,246,246,246,247,247,247,247,247,247,248,248,248,249,249,250,250,250,250,225,225,225,225,224,225,225,225,225,225,226,226,226,226,226,227,226,227,226,227,227,227,227,227,228,227,227,227,227,228,227,228,228,228,228,228,229,229,229,229,229,230,229,230,229,229,229,229,230,230,230,229,230,230,230,231,230,231,230,231,231,230,231,230,231,231,231,231,230,231,230,231,230,230,231,230,231,230,231,230,230,230,230,230,230,230,230,230,231,230,230,230,231,231,230,231,230,231,230,231,231,231,231,230,231,231,231,231,230,231,230,230,230,230,230,229,230,230,230,230,230,231,230,231,231,230,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,230,231,230,230,230,230,231,230,230,230,230,230,229,230,229,230,230,229,230,230,230,229,230,230,229,230,229,230,229,230,230,229,230,230,230,230,230,230,230,231,230,230,230,230,230,230,231,230,230,230,230,231,230,230,230,230,230,230,230,229,230,229,229,229,228,229,228,228,228,227,227,227,227,226,227,227,226,226,226,227,226,226,226,226,227,226,227,226,226,226,226,227,226,227,226,227,227,227,227,226,228,227,227,228,227,229,227,228,228,228,228,228,229,228,228,228,228,228,227,228,228,228,228,228,228,227,228,227,228,228,228,228,228,228,228,228,229,228,230,229,229,230,230,230,230,230,230,231,230,231,232,232,235,237,239,241,243,244,245,245,245,246,246,246,247,246,246,246,246,247,247,247,247,248,248,249,250,250,250,225,225,225,225,225,226,226,226,226,226,227,226,226,226,226,227,226,227,226,227,227,227,227,226,227,227,227,226,227,227,226,227,227,227,227,227,228,227,228,227,227,228,228,229,228,228,228,228,229,228,229,229,229,229,229,230,229,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,231,230,231,231,230,231,230,231,230,230,230,230,231,230,230,230,230,230,230,230,229,230,230,229,229,229,230,229,229,229,229,229,229,229,228,228,229,228,228,228,228,228,228,229,228,229,229,229,229,229,230,229,230,230,230,230,230,230,230,230,230,230,231,230,231,230,230,230,230,230,230,230,229,230,230,230,230,230,230,230,230,230,229,230,229,230,229,229,229,229,230,229,229,229,229,229,229,229,228,229,228,228,229,228,229,228,229,229,228,229,229,229,228,229,229,229,229,228,229,229,229,228,228,229,228,228,228,228,228,227,227,226,227,227,226,226,226,227,226,226,226,226,227,226,227,226,226,227,226,227,227,227,227,227,227,227,227,227,227,227,227,227,226,227,226,226,226,226,227,226,227,226,226,227,226,226,226,226,226,226,226,225,226,225,226,225,225,226,225,226,225,226,226,226,226,226,227,226,227,227,227,228,228,229,228,229,229,229,229,229,230,230,230,230,230,233,236,240,241,243,245,246,246,246,247,247,247,247,247,247,246,246,246,247,248,248,249,249,249,249,250,250,250,250,225,225,225,225,225,225,225,225,225,226,225,226,226,226,227,226,227,227,227,227,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,229,228,229,229,229,230,229,230,230,230,230,230,231,230,231,230,230,230,230,231,230,231,231,231,231,231,231,230,231,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,231,230,230,230,230,231,230,231,231,230,231,230,231,231,231,230,231,231,230,231,230,230,230,230,230,230,230,229,230,230,230,230,230,230,230,230,231,230,231,230,231,230,230,231,231,231,230,231,231,230,231,230,231,230,230,230,230,230,230,230,229,229,230,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,230,229,229,229,229,230,229,230,230,229,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,229,230,229,229,230,229,230,229,230,229,229,229,229,229,228,228,228,227,227,227,227,226,227,227,226,226,226,226,225,226,226,225,226,226,226,226,226,226,226,227,226,227,226,226,227,226,227,226,227,227,227,227,227,227,227,227,227,227,227,227,227,227,227,227,227,227,226,227,227,227,227,227,227,227,228,227,227,228,227,228,228,228,228,228,229,229,229,229,229,229,229,230,229,230,229,229,230,230,231,232,236,240,242,244,244,245,245,245,246,246,245,245,244,244,244,245,245,246,247,248,248,248,248,247,248,248,249,249,225,225,226,225,225,225,225,225,225,226,225,226,226,226,226,226,227,226,226,226,226,227,226,227,226,227,227,227,227,227,227,227,227,227,227,228,227,228,228,228,228,228,229,229,229,229,229,230,229,230,229,229,229,229,230,230,230,230,230,230,230,231,230,230,230,230,230,230,230,229,230,230,229,230,229,230,229,229,230,230,230,230,230,230,230,230,230,231,230,231,230,231,231,230,230,230,230,230,230,229,229,229,228,229,229,229,229,228,229,228,229,229,228,228,228,228,228,228,228,228,229,228,229,229,229,229,229,230,229,230,229,229,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,229,230,229,229,229,228,229,228,229,229,228,229,228,229,228,228,228,228,228,228,228,228,228,228,228,228,227,228,227,227,228,227,229,227,228,228,228,228,228,229,228,229,229,229,229,229,229,229,229,229,229,229,228,228,228,228,228,228,228,228,228,227,227,227,226,227,227,227,226,226,226,225,226,226,226,226,226,226,226,226,226,226,226,226,227,226,226,226,226,226,226,227,226,226,226,226,226,226,226,225,226,226,225,226,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,226,225,225,226,225,227,226,227,227,227,227,227,228,228,228,228,228,229,229,229,229,230,233,237,240,240,243,245,246,246,246,247,247,247,247,247,247,246,246,246,246,246,246,247,248,248,247,246,246,246,247,247,247,248,225,225,225,226,225,225,226,225,226,226,226,226,226,227,226,227,227,227,227,228,228,227,228,228,228,228,228,229,228,229,228,229,229,229,229,229,230,230,230,230,230,230,230,231,230,230,231,230,231,230,231,231,230,231,230,231,230,230,230,230,231,230,230,230,230,230,230,230,229,230,230,230,230,230,230,230,230,230,230,230,230,230,230,231,231,230,231,231,231,231,231,231,231,231,230,231,231,230,230,230,231,230,230,230,230,231,230,231,230,230,230,230,230,230,230,230,230,230,229,230,229,230,229,229,230,229,230,229,230,230,229,229,229,230,229,230,230,229,230,229,230,229,229,230,228,230,229,229,229,229,229,229,229,228,229,229,228,229,228,229,229,229,229,229,229,229,230,229,229,229,229,230,229,229,229,229,229,229,230,229,230,230,229,230,230,230,230,230,230,230,230,230,230,230,230,230,229,230,229,229,229,229,229,229,229,228,229,229,229,228,227,227,227,227,226,226,227,226,226,226,226,226,226,226,225,226,226,226,225,225,226,225,226,226,226,226,226,227,226,227,226,226,227,226,227,226,226,227,227,227,226,227,226,226,226,226,227,226,227,226,226,226,226,227,226,227,227,227,227,227,228,227,228,228,228,228,228,229,229,229,229,229,230,229,230,229,230,232,235,240,242,244,245,246,247,247,247,247,247,246,246,247,246,246,246,246,247,247,248,248,248,248,248,248,247,248,248,247,248,248,225,225,225,225,225,225,225,225,226,225,226,226,226,226,226,227,226,227,227,227,227,227,227,227,227,227,227,228,227,228,227,227,228,227,229,228,228,228,228,229,228,229,229,229,229,229,230,229,230,230,230,230,230,231,230,230,230,230,230,230,230,229,230,230,229,230,229,230,229,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,231,230,230,231,230,230,229,230,230,229,229,229,229,229,229,229,229,229,228,228,228,228,228,227,228,227,228,227,228,228,228,228,227,228,228,228,228,228,229,228,229,229,229,229,229,230,229,229,229,229,230,229,230,229,229,230,229,230,229,230,229,229,229,228,229,228,228,228,228,228,228,228,227,228,228,227,228,227,228,227,228,227,227,228,227,228,227,227,227,227,228,227,228,228,227,228,228,229,228,228,228,228,229,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,227,228,227,227,227,226,227,226,226,225,226,226,225,226,226,226,226,226,226,226,226,225,226,226,225,226,225,226,225,225,226,225,226,225,226,225,225,226,225,226,225,226,225,225,226,225,226,226,226,225,225,226,225,226,225,225,225,225,226,225,227,226,227,227,227,228,227,228,228,228,228,228,229,229,229,231,235,240,243,245,245,246,247,247,247,247,247,246,245,245,245,245,245,246,246,247,247,247,248,248,248,248,248,247,247,247,247,247,247,248,226,225,225,225,225,226,226,226,226,226,227,227,227,227,228,227,228,228,228,228,228,229,228,229,228,228,229,228,229,228,228,229,229,230,229,230,230,230,230,229,230,230,230,230,230,230,230,230,229,230,230,230,230,230,230,230,230,230,229,230,229,229,229,229,229,229,229,229,229,229,229,229,229,230,229,229,230,230,230,230,230,230,230,230,230,231,231,231,231,231,231,231,231,230,231,230,230,230,230,230,230,230,230,230,231,230,230,229,230,230,229,229,229,229,229,229,229,229,230,228,229,229,229,229,228,229,229,229,228,229,229,228,229,228,229,228,228,229,228,229,229,229,229,229,229,229,230,229,229,230,228,229,228,229,228,228,229,228,229,228,228,228,228,229,228,229,228,228,229,229,229,228,229,228,229,229,228,229,229,229,229,229,229,229,230,229,230,230,229,230,229,230,230,230,230,230,230,229,230,229,229,230,229,229,229,229,228,228,228,228,229,228,228,227,227,227,226,226,226,226,226,226,226,225,226,226,225,225,225,226,225,226,226,226,226,226,227,226,227,226,226,227,227,227,226,227,227,227,227,226,227,227,227,227,226,227,226,227,226,226,226,226,226,226,226,226,226,227,226,227,227,227,228,228,229,228,229,228,228,229,228,229,229,230,231,235,239,242,245,245,246,246,246,247,247,247,247,246,246,245,245,245,246,246,247,247,248,248,248,249,249,249,249,248,248,248,248,248,248,249,225,225,225,225,226,225,226,225,225,226,225,226,225,226,226,226,226,226,226,226,226,226,226,227,226,227,226,227,227,226,227,227,227,227,227,228,227,228,227,228,228,228,229,228,229,229,229,229,229,230,229,230,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,230,229,230,230,230,230,230,230,230,230,230,230,230,230,230,229,230,230,230,230,230,230,230,230,229,229,230,229,229,229,229,229,228,229,228,229,228,228,228,228,228,228,228,227,228,228,227,227,227,228,228,228,228,227,228,227,228,227,227,228,228,228,228,228,228,228,229,228,229,228,229,229,228,229,228,229,229,228,229,228,229,228,228,228,228,228,227,228,227,227,227,227,228,227,227,227,227,227,227,227,226,227,226,226,227,226,227,226,227,227,227,227,227,228,227,228,228,228,228,228,229,228,228,228,228,229,228,229,228,229,229,229,229,229,229,229,229,229,228,229,228,228,228,228,228,227,227,226,226,226,225,226,225,225,225,225,225,225,225,225,225,225,225,225,225,226,225,225,225,225,225,225,225,225,225,225,225,225,224,225,225,225,225,224,225,224,225,225,225,225,224,225,225,225,224,224,225,225,225,225,225,225,226,226,226,227,227,227,228,228,228,228,229,229,230,233,236,239,241,244,245,246,246,245,246,246,245,245,245,245,245,245,246,246,246,247,249,250,250,250,250,250,250,250,249,249,249,248,248,247,247,247,225,225,225,225,226,226,226,225,226,226,226,226,226,228,227,227,227,227,228,227,228,227,227,227,227,228,228,229,228,228,229,229,230,229,229,229,230,230,230,230,229,230,230,230,230,229,230,229,229,230,229,230,230,230,229,229,229,229,229,228,229,228,228,228,228,229,228,229,229,229,229,229,230,229,230,230,229,230,230,230,230,230,230,230,230,230,230,230,230,230,230,231,230,231,230,230,230,230,231,230,230,230,230,230,229,230,229,229,229,229,229,229,229,229,228,229,228,229,228,229,228,228,228,228,228,227,228,227,227,228,227,228,227,228,228,228,228,228,229,228,228,229,229,229,228,229,229,229,229,228,229,228,228,228,228,228,228,229,228,228,228,228,229,228,229,228,228,229,228,229,228,229,228,229,229,228,229,229,229,229,229,229,229,230,229,229,230,229,230,229,230,230,230,230,230,230,230,230,230,230,230,229,229,228,229,228,228,228,228,228,227,228,227,227,227,226,227,226,226,226,225,226,225,225,225,225,225,225,226,225,226,225,225,226,225,226,226,226,226,226,227,226,226,226,226,226,226,227,226,227,226,226,227,226,227,226,227,227,226,227,226,227,226,226,226,226,227,226,227,226,227,227,227,227,227,228,228,228,228,228,231,233,237,240,241,243,243,244,245,245,244,244,244,244,244,244,244,245,245,245,246,247,247,249,250,250,250,251,251,251,250,250,249,249,249,249,248,248,248,248,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,226,225,226,226,226,226,226,227,226,227,226,227,227,227,228,227,228,228,228,228,228,229,228,229,228,229,229,229,229,229,229,229,229,229,229,229,229,229,229,228,229,228,228,228,228,228,228,228,227,228,228,228,228,228,229,229,229,229,229,229,229,229,229,229,229,228,229,228,229,228,228,228,228,229,228,228,228,228,229,228,229,228,228,228,228,228,228,228,228,228,228,227,228,227,227,227,227,227,227,227,227,227,227,227,228,227,228,227,227,227,227,228,227,228,228,228,228,228,229,228,229,228,229,229,228,229,228,229,229,228,229,228,228,228,228,228,227,228,226,227,226,227,227,227,227,226,227,226,227,227,226,227,226,227,226,226,227,226,227,226,227,227,227,228,227,228,227,228,228,228,228,228,229,228,228,229,228,229,228,229,229,229,229,228,229,228,228,228,228,228,228,228,228,228,227,227,227,226,227,226,226,226,225,225,225,225,224,224,225,224,225,224,224,224,224,224,224,224,224,224,224,224,224,224,225,224,224,224,224,225,224,225,224,224,224,224,225,224,225,224,224,225,224,225,224,225,225,225,225,225,226,226,226,226,226,228,227,228,227,229,232,235,236,238,241,241,243,244,244,244,245,245,245,245,245,244,244,245,247,248,248,248,249,249,249,250,250,250,250,251,250,250,249,248,248,248,248,248,248,248,248,248,226,226,226,226,225,226,226,226,226,226,226,226,227,226,226,226,226,227,227,227,227,227,227,227,228,227,228,227,228,228,228,229,228,229,229,229,229,229,229,228,229,229,229,229,229,229,229,229,229,228,229,228,229,228,228,228,228,228,227,228,227,227,227,227,228,227,228,227,227,228,228,229,228,229,229,229,229,229,230,229,229,230,229,230,229,230,230,229,230,230,230,230,230,230,230,230,230,230,230,230,230,230,230,229,230,229,229,229,229,229,229,229,228,228,228,227,228,227,228,227,227,227,227,228,227,228,227,227,228,227,229,228,228,228,228,229,228,228,228,228,229,228,229,228,229,229,228,229,228,229,228,229,229,228,229,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,229,229,228,228,228,229,228,229,228,228,229,229,229,229,229,229,229,230,229,230,229,229,229,229,230,229,229,229,229,229,228,229,228,229,228,228,228,228,228,227,228,228,227,227,227,227,226,226,226,226,226,225,226,225,225,225,225,226,225,225,225,225,225,225,226,225,225,225,225,226,225,226,225,225,226,225,226,225,226,225,226,226,226,226,226,226,226,226,226,226,226,225,226,226,226,226,226,226,226,227,227,226,227,227,228,228,230,232,236,238,239,241,242,243,243,243,244,244,244,244,244,244,243,244,244,245,246,248,248,249,249,250,250,250,250,251,251,252,251,250,250,250,250,250,250,251,251,251,250,250,225,225,225,225,224,225,224,225,225,224,225,224,225,224,225,225,225,225,225,226,225,225,226,225,226,226,226,226,227,227,227,227,227,228,228,228,228,228,229,228,229,229,228,229,228,229,228,229,229,228,229,228,229,228,228,228,228,228,227,228,227,227,227,227,228,227,227,227,227,228,228,228,227,228,227,227,228,227,228,228,228,228,228,228,227,228,228,228,228,228,229,228,228,228,228,229,228,228,228,228,228,228,228,228,228,228,228,228,228,229,228,228,228,228,228,228,228,227,228,227,227,227,227,228,227,228,227,227,227,227,228,227,228,228,227,228,228,228,228,228,228,228,228,228,228,228,228,228,227,228,227,228,227,227,228,227,228,227,227,227,226,227,226,227,226,227,227,227,227,226,227,227,227,227,226,228,226,227,226,226,227,227,227,227,227,228,228,228,228,229,228,229,229,228,229,228,229,229,229,229,229,229,228,229,229,228,228,228,229,228,228,228,227,228,227,227,226,226,226,225,226,225,225,224,224,224,223,224,223,224,223,224,224,223,223,223,223,223,223,224,223,224,223,223,223,223,225,224,225,223,224,224,224,225,224,225,224,224,225,224,225,224,225,225,225,226,226,226,226,226,226,226,227,228,232,234,236,237,239,240,241,242,242,243,244,244,244,244,244,244,244,244,245,246,246,247,248,248,249,249,250,250,250,250,251,251,251,250,249,249,248,248,248,248,249,249,249,249,249,249,226,226,226,225,226,226,226,225,225,226,225,226,226,226,226,226,227,226,227,226,226,227,227,227,227,228,227,228,228,227,228,228,228,228,228,228,228,229,228,228,228,228,229,228,229,228,228,228,228,229,228,228,228,228,228,228,228,227,228,227,227,227,227,228,227,228,227,227,228,228,229,228,228,228,228,229,229,229,229,229,229,229,230,229,230,229,229,230,230,230,230,230,230,230,230,229,230,230,230,230,230,230,229,230,229,229,229,229,229,228,229,228,228,228,228,228,227,228,227,227,227,227,228,227,228,227,227,227,227,228,227,228,227,227,228,227,228,228,228,228,228,229,228,228,228,228,228,228,229,228,228,228,228,229,228,229,228,228,228,228,229,228,228,228,228,228,228,229,228,228,228,228,228,228,229,228,228,228,228,228,228,228,228,229,229,228,229,228,229,229,229,229,229,230,228,229,229,228,229,228,229,228,228,228,228,228,228,228,228,228,227,227,227,226,227,227,227,227,226,226,225,226,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,224,225,224,225,225,225,225,224,225,225,225,225,225,225,225,225,225,225,225,225,226,225,225,225,225,226,225,226,226,226,226,227,230,231,233,235,237,238,239,240,240,241,242,242,243,243,243,243,243,244,244,245,245,245,246,247,248,248,249,249,250,251,251,251,252,252,252,251,251,250,250,250,250,250,250,250,249,249,249,249,249,224,224,224,224,224,224,225,224,224,224,224,224,224,225,224,225,225,225,225,225,225,225,226,225,226,226,225,226,226,227,226,226,227,227,227,227,227,228,227,228,227,229,228,228,228,228,228,228,228,228,228,228,227,228,227,228,227,227,227,227,227,227,227,227,227,227,226,227,227,227,227,227,227,227,228,227,227,227,227,228,227,228,227,227,227,227,228,227,228,227,227,227,227,228,227,228,227,227,228,227,228,227,228,228,228,228,228,229,228,228,228,228,229,228,228,228,228,228,228,228,227,227,227,227,228,227,228,227,227,227,227,228,227,228,227,227,228,227,228,227,227,227,227,228,227,228,227,227,227,227,228,227,228,226,227,227,227,227,226,227,227,226,226,226,227,226,226,226,226,227,226,227,226,227,227,227,227,226,227,227,227,227,227,227,227,228,227,228,228,228,228,228,228,228,228,228,228,228,228,229,228,228,228,228,229,228,228,228,228,228,227,228,227,227,227,226,227,226,226,225,225,225,225,225,224,225,224,224,224,223,224,223,224,223,223,223,222,224,223,224,223,223,223,223,224,224,224,223,223,224,223,225,224,224,224,224,225,224,224,224,225,225,224,225,225,225,225,226,227,227,230,232,235,236,238,239,239,240,241,242,242,242,242,242,243,243,243,243,243,244,244,244,245,246,247,247,248,248,249,250,250,251,251,250,250,249,248,248,247,247,247,247,247,247,247,247,247,247,247,248,226,226,226,226,225,226,226,225,225,225,226,225,226,226,226,226,226,226,226,226,226,226,227,227,227,227,227,227,227,228,227,227,227,227,227,227,228,227,228,227,228,228,228,228,228,228,228,228,228,228,228,228,228,228,227,228,227,227,227,227,227,227,227,226,227,227,227,227,227,228,227,228,228,228,228,228,229,228,229,229,228,229,229,229,229,229,229,229,229,229,229,230,229,230,229,230,229,229,229,229,229,228,229,228,229,229,228,229,228,229,228,228,229,228,229,228,228,228,228,228,227,228,227,227,227,227,227,227,227,227,227,227,226,227,226,227,227,227,227,227,228,227,228,227,227,228,227,229,227,228,227,228,228,227,228,228,228,228,228,228,227,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,229,228,228,228,228,229,228,228,228,228,229,228,229,228,228,228,228,228,227,228,227,227,227,227,227,226,227,226,226,226,226,226,225,225,225,225,225,225,225,225,225,225,225,225,225,225,224,225,225,225,225,224,225,225,225,224,224,225,224,225,224,224,225,224,225,224,225,225,225,225,225,226,226,227,228,231,234,234,236,237,238,239,240,240,241,241,242,242,242,242,243,243,243,244,244,244,244,245,247,247,247,248,249,249,250,251,251,252,251,250,249,249,248,248,248,247,248,248,247,247,247,248,248,248,249,249,224,223,224,224,224,225,224,224,223,224,224,224,225,224,225,224,224,224,224,225,225,225,225,225,225,225,226,225,226,226,226,226,226,227,226,227,227,227,227,227,228,228,228,228,228,228,228,228,228,228,228,228,228,227,228,227,228,227,227,227,227,227,227,227,227,226,227,227,227,227,227,227,227,227,227,227,227,227,227,227,227,227,227,227,227,228,227,228,227,227,227,227,228,227,228,227,227,228,227,229,227,227,227,227,228,227,228,227,228,228,228,228,228,228,228,228,228,227,228,227,228,227,227,227,227,227,227,227,227,226,227,226,227,227,227,227,227,227,226,227,226,226,226,226,227,226,226,226,226,227,226,227,226,226,226,226,227,226,226,226,226,226,226,227,226,226,226,226,226,226,227,226,227,226,226,227,226,227,226,227,227,227,228,227,228,227,228,228,228,228,227,229,228,228,228,228,229,228,228,228,228,229,228,229,228,228,228,228,228,228,228,227,227,227,227,227,225,227,226,226,226,225,226,225,225,225,224,224,224,224,223,223,223,223,224,223,224,222,223,223,223,224,223,224,222,223,223,223,224,223,224,223,223,224,223,225,223,224,223,225,225,224,225,225,225,225,226,229,231,233,234,236,236,238,239,239,240,241,242,242,242,243,243,243,243,244,244,245,245,245,246,246,246,247,247,247,248,248,249,250,250,249,249,248,248,247,247,247,246,246,246,246,246,246,246,246,247,247,248,248,225,225,226,225,226,226,225,226,225,226,226,226,226,226,226,225,226,225,226,226,226,226,226,227,226,227,227,227,227,227,227,227,227,227,227,228,227,228,227,227,227,227,228,227,228,227,227,228,228,228,227,228,228,227,228,227,228,227,228,228,227,228,227,228,228,228,228,228,229,228,228,228,228,228,228,228,228,228,228,227,228,228,228,228,228,229,228,228,228,229,229,229,229,228,229,228,229,229,228,228,228,228,228,228,228,227,228,227,228,228,228,228,228,228,228,228,228,227,228,227,228,227,227,227,227,227,227,228,227,227,227,226,227,227,227,227,227,227,227,228,227,228,227,227,228,227,228,227,228,228,228,228,228,228,228,228,228,228,229,228,228,228,228,228,228,229,228,228,228,228,228,228,229,228,228,228,228,228,227,228,227,228,227,227,228,227,228,227,228,228,228,228,227,229,227,228,228,228,228,228,229,228,228,228,228,229,228,228,228,228,229,228,228,228,228,228,228,228,227,228,227,227,227,226,227,226,226,225,225,226,225,225,225,225,224,225,225,224,225,224,225,225,224,225,224,225,224,224,225,224,225,224,224,223,224,224,223,224,224,224,224,224,225,225,226,227,229,232,234,235,235,237,237,238,239,240,241,241,242,242,243,243,244,244,244,245,247,247,248,248,249,249,250,250,250,250,250,251,252,252,251,250,250,250,250,250,249,250,249,249,248,248,248,248,248,248,248,248,248,248,224,224,224,224,224,224,223,224,223,224,223,224,224,224,224,224,224,224,224,225,225,225,225,225,225,225,226,226,226,226,226,226,226,227,226,227,227,227,227,227,228,227,228,227,228,228,228,228,228,228,228,228,228,227,228,227,227,227,227,227,227,227,227,226,226,227,227,226,227,227,227,227,226,227,226,227,226,226,227,226,227,226,227,227,227,227,227,227,227,227,227,227,228,227,228,227,227,228,227,228,227,228,227,227,227,227,228,227,228,228,228,228,227,228,228,228,228,228,228,228,228,227,227,227,227,228,227,227,226,226,226,226,227,226,226,226,226,226,226,226,226,226,226,226,226,226,226,226,226,226,226,226,226,226,226,226,226,226,227,226,227,226,226,226,226,227,226,227,226,226,227,226,227,226,227,227,227,227,227,227,227,227,227,227,228,227,227,227,227,228,227,228,227,227,227,228,228,228,228,227,228,228,228,228,228,228,227,227,227,227,228,227,227,226,226,227,226,227,226,226,226,226,226,225,225,224,224,224,224,224,223,223,223,223,223,223,224,223,224,223,223,223,223,224,223,225,223,223,224,224,225,223,223,223,223,224,223,225,223,224,224,225,225,227,230,232,234,235,236,238,238,239,240,241,241,242,242,243,243,243,244,244,244,245,245,246,247,247,248,248,249,249,249,250,250,250,250,250,250,250,248,248,247,247,247,247,246,247,247,247,246,246,246,247,246,246,246,247,247,247,225,225,225,225,225,225,225,225,225,224,225,225,225,225,225,226,225,225,225,225,226,225,226,225,225,226,226,226,225,226,226,226,226,226,227,226,226,226,226,227,226,227,226,227,227,227,227,227,227,227,227,228,227,228,227,228,227,227,228,227,228,227,228,228,228,228,228,229,228,229,228,228,229,228,229,228,228,229,228,229,228,228,228,228,228,228,229,228,228,228,228,229,228,228,228,228,228,228,228,228,228,228,228,228,227,228,227,227,227,227,227,227,227,227,227,227,227,228,227,228,227,227,227,227,227,227,227,227,227,227,226,227,226,227,226,226,227,226,227,227,227,227,227,227,227,228,227,227,227,227,228,227,228,227,228,228,228,228,228,228,227,228,227,227,228,227,228,227,227,227,227,228,227,228,227,227,227,227,228,227,228,227,227,227,227,228,227,227,227,227,228,227,228,227,227,227,227,229,228,229,228,228,228,228,229,228,228,228,228,229,228,228,228,228,228,227,228,227,228,227,227,227,227,227,226,227,226,226,226,225,226,225,225,225,225,225,224,225,224,224,224,224,225,224,225,224,224,225,224,225,224,224,224,224,224,223,224,224,224,224,224,226,227,230,232,234,236,237,238,238,239,240,240,241,241,242,242,243,243,244,244,244,246,246,247,248,249,249,249,250,250,250,250,251,251,251,251,251,250,250,250,250,250,250,250,249,248,248,249,249,249,249,249,249,248,248,248,248,248,248,0
};
static unsigned char Mode, Zeile;
static unsigned char Error, BRIGHT=8, FEED=70;

static int Digit(Bright, Inp, Feed)
unsigned char Bright, Inp, Feed;
{ char Error;

/* Sorry, but this subroutine was originally written in Assembler, then     */
/* manually translated to Pascal and with p2c you now see the C source :-)  */

  unsigned char A, D;
  unsigned short B, C;

  Mode = Bright | Inp;
  Zeile = Feed;

  port_out(Mode,Flop);

  C = 0x8000L;
  do {
_LL:
    C--;
    if (C == 0)
      return(0);
    A = port_in(rv) & 1;
    if (A != 0)
      goto _LL;
    do {
      C--;
      if (C == 0)
	return(0);
      A = port_in(rv) & 1;
    } while (A == 0);
    A = port_in(rv);
    A = port_in(rv);
    A = port_in(rv) & 1;
  } while (A == 0);
  do {
    do {
      A = port_in(rv) & 4;
    } while (A == 0);
    Zeile--;
    if (Zeile != 0) {
      do {
	A = port_in(rv) & 4;
      } while (A != 0);
    }
  } while (Zeile != 0);
  do {
    A = port_in(rv) & 4;
  } while (A != 0);
  port_out(Mode | 32,Flop);
  D = 201;
  do {
    A = port_in(rv) & 4;
  } while (A == 0);
  A = port_in(rv);
  do {
    do {
      A = port_in(Inn) & 4;
    } while (A == 0);
    D--;
    if (D != 0) {
      do {
	A = port_in(Inn) & 4;
      } while (A != 0);
    }
  } while (D != 0);
  port_out(Mode,Flop);
  A = port_in(rv);
  C = 0;
  for (B = 1; B <= 16000; B++) {
    PicBuffer[C] = port_in(Clock);
    C++;
    PicBuffer[C] = port_in(Clock);
    C++;
    PicBuffer[C] = port_in(Clock);
    C++;
    PicBuffer[C] = port_in(Clock);
    C++;
  }
  return(1); 
}


void digitize()
{
  /* get permission to acess the required port's */
  if ( (ioperm(0x318,10,1) != 0) )
  {  
   /* probably we are not root ??? */
   printf("xvideo: No Permission to do that. Sorry.\n\n");
   exit(1);
  }
  if (Digit(BRIGHT,0x40,FEED)==0)    /* digitize picture */
    printf("xvideo: missing hardware, no video signal or other error\n");
  ioperm(0x318,10,0);
}

/************************************************************************/
/* BMP Bitmap file save routine						*/
/************************************************************************/

unsigned char RGB_QUAD[1024] = 
 { 255,255,255,  0,251,251,251,  0,247,247,247,  0,243,243,243,  0,
  239,239,239,  0,235,235,235,  0,231,231,231,  0,227,227,227,  0,
  223,223,223,  0,219,219,219,  0,215,215,215,  0,210,210,210,  0,
  206,206,206,  0,202,202,202,  0,198,198,198,  0,194,194,194,  0,
  190,190,190,  0,186,186,186,  0,182,182,182,  0,178,178,178,  0,
  174,174,174,  0,170,170,170,  0,166,166,166,  0,162,162,162,  0,
  158,158,158,  0,154,154,154,  0,150,150,150,  0,146,146,146,  0,
  142,142,142,  0,138,138,138,  0,134,134,134,  0,130,130,130,  0,
  125,125,125,  0,121,121,121,  0,117,117,117,  0,113,113,113,  0,
  109,109,109,  0,105,105,105,  0,101,101,101,  0, 97, 97, 97,  0,
   93, 93, 93,  0, 89, 89, 89,  0, 85, 85, 85,  0, 81, 81, 81,  0,
   77, 77, 77,  0, 73, 73, 73,  0, 69, 69, 69,  0, 65, 65, 65,  0,
   61, 61, 61,  0, 57, 57, 57,  0, 53, 53, 53,  0, 49, 49, 49,  0,
   45, 45, 45,  0, 40, 40, 40,  0, 36, 36, 36,  0, 32, 32, 32,  0,
   28, 28, 28,  0, 24, 24, 24,  0, 20, 20, 20,  0, 16, 16, 16,  0,
   12, 12, 12,  0,  8,  8,  8,  0,  4,  4,  4,  0,  0,  0,  0,  0,
  255,255,255,  0,251,251,251,  0,247,247,247,  0,243,243,243,  0,
  239,239,239,  0,235,235,235,  0,231,231,231,  0,227,227,227,  0,
  223,223,223,  0,219,219,219,  0,215,215,215,  0,210,210,210,  0,
  206,206,206,  0,202,202,202,  0,198,198,198,  0,194,194,194,  0,
  190,190,190,  0,186,186,186,  0,182,182,182,  0,178,178,178,  0,
  174,174,174,  0,170,170,170,  0,166,166,166,  0,162,162,162,  0,
  158,158,158,  0,154,154,154,  0,150,150,150,  0,146,146,146,  0,
  142,142,142,  0,138,138,138,  0,134,134,134,  0,130,130,130,  0,
  125,125,125,  0,121,121,121,  0,117,117,117,  0,113,113,113,  0,
  109,109,109,  0,105,105,105,  0,101,101,101,  0, 97, 97, 97,  0,
   93, 93, 93,  0, 89, 89, 89,  0, 85, 85, 85,  0, 81, 81, 81,  0,
   77, 77, 77,  0, 73, 73, 73,  0, 69, 69, 69,  0, 65, 65, 65,  0,
   61, 61, 61,  0, 57, 57, 57,  0, 53, 53, 53,  0, 49, 49, 49,  0,
   45, 45, 45,  0, 40, 40, 40,  0, 36, 36, 36,  0, 32, 32, 32,  0,
   28, 28, 28,  0, 24, 24, 24,  0, 20, 20, 20,  0, 16, 16, 16,  0,
   12, 12, 12,  0,  8,  8,  8,  0,  4,  4,  4,  0,  0,  0,  0,  0,
  255,255,255,  0,251,251,251,  0,247,247,247,  0,243,243,243,  0,
  239,239,239,  0,235,235,235,  0,231,231,231,  0,227,227,227,  0,
  223,223,223,  0,219,219,219,  0,215,215,215,  0,210,210,210,  0,
  206,206,206,  0,202,202,202,  0,198,198,198,  0,194,194,194,  0,
  190,190,190,  0,186,186,186,  0,182,182,182,  0,178,178,178,  0,
  174,174,174,  0,170,170,170,  0,166,166,166,  0,162,162,162,  0,
  158,158,158,  0,154,154,154,  0,150,150,150,  0,146,146,146,  0,
  142,142,142,  0,138,138,138,  0,134,134,134,  0,130,130,130,  0,
  125,125,125,  0,121,121,121,  0,117,117,117,  0,113,113,113,  0,
  109,109,109,  0,105,105,105,  0,101,101,101,  0, 97, 97, 97,  0,
   93, 93, 93,  0, 89, 89, 89,  0, 85, 85, 85,  0, 81, 81, 81,  0,
   77, 77, 77,  0, 73, 73, 73,  0, 69, 69, 69,  0, 65, 65, 65,  0,
   61, 61, 61,  0, 57, 57, 57,  0, 53, 53, 53,  0, 49, 49, 49,  0,
   45, 45, 45,  0, 40, 40, 40,  0, 36, 36, 36,  0, 32, 32, 32,  0,
   28, 28, 28,  0, 24, 24, 24,  0, 20, 20, 20,  0, 16, 16, 16,  0,
   12, 12, 12,  0,  8,  8,  8,  0,  4,  4,  4,  0,  0,  0,  0,  0,
  255,255,255,  0,251,251,251,  0,247,247,247,  0,243,243,243,  0,
  239,239,239,  0,235,235,235,  0,231,231,231,  0,227,227,227,  0,
  223,223,223,  0,219,219,219,  0,215,215,215,  0,210,210,210,  0,
  206,206,206,  0,202,202,202,  0,198,198,198,  0,194,194,194,  0,
  190,190,190,  0,186,186,186,  0,182,182,182,  0,178,178,178,  0,
  174,174,174,  0,170,170,170,  0,166,166,166,  0,162,162,162,  0,
  158,158,158,  0,154,154,154,  0,150,150,150,  0,146,146,146,  0,
  142,142,142,  0,138,138,138,  0,134,134,134,  0,130,130,130,  0,
  125,125,125,  0,121,121,121,  0,117,117,117,  0,113,113,113,  0,
  109,109,109,  0,105,105,105,  0,101,101,101,  0, 97, 97, 97,  0,
   93, 93, 93,  0, 89, 89, 89,  0, 85, 85, 85,  0, 81, 81, 81,  0,
   77, 77, 77,  0, 73, 73, 73,  0, 69, 69, 69,  0, 65, 65, 65,  0,
   61, 61, 61,  0, 57, 57, 57,  0, 53, 53, 53,  0, 49, 49, 49,  0,
   45, 45, 45,  0, 40, 40, 40,  0, 36, 36, 36,  0, 32, 32, 32,  0,
   28, 28, 28,  0, 24, 24, 24,  0, 20, 20, 20,  0, 16, 16, 16,  0,
   12, 12, 12,  0,  8,  8,  8,  0,  4,  4,  4,  0,  0,  0,  0,  0 };

unsigned char BHdr[14] =
 { 66, 77, 54, 254, 0, 0, 0, 0, 0, 0, 54, 4, 0, 0 };
 
unsigned char BInf [40] =
 { 40, 0, 0, 0, 64, 1, 0, 0, 200, 0, 0, 0, 1, 0, 8, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
   0, 0, 0, 0, 0, 0, 0 };

FILE *F;

int SaveBMPPic(Filename)
char *Filename;
{ unsigned short x, y;

  if (*Filename == '\0')
    return(1);
  F = fopen(Filename,"w+");
  if (F == NULL)
    return(1);
  if (fwrite(&BHdr, sizeof(BHdr), 1, F) != 1)
    return(1);
  if (fwrite(&BInf, sizeof(BInf), 1, F) != 1)
    return(1);
  if (fwrite(RGB_QUAD, 1024, 1, F) != 1)
    return(1);
  for (y = 0; y <= 199; y++)
    if (fwrite(&PicBuffer[(199-y)*320],sizeof(unsigned char)*320,1,F)!=1)
      return(1);
  if (F != NULL)
    fclose(F);
  return(0);
}

/************************************************************************/
/* XView variables, routine calls, etc.					*/
/************************************************************************/

Frame		mframe, frame;
Panel		mpanel, panel, filename_panel, digi_button, save_button;
Canvas		canvas;
GC 		gc;
Display		*dpy;
Xv_Font		font;
XGCValues 	gcvalues;
XImage		*ximage;
char		*pixmap_data;
int 		screen;
Visual		 *visual;
Cms		cms;
static Xv_singlecolor colors[] = {
 {255,255,255},{251,251,251},{247,247,247},{243,243,243},{239,239,239},
 {235,235,235},{231,231,231},{227,227,227},{223,223,223},{219,219,219},
 {215,215,215},{211,211,211},{207,207,207},{203,203,203},{199,199,199},
 {195,195,195},{191,191,191},{187,187,187},{183,183,183},{179,179,179},
 {175,175,175},{171,171,171},{167,167,167},{163,163,163},{159,159,159},
 {155,155,155},{151,151,151},{147,147,147},{143,143,143},{139,139,139},
 {135,135,135},{131,131,131},{127,127,127},{123,123,123},{119,119,119},
 {115,115,115},{111,111,111},{107,107,107},{103,103,103},{ 99, 99, 99},
 { 95, 95, 95},{ 91, 91, 91},{ 87, 87, 87},{ 83, 83, 83},{ 79, 79, 79},
 { 75, 75, 75},{ 71, 71, 71},{ 67, 67, 67},{ 63, 63, 63},{ 59, 59, 59},
 { 55, 55, 55},{ 51, 51, 51},{ 47, 47, 47},{ 43, 43, 43},{ 39, 39, 39},
 { 35, 35, 35},{ 31, 31, 31},{ 27, 27, 27},{ 23, 23, 23},{ 19, 19, 19},
 { 15, 15, 15},{ 11, 11, 11},{  7,  7,  7},{  3,  3,  3},
 {255,255,255},{251,251,251},{247,247,247},{243,243,243},{239,239,239},
 {235,235,235},{231,231,231},{227,227,227},{223,223,223},{219,219,219},
 {215,215,215},{211,211,211},{207,207,207},{203,203,203},{199,199,199},
 {195,195,195},{191,191,191},{187,187,187},{183,183,183},{179,179,179},
 {175,175,175},{171,171,171},{167,167,167},{163,163,163},{159,159,159},
 {155,155,155},{151,151,151},{147,147,147},{143,143,143},{139,139,139},
 {135,135,135},{131,131,131},{127,127,127},{123,123,123},{119,119,119},
 {115,115,115},{111,111,111},{107,107,107},{103,103,103},{ 99, 99, 99},
 { 95, 95, 95},{ 91, 91, 91},{ 87, 87, 87},{ 83, 83, 83},{ 79, 79, 79},
 { 75, 75, 75},{ 71, 71, 71},{ 67, 67, 67},{ 63, 63, 63},{ 59, 59, 59},
 { 55, 55, 55},{ 51, 51, 51},{ 47, 47, 47},{ 43, 43, 43},{ 39, 39, 39},
 { 35, 35, 35},{ 31, 31, 31},{ 27, 27, 27},{ 23, 23, 23},{ 19, 19, 19},
 { 15, 15, 15},{ 11, 11, 11},{  7,  7,  7},{  3,  3,  3},
 {255,255,255},{251,251,251},{247,247,247},{243,243,243},{239,239,239},
 {235,235,235},{231,231,231},{227,227,227},{223,223,223},{219,219,219},
 {215,215,215},{211,211,211},{207,207,207},{203,203,203},{199,199,199},
 {195,195,195},{191,191,191},{187,187,187},{183,183,183},{179,179,179},
 {175,175,175},{171,171,171},{167,167,167},{163,163,163},{159,159,159},
 {155,155,155},{151,151,151},{147,147,147},{143,143,143},{139,139,139},
 {135,135,135},{131,131,131},{127,127,127},{123,123,123},{119,119,119},
 {115,115,115},{111,111,111},{107,107,107},{103,103,103},{ 99, 99, 99},
 { 95, 95, 95},{ 91, 91, 91},{ 87, 87, 87},{ 83, 83, 83},{ 79, 79, 79},
 { 75, 75, 75},{ 71, 71, 71},{ 67, 67, 67},{ 63, 63, 63},{ 59, 59, 59},
 { 55, 55, 55},{ 51, 51, 51},{ 47, 47, 47},{ 43, 43, 43},{ 39, 39, 39},
 { 35, 35, 35},{ 31, 31, 31},{ 27, 27, 27},{ 23, 23, 23},{ 19, 19, 19},
 { 15, 15, 15},{ 11, 11, 11},{  7,  7,  7},{  3,  3,  3},
 {255,255,255},{251,251,251},{247,247,247},{243,243,243},{239,239,239},
 {235,235,235},{231,231,231},{227,227,227},{223,223,223},{219,219,219},
 {215,215,215},{211,211,211},{207,207,207},{203,203,203},{199,199,199},
 {195,195,195},{191,191,191},{187,187,187},{183,183,183},{179,179,179},
 {175,175,175},{171,171,171},{167,167,167},{163,163,163},{159,159,159},
 {155,155,155},{151,151,151},{147,147,147},{143,143,143},{139,139,139},
 {135,135,135},{131,131,131},{127,127,127},{123,123,123},{119,119,119},
 {115,115,115},{111,111,111},{107,107,107},{103,103,103},{ 99, 99, 99},
 { 95, 95, 95},{ 91, 91, 91},{ 87, 87, 87},{ 83, 83, 83},{ 79, 79, 79},
 { 75, 75, 75},{ 71, 71, 71},{ 67, 67, 67},{ 63, 63, 63},{ 59, 59, 59},
 { 55, 55, 55},{ 51, 51, 51},{ 47, 47, 47},{ 43, 43, 43},{ 39, 39, 39},
 { 35, 35, 35},{ 31, 31, 31},{ 27, 27, 27},{ 23, 23, 23},{ 19, 19, 19},
 { 15, 15, 15},{ 11, 11, 11},{  7,  7,  7},{  3,  3,  3}
};
unsigned long *pixel_table;

int SHOW=0;

void repaint(canvas,paint_window,dpy,xwin,xrects)
Canvas canvas;
Xv_Window paint_window;
Display *dpy;
Window xwin;
Xv_xrectlist *xrects;
{
  XPutImage(dpy,xwin,gc,ximage,0,0,0,0,320,200);
}


void grabnshow(test)
int test;
{
  Xv_Window window;
  Display *dpy;
  Window xwin;
  Xv_xrectlist *xrects;

  window = (Xv_Window)xv_get(canvas,CANVAS_NTH_PAINT_WINDOW,0); 
  dpy    = (Display *)xv_get(window,XV_DISPLAY);
  xwin   = xv_get(window, XV_XID);
  xrects = (Xv_xrectlist *)NULL;

  if (test==1)
    digitize();

  { int B,C,X,Y;
    C = 0; X=0; Y=0;
    for (B = 1; B <= 64000; B++) {
      XPutPixel (ximage,X,Y,pixel_table[PicBuffer[C]]);
      C++; X++; if (X==320) { X=0; Y++; }
  } }

  repaint((Canvas)NULL,window,dpy,xwin,xrects);
}


void digit_handler(i) 
int i;
{
  grabnshow(1);
  signal(SIGALRM,&digit_handler);
  alarm(SHOW);
}


main (argc,argv)
 int argc;
 char *argv[];
{ 
  Xv_opaque quit();
  Xv_opaque make_pic();
  Xv_opaque save_pic();
  Xv_opaque bright_notify();
  Xv_opaque feed_notify();

  /*****  init for xview *****/
  xv_init(XV_INIT_ARGS, argc,argv,NULL);

  cms = (Cms) xv_create (XV_NULL, CMS,
	CMS_SIZE, 256,
	CMS_COLORS, colors,
	NULL); 

  pixel_table = (unsigned long *)xv_get(cms, CMS_INDEX_TABLE);

  /*** create window for digitized dreck ***/
  frame = (Frame)xv_create (XV_NULL,FRAME,
        XV_SHOW, TRUE,
        XV_WIDTH, 320,
        XV_HEIGHT, 200,
	FRAME_LABEL,"XVideo Bild",
	WIN_CMS, cms,
	NULL); 

  canvas = (Canvas)xv_create(frame,CANVAS,
        XV_X,0,
	XV_Y,0,
        XV_WIDTH,320,
        XV_HEIGHT,200,
        CANVAS_WIDTH,320,
        CANVAS_HEIGHT,200,
        CANVAS_RETAINED, TRUE,
        CANVAS_REPAINT_PROC, repaint,
        CANVAS_X_PAINT_WINDOW, TRUE,
        NULL);

  /***** Create GC ******/    

  dpy = (Display *)xv_get(frame,XV_DISPLAY);
  if (!(font = (Xv_Font)xv_find(canvas,FONT,
        FONT_FAMILY, FONT_FAMILY_DEFAULT_FIXEDWIDTH,
        FONT_STYLE, FONT_STYLE_BOLD,
        FONT_SIZE, 12,
        NULL)))
  {
    /* font failed */
    font = (Xv_Font)xv_get(canvas,XV_FONT);
  }

  gcvalues.font = (Font)xv_get(font, XV_XID);
  gcvalues.foreground = BlackPixel (dpy, DefaultScreen(dpy));
  gcvalues.background = WhitePixel (dpy, DefaultScreen(dpy));
  gcvalues.graphics_exposures = False;
  gc = XCreateGC(dpy,RootWindow(dpy,DefaultScreen(dpy)),
    GCForeground | GCBackground | GCFont | GCGraphicsExposures,
    &gcvalues);

  /***** Create XImage *****/

  screen = DefaultScreen(dpy);
  visual = DefaultVisual(dpy, screen);

  { int depth;
    unsigned int    width=320, height=200;
    depth=XDefaultDepth(dpy, screen);
    if (depth < 8) 
    {
      printf("xvideo: Not enough depth.\n");
      exit(1);
    }
    /* Create X image. */
    ximage=XCreateImage(dpy,visual,depth,ZPixmap,0,
      (char *) NULL,width,height,XBitmapPad(dpy),0);
    if (ximage == (XImage *) NULL)
    {
      printf("xvideo: Unable to create X image.\n");
      exit(1);
    }
    /* Allocate X image pixel data. */
    ximage->data=(char *) malloc(ximage->bytes_per_line*ximage->height);
    if (ximage->data == (char *) NULL)   
    {
      printf("xvideo: Unable to allocate pixel data.\n");
      XDestroyImage(ximage);
      exit(1);
    }
  }

  /***** create control window *****/

  mframe = (Frame)xv_create (XV_NULL,FRAME,
        XV_WIDTH, 320,
        XV_HEIGHT, 60,
	FRAME_LABEL,"XVideo-1000 VGA",
	WIN_CMS, cms,
	NULL); 

  panel = (Panel)xv_create(mframe,PANEL,
        PANEL_LAYOUT,PANEL_VERTICAL,
        XV_HEIGHT, 60,
        XV_WIDTH, 320,
        NULL);  

 (void)xv_create(panel,PANEL_BUTTON,
        XV_X, 8,
        XV_Y, 8,
        PANEL_LABEL_STRING,"Quit",
        PANEL_NOTIFY_PROC,quit,
        NULL);

 digi_button = (Panel)xv_create(panel,PANEL_BUTTON,
        XV_X, 60,
        XV_Y, 8,
        PANEL_LABEL_STRING,"Digitize",
        PANEL_NOTIFY_PROC,make_pic,
        NULL);

 save_button = (Panel)xv_create(panel,PANEL_BUTTON,
        XV_X, 132,
        XV_Y, 8,
        PANEL_LABEL_STRING,"Save",
        PANEL_NOTIFY_PROC,save_pic,
        NULL);

 (Panel)xv_create(panel,
        PANEL_SLIDER,
        XV_SHOW,TRUE,
        PANEL_SHOW_RANGE,FALSE,
	PANEL_SHOW_VALUE,FALSE,
	PANEL_NOTIFY_PROC,bright_notify,
        PANEL_MAX_VALUE,15,
        PANEL_MIN_VALUE,0,
        PANEL_VALUE,8,
        PANEL_LABEL_WIDTH,0,
        PANEL_LABEL_STRING,"",
        XV_X,200,
        XV_Y,3,
        NULL);
  
  (Panel)xv_create(panel,
        PANEL_SLIDER,
        XV_SHOW,TRUE,
        PANEL_SHOW_RANGE,FALSE,
	PANEL_SHOW_VALUE,FALSE,
	PANEL_NOTIFY_PROC,feed_notify,
        PANEL_MAX_VALUE,110,
        PANEL_MIN_VALUE,25,
        PANEL_VALUE,70,
        PANEL_LABEL_WIDTH,0,
        PANEL_LABEL_STRING,"",
        XV_X,200, 
        XV_Y,19,
        NULL);

  filename_panel = (Panel)xv_create(panel,
	PANEL_TEXT,
	XV_SHOW,TRUE,
	XV_X,6,
	XV_Y,40,
	PANEL_VALUE_DISPLAY_WIDTH,233,
	PANEL_LABEL_STRING, "Filename:",
	PANEL_VALUE,"Noname.0",
	PANEL_VALUE_STORED_LENGTH,25,
	NULL);
        
  window_fit(mframe);

  signal(SIGALRM,&digit_handler);
  
  grabnshow(0);
  xv_main_loop (mframe);
}


Xv_opaque quit(item,event)
Panel_item item;
Event *event;
{ 
  xv_destroy_safe (mframe);
  exit(0);
}


Xv_opaque make_pic(item,event)
Panel_item item;
Event *event;
{
  if (SHOW==0) { 
    alarm(1); SHOW=1;
    xv_set(save_button,XV_SHOW,FALSE);
    xv_set(digi_button,PANEL_LABEL_STRING,"Digitize OFF");
  }
  else {
    alarm(0); SHOW=0;
    xv_set(digi_button,PANEL_LABEL_STRING,"Digitize");
    xv_set(save_button,XV_SHOW,TRUE);
  }
}


void new_filename(Filename) 
char *Filename;
{ int len,x; long l;
  char nummer[50],nuller[50];
  
  x=strlen(Filename)-1;
  while ((Filename[x] >= '0') && (Filename[x] <= '9') && (x >= 0))
  {
    x--;
  } x++;
  
  if (x != strlen(Filename)) {
    strcpy (nummer, &Filename[x]);
    strcpy (nuller, "");
    len = strlen (nummer);
    l = atol(nummer) + 1;
    sprintf(nummer,"%d",l);
    if (strlen(nummer) > len) return;
    while (strlen(nummer)+strlen(nuller) < len)
      strcat (nuller,"0");
    strcat (nuller,nummer);
    Filename[x] = '\0';
    strcat(Filename,nuller);
  }
}


Xv_opaque save_pic(item,event)
Panel_item item;
Event *event;
{ char Filename[31];
  int x,len;
  FILE *datei;
  
  strcpy (Filename, (char *) xv_get(filename_panel, PANEL_VALUE));

  /**** only for use of the author **********************************
  { FILE *f;
    long pos;
    f=fopen ("init-pic","w+");
    if (f!=NULL) {
      fprintf(f,"static unsigned char PicBuffer[64001] = {\n");
      for (pos = 0; pos < 64000; pos++)
        fprintf(f,"%d,",PicBuffer[pos]);
      fprintf(f,"0\n};\n");
      fclose(f);
    }
  } 
  ******************************************************************/

  if (SaveBMPPic(Filename) != 0)
    printf ("xvideo: picture save failed!\n");
  else
    new_filename(Filename);
 
  xv_set(filename_panel, PANEL_VALUE, Filename);
}


Xv_opaque bright_notify(item,event)
Panel_item item;
Event *event; 
{ 
  BRIGHT = (unsigned char) xv_get(item,PANEL_VALUE);
}


Xv_opaque feed_notify(item,event)
Panel_item item;
Event *event; 
{ 
  FEED  = (unsigned char) xv_get(item,PANEL_VALUE);
}
