#include "surface.h"
#include "Canvas.h"

#include <X11/cursorfont.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>

#include <string.h>

static String fallback_resources[]=
{
   "#override\n <Key>Return:            carriagereturn()\n",
   "*Box.background: steelblue",
   "*Dialog.background: steelblue",
   "*Command.background: lightyellow",
   "*xsurface*.font:\
        -bitstream-charter-bold-r-normal--14-100-100-100-p-88-iso8859-1",
   "*Connectivity*.font:\
        -bitstream-charter-bold-r-normal--14-100-100-100-p-88-iso8859-1",
   "*Text.width: 200",
   "*xsurface.width: 186",
   "*xsurface.height: 250",
   "*xsurface.x: 500",
   "*xsurface.y: 450",
   "*Control Polyhedron.x: " string(CP_DEF_X),
   "*Control Polyhedron.y: " string(CP_DEF_Y),
   "*Control Polyhedron.width: " string(CP_DEF_W),
   "*Control Polyhedron.height: " string(CP_DEF_H),
   #ifdef DOUBLEBUFFERING
     "*Control Polyhedron.maxWidth: " string(CP_MAX_W),
     "*Control Polyhedron.maxHeight: " string(CP_MAX_H),
   #endif
   "*Control Polyhedron.minWidth: 40",
   "*Control Polyhedron.minHeight: 40",
   "*Bezier Surface.x: " string(BS_DEF_X),
   "*Bezier Surface.y: " string(BS_DEF_Y),
   "*Bezier Surface.width: " string(BS_DEF_W),
   "*Bezier Surface.height: " string(BS_DEF_H),
   #ifdef DOUBLEBUFFERING
     "*Bezier Surface.maxWidth: " string(BS_MAX_W),
     "*Bezier Surface.maxHeight: " string(BS_MAX_H),
   #endif
   "*Bezier Surface.minWidth: 40",
   "*Bezier Surface.minHeight: 40",
   "*Connectivity.x: " string(CN_DEF_X),
   "*Connectivity.y: " string(CN_DEF_Y), 
   "*Connectivity.width: " string(CN_DEF_W),
   "*Connectivity.height: " string(CN_DEF_H),
   "*Connectivity.minWidth: 40",
   "*Connectivity.minHeight: 40",
   "*Connectivity.ConnectivityCanvas.Addpatchshell.AddDialogue.label:\
        Create patch?",
   "*Connectivity.ConnectivityCanvas.Addpatchshell.AddDialogue.width: 120",
   "*Connectivity.ConnectivityCanvas.Addpatchshell.AddDialogue.Yes.width: 60",
   "*Connectivity.ConnectivityCanvas.Addpatchshell.AddDialogue.No.width: 60",
   "*Connectivity.ConnectivityCanvas.Delpatchshell.DelDialogue.label:\
        Delete patch?",
   "*Connectivity.ConnectivityCanvas.Delpatchshell.DelDialogue.width: 120",
   "*Connectivity.ConnectivityCanvas.Delpatchshell.DelDialogue.Yes.width: 60",
   "*Connectivity.ConnectivityCanvas.Delpatchshell.DelDialogue.No.width: 60",
   "*Status.x: " string(ST_DEF_X),
   "*Status.y: " string(ST_DEF_Y),
   "*Status.height: " string(ST_H),
   "*Status.minHeight: " string(ST_H),
   "*Status.maxHeight: " string(ST_H),
   "*Status.width: " string(ST_W),
   "*Status.minWidth: " string(ST_W),
   "*Status.maxWidth: " string(ST_W),
   "*Toolbox.Set View Position.width: 175",
   "*Toolbox.Bezier Resolution.width: 175",
   "*Toolbox.What to Display.width: 175",
   "*Toolbox.What to Display.Dispitemsshell.Dispitemsbox.Display All Patches.width: 175",
   "*Toolbox.What to Display.Dispitemsshell.Dispitemsbox.Display Active Patch.width: 175",
   "*Toolbox.Default View.width: 175",
   "*Toolbox.Continuity Mode.width: 175",
   "*Toolbox.Clear Data.width: 175",
   "*Toolbox.Save Surface.width: 175",
   "*Toolbox.Save Surface.Saveshell.Savebox*input: True",
   "*Toolbox.Save Surface.Saveshell.Savebox*editType: edit",
   "*Toolbox.Save Surface.Saveshell.Savebox.OK.width: 50",
   "*Toolbox.Save Surface.Saveshell.Savebox.Cancel.width: 100",
   "*Toolbox.Load Surface.width: 175",
   "*Toolbox.Load Surface.Loadshell.Loadbox*input: True",
   "*Toolbox.Load Surface.Loadshell.Loadbox*editType: edit",
   "*Toolbox.Load Surface.Loadshell.Loadbox.OK.width: 50",
   "*Toolbox.Load Surface.Loadshell.Loadbox.Cancel.width: 100",
   "*Toolbox.Exit Program.width: 175",
   "*Toolbox.Exit Program.Exitshell.Exitdialogue.label: Are you sure? ",
   "*Toolbox.Exit Program.Exitshell.Exitdialogue.Yes.width: 50",
   "*Toolbox.Exit Program.Exitshell.Exitdialogue.No.width: 50 ",
   "*Toolbox.Set View Position.Setviewshell*View X Axis.width: 190",
   "*Toolbox.Set View Position.Setviewshell*View Y Axis.width: 190",
   "*Toolbox.Set View Position.Setviewshell*View Z Axis.width: 190",
   "*Toolbox.Set View Position.Setviewshell*Done.width: 190",
   "*Toolbox.Bezier Resolution.Setvalueshell.Setvaluedialogue.+.width: 50",
   "*Toolbox.Bezier Resolution.Setvalueshell.Setvaluedialogue.-.width: 50",
   "*Toolbox.Bezier Resolution.Setvalueshell.Setvaluedialogue.Done.width: 50",
   "*Toolbox.Clear Data.Clearshell.Cleardialogue.label: Are you sure?",
   "*Toolbox.Clear Data.Clearshell.Cleardialogue.Yes.width: 50",
   "*Toolbox.Clear Data.Clearshell.Cleardialogue.No.width: 50",
   "*Toolbox.Continuity Mode.Continuityshell*Positional.width: 150",
   "*Toolbox.Continuity Mode.Continuityshell*Tangential.width: 150",
   NULL,
};

void setupwindows(int argc, char **argv)
{
   extern XtAppContext app_context;
   extern Widget bezier, control, connectivity, status, exitbutton, 
          defaultviewbutton, viewbutton, savebutton, loadbutton, 
          dispitemsbutton, clearbutton, continuitybutton, numlinesbutton;
   extern Display *controldisplay, *bezierdisplay, *connectivitydisplay,
          *statusdisplay;
   extern Window controlwindow, bezierwindow, connectivitywindow, statuswindow;
#ifdef DOUBLEBUFFERING
   extern Pixmap controlpixmap, bezierpixmap; 
#endif
   extern windowdata cpwindow, bswindow, cnwindow;

   Display *toolboxdisplay, *clearbuttondisplay, *exitbuttondisplay;
   Window toolboxwindow, clearbuttonwindow, exitbuttonwindow;
   XSetWindowAttributes setwattribs;
   XWindowAttributes wattribs;
   Cursor cursor;
   Widget parent, controltl, beziertl, connectivitytl, statustl, toolbox;
   unsigned long white;

   /* Initialise windowdata structure for three resizeable windows */
   cpwindow.width = CP_DEF_W;
   cpwindow.height = CP_DEF_H;  
   cpwindow.scale = SCALE * min(CP_DEF_W, CP_DEF_H);
   bswindow.width = BS_DEF_W;
   bswindow.height = BS_DEF_H;  
   bswindow.scale = SCALE * min(BS_DEF_W, BS_DEF_H);
   cnwindow.width = CN_DEF_W;
   cnwindow.height = CN_DEF_H;  
   cnwindow.scale = SCALE * min(CN_DEF_W, CN_DEF_H);
   
   /* Initialise Application */ 
   parent = XtAppInitialize(&app_context, "XSurface", NULL, 0, &argc, argv, 
                            fallback_resources, NULL, 0);

   /* Create top level shells */
   controltl = XtAppCreateShell("Control Polyhedron", "ControlTL", 
                          topLevelShellWidgetClass, XtDisplay(parent), NULL, 0);
   beziertl = XtAppCreateShell("Bezier Surface", "BezierTL", 
                          topLevelShellWidgetClass, XtDisplay(parent), NULL, 0);
   connectivitytl = XtAppCreateShell("Connectivity", "ConnectivityTL", 
                          topLevelShellWidgetClass, XtDisplay(parent), NULL, 0);
   statustl = XtAppCreateShell("Status", "StatusTL", 
                          topLevelShellWidgetClass, XtDisplay(parent), NULL, 0);

   /* Create canvas widget in each shell */
   control = XtCreateManagedWidget("ControlCanvas", canvasWidgetClass, 
                                                            controltl, NULL, 0);
   bezier = XtCreateManagedWidget("BezierCanvas", canvasWidgetClass, 
                                                             beziertl, NULL, 0);
   connectivity = XtCreateManagedWidget("ConnectivityCanvas", canvasWidgetClass,
                                                       connectivitytl, NULL, 0);
   status = XtCreateManagedWidget("StatusCanvas", canvasWidgetClass, 
                                                             statustl, NULL, 0);

   /* Realize shells */
   XtRealizeWidget(parent);
   XtRealizeWidget(controltl);
   XtRealizeWidget(beziertl);
   XtRealizeWidget(connectivitytl);
   XtRealizeWidget(statustl);

   /* Create toolbox (boxwidget) */
   toolbox = XtCreateManagedWidget("Toolbox", boxWidgetClass, parent, NULL, 0);

   /* Create buttons (command widgets) within toolbox */
   viewbutton = XtCreateManagedWidget("Set View Position", commandWidgetClass, 
                                                              toolbox, NULL, 0);
   defaultviewbutton = XtCreateManagedWidget("Default View",commandWidgetClass,
                                                              toolbox, NULL, 0);
   numlinesbutton = XtCreateManagedWidget("Bezier Resolution", 
                                          commandWidgetClass, toolbox, NULL, 0);
   dispitemsbutton = XtCreateManagedWidget("What to Display", 
                                          commandWidgetClass, toolbox, NULL, 0);
   continuitybutton = XtCreateManagedWidget("Continuity Mode", 
                                          commandWidgetClass, toolbox, NULL, 0);
   clearbutton = XtCreateManagedWidget("Clear Data", commandWidgetClass, 
                                                              toolbox, NULL, 0);
   savebutton = XtCreateManagedWidget("Save Surface", commandWidgetClass, 
                                                              toolbox, NULL, 0);
   loadbutton = XtCreateManagedWidget("Load Surface", commandWidgetClass, 
                                                              toolbox, NULL, 0);
   exitbutton = XtCreateManagedWidget("Exit Program", commandWidgetClass, 
                                                              toolbox, NULL, 0);

   /* Get display and window pointers */
   controldisplay = XtDisplay(control);
   controlwindow = XtWindow(control);
   bezierdisplay = XtDisplay(bezier);
   bezierwindow = XtWindow(bezier);
   /* Don't know what these were for...
   beziertldisplay = XtDisplay(beziertl);
   beziertlwindow = XtWindow(beziertl); */
   connectivitydisplay = XtDisplay(connectivity);
   connectivitywindow = XtWindow(connectivity);
   statusdisplay = XtDisplay(status);
   statuswindow = XtWindow(status);
   toolboxdisplay = XtDisplay(toolbox);
   toolboxwindow = XtWindow(toolbox);
   clearbuttondisplay = XtDisplay(clearbutton);
   clearbuttonwindow = XtWindow(clearbutton);
   exitbuttondisplay = XtDisplay(exitbutton);
   exitbuttonwindow = XtWindow(exitbutton);

#ifdef DOUBLEBUFFERING
   /* Create control and bezier pixmaps */
   controlpixmap = XCreatePixmap(controldisplay, controlwindow, CP_MAX_W, 
        CP_MAX_H, XDefaultDepth(controldisplay, DefaultScreen(controldisplay)));
   bezierpixmap = XCreatePixmap(bezierdisplay, bezierwindow, BS_MAX_W, BS_MAX_H,
                    XDefaultDepth(bezierdisplay, DefaultScreen(bezierdisplay)));
#endif

   /* Get code for white pixel */
   white = WhitePixelOfScreen(DefaultScreenOfDisplay(controldisplay));

   /* Set window attributes */
   XGetWindowAttributes(bezierdisplay, bezierwindow, &wattribs);
   setwattribs.event_mask = wattribs.your_event_mask | StructureNotifyMask;
   setwattribs.background_pixel = white;
   setwattribs.backing_store = Always;
   XChangeWindowAttributes(controldisplay, controlwindow, 
                           CWBackPixel | CWBackingStore, &setwattribs);
   XChangeWindowAttributes(bezierdisplay, bezierwindow, CWEventMask |
                           CWBackPixel | CWBackingStore, &setwattribs);
   XChangeWindowAttributes(connectivitydisplay, connectivitywindow, 
                           CWBackPixel | CWBackingStore, &setwattribs);
   XChangeWindowAttributes(XtDisplay(status), XtWindow(status), 
                           CWBackPixel | CWBackingStore, &setwattribs);  

   /* Define pointer shape for each window */
   cursor = XCreateFontCursor(controldisplay, XC_crosshair);
   XDefineCursor(controldisplay, controlwindow, cursor);
   cursor = XCreateFontCursor(connectivitydisplay, XC_dot);
   XDefineCursor(connectivitydisplay, connectivitywindow, cursor);
   cursor = XCreateFontCursor(toolboxdisplay, XC_hand2);
   XDefineCursor(toolboxdisplay, toolboxwindow, cursor);
   cursor = XCreateFontCursor(bezierdisplay, 0x32);
   XDefineCursor(bezierdisplay, bezierwindow, cursor);
   cursor = XCreateFontCursor(bezierdisplay, 0x84);
   XDefineCursor(statusdisplay, statuswindow, cursor);
   cursor = XCreateFontCursor(exitbuttondisplay, XC_pirate);
   XDefineCursor(exitbuttondisplay, exitbuttonwindow, cursor);
   XDefineCursor(clearbuttondisplay, clearbuttonwindow, cursor);
 
   /* Add Callbacks ... */
   XtAddCallback(exitbutton, XtNcallback, popupexitbox, NULL);
   XtAddCallback(viewbutton, XtNcallback, popupsetviewbox, NULL);
   XtAddCallback(defaultviewbutton, XtNcallback, defaultvalues, NULL);
   XtAddCallback(numlinesbutton, XtNcallback, setvalue, NULL);
   XtAddCallback(dispitemsbutton, XtNcallback, popupdispitemsbox, NULL);
   XtAddCallback(continuitybutton, XtNcallback, popupcontinuitybox, NULL);
   XtAddCallback(clearbutton, XtNcallback, popupclearbox, NULL);
   XtAddCallback(savebutton, XtNcallback, popupsavebox, NULL);
   XtAddCallback(loadbutton, XtNcallback, popuploadbox, NULL);

   XtAddCallback(control, XtNcallback, controlclicked, NULL);
   XtAddCallback(connectivity, XtNcallback, connectivityclicked, NULL);
   XtAddCallback(bezier, XtNcallback, bezierclicked, NULL);
}

void setupgc(void)
{
   extern GC gc, gcclear;
   extern Display *controldisplay;
   extern Window controlwindow;
   XGCValues values;
   Font font;
   unsigned long black, white;

   font = XLoadFont(controldisplay, 
                "-adobe-helvetica-medium-r-normal--12-120-75-75-p-67-iso8859-1");

   black = BlackPixelOfScreen(DefaultScreenOfDisplay(controldisplay));
   white = WhitePixelOfScreen(DefaultScreenOfDisplay(controldisplay));
   values.foreground = black;
   values.background = white;
   gc = XCreateGC(controldisplay, controlwindow, 
                  GCForeground | GCBackground, &values);
   values.function = GXxor;
   values.foreground = black ^ white;
   gcclear = XCreateGC(controldisplay, controlwindow, 
                       GCForeground | GCFunction, &values);
   XSetFont(controldisplay, gc, font);
}

void updatestatus(int num, char *message)
{
   extern GC gc;
   extern Display *statusdisplay;
   extern Window statuswindow;

   static char statusstrings[4][STATUSWIDTH]= { "Displaying all patches", "Maintaining positional & tangential continuity", "", ""};
  
   strncpy(statusstrings[num], message, STATUSWIDTH);
 
   XClearWindow(statusdisplay, statuswindow);

   XDrawString(statusdisplay, statuswindow, gc, 10, 15, statusstrings[0], 
               strlen(statusstrings[0]));
   XDrawString(statusdisplay, statuswindow, gc, 10, 30, statusstrings[1], 
               strlen(statusstrings[1]));
   XDrawString(statusdisplay, statuswindow, gc, 10, 45, statusstrings[2], 
               strlen(statusstrings[2]));
   XDrawString(statusdisplay, statuswindow, gc, 10, 60, statusstrings[3], 
               strlen(statusstrings[3]));
}

void carriagereturn(Widget w, XEvent * event, String * params, 
                    Cardinal * num_params)
{
   extern Widget loadbutton, savebutton;

   /* Trap CR in load/save text boxes! */
   if (XtParent(XtParent(XtParent(w))) == loadbutton)
      load(w, w, NULL);
   else if (XtParent(XtParent(XtParent(w))) == savebutton)
      save(w, w, NULL);
}
