/* my_malloc.c : memory allocation routines with error checking
**
** Written and Copyright (C) 1994 by Michael J. Gourlay
**
** NO WARRANTEES, EXPRESS OR IMPLIED.
*/

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include "my_malloc.h"

char *
my_malloc(unsigned size, char *proc)
{
  char *mem;
#ifdef SUNOS
  malloc_verify();
#endif
  if((mem=malloc(size))==NULL) {
    fprintf(stderr, "Bad Alloc: %li in %s\n", size, proc);
  }

#ifdef SUNOS
  malloc_verify();
#endif
  return(mem);
}

char *
my_calloc(unsigned nelem, unsigned elsize, char *proc)
{
  char *mem;
#ifdef SUNOS
  malloc_verify();
#endif
  if((mem=calloc(nelem, elsize))==NULL) {
    fprintf(stderr, "Bad Alloc: %li x %li in %s\n", nelem, elsize, proc);
  }

#ifdef SUNOS
  malloc_verify();
#endif
  return(mem);
}

void
my_free(void *ptr)
{
#ifdef SUNOS
  malloc_verify();
#endif
  free(ptr);
#ifdef SUNOS
  malloc_verify();
#endif
  return;
}
