/*
 * This is xvmpeg v0.1 (4-08-1995)
 * Copyright (C) 1995 Alexandre Naaman <hoser@step.polymtl.ca>
 */

/*   This program is free software; you can redistribute it and/or
     modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either version 2
     of the License, or (at your option) any later version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */


#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/notice.h>
#include <xview/file_chsr.h>
#include <xview/icon.h>
#include <xview/svrimage.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>

#include "xvmpeg.xbm"
#include "xvmpeg_mask.xbm"

#define XVMPEG_NAME "xvmpeg v0.1"

Frame frame;
Panel panel;
Panel_item options, dither, quiet;
char f_name[PATH_MAX+NAME_MAX];
int init_height, init_width;

void show_warning(void)
{
  Xv_notice notice;
  
  notice = (Xv_notice)xv_create(panel, NOTICE,
  	NOTICE_MESSAGE_STRINGS,
  		"No file has been selected!",
  		"Use \"Open File...\" button to select file.",
  		NULL,
  	NOTICE_BUTTON_YES,	"Ok",
  	NOTICE_NO_BEEPING,	TRUE,
  	XV_SHOW,		TRUE,
  	NULL);
  	
  xv_destroy_safe(notice);
}


void play_anim(void)
{
  char command[PATH_MAX+NAME_MAX+50];
  char dithering[30];
  int  i,quiet=0;
  
  int dec=(int)xv_get(options,PANEL_VALUE);
  int dith=(int)xv_get(dither,PANEL_VALUE);

  /* Show a warning if no file has been selected -- nothing to play */
  if (f_name[0]=='\0') {
  	show_warning();
  	return;
  }

  /* Determine which options have been chosen */
  strcpy(command,"mpeg_play ");
  for(i=0;dec;i++,dec>>=1)
    if (dec & 1) 
      switch(i) {
        case 0: strcat(command," -nob"); break;
        case 1: strcat(command," -nop"); break;
        case 2: strcat(command," -quiet"); 
        	quiet=1;
        	break;
      }
  
  /* Determine which type of dithering has been chosen */
  switch(dith){
  	case 0: strcpy(dithering," -dither ordered"); break;
  	case 1: strcpy(dithering," -dither ordered2"); break;
  	case 2: strcpy(dithering," -dither mbordered"); break;
  	case 3: strcpy(dithering," -dither fs4"); break;
  	case 4: strcpy(dithering," -dither fs2"); break;
  	case 5: strcpy(dithering," -dither fs2fast"); break;
  	case 6: strcpy(dithering," -dither hybrid"); break;
  	case 7: strcpy(dithering," -dither hybrid2"); break;
  	case 8: strcpy(dithering," -dither 2x2"); break;
  	case 9: strcpy(dithering," -dither gray"); break;
  	case 10:strcpy(dithering," -dither color"); break;
  	case 11:strcpy(dithering," -dither none"); break;
  	case 12:strcpy(dithering," -dither mono"); break;
  	case 13:strcpy(dithering," -dither threshold"); break;
  	default: break;
  }
  if (dith!=14) strcat(command,dithering);

  strcat(command," ");
  strcat(command,f_name);
  if(quiet) 
    strcat(command," >/dev/null");
  else
    strcat(command," >/dev/console");
  strcat(command," 2>/dev/console");
  /* Execute system command! */
  system(command);
}


void opened_file(File_chooser fc,char *path,char *file,Xv_opaque client_data)
{
  char title[NAME_MAX+10]="xvmpeg: ";
  
  strcat(title,file);
  strcpy(f_name,path);
  xv_set(frame,FRAME_LABEL,title,NULL);
  xv_set(fc, XV_SHOW, FALSE, NULL);	
}

void open_file(void)
{
  File_chooser	open_file_win;
  
  open_file_win = xv_create(frame, FILE_CHOOSER_OPEN_DIALOG,
  	XV_LABEL,			"Select file to load",
  	FILE_CHOOSER_NOTIFY_FUNC,	opened_file,
  	NULL); 	
  xv_set(open_file_win, XV_SHOW, TRUE, NULL);	
}

void setup_icon(Frame frame)
{
  Server_image image_ok, image_mask;
  Icon icon;

  image_ok = (Server_image)xv_create(XV_NULL, SERVER_IMAGE,
  	XV_WIDTH,    xvmpeg_width,
  	XV_HEIGHT,   xvmpeg_height,
  	SERVER_IMAGE_DEPTH,  1,
  	SERVER_IMAGE_X_BITS, xvmpeg_bits,
        NULL);
  image_mask = (Server_image)xv_create(XV_NULL, SERVER_IMAGE,
  	XV_WIDTH,    xvmpeg_width,
  	XV_HEIGHT,   xvmpeg_height,
  	SERVER_IMAGE_DEPTH,  1,
  	SERVER_IMAGE_X_BITS, xvmpeg_mask_bits,
  	NULL);
  icon = (Icon)xv_create(frame, ICON,
  	ICON_IMAGE,       image_ok,
  	ICON_MASK_IMAGE,  image_mask,
  	ICON_LABEL,       "xvmpeg", 
  	NULL);
  xv_set(frame, FRAME_ICON, icon, NULL);
}

void about_xvmpeg(void)
{
  Xv_notice notice;
  
  notice = (Xv_notice)xv_create(panel, NOTICE,
  	NOTICE_MESSAGE_STRINGS,
  		"xvmpeg 0.1, Copyright (C) 1995 Alexandre Naaman",
  		"<hoser@step.polymtl.ca>",
  		"-------------------------------------------------",
  		"xvmpeg comes with ABSOLUTELY NO WARRANTY. This is",
  		"free software, you are welcome to redistribute it",
  		"under certain conditions; See the GNU General",
  		"Public License for details.",
  		NULL,
  	NOTICE_BUTTON_YES,	"Ok",
  	NOTICE_NO_BEEPING,	TRUE,
  	XV_SHOW,		TRUE,
  	NULL);

  xv_destroy_safe(notice);
}

void process_args(int argc,char *argv[])
{
  struct stat statbuf;
  char temp[PATH_MAX+NAME_MAX];
  
  if(argc>1) {
    if(stat(argv[1], &statbuf)<0)
      fprintf (stderr,"Unable to stat %s\n",argv[1]);
    else {
      strcpy(f_name,argv[1]);
      sprintf(temp,"xvmpeg: %s", f_name);
      xv_set(frame,FRAME_LABEL,temp,NULL);
    } 
  }
}

void resize_window(void)
{
  /* This simply sets the base frame's size back to it's initial size */
  xv_set(frame,XV_HEIGHT,init_height);
  xv_set(frame,XV_WIDTH,init_width);
}

int main(int argc,char *argv[])
{
  xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, NULL);

  frame = (Frame)xv_create(XV_NULL, FRAME,
  	 FRAME_LABEL, XVMPEG_NAME,
  	 FRAME_SHOW_RESIZE_CORNER, FALSE, 
  	 NULL);

  /* Take care of window resizing events with window managers other
   * than ol(v)wm.
   */       
  xv_set(frame,
  	WIN_EVENT_PROC, resize_window,
  	NULL); 

  process_args(argc,argv);

  panel = (Panel)xv_create(frame, PANEL, NULL);

  xv_create(panel, PANEL_BUTTON,
  	PANEL_NOTIFY_PROC,    open_file,
	PANEL_LABEL_STRING,   "Open file...",
	NULL);

  xv_create(panel, PANEL_BUTTON,
	PANEL_NOTIFY_PROC,    play_anim,
	PANEL_LABEL_STRING,   "Play animation",
	NULL);

  xv_create(panel, PANEL_BUTTON,
  	PANEL_LABEL_STRING,	"About",
  	PANEL_NOTIFY_PROC,	about_xvmpeg,
  	NULL);

  options=xv_create(panel, PANEL_CHECK_BOX,
	PANEL_NEXT_ROW,	      -1,
	PANEL_CHOICE_STRINGS, "No B Frames",
	                      "No P Frames",
	                      "Quiet",
	                       NULL,
	PANEL_VALUE,	      4, /* Quiet on by default */
	NULL);

  dither=xv_create(panel, PANEL_CHOICE_STACK,
	PANEL_LAYOUT,         PANEL_VERTICAL,
	PANEL_NEXT_ROW,	      -1,
	PANEL_LABEL_STRING,   "Dithering...",
	PANEL_CHOICE_STRINGS, "Ordered",
	                      "Fast Ordered",
	                      "Macroblock Ordered",
	                      "Floyd-Steinberg with 4 error values",
	                      "Floyd-Steinberg with 2 error values",
	                      "Fast Floyd-Steinberg with 2 error values",
	                      "Hybrid",
	                      "Hybrid with error propagation",
	                      "2x2",
	                      "Grayscale",
	                      "Colour 24 bit only",
	                      "No diplay, no dither",
	                      "Monochrome",
	                      "floyd-Steinberg simple, monochrome only",
	                      "No dithering",
	                      NULL,
	PANEL_VALUE,          14,
	NULL);

  setup_icon(frame);
  
  window_fit(panel);
  window_fit(frame);
  
  init_height=(int)xv_get(frame,XV_HEIGHT);
  init_width=(int)xv_get(frame,XV_WIDTH);
  
  xv_main_loop(frame);
  
  return 0;  
}