/*
 * xwarp.c: Main program 
 */

#include <xview/xview.h>
#include <xview/frame.h>
#include <xview/panel.h>
#include <xview/notice.h>
#include <xview/openmenu.h>
#include <xview/canvas.h>
#include <xview/scrollbar.h>
#include <xview/xv_xrect.h>
#include <X11/cursorfont.h>

#include "gif_lib.h"
#include "grid.h"
#include "graph.h"
#include "imageh.h"
#include "warper.h"

#define MAXCANVASWIDTH	1024
#define MAXCANVASHEIGHT	768

/* xview specific staff */

Frame frame,open_image_frame,new_grid_frame,save_grid_frame,load_grid_frame;
Panel panel,open_image_panel,new_grid_panel,load_grid_panel,save_grid_panel;
Panel_item about_btn,file_btn,grid_btn,warp_btn,select_btn;
Panel_item xgran_item,ygran_item,load_grid_name_item,save_grid_name_item;
Panel_item image_str,grid_str,open_image_mess;
Cursor crosscursor,normcursor,waitcursor;
Scrollbar x_scroll,y_scroll;
Menu file_menu,grid_menu;
Icon icon;
Server_image icon_img;
Canvas canvas;

/* X11 specific staff */

Window canvas_win;
Display *XDisplay;
XColor XColorTable[256];
unsigned long XPixelTable[256];
int XScreen;
Window Xroot;
Colormap XColorMap;
GC XGraphContext,GridGC;
Visual *XVisual;
XImage *XImageSource=NULL,*XImageDest=NULL,*XImageBuffer=NULL;
Cursor XCursor;
char *XImageData1=NULL;
char *XImageData2=NULL;

int CCXPos=0; /* Cursor Current Position for lineto function */
int CCYPos=0;

int Dragging=0;
int IsSourceGrid=1;
int WarpingOn=0;
int HideGrid=0;
int GridColor=0;
Point SourceAreaPoint;
int lastIndex;
char* SourceImage;
char* DestImage;
grid grd=NULL;
grid sourceGrid=NULL;
grid destGrid=NULL;
int xgran,ygran;
int WWidth=320,WHeight=200;
static GifRowType *ScreenBuffer=NULL;

static short icon_bits[]={
#include "hello_world.icon"
};

/*
 * Various useful functions
 */

void xwarning(str)
	char* str;
	{
	notice_prompt(frame,NULL,
		NOTICE_MESSAGE_STRINGS,
		"Warning!","",str,NULL,
		NOTICE_BUTTON_YES,"Continue",
		NULL);
	}

void ChangeCursorTo(Cursor newc)
	{
        XDefineCursor(XDisplay,canvas_win,newc);
	}

/*
 * 2 routines for pixel handling...
 */
 
void SetThePixel(int x,int y,Pixel value)
	{
	/* Put the pixel in the destination image */

	if(x<0) x=0;
	if(x>=WWidth) x=WWidth-1;
	if(y<0) y=0;
	if(y>=WHeight) y=WHeight-1;
	DestImage[y*WWidth+x]=value;
	}

Pixel GetThePixel(int x,int y)
	{
	/* Get the pixel from the source image */

	if(x<0) x=0;
	if(x>=WWidth) x=WWidth-1;
	if(y<0) y=0;
	if(y>=WHeight) y=WHeight-1;
	return(SourceImage[y*WWidth+x]);
	}

/*
 * The WARPING routine ...
 */

void Warp(void)
	{
	int x,y;
	WArea WS,WD;
	
	for(y=0;y<sourceGrid->YGran;y++)		
		for(x=0;x<sourceGrid->XGran;x++)
				{
				WS.x[0]=sourceGrid->theGrid[y][x].v[0].x;
				WS.y[0]=sourceGrid->theGrid[y][x].v[0].y;
				WS.x[1]=sourceGrid->theGrid[y][x].v[1].x;
				WS.y[1]=sourceGrid->theGrid[y][x].v[1].y;
				WS.x[2]=sourceGrid->theGrid[y][x].v[2].x;
				WS.y[2]=sourceGrid->theGrid[y][x].v[2].y;
				WS.x[3]=sourceGrid->theGrid[y][x].v[3].x;
				WS.y[3]=sourceGrid->theGrid[y][x].v[3].y;
				
				WD.x[0]=destGrid->theGrid[y][x].v[0].x;
				WD.y[0]=destGrid->theGrid[y][x].v[0].y;
				WD.x[1]=destGrid->theGrid[y][x].v[1].x;
				WD.y[1]=destGrid->theGrid[y][x].v[1].y;
				WD.x[2]=destGrid->theGrid[y][x].v[2].x;
				WD.y[2]=destGrid->theGrid[y][x].v[2].y;
				WD.x[3]=destGrid->theGrid[y][x].v[3].x;
				WD.y[3]=destGrid->theGrid[y][x].v[3].y;

				/* Let's warp !!!!! */
				/* warpArea is in warper.c */

				warpArea(WS,WD);
				}
	
	/* Now we have the new ImageData just warped... */
	/* Let's create an XImage from this ... */

	XFree(XImageDest);
        XImageDest=XCreateImage(XDisplay, XVisual, 8, ZPixmap, 0,
                                DestImage, WWidth, WHeight,
                                8, WWidth);
	XPutImage(XDisplay,canvas_win,XGraphContext,XImageBuffer,0,0,0,0,WWidth,
			WHeight);
	if(!HideGrid)
		show_grid(grd);
	}

/*
 * Functions for the status informations
 */

void change_image_str(name)
	char *name;
	{
	xv_set(image_str,PANEL_LABEL_STRING,name,NULL);
	}

void change_grid_str()
	{
	if(IsSourceGrid)
		xv_set(grid_str,PANEL_LABEL_STRING,"SOURCE",NULL);
	else
		xv_set(grid_str,PANEL_LABEL_STRING,"DESTINATION",NULL);
	}

/*
 * Let's check the granularity of the 2 grids
 */

void CheckGrid()
	{
        if(IsSourceGrid && destGrid!=NULL)
                {
                if(grd->XGran!=destGrid->XGran || grd->YGran!=destGrid->YGran)
                        {
                        notice_prompt(panel,NULL,
                                NOTICE_MESSAGE_STRINGS,
                                "Warning:",
                                "",
                                "Unmatching granularity",
                                NULL);
                        }
                }
        else if(!IsSourceGrid && sourceGrid!=NULL)
                {
                if(grd->XGran!=sourceGrid->XGran || grd->YGran!=sourceGrid->YGran)
                        {
                        notice_prompt(panel,NULL,
                                NOTICE_MESSAGE_STRINGS,
                                "Warning:",
                                "",
                                "Unmatching granularity",
                                NULL);
                        }
		}
	}

/*
 * Handlers for buttons, canvas, menus...
 */
	
void do_select_btn(item,event)
	Panel_item item;
	Event *event;
	{
	if(IsSourceGrid)
		{
		xv_set(item,PANEL_LABEL_STRING,"Dest grid",NULL);
		grd=destGrid;
		XImageBuffer=XImageDest;
		IsSourceGrid=0;
		}
	else
		{
		xv_set(item,PANEL_LABEL_STRING,"Source grid",NULL);
		grd=sourceGrid;
		XImageBuffer=XImageSource;
		IsSourceGrid=1;
		}
	change_grid_str();
	if(XImageBuffer==NULL) return;
	ChangeCursorTo(waitcursor);
	XPutImage(XDisplay,canvas_win,XGraphContext,
		XImageBuffer,
		0,0,0,0,WWidth,WHeight);
	if(grd!=NULL && !HideGrid)
		show_grid(grd);
	ChangeCursorTo(normcursor);
	}
	
void do_about_btn(item,event)
	Panel_item item;
	Event *event;
	{
	notice_prompt(panel,NULL,
		NOTICE_MESSAGE_STRINGS,
		"XWarp",
		"Version 1.00","",
		"CalamaroSoft (C) 1993",
		"",
		"calamaro@dist.dist.unige.it",
		"",
		"Maranzano Luca",
		"Cardino Guido",
		"Surlinelli Roberto",
		NULL);
	}

void cancel_notify(item,event)
	Panel_item item;
	Event *event;
	{
	Panel panel=(Panel)xv_get(item,PANEL_PARENT_PANEL);
	Frame frame=(Frame)xv_get(panel,XV_OWNER);
	xv_set(frame,XV_SHOW,FALSE,NULL);
	}

void do_warp_btn(item,event)
	Panel_item item;
	Event *event;
	{
	if(sourceGrid==NULL || destGrid==NULL)
		{
		xwarning("First create a source and a destination grid");
		return;
		}
	if(XImageBuffer==NULL)
		{
		xwarning("First load an image");
		return;
		}
	if(sourceGrid->XGran!=destGrid->XGran || sourceGrid->YGran!=destGrid->YGran)
		{
		xwarning("Unable to warp: unmatching granularity");
		return;
		}
	ChangeCursorTo(waitcursor);
	Warp();
	if(IsSourceGrid) grd=sourceGrid;
	ChangeCursorTo(normcursor);
	}

void do_new_grid(item,event)
        Panel_item item;
        Event *event;
        {
        xgran=atoi((char*)xv_get(xgran_item,PANEL_VALUE));
        ygran=atoi((char*)xv_get(ygran_item,PANEL_VALUE));
	CheckGrid();
	if(xgran<=1||ygran<=1) 
		{
		xwarning("Invalid parameters");	
		return;
		}
	xv_set(new_grid_frame,XV_SHOW,FALSE,NULL);
	if(grd!=NULL) free_grid(grd);
	grd=new_grid(WWidth,WHeight,xgran,ygran);
	XFree(XImageDest);
        XImageDest=XCreateImage(XDisplay, XVisual, 8, ZPixmap, 0,
                                SourceImage, WWidth, WHeight,
                                8, WWidth);
	if(IsSourceGrid)
		sourceGrid=grd;
	else
		{
		XImageBuffer=XImageDest;
		destGrid=grd;	
		}
	if(grd==NULL)
		{
		xwarning("Unable to allocate the grid");
		return;	
		}
	ChangeCursorTo(waitcursor);
	XPutImage(XDisplay,canvas_win,XGraphContext,XImageBuffer,
		0,0,0,0,WWidth,WHeight);
      	show_grid(grd);  
      	ChangeCursorTo(normcursor);
	}

void do_quit(item,event)
	Panel_item item;
	Event *event;	
	{
	free_grid(grd);
	free(ScreenBuffer);
	free(XImageData1);
	free(XImageData2);
	xv_destroy_safe(frame);
	}

void proc_file_menu(menu,menu_item)
	Menu menu;
	Menu_item menu_item;
	{
	char *choice=(char*)xv_get(menu_item,MENU_STRING);
	
	if(strcmp(choice,"Open Image")==0)
		xv_set(open_image_frame,XV_SHOW,TRUE,NULL);
	else if(strcmp(choice,"Quit")==0)
		do_quit(/*item,event*/);
	}

void proc_grid_menu(menu,menu_item)
        Menu menu;
        Menu_item menu_item;
        {
        char *choice=(char*)xv_get(menu_item,MENU_STRING);
        
	if(XImageBuffer==NULL)
		{
		xwarning("First load an image");
		return;
		}
        if(strcmp(choice,"New grid")==0)
		{
		if(IsSourceGrid)
			xv_set(new_grid_frame,XV_SHOW,TRUE,NULL);
		else if(sourceGrid==NULL)
			xwarning("First create a source grid");
		else
			{
			if((grd=copy_grid(sourceGrid))!=NULL)
				{
				destGrid=grd;
				XPutImage(XDisplay,canvas_win,XGraphContext,
					XImageBuffer,0,0,0,0,WWidth,WHeight);
				show_grid(grd);
				}
			else 
				{
				grd=destGrid;
				xwarning("Unable to copy the grid");
				}
			}
		}
        else if(strcmp(choice,"Save grid")==0)
		xv_set(save_grid_frame,XV_SHOW,TRUE,NULL);
	else if(strcmp(choice,"Load grid")==0)
		xv_set(load_grid_frame,XV_SHOW,TRUE,NULL);
        }

void open_image_notify(item,event)
	Panel_item item;
	Event *event;
	{
	int i;
	char *imagename=(char*)xv_get(open_image_mess,PANEL_VALUE);

	if((ScreenBuffer=load_gif(imagename))==NULL)	
		{
		xwarning("Unable to load the file");
		xv_set(open_image_frame,XV_SHOW,TRUE,NULL);
		}
	else
		{
		change_image_str(imagename);
		if(sourceGrid!=NULL) free_grid(sourceGrid);
		if(destGrid!=NULL) free_grid(destGrid);
		grd=NULL;
		sourceGrid=NULL;
		destGrid=NULL;
		if(XImageBuffer!=NULL)
			{
			XFree(XImageSource);
			XFree(XImageDest);
			DeallocateColors();
			}
		ChangeCursorTo(waitcursor);
		xv_set(open_image_frame,XV_SHOW,FALSE,NULL);
		XClearWindow(XDisplay,canvas_win);
		xv_set(frame,XV_WIDTH,WWidth<380?380:WWidth,XV_HEIGHT,WHeight+70,NULL);
		free(XImageData1);
		free(XImageData2);
		Screen2X(ScreenBuffer,&XImageSource,&XImageDest,WWidth,WHeight);
		if(IsSourceGrid)
			XImageBuffer=XImageSource;
		else
			XImageBuffer=XImageDest;
		SourceImage=XImageData1;
		DestImage=XImageData2;
		free(ScreenBuffer);
		ScreenBuffer=NULL;
		XPutImage(XDisplay,canvas_win,XGraphContext,XImageBuffer,
	                0,0,0,0,WWidth,WHeight);
		ChangeCursorTo(normcursor);
		}
	}

void do_load_grid(item,event)
        Panel_item item;
	Event *event;
	{
        char *gridname=(char*)xv_get(load_grid_name_item,PANEL_VALUE);
	if((grd=load_grid(gridname))==NULL)
		{
		xwarning("Unable to load the grid");
                ChangeCursorTo(normcursor);
		if(IsSourceGrid) grd=sourceGrid;
		else grd=destGrid;
		return;
		}
	if(IsSourceGrid) 
		{
		free_grid(sourceGrid);	
		sourceGrid=grd;
		}
	else 
		{
		free_grid(destGrid);
		destGrid=grd;
		}
	CheckGrid();
        xv_set(frame,XV_WIDTH,WWidth<380?380:WWidth,XV_HEIGHT,WHeight+70,NULL);
	XClearWindow(XDisplay,canvas_win);
	XPutImage(XDisplay,canvas_win,XGraphContext,XImageBuffer,
		0,0,0,0,WWidth,WHeight);
	show_grid(grd);
	xv_set(load_grid_frame,XV_SHOW,FALSE,NULL);
        }

void do_save_grid(item,event)
        Panel_item item;
        Event *event;
        {
        char *gridname=(char*)xv_get(save_grid_name_item,PANEL_VALUE);
        if((save_grid(grd,gridname))==0)
                xwarning("Unable to save the grid");
        xv_set(save_grid_frame,XV_SHOW,FALSE,NULL);
        }

/* 
 * This function handles the mouse events related to
 * the action of each button.
 */

void event_handler(window,event)
	Xv_Window window;
	Event *event;
	{
	static int selectToSkip=0;
	static int adjustToSkip=0;
	static int menuToSkip=0;
	static int destIndex=0;
	int index;
	Point p;

	switch(event_action(event))
		{
		case LOC_MOVE:
			if(HideGrid) return;
			if(grd==NULL) return;
			if(Dragging) return;
			p.x=event_x(event);
			p.y=event_y(event);
			if((index=hit_point(grd,p))>=0)
				ChangeCursorTo(crosscursor);
			else	ChangeCursorTo(normcursor);
			break;
		case ACTION_SELECT:
			if(selectToSkip) 
				{
				selectToSkip=0;
				return;
				}
			selectToSkip=1;
			if(grd==NULL) return;
			if(HideGrid) return;
			p.x=event_x(event);
			p.y=event_y(event);
			if(!Dragging)
				{
				if((index=hit_point(grd,p))>=0)
					{
					XDrawArc(XDisplay,canvas_win,
						XGraphContext,
						grd->CrossPoint[index].x-4,
						grd->CrossPoint[index].y-4,
						9,9,0,360*64);
					ChangeCursorTo(crosscursor);
					SourceAreaPoint=grd->CrossPoint[index];
					Dragging=1;
					destIndex=index;
					}
				}
			else
				{
				ChangeCursorTo(normcursor);
				move_hit_point(grd,p,destIndex);
				ChangeCursorTo(waitcursor);
				XPutImage(XDisplay,canvas_win,XGraphContext,
					XImageBuffer,
					0,0,0,0,WWidth,WHeight);
				show_grid(grd);
				Dragging=0;
				}
			break;
		case ACTION_MENU:
			if(grd==NULL) return;
			if(menuToSkip)
				{
				menuToSkip=0;
				return;
				}
			GridColor=(GridColor==0)?1:0;
			show_grid(grd);
			menuToSkip=1;
			break;
		case ACTION_ADJUST:
			if(adjustToSkip)
				{
				adjustToSkip=0;
				return;
				}
			adjustToSkip=1;
			if(grd==NULL || XImageBuffer==NULL) return;
			ChangeCursorTo(waitcursor);
			if(HideGrid)
				{
				show_grid(grd);
				HideGrid=0;
				}
			else 
				{
				XPutImage(XDisplay,canvas_win,XGraphContext,
					XImageBuffer,
					0,0,0,0,WWidth,WHeight);
				HideGrid=1;
				}
			ChangeCursorTo(normcursor);
			break;			
		}
	}

void canvas_repaint(canvas,paint_window,dpy,xwin,xrects)
	Canvas canvas;
	Xv_Window paint_window;
	Display *dpy;
	Window xwin;
	Xv_xrectlist *xrects;
	{
	canvas_win=xwin;
	}

/* 
 * End of the canvas, menus, buttons handling functions.
 */

int main(argc,argv)
	int argc;
	char *argv[];
	{
	XGCValues gcvalues;

/* Initialize the warper ... */

	initWarper(GetThePixel,SetThePixel);
	
	xv_init(XV_INIT_ARGC_PTR_ARGV,&argc,argv,NULL);

/* Create base window */

        frame=(Frame)xv_create(NULL,FRAME,
                FRAME_LABEL,"XWarp 1.00",
                XV_WIDTH,380,
                XV_HEIGHT,250,
                FRAME_NO_CONFIRM,FALSE,
                NULL);

        XDisplay=(Display*)xv_get(frame,XV_DISPLAY);
	XScreen = DefaultScreen(XDisplay);
	Xroot = RootWindow(XDisplay, XScreen);
    	XColorMap = DefaultColormap(XDisplay, XScreen);
    	XGraphContext = DefaultGC(XDisplay, XScreen);
    	XVisual = DefaultVisual(XDisplay, XScreen);
    	XSetBackground(XDisplay, XGraphContext, BlackPixel(XDisplay, XScreen));
    	XSetForeground(XDisplay, XGraphContext, WhitePixel(XDisplay, XScreen));

	icon_img=(Server_image)xv_create(NULL,SERVER_IMAGE,
		XV_HEIGHT,64,
		XV_WIDTH,64,
		SERVER_IMAGE_BITS,icon_bits,
		NULL);
	icon=(Icon)xv_create(NULL,ICON,
		ICON_IMAGE,icon_img,
		NULL);
	xv_set(frame,FRAME_ICON,icon,NULL);
	
	panel=(Panel)xv_create(frame,PANEL,
		XV_HEIGHT,70,
		NULL);
	
	file_menu=(Menu)xv_create(NULL,MENU,
		MENU_NOTIFY_PROC,proc_file_menu,
		MENU_STRINGS,
		"Open Image",
		"Quit",
		NULL,NULL);

	grid_menu=(Menu)xv_create(NULL,MENU,
		MENU_NOTIFY_PROC,proc_grid_menu,
		MENU_STRINGS,
		"New grid",
		"Load grid",
		"Save grid",
		NULL,NULL);
	
	file_btn=(Panel_item)xv_create(panel,PANEL_BUTTON,
		PANEL_LABEL_STRING,"File",
		PANEL_ITEM_MENU,file_menu,
		NULL);
	select_btn=(Panel_item)xv_create(panel,PANEL_BUTTON,
		PANEL_LABEL_STRING,"Source grid",
		PANEL_NOTIFY_PROC,do_select_btn,
		NULL);
        grid_btn=(Panel_item)xv_create(panel,PANEL_BUTTON,
                PANEL_LABEL_STRING,"Grid",
                PANEL_ITEM_MENU,grid_menu,
                NULL);
	warp_btn=(Panel_item)xv_create(panel,PANEL_BUTTON,
		PANEL_LABEL_STRING,"Warp",
		PANEL_NOTIFY_PROC,do_warp_btn,
		NULL);
	about_btn=(Panel_item)xv_create(panel,PANEL_BUTTON,
		PANEL_LABEL_STRING,"About",
		PANEL_NOTIFY_PROC,do_about_btn,
		NULL);
	xv_create(panel,PANEL_MESSAGE,
		PANEL_LABEL_STRING,"Current image: ",
		XV_X,8,
		XV_Y,30,
		NULL);
	image_str=(Panel_item)xv_create(panel,PANEL_MESSAGE,
		PANEL_LABEL_STRING,"(none)",
		NULL);
	xv_create(panel,PANEL_MESSAGE,
		PANEL_LABEL_STRING,"Current grid: ",
		XV_X,8,
		XV_Y,50,
		NULL);
	grid_str=(Panel_item)xv_create(panel,PANEL_MESSAGE,
		PANEL_LABEL_STRING,"SOURCE",
		NULL);

/*
 * File::Open image
 */

	open_image_frame=(Frame)xv_create(frame,FRAME_CMD,
		XV_WIDTH,400,
		XV_HEIGHT,70,
		FRAME_LABEL,"Open image",
		NULL);
	open_image_panel=(Panel)xv_get(open_image_frame,FRAME_CMD_PANEL);
	open_image_mess=(Panel_item)xv_create(open_image_panel,PANEL_TEXT,
		PANEL_LABEL_STRING,"Image name: ",
		PANEL_NOTIFY_PROC,open_image_notify,
		PANEL_NOTIFY_LEVEL,PANEL_SPECIFIED,
		PANEL_NOTIFY_STRING,"\n\r",
		NULL);
	xv_create(open_image_panel,PANEL_BUTTON,
		PANEL_LABEL_STRING,"Ok",
		PANEL_NEXT_ROW,-1,
		XV_X,140,
		PANEL_NOTIFY_PROC,open_image_notify,
		NULL);
	xv_create(open_image_panel,PANEL_BUTTON,
		PANEL_LABEL_STRING,"Cancel",
		XV_X,190,
		PANEL_NOTIFY_PROC,cancel_notify,
		NULL);

/*
 * Grid::New grid
 */

        new_grid_frame=(Frame)xv_create(frame,FRAME_CMD,
                XV_WIDTH,400,
                XV_HEIGHT,110,
                FRAME_LABEL,"New grid",
                NULL);
        new_grid_panel=(Panel)xv_get(new_grid_frame,FRAME_CMD_PANEL);
        xgran_item=(Panel_item)xv_create(new_grid_panel,PANEL_TEXT,
                PANEL_LABEL_STRING,"X granularity: ",
                PANEL_NOTIFY_LEVEL,PANEL_SPECIFIED,
		PANEL_NOTIFY_STRING,"\n\r",
                PANEL_NOTIFY_PROC,do_new_grid,
                NULL);
        ygran_item=(Panel_item)xv_create(new_grid_panel,PANEL_TEXT,
                PANEL_LABEL_STRING,"Y granularity: ",
                PANEL_NOTIFY_LEVEL,PANEL_SPECIFIED,
                PANEL_NOTIFY_STRING,"\n\r",
                PANEL_NOTIFY_PROC,do_new_grid,
                NULL);
	xv_create(new_grid_panel,PANEL_MESSAGE,
		PANEL_LABEL_STRING,"Use tab to change input line",
		PANEL_NEXT_ROW,-1,
		XV_X,8,
		NULL);
	xv_create(new_grid_panel,PANEL_BUTTON,
		PANEL_LABEL_STRING,"Ok",
		PANEL_NOTIFY_PROC,do_new_grid,
		PANEL_NEXT_ROW,-1,
		XV_X,140,
		NULL);
	xv_create(new_grid_panel,PANEL_BUTTON,
		PANEL_LABEL_STRING,"Cancel",
		XV_X,190,
		PANEL_NOTIFY_PROC,cancel_notify,
		NULL);
/* 
 * Grid::Load grid
 */

        load_grid_frame=(Frame)xv_create(frame,FRAME_CMD,
                XV_WIDTH,400,
                XV_HEIGHT,50,
                FRAME_LABEL,"Load a grid",
                NULL);
        load_grid_panel=(Panel)xv_get(load_grid_frame,FRAME_CMD_PANEL);
        load_grid_name_item=(Panel_item)xv_create(load_grid_panel,PANEL_TEXT,
                PANEL_LABEL_STRING,"Grid name: ",
                PANEL_NOTIFY_PROC,do_load_grid,
                PANEL_NOTIFY_STRING,"\n\r",
                NULL);
        xv_create(load_grid_panel,PANEL_BUTTON,
                PANEL_LABEL_STRING,"Ok",
                PANEL_NOTIFY_PROC,do_load_grid,
		PANEL_NEXT_ROW,-1,
		XV_X,140,
                NULL);
	xv_create(load_grid_panel,PANEL_BUTTON,
		PANEL_LABEL_STRING,"Cancel",
		XV_X,190,
		PANEL_NOTIFY_PROC,cancel_notify,
		NULL);

/*
 * Grid::Save grid
 */

        save_grid_frame=(Frame)xv_create(frame,FRAME_CMD,
                XV_WIDTH,400,
                XV_HEIGHT,50,
                FRAME_LABEL,"Save current grid",
                NULL);
        save_grid_panel=(Panel)xv_get(save_grid_frame,FRAME_CMD_PANEL);
        save_grid_name_item=(Panel_item)xv_create(save_grid_panel,PANEL_TEXT,
                PANEL_LABEL_STRING,"Grid name: ",
                PANEL_NOTIFY_PROC,do_save_grid,
                PANEL_NOTIFY_STRING,"\n\r",
                NULL);
        xv_create(save_grid_panel,PANEL_BUTTON,
                PANEL_LABEL_STRING,"Ok",
                PANEL_NOTIFY_PROC,do_save_grid,
		PANEL_NEXT_ROW,-1,
		XV_X,140,
                NULL);
	xv_create(save_grid_panel,PANEL_BUTTON,
		PANEL_LABEL_STRING,"Cancel",
		XV_X,190,
		PANEL_NOTIFY_PROC,cancel_notify,
		NULL);


/*
 * Menu definitions end 
 */

	/* Creazione canvas */

       	canvas=(Canvas)xv_create(frame,CANVAS,
		CANVAS_REPAINT_PROC,canvas_repaint,
 		CANVAS_X_PAINT_WINDOW,TRUE,
		CANVAS_AUTO_EXPAND,TRUE,
		CANVAS_AUTO_SHRINK,FALSE,
		CANVAS_HEIGHT,MAXCANVASHEIGHT,
		CANVAS_WIDTH,MAXCANVASWIDTH,
		NULL);

	/* 
	 * Cursors creation.
	 */

	crosscursor=XCreateFontCursor(XDisplay,XC_diamond_cross);
	normcursor=XCreateFontCursor(XDisplay,XC_top_left_arrow);
	waitcursor=XCreateFontCursor(XDisplay,XC_watch);

	/* 
	 * Set the attributes.
         */

	gcvalues.foreground=BlackPixel(XDisplay,XScreen);
	gcvalues.background=WhitePixel(XDisplay,XScreen);

	/* 
 	 * Create a graphic context associated to the Display
	 */

	GridGC=XCreateGC(XDisplay,Xroot,
		GCForeground|GCBackground,
		&gcvalues); 

	/* 
	 * Canvas events selection
	 */ 

	xv_set(canvas_paint_window(canvas),
		WIN_CONSUME_EVENTS,
		WIN_MOUSE_BUTTONS,
		LOC_MOVE,LOC_DRAG,NULL,
		WIN_EVENT_PROC,event_handler,
		NULL);

	xv_main_loop(frame);
	exit(0);
	}
