/*
 * graph.c: drawing functions used in grid.c. Implementation for X11 
 */


#include <xview/xview.h>

/* XWindow e XView staff */

extern Display* XDisplay;
extern int XScreen;
extern GC GridGC;
extern int CCXPos;
extern int CCYPos;
extern Window canvas_win;

void moveto(int x,int y)
	{
	CCXPos=x;
	CCYPos=y;
	}

void lineto(int x,int y)
	{
	XDrawLine(XDisplay,canvas_win,GridGC,CCXPos,CCYPos,x,y);
	moveto(x,y);
	}

void putpixel(int x,int y)
	{
	XDrawPoint(XDisplay,canvas_win,GridGC,x,y);
	}

void ChangeFGColor(unsigned long col)
	{
	XGCValues gcvalues;

	(col==0)?(gcvalues.foreground=BlackPixel(XDisplay,XScreen)):
			(gcvalues.foreground=WhitePixel(XDisplay,XScreen));
	XChangeGC(XDisplay,GridGC,GCForeground,&gcvalues);
	}

