/*
 *      Three Dim Routines Modul  -  d3.c
 *      Copyright (c) 1994,1995  R.Gosiorovsky, T.Hruz, I.Povazan
 */ 

#include "typy.h"

INT t_real,t_total,t_proj,t_clear,t_init,t_sort,t_draw;  

/*
 *     control structure initialization
 */

VOID init_control()
   {
      static CONTROL control;
      c = &control;
      c->model = FFF;
      c->proj  = 1;
      c->angle = M_PI_2/3;
      c->SIN   = sin(c->angle);
      c->COS   = cos(c->angle);
      c->dist  = 1;
      c->P.x   = 0;
      c->P.y   = 0;
      c->P.z   = -8;
      c->r.x   = 1;
      c->r.y   = 0;
      c->r.z   = 0;
      c->ratio = 1;
   }

/*
 *     save scene
 */

INT save(CHAR *file_name)
  {
    INT i,j,k;
    FILE *file;
    OBJECT *t;

    file=fopen(file_name,"w");
    if (file==NULL) return(0);

    for(i=0;i<pt;i++)
     {
       t= &object[i];
       fprintf(file,"%d %f %f %d %d \n",t->typ,t->R,t->r,t->segm1,t->segm2);
       for(j=0;j<4;j++) 
         { 
           for(k=0;k<4;k++) fprintf(file,"%f ",t->position[j][k]);
           fprintf(file,"\n");
         }
       fprintf(file,"\n");
     }

    fclose(file);
    return(1);
  }

/*
 *     load scene
 */

INT get(CHAR *file_name)
 {
   INT i=pt,j,l;
   FILE *file;
   OBJECT *t;

   file=fopen(file_name,"r");
   if (file==NULL) return(0);

   while(!feof(file))
    {
      if (i>=MAX_OBJECTS) { mess(280,220,"Too much objects !");
                            pt=i; fclose(file); return(1); }   

      t= &object[i];
      fscanf(file,"%d %f %f %d %d \n",&(t->typ),&(t->R),&(t->r),
                                       &(t->segm1),&(t->segm2));

      for(j=0;j<4;j++) 
        { 
          for(l=0;l<4;l++) fscanf(file,"%f ",&(t->position[j][l]));
          fscanf(file,"\n");
        }
      fscanf(file,"\n");

      switch(t->typ)
       {
        case SPHERE: *t = sphere(t->position,&(t->R),t->segm1,t->segm2); break;
        case TORUS: *t = torus(t->position,&(t->R),&(t->r),t->segm1,t->segm2);
                    break;
        case CYLINDER: *t = cylinder(t->position,&(t->R),&(t->r),t->segm1);
                          break;
        case CUBE: *t = cube(t->position,&(t->R)); break;
        case TETRAHEDRON: *t = tetrahedron(t->position,&(t->R)); break;
       }

      i++;  
    }
   pt=i;  
   fclose(file);
   return(1);
 }

/*
 *     basic geometric functions     
 */

POINT plus(POINT *A,POINT *B)
  {
    POINT C;
    C.x = A->x + B->x;
    C.y = A->y + B->y;
    C.z = A->z + B->z;
    return(C);
  }

POINT multiple(POINT *A,FLOAT *c)
  {
    POINT B;
    B.x= *c * A->x;
    B.y= *c * A->y;
    B.z= *c * A->z;
    return(B);
  }

FLOAT distance(POINT *A,POINT *B)
  {
     POINT C;
     C=minus(A,B);
     return((FLOAT)sqrt(C.x*C.x+C.y*C.y+C.z*C.z));
  }

VOID M_object_matrix(OBJECT *t,MATRIX M)
   {
      INT i;
      for(i=0;i<t->verts;i++) M_point_matrix(&(t->vertex[i]),M);
   }

/*
 *     scene position
 */

VOID position_all()
  {
     INT i;
     for(i=0;i<pt;i++) M_object_matrix(&object[i],object[i].position);
  }

VOID rotate_all()
  {
     INT i;
     MATRIX R;

     M_rotate(R);
     for(i=0;i<pt;i++)
       {
          M_matrix_matrix(object[i].position,R);          
          M_object_matrix(&object[i],R);
       }
  }

VOID move_all(POINT *T)
  {
     INT i;
     MATRIX M;

     M_translate(M,T);
     for(i=0;i<pt;i++) 
       {
          M_matrix_matrix(object[i].position,M);
          M_object_matrix(&object[i],M);
       }
  }

VOID resize_object(OBJECT *t,FLOAT zv)
  {
     INT i;
     for(i=0;i<t->verts;i++) t->vertex[i]=multiple(&t->vertex[i],&zv);
  }

VOID resize_all(FLOAT zv)
  {
     INT i;
     for(i=0;i<pt;i++) resize_object(&object[i],zv);
  }

POINT minus(POINT *A,POINT *B)
   {
      POINT D;
      D.x = A->x - B->x;
      D.y = A->y - B->y;
      D.z = A->z - B->z;
      return(D);
   }

FLOAT scalar(POINT *A,POINT *B)
   {
      return(A->x*B->x+A->y*B->y+A->z*B->z);
   }

POINT vector(POINT *A,POINT *B)
   {
      POINT C;
      C.x =  A->y * B->z  -  A->z * B->y;
      C.y =  A->z * B->x  -  A->x * B->z;
      C.z =  A->x * B->y  -  A->y * B->x;
      return(C);
   }

FLOAT face_distance(OBJECT *t,FACE *face)
   {
     POINT b;
     b=minus(&t->vertex[face->vertex[0]],&c->P);
     return(b.x*b.x+b.y*b.y+b.z*b.z);
   }

INT visible(OBJECT *t,FACE *face)
   {
       FLOAT S;
       POINT *A,*B,*C;
       POINT Nor,Obs,AB,AC;

       A= &t->vertex[face->vertex[0]];
       B= &t->vertex[face->vertex[1]];
       C= &t->vertex[face->vertex[2]];

       if (c->proj)
           S = (B->x-A->x)*(C->y-A->y) - (B->y-A->y)*(C->x-A->x);
       else
         {  
           Obs = minus(A,&c->P);
           AB  = minus(B,A);
           AC  = minus(C,A);
           Nor = vector(&AB,&AC);
           S   = scalar(&Obs,&Nor);
         }
 
       if (S<0) return(TRUE);
       return(FALSE);
   }

VOID draw_face(OBJECT *t,FACE *face)
   {
      POINT2 a[12];
      FLOAT z_coord[20];
      INT i;
      INT out=FALSE;

      for(i=0;i<face->verts;i++)
       {
	  a[i] = t->bd[face->vertex[i]];
          if ((a[i].x<MinX)||(a[i].x>MaxX)||(a[i].y<MinY)||(a[i].y>MaxY))
          out=TRUE;  
       }
    
   if(!out)
      switch(c->model)
       {
	 case DSF:  FillPoly(face->verts,a,f->line,f->work);
                    break;
         case DSC:
         case FFC:  FillPoly(face->verts,a,f->line,face->color);
                    break;
         case ALV:    
	 case FFF:  a[face->verts]=a[0];
                    GColor(f->line);
		    Poly(face->verts+1,a);
                    break;
         case ZBF:  for(i=0;i<face->verts;i++)
                      z_coord[i]=t->vertex[face->vertex[i]].z;
                    ZBF_Polygon(face->verts,a,z_coord,f->line,face->color);
                    break;
         case COU1:
         case COU2:
         case COU4: GColor(f->line);
                    CU_Polygon(face->verts,a);
                    break;
         case COU3: GColor(f->line);
                    CU_Polygon3(face->verts,a);  
                    break;
       }
   }

INT comp(FLOAT *a,FLOAT *b)
 {
   if ( *a < *b ) return (1);
   return(-1);
 }

VOID draw_sort()
 {
    INT i,j; 
    INT S=0;
    INT N=0;
    struct {FLOAT dist; INT six; INT tix;} *v;

    t_sort=clock();

    for(j=0;j<pt;j++) S+=object[j].faces;
        
    v = calloc(S,sizeof(FLOAT)+2*sizeof(INT));
    if (v==NULL) { N=0; mess(300,200,"No space for sorting !"); return; }
     
    for(j=0;j<pt;j++)
      for(i=0;i<object[j].faces;i++)
        if (visible(&object[j],&object[j].face[i]))  
          {
             v[N].dist = face_distance(&object[j],&object[j].face[i]);
             v[N].six = i;
             v[N].tix = j;
             N++;
          }

    qsort(v,N,sizeof(FLOAT)+2*sizeof(INT),comp);

    t_sort=clock()-t_sort;
    t_draw=clock();

    switch(c->model)
      {
        case COU1:
        case COU2:
        case COU4:
        case COU3: for(i=N-1;i>=0;i--)
                 draw_face(&object[v[i].tix],&object[v[i].tix].face[v[i].six]);
                   break;
        case DSC:
        case DSF: for(i=0;i<N;i++)
                 draw_face(&object[v[i].tix],&object[v[i].tix].face[v[i].six]);
                  break;
      }

    t_draw=clock()-t_draw;
    free(v);
 }

VOID draw_all()
 {
   INT i;

   t_draw=clock();
   for(i=0;i<pt;i++) draw_object(&object[i]);
   t_draw=clock()-t_draw;
 }

VOID draw_object(OBJECT *t)
 {
   INT i;

   switch(c->model)
     {
        case FFF: 
        case FFC: 
        case ZBF: for(i=0;i<t->faces;i++)
                    if (visible(t,&(t->face[i]))) draw_face(t,&(t->face[i]));
                  break;
	case ALV: for(i=0;i<t->faces;i++) draw_face(t,&(t->face[i]));
                  break;
      } 
 }

POINT2 *proj(POINT *B)
 {
   static POINT2 b;

   b.x= (INT) (( 500*c->dist*(B->x-c->P.x)/(B->z-c->P.z) + (MaxX+MinX)/2 ));
   b.y= (INT) (( c->ratio *  500*c->dist*(B->y-c->P.y)/(B->z-c->P.z) 
                                                         + (MaxY+MinY)/2 ));
  
   return(&b);
 }

POINT2 *proj_ortho(POINT *B)
 {
   static POINT2 b;

   b.x= (INT) (            70*c->dist*(B->x-c->P.x) + (MaxX+MinX)/2 );
   b.y= (INT) ( c->ratio * 70*c->dist*(B->y-c->P.y) + (MaxY+MinY)/2 );

   return(&b);
 }

VOID project_object(OBJECT *t)
 {
   INT i;

   if (c->proj==0)
       for(i=0;i<t->verts;i++)
           t->bd[i]= *proj(&t->vertex[i]);
   else 
       for(i=0;i<t->verts;i++)
           t->bd[i]= *proj_ortho(&t->vertex[i]);
 }

VOID project_all()
  {
    INT i;
    for(i=0;i<pt;i++) project_object(&object[i]);
  }

/*
#include <sys/time.h>

int cas()
 {
    int t;
    struct timeval tt;
    struct timezone tz;

    gettimeofday(&tt,&tz);
    t=1000*(int)tt.tv_sec+(int)(tt.tv_usec/1000);
    return(t);
  }
*/

VOID go()
 {
   INT i;
   CHAR time[20];

   if (pt==0) return; 

/*   t_total=clock();
   t_real=cas();

   t_proj=clock();  */

   project_all();

/*   t_proj=clock()-t_proj;
   t_clear=clock();  */

   Clear(MinX,MinY,MaxX,MaxY,f->work);   

/*   t_clear=clock()-t_clear;   
   t_init=clock(); */

   switch(c->model)
     { 
        case COU1: clear_CU();
                   init_CU();
                   break;
        case COU4:
        case COU2: clear_CU2();
                   break;   
        case COU3: init_global_c_a();
                   break;
        case ZBF:  CLEAR_Z_BUFFER(MinX,MinY,MaxX,MaxY); 
                   break;
     }

/*   t_init=clock()-t_init;  */

   switch(c->model)
     {
        case COU1: 
        case COU2:
        case COU4:
        case COU3:
        case DSC:
        case DSF: draw_sort(); 
                  break;

        case ZBF:
        case FFC:
        case FFF:
        case ALV: draw_all();
                  break;
      } 

/*   t_total=clock()-t_total;   */

   PutPixmap(MinX,MinY,MaxX,MaxY);

/*   t_real=cas()-t_real;  */

/*   GColor(3);   

   sprintf(time,"real time: %d ms",t_real);
   TextXY(MinX+10,MinY+0,time);
   sprintf(time,"CPU time : %d ms",t_total/1000);
   TextXY(MinX+10,MinY+10,time);

   sprintf(time,"projection: %d ms",t_proj/1000);
   TextXY(MinX+10,MinY+20,time);
   sprintf(time,"clear disp: %d ms",t_clear/1000);
   TextXY(MinX+10,MinY+30,time);
   sprintf(time,"init      : %d ms",t_init/1000);
   TextXY(MinX+10,MinY+40,time);

   GColor(f->line);

   sprintf(time,"sorting   : %d ms",t_sort/1000);
   TextXY(MinX+10,MinY+50,time);
   sprintf(time,"drawing   : %d ms",t_draw/1000);
   TextXY(MinX+10,MinY+60,time);

   t_sort=0; t_init=0;   */
 }
/*-----------------------------------------------------------------------*/

