/***************************************************\
********                                     ********
********  Schlampisoft X-Window Workbench    ********
********                                     ********
********      (c)1995 by Michael Sohmen      ********
********                                     ********
\***************************************************/

#include <xview/frame.h>
#include <xview/panel.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/scrollbar.h>
#include <xview/notice.h>
#include <xview/textsw.h>
#include <xview/tty.h>
#include <xview/cms.h>
#include <xview/xv_xrect.h>
#include <xview/seln.h>
#include <xview/notify.h>
#include <xview/file_list.h>
/*#include <xview/icon.h>*/
#include <sys/ioctl.h>

/* used for menu_dir function */
#include <sys/stat.h>
#include <dirent.h>
#include <sys/dirent.h>
#ifndef MAXPATHLEN
#include <sys/param.h>
#endif /* MAXPATHLEN */

#include "xwbicons.h"

/*#define  MENU_KEY         200*/
#define  NUM_COLORS       16

/*  file */
void New_text_frame ();
void Actual_text_frame ();
Menu gen_path_menu ();
Menu Filechoosermenu ();
void Save ();
void Filechooseropen ();
void Filechoosersaveas ();
void Copyright ();
void Save1 ();
void configurate      () ;
void Saved_notify     () ;
void Quit             () ;
void Quit1            () ;
void Quit2            () ;

/* ttycalls */
void Print     () ;
void Printformat      () ;
void Printformatoddsides  () ;
void Printformatevensides () ;
void Preformattedprint    () ;
void Compile      () ;
void Compile1      () ;
void RunX         () ;
void RunX1         () ;
void Run          () ;
void Run1          () ;
void Break        () ;
void Break1        () ;

/* periphery */
char *working_directory;
char *file_directory;
int edited, reports;

unsigned long horizontalsize, verticalsize, projhorizontalsize, projverticalsize, numberproj;
Frame       frame, addframe, helpframe, Filech_frame, projframe[256], resultframe;
Panel       panel, addpanel, Filech_panel, panelproj[256], resultpanel, resultpanel1;
Canvas      canvas ;
Menu        filemenu, toolmenu, optmenu, execmenu, helpmenu ;
char        filename[512], *filenamep ;
Textsw      textsw, helptext, textswproj[256], resulttext;
unsigned long textsw_buf_size, textsw_proj_buf_size, projitems;
Tty         tty ;
char       *tempstr;
char       *projbuf[256];  /* It'll contain all the projfiles - can't use textsws

/* needed by child process: */
int pipe_input[2];
char *comp_results[1024];
int result_counter;
Notify_client client1 = (Notify_client)10;
/*                         
   parent pipe_input[0]  << [ ][ ] <<  child pipe_input[1]
                                                 */

/* All variables needed by graphical canvas subwindow */
Xv_cmsdata    cms_data ;
unsigned char red[NUM_COLORS], green[NUM_COLORS], blue[NUM_COLORS] ;
unsigned long  *colors ;
GC  gc ;
Server_image  chips[NUM_COLORS], icon_image ;
Canvas piccanvas ;
char stipple_bits[4];
Xv_Server server ;
Textsw_index point ;
char copytext[2048] ;
char *findstring ;
char *replacestring ;
Display *display ;
XID piccanvas_xid ;
XFontStruct *font ;
XGCValues gc_val ;
Textsw_index cursor ;

Xv_Font textswfont, projfont;
char *spec_font;

Icon icon, buttonicon, compilericon;
int filechooser ;
int Filech_path_text ;
int  compnum ;
void select_conf();
Panel_item opt_text, results_message ;
Frame helpframe;
char compilername_buf     [16][256] ;
char compiler_buf         [16][4096] ;
char source_buf           [16][256] ;
char exec_buf             [16][256] ;
char usew_buf             [16][256] ;
char tatt_buf             [16][256] ;
char printer_buf          [16][256] ;
char printformat_buf      [16][1024] ;
char printformat_even_buf [16][1024] ;
char preformat_print_buf  [16][1024] ;
char errmess_buf          [16][1024] ;
char terminate_buf        [16][256] ;
char help_buf        [3][16000] ;
char           xpath[1000];
Panel_item save_file_text;
int filecounter, didchangepath, compilerrunning;
unsigned long int path_counter, errpt;

void textsw_notifyproc    () ;

void Close            () ;
void Cancel_button    () ;
void Linenumber       () ;
void Linenumber1      () ;
void Linenumber2      () ;
char printformat_odd_buf  [16][1024] ;
void Undo             () ;
void Redo             () ;
void Find             () ;
void Find1            () ;
void Find2            () ;
void Findnext         () ;
void Findnext1         () ;
void Findnext2         () ;
int  search_string    () ;
void Replace          () ;
void set_replace_string  () ;
void set_replace_string2 () ;
void replace_string   () ;
void Copy_string      () ;
void Copy_string1      () ;
void Copy_string2      () ;
void Insert_string    () ;
void Insert_string1    () ;
void Insert_string2    () ;
void Shortwin         () ;
void compname_opt     () ;
void comp_opt         () ;
void srce_opt         () ;
void exec_opt         () ;
void usew_opt         () ;
void tatt_opt         () ;
void prnt_opt         () ;
void form_opt         () ;
void form_odd_opt     () ;
void form_even_opt    () ;
void preformat_print_opt () ;
void errmess_opt         () ;
void terminate_opt       () ;
int  filebutton  () ;
int  toolbutton  () ;
int  optbutton   () ;
int  execbutton  () ; 
int  helpbutton  () ;          
void Helpabout    () ;
void Helpquick    () ;
void Helpdetail   () ;

void piccanvas_repaint () ;
void initcolor    () ;
void initchips    () ;
void choosecolor  () ; 
void cancel_quit  () ;
void ende         () ;
Notify_value notify_resize () ;


main (argc, argv)
int argc ; 
char *argv[] ;
{
  /* needed if a load-file parameter is given */
  FILE *fp;
  char xx[1];
  int i;
  
  /* read in config file and get current path */
  configurate(strcpy(malloc(sizeof(argv[0]))+1, argv[0]));
  working_directory = strcpy( malloc(strlen (getcwd(NULL, MAXPATHLEN))+1), getcwd(NULL, MAXPATHLEN)) ;

  filenamep = malloc(2);    sprintf(filenamep,   "");    /* the necessary pointer initialisation */
  tempstr = malloc(2);      sprintf(tempstr,     "");
  file_directory = malloc(2);      sprintf(file_directory,  "");
  resultframe = 0; compilerrunning=0;
  comp_results[0] = malloc(2);      sprintf(comp_results[0],     "");
  for(i=0; i<256; i++) projbuf[i]=NULL;

  /* start X-window process */
  xv_init (XV_INIT_ARGC_PTR_ARGV, &argc, argv, NULL);

  /* creation of icons */
  icon = (Icon)xv_create(frame, ICON,
      ICON_IMAGE,         
          (Server_image)xv_create((int)NULL, SERVER_IMAGE,
              XV_WIDTH,           64,
              XV_HEIGHT,          64,
              SERVER_IMAGE_BITS,  xwbicon_bits,
              NULL),
      XV_X,               100,
      XV_Y,               100,
      NULL);
  buttonicon = (Icon)xv_create(frame, ICON,
      ICON_IMAGE,         
          (Server_image)xv_create((int)NULL, SERVER_IMAGE,
              XV_WIDTH,           64,
              XV_HEIGHT,          64,
              SERVER_IMAGE_BITS,  button_bits,
              NULL),
      XV_X,               100,
      XV_Y,               100,
      NULL);
  compilericon = (Icon)xv_create(frame, ICON,
      ICON_IMAGE,         
          (Server_image)xv_create((int)NULL, SERVER_IMAGE,
              XV_WIDTH,        64,
              XV_HEIGHT,       64,
              SERVER_IMAGE_BITS,         compiler_bits,
              NULL),
      XV_X,               100,
      XV_Y,               100,
      NULL);


  /* Initialize  base frame */
  frame = (Frame)xv_create ((int)NULL, FRAME, 
       FRAME_LABEL,     "Schlampisoft X-window Workbench",
       XV_WIDTH,        horizontalsize,
       XV_HEIGHT,       verticalsize,
       FRAME_ICON,      icon,
       NULL) ;
  display = (Display *)xv_get (frame, XV_DISPLAY);

  /* Initialize Menu-Choosecolor */
  initcolor(&cms_data, red, green, blue);
  /*initchips(panel, chips) ;*/
  compnum=0 ;
  stipple_bits[0] = 0xAA ; stipple_bits[1] = 0xAA ;
  stipple_bits[2] = 0x55 ; stipple_bits[3] = 0x55 ;
  
  /* Initialize menu */
  filemenu = (Menu) xv_create((int)NULL , MENU,             
       MENU_ITEM,  
         MENU_STRING,         "New",
         MENU_PULLRIGHT,
         xv_create(panel , MENU,
           MENU_ITEM,
             MENU_STRING,        "Another frame", 
             MENU_NOTIFY_PROC,    New_text_frame,
             MENU_CLIENT_DATA,    argv[0],
             NULL,
           MENU_ITEM,
             MENU_STRING,        "Clear window", 
             MENU_NOTIFY_PROC,    Actual_text_frame,
             NULL,
           NULL),
         NULL,
       MENU_ITEM,
         MENU_STRING,       "Open",
         MENU_NOTIFY_PROC,   Filechooseropen,
         NULL,   
       MENU_ITEM,
         MENU_STRING,        "Save",
         MENU_NOTIFY_PROC,    Save, 
         NULL,
       MENU_ITEM,
         MENU_STRING,       "Save as",
         MENU_NOTIFY_PROC,   Filechoosersaveas,
         NULL,   
       MENU_ITEM,
         MENU_STRING,      "Print",
         MENU_NOTIFY_PROC,  Print,
         NULL,
       MENU_ITEM,
         MENU_STRING,      "Formatted print",
         MENU_PULLRIGHT,
         xv_create(panel, MENU,
           MENU_ITEM,
             MENU_STRING,       "Print preformatted",
             MENU_NOTIFY_PROC,  Preformattedprint,
             NULL,
           MENU_ITEM,
             MENU_STRING,       "Print all",
             MENU_NOTIFY_PROC,  Printformat,
             NULL,
           MENU_ITEM,
             MENU_STRING,       "Print odd sides",
             MENU_NOTIFY_PROC,  Printformatoddsides,
             NULL,
           MENU_ITEM,
             MENU_STRING,       "Print even sides",
             MENU_NOTIFY_PROC,  Printformatevensides,
             NULL,
           NULL),
         NULL,
       MENU_ITEM,
         MENU_STRING,      "Author",
         MENU_NOTIFY_PROC, Copyright,
         NULL,
       MENU_ITEM,
         MENU_STRING,      "QUIT",
         MENU_NOTIFY_PROC,  Quit,            
         NULL,
       NULL);
  toolmenu = (Menu) xv_create((int)NULL, MENU,
       MENU_ITEM,
         MENU_STRING,      "Line number",
         MENU_NOTIFY_PROC,  Linenumber,
         NULL,
       MENU_ITEM,  
         MENU_STRING,         "Find",
         MENU_PULLRIGHT,
         xv_create(panel , MENU,
           MENU_ITEM,
             MENU_STRING,        "search forward", 
             MENU_CLIENT_DATA, 0,
            MENU_NOTIFY_PROC,    Find,
             NULL,
           MENU_ITEM,
             MENU_STRING,        "search backward", 
             MENU_CLIENT_DATA, 1,
            MENU_NOTIFY_PROC,    Find,
             NULL,
           NULL),
         NULL,
       MENU_ITEM,  
         MENU_STRING,         "find next",
         MENU_PULLRIGHT,
         xv_create(panel , MENU,
           MENU_ITEM,
             MENU_STRING,        "search forward", 
             MENU_CLIENT_DATA, 0,
            MENU_NOTIFY_PROC,    Findnext,
             NULL,
           MENU_ITEM,
             MENU_STRING,        "search backward", 
             MENU_CLIENT_DATA, 1,
            MENU_NOTIFY_PROC,    Findnext,
             NULL,
           NULL),
         NULL,
       MENU_ITEM,
         MENU_STRING,      "Replace",
         MENU_NOTIFY_PROC,  Replace,
         NULL,
       MENU_ITEM,
         MENU_STRING,      "Copy string",
         MENU_NOTIFY_PROC,  Copy_string, 
         NULL,
       MENU_ITEM,
         MENU_STRING,      "Insert string",
         MENU_NOTIFY_PROC,  Insert_string, 
         NULL,
       NULL);
  optmenu = (Menu) xv_create((int)NULL, MENU,
       MENU_ITEM,
         MENU_STRING,      "Button window",
         MENU_NOTIFY_PROC,  Shortwin, 
         NULL,
       MENU_ITEM,
         MENU_STRING,      "Choose Configuration",
         MENU_PULLRIGHT,
         xv_create(panel, MENU,
           MENU_ITEM,
             MENU_STRING,       compilername_buf[0],
             MENU_CLIENT_DATA,  0,
             MENU_NOTIFY_PROC,  select_conf,
             NULL,
           MENU_ITEM,
             MENU_STRING,       compilername_buf[1],
             MENU_CLIENT_DATA,  1,
             MENU_NOTIFY_PROC,  select_conf,
             NULL,
           MENU_ITEM,
             MENU_STRING,       compilername_buf[2],
             MENU_CLIENT_DATA,  2,
             MENU_NOTIFY_PROC,  select_conf,
             NULL,
           MENU_ITEM,
             MENU_STRING,       compilername_buf[3],
             MENU_CLIENT_DATA,  3,
             MENU_NOTIFY_PROC,  select_conf,
             NULL,
           MENU_ITEM,
             MENU_STRING,       compilername_buf[4],
             MENU_CLIENT_DATA,  4,
             MENU_NOTIFY_PROC,  select_conf,
             NULL,
           MENU_ITEM,
             MENU_STRING,       compilername_buf[5],
             MENU_CLIENT_DATA,  5,
             MENU_NOTIFY_PROC,  select_conf,
             NULL,
           MENU_ITEM,
             MENU_STRING,       compilername_buf[6],
             MENU_CLIENT_DATA,  6,
             MENU_NOTIFY_PROC,  select_conf,
             NULL,
           MENU_ITEM,
             MENU_STRING,       compilername_buf[7],
             MENU_CLIENT_DATA,  7,
             MENU_NOTIFY_PROC,  select_conf,
             NULL,
           MENU_ITEM,
             MENU_STRING,       compilername_buf[8],
             MENU_CLIENT_DATA,  8,
             MENU_NOTIFY_PROC,  select_conf,
             NULL,
           MENU_ITEM,
             MENU_STRING,       compilername_buf[9],
             MENU_CLIENT_DATA,  9,
             MENU_NOTIFY_PROC,  select_conf,
             NULL,
           MENU_ITEM,
             MENU_STRING,       compilername_buf[10],
             MENU_CLIENT_DATA,  10,
             MENU_NOTIFY_PROC,  select_conf,
             NULL,
           MENU_ITEM,
             MENU_STRING,       compilername_buf[11],
             MENU_CLIENT_DATA,  11,
             MENU_NOTIFY_PROC,  select_conf,
             NULL,
           MENU_ITEM,
             MENU_STRING,       compilername_buf[12],
             MENU_CLIENT_DATA,  12,
             MENU_NOTIFY_PROC,  select_conf,
             NULL,
           MENU_ITEM,
             MENU_STRING,       compilername_buf[13],
             MENU_CLIENT_DATA,  13,
             MENU_NOTIFY_PROC,  select_conf,
             NULL,
           MENU_ITEM,
             MENU_STRING,       compilername_buf[14],
             MENU_CLIENT_DATA,  14,
             MENU_NOTIFY_PROC,  select_conf,
             NULL,
           MENU_ITEM,
             MENU_STRING,       compilername_buf[15],
             MENU_CLIENT_DATA,  15,
             MENU_NOTIFY_PROC,  select_conf,
             NULL,
           NULL),
         NULL,
       MENU_ITEM,
         MENU_STRING,      "Compiler Description",
         MENU_NOTIFY_PROC,  compname_opt,
         NULL,
       MENU_ITEM,
         MENU_STRING,      "Compiler",
         MENU_NOTIFY_PROC,  comp_opt,
         NULL,
       MENU_ITEM,
         MENU_STRING,      "Source file format",
         MENU_NOTIFY_PROC,  srce_opt,
         NULL,
       MENU_ITEM,
         MENU_STRING,      "Target file format",
         MENU_NOTIFY_PROC,  exec_opt,
         NULL,
       MENU_ITEM,
         MENU_STRING,      "Use target file with",
         MENU_NOTIFY_PROC,  usew_opt,
         NULL,
       MENU_ITEM,
         MENU_STRING,      "Printer",
         MENU_NOTIFY_PROC,  prnt_opt,
         NULL,         
       MENU_ITEM,  
         MENU_STRING,         "Formatted print",
         MENU_PULLRIGHT,
         xv_create(panel , MENU,
           MENU_ITEM,
             MENU_STRING,      "Preformatted print",
             MENU_NOTIFY_PROC,  preformat_print_opt,
             NULL,   
           MENU_ITEM,
             MENU_STRING,        "Print all", 
             MENU_NOTIFY_PROC,    form_opt,
             NULL,
           MENU_ITEM,
             MENU_STRING,        "Print odd sides", 
             MENU_NOTIFY_PROC,    form_odd_opt,
             NULL,
           MENU_ITEM,
             MENU_STRING,        "Print even sides", 
             MENU_NOTIFY_PROC,    form_even_opt,
             NULL,
           NULL),
         NULL,
       MENU_ITEM,
         MENU_STRING,      "Error messages",
         MENU_NOTIFY_PROC,  errmess_opt,
         NULL,
        MENU_ITEM,
         MENU_STRING,      "Compiler method",
         MENU_NOTIFY_PROC,  terminate_opt,
         NULL,
      NULL);
  execmenu = (Menu) xv_create((int)NULL, MENU,
       MENU_ITEM,
         MENU_STRING,      "Compile actual file",
         MENU_NOTIFY_PROC,  Compile,
         NULL,
       MENU_ITEM,
         MENU_STRING,      "Run Xwin application",
         MENU_NOTIFY_PROC,  RunX,
         NULL,
       MENU_ITEM,
         MENU_STRING,      "Run in foreground",
         MENU_NOTIFY_PROC,  Run, 
         NULL,
       MENU_ITEM,
         MENU_STRING,      "Break execution",
         MENU_NOTIFY_PROC,  Break,
         NULL,
       NULL);
  helpmenu = (Menu) xv_create((int)NULL, MENU,
       MENU_ITEM,
         MENU_STRING,      "About",
         MENU_NOTIFY_PROC,  Helpabout,
         NULL,
       MENU_ITEM,
         MENU_STRING,      "Quick Introduction",
         MENU_NOTIFY_PROC, Helpquick ,
         NULL,
       MENU_ITEM,
         MENU_STRING,      "Summary",
         MENU_NOTIFY_PROC,  Helpdetail, 
         NULL,
      NULL);

  /* Initialize menu buttons */
  panel = (Panel)xv_create (frame, PANEL, 
       XV_X,                     0,
       XV_Y,                     0,
        WIN_ROWS,               1,
       NULL);
       
  (void)xv_create (panel, PANEL_BUTTON,
       PANEL_LABEL_STRING,       "File",
       PANEL_ITEM_COLOR,         6,
       PANEL_ITEM_MENU,          filemenu,
       NULL);
  (void)xv_create (panel, PANEL_BUTTON,
       PANEL_LABEL_STRING,       "Tools",
       PANEL_ITEM_COLOR,         7,
       PANEL_ITEM_MENU,          toolmenu,
       NULL);
  (void)xv_create (panel, PANEL_BUTTON,
       PANEL_LABEL_STRING,       "Options",
       PANEL_ITEM_COLOR,         8,
       PANEL_ITEM_MENU,          optmenu,
       NULL);
  (void)xv_create (panel, PANEL_BUTTON,
       PANEL_LABEL_STRING,       "Execute",
       PANEL_ITEM_COLOR,         9,
       PANEL_ITEM_MENU,          execmenu,
       NULL);
  (void)xv_create (panel, PANEL_BUTTON,
       PANEL_LABEL_STRING,       "Help",   
       PANEL_ITEM_COLOR,         10,
       PANEL_ITEM_MENU,          helpmenu,
       NULL);

  /* Canvas: root for Editor */
  canvas = (Canvas)xv_create (frame, CANVAS,
       CANVAS_AUTO_SHRINK,   TRUE,
       CANVAS_AUTO_EXPAND,   TRUE,
       XV_X,            0,
       WIN_BELOW,       panel,
       XV_WIDTH,        xv_get(frame, XV_WIDTH),
       XV_HEIGHT,       xv_get(frame, XV_HEIGHT)-25,
       NULL);
    
  /* Text-subwindow */
  textsw = (Textsw)xv_create(canvas,TEXTSW,
       TEXTSW_MEMORY_MAXIMUM,     textsw_buf_size,
       TEXTSW_AUTO_INDENT,        TRUE,
       XV_X,                      0,
       XV_Y,                      0,
       XV_WIDTH,                  xv_get(canvas, XV_WIDTH),
       XV_HEIGHT,                 (xv_get(canvas, XV_HEIGHT)/5)*4,
       WIN_FOREGROUND_COLOR,      2,
       NULL);

  textswfont = (Xv_Font)xv_find(frame, FONT, FONT_NAME, spec_font, NULL);
  if (!textswfont)
    printf("Specified font not found, using default\n");
  else
    xv_set(textsw, TEXTSW_FONT, textswfont, NULL);

   /* Required Configuration for graphic Display */ 
  piccanvas_xid     = (Window)      xv_get (canvas_paint_window(canvas), XV_XID);
  if(!(font = XLoadQueryFont(display, "fixed")))  { printf("cannot find fixed font\n"); exit(1); }
  gc_val.font = font->fid;
  gc_val.stipple = XCreateBitmapFromData(display, piccanvas_xid, stipple_bits, 16, 2);
  gc = XCreateGC(display, piccanvas_xid, GCFont | GCStipple, &gc_val);
    


  /* Picture-Subwindow */
  piccanvas = (Canvas) xv_create (canvas, CANVAS,
       CANVAS_REPAINT_PROC,   piccanvas_repaint,
       CANVAS_X_PAINT_WINDOW, TRUE,
       WIN_DYNAMIC_VISUAL,    FALSE,
       XV_X,                   0,
       WIN_BELOW,              textsw,
       XV_WIDTH,          (215*xv_get(canvas, XV_HEIGHT))/700,
       XV_HEIGHT,         xv_get(canvas, XV_HEIGHT)-xv_get(textsw, XV_HEIGHT),
       WIN_CMS_NAME,      "palette",
       WIN_CMS_DATA,      &cms_data,
       NULL);
       
  colors = (unsigned long *)xv_get (piccanvas, WIN_X_COLOR_INDICES);

  /* Tty-Subwindow */
  tty = (Tty)xv_create (canvas, TTY,
       XV_X,              xv_get(piccanvas, XV_WIDTH),
       WIN_BELOW,              textsw,
       XV_WIDTH,        xv_get(canvas, XV_WIDTH)-xv_get(piccanvas, XV_WIDTH), 
       XV_HEIGHT,       xv_get(canvas, XV_HEIGHT)-xv_get(textsw, XV_HEIGHT),
       NULL); 
  
  window_fit(frame);
  window_fit(canvas);
  
/* File to load given as an argument ? */
  if (argv[1]!=NULL)
    if(fp = fopen(argv[1],"r"))  /* file accessable ?  */
      if(!read(fileno(fp), xx, 1)==0)
        if(!(unsigned int)xx[0]==0)
        {
          close((int)fp);
          xv_set(textsw, TEXTSW_FILE, argv[1], NULL);
          
          /* find an accurate configuration */
          i=0;
          if (strlen(argv[1])>=strlen(source_buf[i]))
            if (strcmp(source_buf[i], argv[1]-strlen(source_buf[i])+strlen(argv[1])))
            {
              while (i<16)
              {
                while (strlen(argv[1])<strlen(source_buf[i]) && i<16)
                  i++;
                if (strcmp(source_buf[i], argv[1]+strlen(argv[1])-strlen(source_buf[i])))
                  i++;
                else
                {
                  if (i<16) compnum=i;
                  i=16;
                }
              }
            } else compnum=0;

          free(tempstr);
          tempstr=malloc(strlen(compilername_buf[compnum])+strlen(argv[1])+5);
          sprintf(tempstr, "%s: <%s>",compilername_buf[compnum],argv[1]);
          xv_set(frame, FRAME_LABEL, tempstr, NULL);
          xv_set(textsw, TEXTSW_NOTIFY_PROC, textsw_notifyproc, NULL);
          free(filenamep);
          filenamep = malloc(strlen(file_directory)+strlen(argv[1])+2);
          sprintf(filenamep, "%s/%s", file_directory, argv[1]);
        }
  edited=0;
    
  xv_main_loop (frame) ;
  exit(0);
}

void
textsw_notifyproc()
{
  int temp=edited, l;
  if ((int)xv_get (textsw, TEXTSW_MODIFIED) == TRUE) edited=1; else edited=0;
  if (temp!=edited)
  {
    l=strlen(file_directory)+1;
    free(tempstr);
    tempstr=malloc(strlen(compilername_buf[compnum])+strlen(filenamep+l)+15);
    sprintf(tempstr,"%s: <%s> - edited", compilername_buf[compnum], filenamep+l);
    xv_set(frame, FRAME_LABEL, tempstr, NULL);
  }
}

int
getedittext()
{
  filename[0]='\0';
  return(textsw_append_file_name(textsw, filename) );
  free(filenamep);
  filenamep = strcpy(malloc(strlen(filename)+1), filename);
}

void 
Saved_notify()
{ 
  int result, l;
  Panel mypanel;
  if (getedittext()!=0) return;
  if((int)xv_get (textsw, TEXTSW_MODIFIED) != FALSE)
  {  
    mypanel = (Panel)xv_get (panel , PANEL_PARENT_PANEL);
    result = notice_prompt(mypanel, NULL,
      NOTICE_MESSAGE_STRINGS, "text modified, save?", NULL,
      NOTICE_BUTTON_YES,      "SAVE",
      NOTICE_BUTTON_NO,       "Don't save",
      NULL);
    if (result==NOTICE_YES)
    {
      textsw_store_file(textsw, filename, 0, 0);
      l=strlen(file_directory)+1;
      free(tempstr);
      tempstr=malloc(strlen(compilername_buf[compnum])+strlen(filenamep+l)+5);
      sprintf(tempstr,"%s: <%s>", compilername_buf[compnum], filenamep+l);
      if ( xv_set(frame, FRAME_LABEL, tempstr, NULL) ) edited=0;
    }
  }
}


void Save2 ();


void     
New_text_frame(menu, menu_item)
Menu        menu;  
Menu_item   menu_item;
{
  ttysw_input (tty, xv_get(menu_item, MENU_CLIENT_DATA), sizeof(xv_get(menu_item, MENU_CLIENT_DATA)));
  ttysw_input (tty, " &\n", strlen(" &\n"));
}

void     
Actual_text_frame(menu, menu_item)
Menu        menu;  
Menu_item   menu_item;
{
  int result;
  Panel mypanel;
  long int end = (Textsw_index)xv_get (textsw, TEXTSW_LENGTH)-1;
  mypanel = (Panel)xv_get ( panel , PANEL_PARENT_PANEL);
  result = notice_prompt(mypanel, NULL,
      NOTICE_MESSAGE_STRINGS, "REALLY CLEAR TEXT WINDOW?", NULL,
      NOTICE_BUTTON_YES,      "Do it",
      NOTICE_BUTTON_NO,       "cancel",
      NULL);
  if (result==NOTICE_YES)
  {
    Saved_notify();
    textsw_erase(textsw, 0, end);
    xv_set(textsw, TEXTSW_FILE_CONTENTS, "", TEXTSW_FIRST, 0, NULL);
  }
}

void Ok_open_flist();
void Ok_save_flist();


static int
flistnotify( item, dir, file, client_data, op, event, row )
     File_list item;
     char *dir;
     char *file;
     Xv_opaque client_data;
     Panel_list_op op;
     Event *event;
     int row;
{
  if (!strcmp(file, "...Go up one folder...")) return;
  
  free(filenamep);
  filenamep = malloc(strlen(file)+strlen(dir)+2);
  sprintf(filenamep,"%s/%s",dir ,file );
  if (save_file_text!=0)
    xv_set(save_file_text, PANEL_VALUE, file, NULL);
  
  /* double-click: */
  if(op==PANEL_LIST_OP_DBL_CLICK)
    if (save_file_text!=0)
      Ok_save_flist((Panel_item)0); /* item value not used anyway */
    else
      Ok_open_flist((Panel_item)0);
}

static int
flistchdir( list, path, sbuf, op )
     File_list list;
     char *path;
     struct stat *sbuf;
     File_list_op op;
{
  if (strcmp(path, working_directory)) didchangepath = 1; else return ;
  xv_set(Filech_path_text, PANEL_VALUE, path, NULL);
  free(working_directory);
  working_directory = strcpy( malloc(strlen(path)+1), path ) ;
  if (save_file_text!=0)
    xv_set(save_file_text, PANEL_VALUE, "", NULL);
}

void 
Ok_open_flist(item)
Panel_item   item;
{  
  int i=0,l;
  FILE *fp;
  char xx[1];

  if (didchangepath == 1)
  {
    ttysw_input (tty, "cd ", 3);
    ttysw_input (tty, working_directory, strlen(working_directory));
    ttysw_input (tty, "\n", 1);
    chdir(working_directory);
  }
  
  if(!(fp = fopen(filenamep,"r"))) return;  /* file accessable ?  */
  if(read(fileno(fp), xx, 1)==0) return;
  if((unsigned int)xx[0]==0) return;
  close((int)fp);

  xv_set(textsw, TEXTSW_FILE, filenamep, NULL);
  l=strlen(working_directory)+1;
  while (strlen(filenamep+l)<strlen(source_buf[compnum]) && compnum<16)
    compnum++;
  if (strcmp(source_buf[compnum], filenamep+strlen(filenamep)-strlen(source_buf[compnum])))
  {
    /* find an accurate configuration */
    i=0;
    if (strlen(filenamep+l)>=strlen(source_buf[i]))
      if (strcmp(source_buf[i], filenamep-strlen(source_buf[i])+strlen(filenamep)))
      {
        while (i<16)
        {
          while (strlen(filenamep+l)<strlen(source_buf[i]) && i<16)
            i++;
          if (strcmp(source_buf[i], filenamep+l+strlen(filenamep+l)-strlen(source_buf[i])))
            i++;
          else
          {
            if (i<16) compnum=i;
            i=16;
          }
        }
      } else compnum=0;
  }
  free(tempstr);
  tempstr=malloc(strlen(compilername_buf[compnum])+strlen(filenamep+l)+5);
  sprintf(tempstr, "%s: <%s>",compilername_buf[compnum],filenamep+l);
  if ( xv_set(frame, FRAME_LABEL, tempstr, NULL) ) edited=0;
  free(file_directory);
  file_directory = strcpy(malloc(strlen(working_directory)+1), working_directory);
  xv_destroy_safe (Filech_frame);
  Filech_frame=0;
  
  xv_set(textsw, TEXTSW_NOTIFY_PROC, textsw_notifyproc, NULL);
}

/*void 
Ok_project_flist(item)
Panel_item   item;
{
  FILE *fp, *fp_proj;
  int result;
  char xx[256];
  char *tmp_buf;
  long int i, j;  / * using i for buffer pointer * /
  long int end = (Textsw_index)xv_get (textsw, TEXTSW_LENGTH)-1;
  Panel mypanel;

  mypanel = (Panel)xv_get (panel , PANEL_PARENT_PANEL);
  result = notice_prompt(mypanel, NULL,
      NOTICE_MESSAGE_STRINGS, "Are you sure this is a project file?", NULL,
      NOTICE_BUTTON_YES,      "Yes",
      NOTICE_BUTTON_NO,       "No",
      NULL);
  if (result==NOTICE_NO)
    return;

  if (didchangepath == 1)
  {
    ttysw_input (tty, "cd ", 3);
    ttysw_input (tty, working_directory, strlen(working_directory));
    ttysw_input (tty, "\n", 1);
  }
 
  textsw_erase(textsw, 0, end);
  xv_set(textsw, TEXTSW_FILE_CONTENTS, "", TEXTSW_FIRST, 0, NULL);

  / * get contents of project file * /
  if(!(fp = fopen(filenamep,"r"))) return;
  / * use mainframe here first * /
  numberproj=j=0;
  while(j==0 || (xx[j-1]!='\n' && xx[j-1]!='\0'))
    { if(read(fileno(fp), xx+j, 1)==0) return;  j++; }
  xx[j-1]='\0';
  xv_set(textsw, TEXTSW_FILE, xx, NULL);

  while (numberproj<projitems || xx[j-1]!='\0')
  {
    j=0;
    while(j==0 || (xx[j-1]!='\n' && xx[j-1]!='\0'))
      { read(fileno(fp), xx+j, 1);  j++; }
    if (xx[j-1]=='\0') break;
    xx[j-1]='\0';
    projframe[numberproj] = (Frame)xv_create (frame, FRAME, 
        FRAME_LABEL,     xx,
        XV_WIDTH,        projhorizontalsize,
        XV_HEIGHT,       projverticalsize,
        NULL) ;
    panelproj[numberproj] = (Panel)xv_create (projframe[numberproj], PANEL, 
        XV_WIDTH,        projhorizontalsize,
        XV_HEIGHT,       projverticalsize,
        NULL); 

    / * textsw not usable, so use PANEL_MULTILINE_TEXT * /
    tmp_buf = malloc(textsw_proj_buf_size);
    i=0;
    if(!(fp_proj = fopen(xx,"r"))) return;  
    while ( i<textsw_proj_buf_size )
    {
    
      if(read(fileno(fp), tmp_buf+i, 1)==0)
      {
        (char)*(tmp_buf+i)='\0';
        i=textsw_proj_buf_size;
      }
      i++;
      if (i==textsw_proj_buf_size)
      {
        result = notice_prompt(mypanel, NULL,
            NOTICE_MESSAGE_STRINGS, "File size of projfile larger than",
                                    "given maximum in config file.",
                                    "You should raise it now.", NULL,
            NOTICE_BUTTON_YES,      "Abort",
            NULL);
            
            / *.....* /
        return;      
      }
    } 
    projbuf[numberproj] = strcpy( malloc(textsw_proj_buf_size+1), tmp_buf );
    free(tmp_buf);


      / *textswproj[numberproj] = (Textsw)xv_create(panelproj[numberproj], TEXTSW,
        TEXTSW_MEMORY_MAXIMUM,     textsw_proj_buf_size,
        TEXTSW_AUTO_INDENT,        TRUE,
        XV_WIDTH,        projhorizontalsize,
        XV_HEIGHT,       projverticalsize,
       NULL);
    xv_set(textswproj[numberproj], TEXTSW_FILE, xx, NULL);* /
    
    
    xv_set(projframe[numberproj], XV_SHOW, TRUE,   NULL);
    numberproj++;
  }
  close((int)fp);
  xv_destroy_safe (Filech_frame);
  Filech_frame=0;
}*/

void 
Ok_save_flist(item)
Panel_item   item;
{  
  int i=0,l;
  /*FILE *fp;*/
  char xx[1];
  
  free(filenamep);
  filenamep = malloc(sizeof(xv_get(save_file_text, PANEL_VALUE)));
  sprintf(filenamep,"%s",xv_get(save_file_text, PANEL_VALUE));
  if ( '\0'==(char)*(filenamep) ) return;

  if (didchangepath == 1)
  {
    ttysw_input (tty, "cd ", 3);
    ttysw_input (tty, working_directory, strlen(working_directory));
    ttysw_input (tty, "\n", 1);
    chdir(working_directory);
  }
  textsw_store_file(textsw, filenamep, 0, 0);
  
  while (strlen(filenamep)<strlen(source_buf[compnum]) && compnum<16)
    compnum++;
  if (strcmp(source_buf[compnum], filenamep+strlen(filenamep)-strlen(source_buf[compnum])))
  {
    /* find an accurate configuration */
    i=0;
    if (strlen(filenamep)>=strlen(source_buf[i]))
      if (strcmp(source_buf[i], filenamep-strlen(source_buf[i])+strlen(filenamep)))
      {
        while (i<16)
        {
          while (strlen(filenamep)<strlen(source_buf[i]) && i<16)
            i++;
          if (strcmp(source_buf[i], filenamep+strlen(filenamep)-strlen(source_buf[i])))
            i++;
          else
          {
            if (i<16) compnum=i;
            i=16;
          }
        }
      } else compnum=0;
  }
  free(tempstr);
  tempstr=malloc(strlen(compilername_buf[compnum])+strlen(filenamep)+5);
  sprintf(tempstr, "%s: <%s>",compilername_buf[compnum],filenamep);
  if ( xv_set(frame, FRAME_LABEL, tempstr, NULL) ) edited=0;
  free(file_directory);
  file_directory = strcpy(malloc(strlen(working_directory)+1), working_directory);
  xv_destroy_safe (Filech_frame);
  Filech_frame=0;

  
  
  xv_destroy_safe (Filech_frame);
  Filech_frame=0;
  save_file_text=0;
}

void Cancel_button(item)
Panel_item  item;
{
  if (didchangepath == 1)
  {
    ttysw_input (tty, "cd ", 3);
    ttysw_input (tty, working_directory, strlen(working_directory));
    ttysw_input (tty, "\n", 1);
  }
  xv_destroy_safe(Filech_frame);
  Filech_frame=0;
  getedittext();
}


void 
Filechooseropen(menu_item, op)
Menu_item     menu_item;
Menu_generate op;
{
  if (Filech_frame!=0)  return;
  Saved_notify ();
  didchangepath = 0;
  save_file_text=0;
  Filech_frame = (Frame)xv_create ((int)NULL, FRAME, 
       FRAME_LABEL,            "Select a file to open",
       NULL) ;
  Filech_panel = (Panel)xv_create (Filech_frame, PANEL, 
       PANEL_LAYOUT, PANEL_VERTICAL, 
       NULL);
  Filech_path_text = xv_create(Filech_panel, PANEL_TEXT,
		    PANEL_READ_ONLY,		TRUE,
		    PANEL_LABEL_STRING,		"Current path:",
		    PANEL_VALUE,		(working_directory)
		    					? working_directory
		    					: "",
		    PANEL_VALUE_UNDERLINED,	FALSE,
		    PANEL_VALUE_STORED_LENGTH, 30,
		    PANEL_LAYOUT,		PANEL_VERTICAL,
		    NULL);
  filechooser = xv_create(Filech_panel, FILE_LIST, 
  		    FILE_LIST_CHANGE_DIR_FUNC,  flistchdir,
		    PANEL_NOTIFY_PROC,		flistnotify,
		    FILE_LIST_DIRECTORY,	working_directory,
		    PANEL_DISPLAY_ROWS,	        15,
                    NULL);
  xv_create(Filech_panel, PANEL_BUTTON,
		    PANEL_LABEL_STRING,  "  OPEN FILE  ",
		    PANEL_NOTIFY_PROC,   Ok_open_flist,
		    NULL);
  xv_set(Filech_panel, PANEL_LAYOUT, PANEL_HORIZONTAL, NULL);
  xv_create(Filech_panel, PANEL_BUTTON,
		    PANEL_LABEL_STRING,  "  close  ",
		    PANEL_NOTIFY_PROC,   Cancel_button,
		    NULL);
		    
  /* still problems with textsubwindows in childframes */
  xv_set(Filech_panel, PANEL_LAYOUT, PANEL_VERTICAL, NULL);
  /*(void)xv_create(Filech_panel, PANEL_MESSAGE, 
       PANEL_LABEL_STRING,               "========================", 
       NULL);
   xv_create(Filech_panel, PANEL_BUTTON,
		    PANEL_LABEL_STRING,  "         OPEN PROJECT         ",
		    PANEL_NOTIFY_PROC,   Ok_project_flist,
		    NULL);*/

		    
  xv_set(filechooser, XV_WIDTH, 200, NULL);  /* Without setting xvwidth, it doesn't work. Bug? */
  xv_set(Filech_panel, XV_WIDTH, xv_get(filechooser, XV_WIDTH), NULL);
  window_fit(Filech_panel);
  xv_set(Filech_panel, XV_WIDTH, 200, NULL);
  window_fit(Filech_frame);
  xv_set(Filech_frame, XV_SHOW, TRUE,   NULL);
}

void 
Filechoosersaveas(menu_item, op)
Menu_item     menu_item;
Menu_generate op;
{
  int l;
  if (Filech_frame!=0)  return;
  didchangepath = 0;
  Filech_frame = (Frame)xv_create ((int)NULL, FRAME, 
       FRAME_LABEL,            "Choose a filename to save",
       NULL) ;
  Filech_panel = (Panel)xv_create (Filech_frame, PANEL, 
       PANEL_LAYOUT, PANEL_VERTICAL, 
       NULL); 
  Filech_path_text = xv_create(Filech_panel, PANEL_TEXT,
		    PANEL_READ_ONLY,		TRUE,
		    PANEL_LABEL_STRING,		"Current path:",
		    PANEL_VALUE,		(working_directory)
		    					? working_directory
		    					: "",
		    PANEL_VALUE_UNDERLINED,	FALSE,
		    PANEL_VALUE_STORED_LENGTH, 30,
		    PANEL_LAYOUT,		PANEL_VERTICAL,
		    NULL);
  filechooser = xv_create(Filech_panel, FILE_LIST, 
  		    FILE_LIST_CHANGE_DIR_FUNC,  flistchdir,
		    PANEL_NOTIFY_PROC,		flistnotify,
		    FILE_LIST_DIRECTORY,	working_directory,
		    PANEL_DISPLAY_ROWS,	        15,
                               NULL);
  xv_create(Filech_panel, PANEL_BUTTON,
		    PANEL_LABEL_STRING,  "      Ok      ",
		    PANEL_NOTIFY_PROC,   Ok_save_flist,
		    NULL);
  xv_set(Filech_panel, PANEL_LAYOUT, PANEL_HORIZONTAL, NULL);
  xv_create(Filech_panel, PANEL_BUTTON,
		    PANEL_LABEL_STRING,  "    cancel    ",
		    PANEL_NOTIFY_PROC,   Cancel_button,
		    NULL);
  xv_set(Filech_panel, PANEL_LAYOUT, PANEL_VERTICAL, NULL);
  /*getedittext();*/
  l=strlen(file_directory)+1;
  if (strcmp(file_directory,working_directory))
    save_file_text = (Panel_item)xv_create (Filech_panel, PANEL_TEXT,
        PANEL_LABEL_STRING,        "Filename: ",
        PANEL_LAYOUT,               PANEL_HORIZONTAL,
        PANEL_VALUE_DISPLAY_LENGTH, 12,
        PANEL_VALUE_STORED_LENGTH,  256,
	    PANEL_NOTIFY_PROC,   Ok_save_flist,
        NULL);
  else
    save_file_text = (Panel_item)xv_create (Filech_panel, PANEL_TEXT,
        PANEL_VALUE,                filename+l,
        PANEL_LABEL_STRING,        "Filename: ",
        PANEL_LAYOUT,               PANEL_HORIZONTAL,
        PANEL_VALUE_DISPLAY_LENGTH, 12,
        PANEL_VALUE_STORED_LENGTH,  256,
	    PANEL_NOTIFY_PROC,   Ok_save_flist,
        NULL);


  xv_set(filechooser, XV_WIDTH, 200, NULL);
  xv_set(Filech_panel, XV_WIDTH, xv_get(filechooser, XV_WIDTH), NULL);
  window_fit(Filech_panel);
  xv_set(Filech_panel, XV_WIDTH, 200, NULL);
  window_fit(Filech_frame);
  xv_set(Filech_frame, XV_SHOW, TRUE,   NULL);
}

void 
Save(menu, menu_item)
Menu        menu;  
Menu_item   menu_item;
{
  Save2();
}

void 
Save1(item)
Panel_item   item;
{
  Save2();
}

void 
Save2()
{
  Panel mypanel;
  int l;
  mypanel = (Panel)xv_get ( panel , PANEL_PARENT_PANEL);
 if((int)xv_get (textsw, TEXTSW_MODIFIED) == FALSE)
    notice_prompt(mypanel, NULL,
        NOTICE_MESSAGE_STRINGS, "Text has not been modified,  or", "no file name specified", NULL,
        NOTICE_BUTTON_YES,      "Acknowledged",
        NULL);
    else
  if (getedittext()==0)
  {
    textsw_store_file(textsw, filename, 0, 0);
    
    l=strlen(file_directory)+1;
    free(tempstr);
    tempstr=malloc(strlen(compilername_buf[compnum])+strlen(filenamep+l)+5);
    sprintf(tempstr,"%s: <%s>", compilername_buf[compnum], filenamep+l);
    if ( xv_set(frame, FRAME_LABEL, tempstr, NULL) ) edited=0;
  }
}



void
Copyright()
{ 
  int result;
  Panel mypanel = (Panel) xv_get (panel, PANEL_PARENT_PANEL);
  result = notice_prompt(mypanel, NULL,
      NOTICE_MESSAGE_STRINGS, "     --------------------------     ",
                              "Schlampisoft",
                              "X-window-Workbench",
                              "Version 2.0",
                              "-------------------------",
                              "",
                              "(c)1995 by Michael Sohmen",
                              "somi0011@rz03.FH-Karlsruhe.de",
                              "See Help, About for details",
                              "",
      NULL,
      NOTICE_BUTTON_YES,      "   Ok   ",
      NULL);
}
  


void Compile2      () ;
void RunX2         () ;
void Run2          () ;
void Break2        () ;


void
Print(menu, menu_item)
Menu        menu;
Menu_item   menu_item;
{
  int result;
  Panel mypanel;
  mypanel = (Panel)xv_get ( panel , PANEL_PARENT_PANEL);
  Saved_notify();
  result = notice_prompt(mypanel, NULL,
      NOTICE_MESSAGE_STRINGS, "Print file?", NULL,
      NOTICE_BUTTON_YES,      "GO!",
      NOTICE_BUTTON_NO,       "cancel",
      NULL);
  if (result==NOTICE_YES)
  {
    ttysw_input (tty, "cat ", strlen("cat "));
    ttysw_input (tty, filename, strlen(filename));
    ttysw_input (tty, " > ", strlen(" > "));
    ttysw_input (tty, printer_buf[compnum], strlen(printer_buf[compnum]));
    ttysw_input (tty, "& \n", strlen("& \n"));
  }
}
 
void 
Printformat_function(char *xx)
{  
  int i, j, result;
  Panel mypanel;
  char temp[4096];
  mypanel = (Panel)xv_get ( panel , PANEL_PARENT_PANEL);
  Saved_notify();
  /*result = notice_prompt(mypanel, NULL,
      NOTICE_MESSAGE_STRINGS,  "Print formatted output?", NULL,
      NOTICE_BUTTON_YES,      "GO!",
      NOTICE_BUTTON_NO,       "cancel",
      NULL);*/
  /*if (result==NOTICE_YES)*/
  for(i=j=0;xx[i]!='\0' && j<4096; i++)
    if ((int)xx[i]!=92 && xx[i]!='*')
      temp[j++]=xx[i];
    else
      if ((int)xx[i]==92 && xx[i+1]=='n')
      { 
        temp[j++]='\n';
        i++;
      }
      else
        if (xx[i]=='*')
        { 
          strncpy(temp+j, (char *)filename, strlen(filename)-strlen(source_buf[compnum]));
          j+=strlen(filename)-strlen(source_buf[compnum]);
        }
  temp[j++]='\n';
  ttysw_input (tty, temp, strlen(temp)+1);
}

void     
Printformat(menu, menu_item)
Menu        menu;  
Menu_item   menu_item;
{
  Printformat_function(strcpy (malloc(sizeof(printformat_buf[compnum])+1),printformat_buf[compnum])); 
}

void     
Printformatoddsides(menu, menu_item)
Menu        menu;  
Menu_item   menu_item;
{
  Printformat_function(strcpy (malloc(sizeof(printformat_odd_buf[compnum])+1),printformat_odd_buf[compnum])); 
}

void     
Printformatevensides(menu, menu_item)
Menu        menu;  
Menu_item   menu_item;
{
  Printformat_function(strcpy (malloc(sizeof(printformat_even_buf[compnum])+1),printformat_even_buf[compnum])); 
}

void     
Preformattedprint(menu, menu_item)
Menu        menu;  
Menu_item   menu_item;
{
  Printformat_function(strcpy (malloc(sizeof(preformat_print_buf[compnum])+1),preformat_print_buf[compnum])); 
}


void 
Quit(menu, menu_item)
Menu        menu;  
Menu_item   menu_item;
{
  Quit2();
}

void 
Quit1(item)
Panel_item   item;
{
  Quit2();
}

void 
Quit2()
{
  int result;
  Panel mypanel;
  mypanel = (Panel)xv_get ( panel , PANEL_PARENT_PANEL);
  result = notice_prompt(mypanel, NULL,
      NOTICE_MESSAGE_STRINGS, "REALLY QUIT?", NULL,
      NOTICE_BUTTON_YES,      "Quit",
      NOTICE_BUTTON_NO,       "cancel",
      NULL);
  if (result==NOTICE_YES)
  {
    Saved_notify();
    printf("Thanks and goodbye.\n");
    exit(0);
  }
}

void 
Linenumber(menu, menu_item)
Menu        menu;  
Menu_item   menu_item;
{
  Linenumber2();
}

void 
Linenumber1(item)
Panel_item   item;
{
  Linenumber2();
}

void 
Linenumber2()
{
  int set_line_number();
  Panel_item item;
  Seln_request *response;
  register char       *ptr;
  long int value;
  Seln_holder   holder;
  if (opt_text>0)  { xv_destroy_safe(opt_text); opt_text=0; return; }
  server = (Xv_Server)xv_get ( xv_get(frame, XV_SCREEN), SCREEN_SERVER );
  holder = selection_inquire(server, SELN_PRIMARY);
  response = selection_ask(server, &holder,
      SELN_REQ_CONTENTS_ASCII,    NULL,
      NULL);
  ptr = response->data;
  ptr += sizeof(SELN_REQ_CONTENTS_ASCII);
  printf("%s", ptr);
  if ((value=atol(ptr))>0) 
    opt_text = (Panel_item)xv_create (panel, PANEL_TEXT,
        XV_Y,                       8,
        PANEL_LABEL_STRING,        "Select line number ",      
        PANEL_LAYOUT,               PANEL_HORIZONTAL,
        PANEL_NOTIFY_PROC,          set_line_number,
        PANEL_VALUE,                ptr,
        PANEL_VALUE_DISPLAY_LENGTH, 8,
        PANEL_VALUE_STORED_LENGTH,  256,      
        NULL);
  else
    opt_text = (Panel_item)xv_create (panel, PANEL_TEXT,
        XV_Y,                       8,
        PANEL_LABEL_STRING,        "Select line number ",      
        PANEL_LAYOUT,               PANEL_HORIZONTAL,
        PANEL_NOTIFY_PROC,          set_line_number,
        PANEL_VALUE_DISPLAY_LENGTH, 8,
        PANEL_VALUE_STORED_LENGTH,  256,      
        NULL);
  xv_set(panel, PANEL_CARET_ITEM, opt_text, NULL);
}

int
set_line_number(item, event)
Panel_item  item;
Event *event;
{
  char number[10];
  long num;
  long i,j=0,k=0;
  char buf[2];
  long int end = (Textsw_index)xv_get (textsw, TEXTSW_LENGTH)-1;
  (void)strncpy(number, (char *)xv_get(item, PANEL_VALUE), sizeof(number) );
  num = atol(number)-1;
  if (num<0) {xv_destroy_safe(opt_text); return 1;}
  i=num;
  while (i>0)
  {
    if ((Textsw_index)xv_get (textsw, TEXTSW_CONTENTS, j, buf, 1)<1 || j>end) {xv_destroy_safe(opt_text); return 1;}
      j++;
    if(buf[0]=='\n') i--;
  }
  textsw_possibly_normalize(textsw, j);
  buf[0]=' ';
   while (buf[0]!='\n')
  {
    if ((Textsw_index)xv_get (textsw, TEXTSW_CONTENTS, j+k, buf, 1)<1 || j+k>end) {xv_destroy_safe(opt_text); return 1;}
      k++;
  } 
  textsw_set_selection(textsw, j, j+k, 1);
  xv_destroy_safe(opt_text);
  opt_text=0;
}


void 
Undo(menu, menu_item)
Menu        menu;  
Menu_item   menu_item;
{
    textsw_reset(textsw, 0, 0);/*locx, locy);*/
}

void 
Redo(menu, menu_item)
Menu        menu;  
Menu_item   menu_item;
{

}

void 
Find(menu, menu_item)
Menu        menu;  
Menu_item   menu_item;
{
  Find2(xv_get(menu_item, MENU_CLIENT_DATA));
}

void 
Find1(item)
Panel_item   item;
{
  Find2(xv_get(item, PANEL_CLIENT_DATA));
}

void 
Find2(direction)
int   direction;
{
  int set_find_string();
  Panel_item item;
  Seln_holder   holder;
  Seln_request *response;
  Textsw_index        first, last;
  register char       *ptr;
  point = (Textsw_index)xv_get (textsw, TEXTSW_INSERTION_POINT);
  if (opt_text>0)  { xv_destroy_safe(opt_text); opt_text=0; return; }
  server = (Xv_Server)xv_get ( xv_get(frame, XV_SCREEN), SCREEN_SERVER );
  holder = selection_inquire(server, SELN_PRIMARY);
  response = selection_ask(server, &holder,
      SELN_REQ_FIRST,             NULL,
      SELN_REQ_LAST,              NULL,
      SELN_REQ_CONTENTS_ASCII,    NULL,
      NULL);
  
  ptr = response->data;
  first = *(Textsw_index *)(ptr += sizeof(SELN_REQ_FIRST));
  ptr += sizeof(Textsw_index); 
  last  = *(Textsw_index *)(ptr += sizeof(SELN_REQ_LAST));
  ptr += sizeof(Textsw_index); 
  ptr += sizeof(SELN_REQ_CONTENTS_ASCII);
  findstring=malloc(strlen(ptr)+1); 
  strcpy(findstring, ptr);
  if (strlen(findstring)>0) 
  {
    if (direction==0)
    point = last+1; else point = first;
    search_string(direction);
  }
  else  
  {
    opt_text = (Panel_item)xv_create (panel, PANEL_TEXT,
        XV_Y,                       8,
        PANEL_LABEL_STRING,        "Search for -> ",      
        PANEL_LAYOUT,               PANEL_HORIZONTAL,
        PANEL_NOTIFY_PROC,          set_find_string,
        PANEL_CLIENT_DATA,           direction,
        PANEL_VALUE_DISPLAY_LENGTH, 30,
        PANEL_VALUE_STORED_LENGTH,  256,
      NULL);
      xv_set(panel, PANEL_CARET_ITEM, opt_text, NULL);
  }
}



int
set_find_string(item, event)
Panel_item  item;
Event *event;
{
  findstring=malloc(sizeof(xv_get(item, PANEL_VALUE))+1);
  (void) sprintf(findstring, "%s", xv_get(item, PANEL_VALUE));
  if (search_string(xv_get(item, PANEL_CLIENT_DATA))>0)
  {
    xv_destroy_safe(opt_text);
    opt_text=0;
  }
}

void 
Findnext(menu, menu_item)
Menu        menu;  
Menu_item   menu_item;
{
  Findnext2(xv_get(menu_item, MENU_CLIENT_DATA));
}

void 
Findnext1(item)
Panel_item   item;
{
  Findnext2(xv_get(item, PANEL_CLIENT_DATA));
}


void 
Findnext2(direction)
int   direction;
{
  point = (Textsw_index)xv_get (textsw, TEXTSW_INSERTION_POINT);
  (void)search_string(direction);
}

int
search_string(client)
int        client;
{
  Textsw_index where;
  Textsw_index *first = malloc(sizeof(Textsw_index));
  Textsw_index *lastplusone = malloc(sizeof(Textsw_index));
  *first = point;
  *lastplusone = (Textsw_index)xv_get (textsw, TEXTSW_LENGTH)-1;
  where = textsw_find_bytes(textsw, first, lastplusone, findstring, strlen(findstring), client);
  if (where<0)
  {
    *first = 0;
    *lastplusone = point;
    where = textsw_find_bytes(textsw, first, lastplusone, findstring, strlen(findstring), 0);
  } 
  if (where>-1) 
  {  
    textsw_possibly_normalize(textsw, where);
    textsw_set_selection(textsw, where, where+strlen(findstring), 1);
    if  (client==0)
      xv_set(textsw, TEXTSW_INSERTION_POINT, *lastplusone, NULL);
    else
      xv_set(textsw, TEXTSW_INSERTION_POINT, *first, NULL); 
      free(first); free(lastplusone);
    return 1;
  } 
  free(first); free(lastplusone);
  return 0;
}


void 
Replace(menu, menu_item)
Menu        menu;  
Menu_item   menu_item;
{
  int set_find_string();
  Panel_item item;
  Seln_holder   holder;
  Seln_request *response;
  Textsw_index        first, last;
  register char       *ptr;
  point = (Textsw_index)xv_get (textsw, TEXTSW_INSERTION_POINT);
  if (opt_text>0)  { xv_destroy_safe(opt_text); opt_text=0; return; }
  server = (Xv_Server)xv_get ( xv_get(frame, XV_SCREEN), SCREEN_SERVER );
  holder = selection_inquire(server, SELN_PRIMARY);
  response = selection_ask(server, &holder,
      SELN_REQ_FIRST,             NULL,
      SELN_REQ_LAST,              NULL,
      SELN_REQ_CONTENTS_ASCII,    NULL,
      NULL);
      
  ptr = response->data;
  first = *(Textsw_index *)(ptr += sizeof(SELN_REQ_FIRST));
  ptr += sizeof(Textsw_index); 
  last  = *(Textsw_index *)(ptr += sizeof(SELN_REQ_LAST));
  ptr += sizeof(Textsw_index); 
  ptr += sizeof(SELN_REQ_CONTENTS_ASCII);
  findstring=malloc(strlen(ptr)+1); 
  strcpy(findstring, ptr);
  if (strlen(findstring)>0) 
  {
    point = first;
    set_replace_string2(); 
  }
  else  
  {
    /*free(findstring);*/
    opt_text = (Panel_item)xv_create (panel, PANEL_TEXT,
        XV_Y,                       8,
        PANEL_LABEL_STRING,        "Replace this -> ",      
        PANEL_LAYOUT,               PANEL_HORIZONTAL,
        PANEL_NOTIFY_PROC,          set_replace_string,
        PANEL_VALUE_DISPLAY_LENGTH, 30,
        PANEL_VALUE_STORED_LENGTH,  256,
      NULL);
      xv_set(panel, PANEL_CARET_ITEM, opt_text, NULL);
  }
}

void
set_replace_string(item, event)
Panel_item  item;
Event *event;
{
  /*free(findstring);*/
  findstring=malloc(sizeof(xv_get(item, PANEL_VALUE))+1);
  (void) sprintf(findstring, "%s", xv_get(item, PANEL_VALUE));
  set_replace_string2();
}

void
set_replace_string2()
{
  xv_destroy_safe(opt_text); 
  opt_text=0;
  if (search_string(0)==1)
    opt_text = (Panel_item)xv_create (panel, PANEL_TEXT,
        XV_Y,                       8,
        PANEL_LABEL_STRING,        "Replace with -> ",      
        PANEL_LAYOUT,               PANEL_HORIZONTAL,
        PANEL_NOTIFY_PROC,          replace_string,
        PANEL_VALUE_DISPLAY_LENGTH, 30,
        PANEL_VALUE_STORED_LENGTH,  256,
    NULL);
    xv_set(panel, PANEL_CARET_ITEM, opt_text, NULL);
}

void
replace_string(item, event)
Panel_item  item;
Event *event;
{
  int result, result1;
  int prompt;
  Textsw_index where, begin, end ;
  Panel mypanel;
  Textsw_index *first = malloc(sizeof(Textsw_index)+1);
  Textsw_index *lastplusone = malloc(sizeof(Textsw_index)+1);
  replacestring=malloc(sizeof(xv_get(item, PANEL_VALUE))+20);
  (void) sprintf(replacestring, "%s", xv_get(item, PANEL_VALUE));
  mypanel = (Panel)xv_get ( panel , PANEL_PARENT_PANEL);
  result = notice_prompt(mypanel, NULL,
      NOTICE_MESSAGE_STRINGS, "PROMPT ON REPLACE?", NULL,
      NOTICE_BUTTON_YES,      "prompt",
      NOTICE_BUTTON_NO,       "replace all",
      NOTICE_BUTTON,          "cancel", 101,
      NULL);
  xv_destroy_safe(opt_text); 
  opt_text=0; 
  if (result==NOTICE_YES)
  {
    prompt = 1;
  }
  else 
    if (result==NOTICE_NO) 
      {
        prompt = 0;
      }
    else 
      { free(findstring); free(replacestring); return;}
  *first = begin = point;
  *lastplusone = end = (Textsw_index)xv_get (textsw, TEXTSW_LENGTH)-1;
  result1=NOTICE_YES;
  while(prompt!=2)
  {
    *first = begin;
    *lastplusone = end;
    where = textsw_find_bytes(textsw, first, lastplusone, findstring, strlen(findstring), 0);
    if (where>end) return;
    if (where<0 || where<begin)
    {
      if (begin==0) return;
      *first = begin = 0;
      *lastplusone = end = point-1;
      where = textsw_find_bytes(textsw, first, lastplusone, findstring, strlen(findstring), 0);
      if (where<0) return;
    }
      if (prompt==1)
      {
        textsw_possibly_normalize(textsw, where);
        textsw_set_selection(textsw, where, where+strlen(findstring), 1);
        if (result1==NOTICE_YES)
          result = notice_prompt(mypanel, NULL,
             XV_X,                    0,
             XV_Y,                    700,
             NOTICE_MESSAGE_STRINGS, "REPLACE THIS STRING?", NULL,
             NOTICE_BUTTON_YES,      "YES",                            
             NOTICE_BUTTON_NO,       "NO",      
             NOTICE_BUTTON,          "cancel", 101,
             NULL); 
        else
          result = notice_prompt(mypanel, NULL,
             XV_X,                    0,
             XV_Y,                    700,
             NOTICE_MESSAGE_STRINGS, "REPLACE THIS STRING?", NULL,
             NOTICE_BUTTON_NO,       "YES",                            
             NOTICE_BUTTON_YES,      "NO",      
             NOTICE_BUTTON,          "cancel", 101,
             NULL); 
        if ( (result==NOTICE_YES && result1==NOTICE_YES) || 
             (result==NOTICE_NO  && result1==NOTICE_NO ) )
        {
          textsw_replace_bytes( textsw, *first, *first+strlen(findstring), 
                                replacestring, strlen(replacestring) );
          end  += strlen(replacestring)-strlen(findstring);
          result1=NOTICE_YES;
        }
        else 
          if (result!=NOTICE_NO && result!=NOTICE_YES) 
          {
            free(findstring); 
            free(replacestring); 
            return;
          }
        else
          result1=NOTICE_NO;
      }
      else 
      {
        textsw_replace_bytes(textsw, *first, *first+strlen(findstring), replacestring, strlen(replacestring));
        end  += strlen(replacestring)-strlen(findstring);
      }
     begin = where+strlen(replacestring);
  }
  free(findstring); free(replacestring);
}

void 
Copy_string(menu, menu_item)
Menu        menu;  
Menu_item   menu_item;
{
  Copy_string2();
}

void 
Copy_string1(item)
Panel_item   item;
{
  Copy_string2();
}

void 
Copy_string2()
{
  Seln_holder   holder;
  Seln_request *response;
  server = (Xv_Server)xv_get ( xv_get(frame, XV_SCREEN), SCREEN_SERVER );
  holder = selection_inquire(server, SELN_PRIMARY);
  response = selection_ask(server, &holder,
      SELN_REQ_CONTENTS_ASCII, NULL,
      NULL);
  strcpy(copytext, response->data + sizeof (SELN_REQ_CONTENTS_ASCII) );
}

void 
Insert_string(menu, menu_item)
Menu        menu;  
Menu_item   menu_item;
{
  Insert_string2();
}

void 
Insert_string1(item)
Panel_item   item;
{
  Insert_string2();
}

void 
Insert_string2()
{
  Seln_holder   holder;
  server = (Xv_Server)xv_get ( xv_get(frame, XV_SCREEN), SCREEN_SERVER );
  holder = selection_inquire(server, SELN_PRIMARY);
  (void)selection_ask(server, &holder,
      SELN_REQ_DELETE, NULL,
      NULL);
  textsw_insert(textsw, copytext, strlen(copytext) );
}

void 
Shortwin (menu, menu_item)       
Menu menu;
Menu_item menu_item;
{
  /* Extra Button Window */
  if (addframe!=0)  return;
  addframe = (Frame)xv_create ((int)NULL, FRAME, 
       FRAME_LABEL,  "Button Menu",
       FRAME_ICON,   buttonicon,
       NULL) ;
  /* Initialize menu buttons */
  addpanel = (Panel)xv_create (addframe, PANEL, 
       PANEL_LAYOUT, PANEL_VERTICAL, 
       NULL); 
  (void)xv_create(addpanel, PANEL_MESSAGE, 
       PANEL_LABEL_STRING, "========", 
       NULL);
  (void)xv_create(addpanel, PANEL_MESSAGE, 
       PANEL_LABEL_STRING,       "File", 
       NULL);
  (void)xv_create (addpanel, PANEL_BUTTON,
       PANEL_LABEL_STRING,       "Save",
       PANEL_NOTIFY_PROC,        Save1,
       NULL);
  (void)xv_create (addpanel, PANEL_BUTTON,
       PANEL_LABEL_STRING,       "Quit",
       PANEL_NOTIFY_PROC,        Quit1,
       NULL);
       
  (void)xv_create(addpanel, PANEL_MESSAGE, 
       PANEL_LABEL_STRING, "========", 
       NULL);
  (void)xv_create(addpanel, PANEL_MESSAGE, 
       PANEL_LABEL_STRING, "Tools", 
       NULL);
  (void)xv_create (addpanel, PANEL_BUTTON,
       PANEL_LABEL_STRING,       "Line n",
       PANEL_NOTIFY_PROC,        Linenumber1,
       NULL);
  (void)xv_create (addpanel, PANEL_BUTTON,
       PANEL_LABEL_STRING,       "Find >",
       PANEL_NOTIFY_PROC,        Find1,
       PANEL_CLIENT_DATA,        0,
       NULL);
  (void)xv_create (addpanel, PANEL_BUTTON,
       PANEL_LABEL_STRING,       "Find <",
       PANEL_NOTIFY_PROC,        Find1,
       PANEL_CLIENT_DATA,        1,
       NULL);
  (void)xv_create (addpanel, PANEL_BUTTON,
       PANEL_LABEL_STRING,       "Find` >",
       PANEL_NOTIFY_PROC,        Findnext1,
       PANEL_CLIENT_DATA,        0,
       NULL);
  (void)xv_create (addpanel, PANEL_BUTTON,
       PANEL_LABEL_STRING,       "Find` <",
       PANEL_NOTIFY_PROC,        Findnext1,
       PANEL_CLIENT_DATA,        1,
       NULL);
  (void)xv_create (addpanel, PANEL_BUTTON,
       PANEL_LABEL_STRING,       "Copy",   
       PANEL_NOTIFY_PROC,        Copy_string1,
       NULL);
  (void)xv_create (addpanel, PANEL_BUTTON,
       PANEL_LABEL_STRING,       "Insert",   
       PANEL_NOTIFY_PROC,        Insert_string1,
       NULL);
 
  (void)xv_create(addpanel, PANEL_MESSAGE, 
       PANEL_LABEL_STRING, "========", 
       NULL);
  (void)xv_create(addpanel, PANEL_MESSAGE, 
       PANEL_LABEL_STRING, "Execute", 
       NULL);
  (void)xv_create (addpanel, PANEL_BUTTON,
       PANEL_LABEL_STRING,       "Compile",   
       PANEL_NOTIFY_PROC,        Compile1,
       NULL);
  (void)xv_create (addpanel, PANEL_BUTTON,
       PANEL_LABEL_STRING,       "Run Xap",   
       PANEL_NOTIFY_PROC,        RunX1,
       NULL);
  (void)xv_create (addpanel, PANEL_BUTTON,
       PANEL_LABEL_STRING,       "Run fg.",   
       PANEL_NOTIFY_PROC,        Run1,
       NULL);
  (void)xv_create (addpanel, PANEL_BUTTON,
       PANEL_LABEL_STRING,       "Break",   
       PANEL_NOTIFY_PROC,        Break1,
       NULL);
  (void)xv_create(addpanel, PANEL_MESSAGE, 
       PANEL_LABEL_STRING, "========", 
       NULL);
  (void)xv_create(addpanel, PANEL_MESSAGE, 
       PANEL_LABEL_STRING, "Buttons", 
       NULL);
  (void)xv_create (addpanel, PANEL_BUTTON,
       PANEL_LABEL_STRING,       "Close",   
       PANEL_NOTIFY_PROC,        Close,
       NULL);
  window_fit(addpanel);
  window_fit(addframe);
  xv_set(addframe, XV_SHOW, TRUE,  NULL);
}

void Close(item, event)
Panel_item  item;
Event *event;
{
  xv_destroy_safe(addframe);
  addframe=0;
}

/*void 
Fontselect (menu, menu_item)       
Menu menu;
Menu_item menu_item;
{
  * Extra Button Window *
  addframe = (Frame)xv_create ((int)NULL, FRAME, 
       FRAME_LABEL,            "Font configuration",
       NULL) ;
  * Initialize menu buttons *
  addpanel = (Panel)xv_create (addframe, PANEL, 
       PANEL_LAYOUT, PANEL_VERTICAL, 
       NULL); 
  (void)xv_create(addpanel, PANEL_MESSAGE, 
       PANEL_LABEL_STRING, "========", 
       NULL);
  (void)xv_create(addpanel, PANEL_MESSAGE, 
       PANEL_LABEL_STRING,       "File", 
       NULL);
  (void)xv_create (addpanel, PANEL_BUTTON,
       PANEL_LABEL_STRING,       "Save",
       PANEL_NOTIFY_PROC,        Save1,
       NULL);
  (void)xv_create (addpanel, PANEL_BUTTON,
       PANEL_LABEL_STRING,       "Quit",
       PANEL_NOTIFY_PROC,        Quit1,
       NULL);
  (void)xv_create (addpanel, PANEL_BUTTON,
       PANEL_LABEL_STRING,       "Close",   
       PANEL_NOTIFY_PROC,        Close,
       NULL);
  window_fit(addpanel);
  window_fit(addframe);
  xv_set(addframe, XV_SHOW, TRUE, *XV_X,  1, XV_Y, 2,*  NULL);
}*/


void select_conf(menu,menu_item)
Menu menu; 
Menu_item menu_item; 
{
  char *tempstr;
  getedittext();
  compnum=xv_get(menu_item, MENU_CLIENT_DATA);
  tempstr=malloc(sizeof(compilername_buf[compnum])+sizeof(filename)+1);
  sprintf(tempstr,"%s: <%s>",compilername_buf[compnum],filename);
  xv_set(frame, FRAME_LABEL, tempstr, NULL );
  free(tempstr);
}

void 
compname_opt(menu, menu_item)
Menu        menu;  
Menu_item   menu_item;
{
  int get_compname_opt();
  Panel_item item;
  if (opt_text>0)  { xv_destroy_safe(opt_text); opt_text=0; return; }
  opt_text = (Panel_item)xv_create (panel, PANEL_TEXT,
      XV_Y,                       8,
      PANEL_VALUE,                compilername_buf[compnum],
      PANEL_LABEL_STRING,        "COMPILER DESCRIPTION -> ",
      PANEL_NOTIFY_PROC,          get_compname_opt,
      PANEL_LAYOUT,               PANEL_HORIZONTAL,
      PANEL_VALUE_DISPLAY_LENGTH, 30,
      PANEL_VALUE_STORED_LENGTH,  256,
      NULL);
      xv_set(panel, PANEL_CARET_ITEM, opt_text, NULL);
}

int get_compname_opt(item, event)
Panel_item  item;
Event *event;
{
  (void)strncpy(compilername_buf[compnum], (char *)xv_get(item, PANEL_VALUE), sizeof compilername_buf[compnum] );
  xv_destroy_safe(opt_text);
  opt_text=0;
}

void 
comp_opt(menu, menu_item)
Menu        menu;  
Menu_item   menu_item;
{
  int get_comp_opt();
  Panel_item item;
  if (opt_text>0)  { xv_destroy_safe(opt_text); opt_text=0; return; }
  opt_text = (Panel_item)xv_create (panel, PANEL_TEXT,
      XV_Y,                       8,
      PANEL_VALUE,                compiler_buf[compnum],
      PANEL_LABEL_STRING,        "COMPILER CALL -> ",
      PANEL_NOTIFY_PROC,          get_comp_opt,
      PANEL_LAYOUT,               PANEL_HORIZONTAL,
      PANEL_VALUE_DISPLAY_LENGTH, 30,
      PANEL_VALUE_STORED_LENGTH,  256,
      NULL);
  xv_set(panel, PANEL_CARET_ITEM, opt_text, NULL);
}

int get_comp_opt(item, event)
Panel_item  item;
Event *event;
{
  (void)strncpy(compiler_buf[compnum], (char *)xv_get(item, PANEL_VALUE), sizeof compiler_buf[compnum] );
  xv_destroy_safe(opt_text);
  opt_text=0;
}

void 
srce_opt(menu, menu_item)
Menu        menu;  
Menu_item   menu_item;
{
  int get_srce_opt();
  Panel_item item;
  if (opt_text>0)  { xv_destroy_safe(opt_text); opt_text=0; return; }
  opt_text = (Panel_item)xv_create (panel, PANEL_TEXT,
      XV_Y,                       8,
      PANEL_VALUE,                source_buf[compnum],
      PANEL_LABEL_STRING,        "SOURCE FILE EXTENSION -> ",
      PANEL_NOTIFY_PROC,          get_srce_opt,
      PANEL_LAYOUT,               PANEL_HORIZONTAL,
      PANEL_VALUE_DISPLAY_LENGTH, 30,
      PANEL_VALUE_STORED_LENGTH,  256,
      NULL);
  xv_set(panel, PANEL_CARET_ITEM, opt_text, NULL);
}

int get_srce_opt(item, event)
Panel_item  item;
Event *event;
{
  (void)strncpy(source_buf[compnum], (char *)xv_get(item, PANEL_VALUE), sizeof source_buf[compnum] );
  xv_destroy_safe(opt_text);
  opt_text=0;
}

void 
exec_opt(menu, menu_item)
Menu        menu;  
Menu_item   menu_item;
{
  int get_exec_opt();
  Panel_item item;
  if (opt_text>0)  { xv_destroy_safe(opt_text); opt_text=0; return; }
  opt_text = (Panel_item)xv_create (panel, PANEL_TEXT,
      XV_Y,                       8,
      PANEL_VALUE,                exec_buf[compnum],
      PANEL_LABEL_STRING,        "TARGET FILE EXTENSION -> ",
      PANEL_NOTIFY_PROC,          get_exec_opt,
      PANEL_LAYOUT,               PANEL_HORIZONTAL,
      PANEL_VALUE_DISPLAY_LENGTH, 30,
      PANEL_VALUE_STORED_LENGTH,  256,
      NULL);
  xv_set(panel, PANEL_CARET_ITEM, opt_text, NULL);
}

int get_exec_opt(item, event)
Panel_item  item;
Event *event;
{
  (void)strncpy(exec_buf[compnum], (char *)xv_get(item, PANEL_VALUE), sizeof exec_buf[compnum] );
  xv_destroy_safe(opt_text);
  opt_text=0;
}

void 
usew_opt(menu, menu_item)
Menu        menu;  
Menu_item   menu_item;
{
  int get_usew_opt();
  Panel_item item;
  if (opt_text>0)  { xv_destroy_safe(opt_text); opt_text=0; return; }
  opt_text = (Panel_item)xv_create (panel, PANEL_TEXT,
      XV_Y,                       8,
      PANEL_VALUE,                usew_buf[compnum],
      PANEL_LABEL_STRING,        "CALL TARGET FILE WITH -> ",
      PANEL_NOTIFY_PROC,          get_usew_opt,
      PANEL_LAYOUT,               PANEL_HORIZONTAL,
      PANEL_VALUE_DISPLAY_LENGTH, 30,
      PANEL_VALUE_STORED_LENGTH,  256,
      NULL);
  xv_set(panel, PANEL_CARET_ITEM, opt_text, NULL);
}

int get_usew_opt(item, event)
Panel_item  item;
Event *event;
{
  (void)strncpy(usew_buf[compnum], (char *)xv_get(item, PANEL_VALUE), sizeof usew_buf[compnum] );
  xv_destroy_safe(opt_text);
  opt_text=0;
}

void 
tatt_opt(menu, menu_item)
Menu        menu;  
Menu_item   menu_item;
{
  int get_tatt_opt();
  Panel_item item;
  if (opt_text>0)  { xv_destroy_safe(opt_text); opt_text=0; return; }
  opt_text = (Panel_item)xv_create (panel, PANEL_TEXT,
      XV_Y,                       8,
      PANEL_VALUE,                tatt_buf[compnum],
      PANEL_LABEL_STRING,        "TARGET CALL ATTRIBUTES	 -> ",
      PANEL_NOTIFY_PROC,          get_tatt_opt,
      PANEL_LAYOUT,               PANEL_HORIZONTAL,
      PANEL_VALUE_DISPLAY_LENGTH, 30,
      PANEL_VALUE_STORED_LENGTH,  256,
      NULL);
  xv_set(panel, PANEL_CARET_ITEM, opt_text, NULL);
}

int get_tatt_opt(item, event)
Panel_item  item;
Event *event;
{
  (void)strncpy(tatt_buf[compnum], (char *)xv_get(item, PANEL_VALUE), sizeof tatt_buf[compnum] );
  xv_destroy_safe(opt_text);
  opt_text=0;
}

void 
prnt_opt(menu, menu_item)
Menu        menu;  
Menu_item   menu_item;
{
  int get_prnt_opt();
  Panel_item item;
  if (opt_text>0)  { xv_destroy_safe(opt_text); opt_text=0; return; }
  opt_text = (Panel_item)xv_create (panel, PANEL_TEXT,
      XV_Y,                       8,
      PANEL_VALUE,                printer_buf[compnum],
      PANEL_LABEL_STRING,        "PRINTER DEVICE FILE -> ",
      PANEL_NOTIFY_PROC,          get_prnt_opt,
      PANEL_LAYOUT,               PANEL_HORIZONTAL,
      PANEL_VALUE_DISPLAY_LENGTH, 30,
      PANEL_VALUE_STORED_LENGTH,  256,
      NULL);
  xv_set(panel, PANEL_CARET_ITEM, opt_text, NULL);
}

int get_prnt_opt(item, event)
Panel_item  item;
Event *event;
{
  (void)strncpy(printer_buf[compnum], (char *)xv_get(item, PANEL_VALUE), sizeof printer_buf[compnum] );
  xv_destroy_safe(opt_text);
  opt_text=0;
}

void 
form_opt(menu, menu_item)
Menu        menu;  
Menu_item   menu_item;
{
  int get_form_opt();
  Panel_item item;
  if (opt_text>0)  { xv_destroy_safe(opt_text); opt_text=0; return; }
  opt_text = (Panel_item)xv_create (panel, PANEL_TEXT,
      XV_Y,                       8,
      PANEL_VALUE,                printformat_buf[compnum],
      PANEL_LABEL_STRING,        "FORMATTED PRINT CALL -> ",
      PANEL_NOTIFY_PROC,          get_form_opt,
      PANEL_LAYOUT,               PANEL_HORIZONTAL,
      PANEL_VALUE_DISPLAY_LENGTH, 30,
      PANEL_VALUE_STORED_LENGTH,  1024,
      NULL);
  xv_set(panel, PANEL_CARET_ITEM, opt_text, NULL);
}

int get_form_opt(item, event)
Panel_item  item;
Event *event;
{
  (void)strncpy(printformat_buf[compnum], (char *)xv_get(item, PANEL_VALUE), sizeof printformat_buf[compnum] );
  xv_destroy_safe(opt_text);
  opt_text=0;
}

void 
form_odd_opt(menu, menu_item)
Menu        menu;  
Menu_item   menu_item;
{
  int get_odd_form_opt();
  Panel_item item;
  if (opt_text>0)  { xv_destroy_safe(opt_text); opt_text=0; return; }
  opt_text = (Panel_item)xv_create (panel, PANEL_TEXT,
      XV_Y,                       8,
      PANEL_VALUE,                printformat_odd_buf[compnum],
      PANEL_LABEL_STRING,        "ODD SIDES FORMATTED PRINT CALL -> ",
      PANEL_NOTIFY_PROC,          get_odd_form_opt,
      PANEL_LAYOUT,               PANEL_HORIZONTAL,
      PANEL_VALUE_DISPLAY_LENGTH, 30,
      PANEL_VALUE_STORED_LENGTH,  1024,
      NULL);
}

int get_odd_form_opt(item, event)
Panel_item  item;
Event *event;
{
  (void)strncpy(printformat_odd_buf[compnum], (char *)xv_get(item, PANEL_VALUE), sizeof printformat_odd_buf[compnum] );
  xv_destroy_safe(opt_text);
  opt_text=0;
}

void 
form_even_opt(menu, menu_item)
Menu        menu;  
Menu_item   menu_item;
{
  int get_even_form_opt();
  Panel_item item;
  if (opt_text>0)  { xv_destroy_safe(opt_text); opt_text=0; return; }
  opt_text = (Panel_item)xv_create (panel, PANEL_TEXT,
      XV_Y,                       8,
      PANEL_VALUE,                printformat_even_buf[compnum],
      PANEL_LABEL_STRING,        "EVEN SIDES FORMATTED PRINT CALL -> ",
      PANEL_NOTIFY_PROC,          get_even_form_opt,
      PANEL_LAYOUT,               PANEL_HORIZONTAL,
      PANEL_VALUE_DISPLAY_LENGTH, 30,
      PANEL_VALUE_STORED_LENGTH,  1024,
      NULL);
  xv_set(panel, PANEL_CARET_ITEM, opt_text, NULL);
}

int get_even_form_opt(item, event)
Panel_item  item;
Event *event;
{
  (void)strncpy(printformat_even_buf[compnum], (char *)xv_get(item, PANEL_VALUE), sizeof printformat_even_buf[compnum] );
  xv_destroy_safe(opt_text);
  opt_text=0;
}

void 
preformat_print_opt(menu, menu_item)
Menu        menu;  
Menu_item   menu_item;
{
  int get_preformat_print_opt();
  Panel_item item;
  if (opt_text>0)  { xv_destroy_safe(opt_text); opt_text=0; return; }
  opt_text = (Panel_item)xv_create (panel, PANEL_TEXT,
      XV_Y,                       8,
      PANEL_VALUE,                preformat_print_buf[compnum],
      PANEL_LABEL_STRING,        "PREFORMATTED FILE PRINT CALL -> ",
      PANEL_NOTIFY_PROC,          get_preformat_print_opt,
      PANEL_LAYOUT,               PANEL_HORIZONTAL,
      PANEL_VALUE_DISPLAY_LENGTH, 30,
      PANEL_VALUE_STORED_LENGTH,  1024,
      NULL);
  xv_set(panel, PANEL_CARET_ITEM, opt_text, NULL);
}

int get_preformat_print_opt(item, event)
Panel_item  item;
Event *event;
{
  (void)strncpy(preformat_print_buf[compnum], (char *)xv_get(item, PANEL_VALUE), sizeof preformat_print_buf[compnum] );
  xv_destroy_safe(opt_text);
  opt_text=0;
}

void 
errmess_opt(menu, menu_item)
Menu        menu;  
Menu_item   menu_item;
{
  int get_errmess_opt();
  Panel_item item;
  if (opt_text>0)  { xv_destroy_safe(opt_text); opt_text=0; return; }
  opt_text = (Panel_item)xv_create (panel, PANEL_TEXT,
      XV_Y,                       8,
      PANEL_VALUE,                errmess_buf[compnum],
      PANEL_LABEL_STRING,        "ERROR MESSAGES FORM -> ",
      PANEL_NOTIFY_PROC,          get_errmess_opt,
      PANEL_LAYOUT,               PANEL_HORIZONTAL,
      PANEL_VALUE_DISPLAY_LENGTH, 30,
      PANEL_VALUE_STORED_LENGTH,  1024,
      NULL);
  xv_set(panel, PANEL_CARET_ITEM, opt_text, NULL);
}

int get_errmess_opt(item, event)
Panel_item  item;
Event *event;
{
  (void)strncpy(errmess_buf[compnum], (char *)xv_get(item, PANEL_VALUE), sizeof errmess_buf[compnum] );
  xv_destroy_safe(opt_text);
  opt_text=0;
}

void 
terminate_opt(menu, menu_item)
Menu        menu;  
Menu_item   menu_item;
{
  int get_terminate_opt();
  Panel_item item;
  if (opt_text>0)  { xv_destroy_safe(opt_text); opt_text=0; return; }
  opt_text = (Panel_item)xv_create (panel, PANEL_TEXT,
      XV_Y,                       8,
      PANEL_VALUE,                terminate_buf[compnum],
      PANEL_LABEL_STRING,        "COMPILER DOES ALWAYS TERMINATE -> ",
      PANEL_NOTIFY_PROC,          get_terminate_opt,
      PANEL_LAYOUT,               PANEL_HORIZONTAL,
      PANEL_VALUE_DISPLAY_LENGTH, 30,
      PANEL_VALUE_STORED_LENGTH,  1024,
      NULL);
  xv_set(panel, PANEL_CARET_ITEM, opt_text, NULL);
}

int get_terminate_opt(item, event)
Panel_item  item;
Event *event;
{
  (void)strncpy(terminate_buf[compnum], (char *)xv_get(item, PANEL_VALUE), sizeof terminate_buf[compnum] );
  xv_destroy_safe(opt_text);
  opt_text=0;
}

/* the next few functions are being used by compiler call */
Notify_value
get_results(client, fd)
Notify_client   client;
register int fd;
{
  char buf[BUFSIZ];
  int bytes, i, j;
  if (ioctl(fd, FIONREAD, &bytes) == 0)
    while (bytes > 0) {
      if ((i = read(fd, buf, sizeof buf)) > 0)
      {
        comp_results[result_counter] = strncpy(malloc(i+1), buf, i);
        sprintf(comp_results[result_counter++]+i, "\0");
        for(j=0; j<i; j++)
          if  ((char)*(comp_results[result_counter-1]+j)<31 && 
              !(char)*(comp_results[result_counter-1]+j)==10)
            sprintf(comp_results[result_counter-1]+j, " ");
        if (reports)
          printf("::xwb compiler signal: %s", comp_results[result_counter-1]);
        bytes -= i;
      }
    }
  return NOTIFY_DONE;
}

Notify_value
sigchldcatcher(client, pid, status, rusage)
Notify_client client; /* the client noted in main() */
int pid; /* the pid that died */
#ifdef SVR4
int *status;
#else
union wait *status; /* the status of the process (unused here) */
#endif
struct rusage *rusage; /* resources used by this process (unused) */
{
  int a,b;
  if (WIFEXITED(*status)) {
    printf("Process termined with status %d\n", 
/*#ifdef SVR4
      *status
#else*/
      status->w_retcode
/*#endif*/
      );
    /* unregister input func with appropriate file descriptor */
    notify_set_input_func(client, NOTIFY_FUNC_NULL, (client == client1)? pipe_input[0] : 0);    
    for (a=1, b=0; a<result_counter; a++)
      b+=strlen(comp_results[a]);
    comp_results[0]=malloc(b+1);
    b=0;
    for (a=1; a<result_counter; a++)
    {
      strcpy(comp_results[0]+b,comp_results[a]);
      b+=strlen(comp_results[a]);
      free(comp_results[a]);
    }  
    xv_set(resulttext, PANEL_VALUE, comp_results[0], NULL);
    xv_set(results_message, PANEL_LABEL_STRING, "!!! Finished !!!", NULL);
    compilerrunning=0;
    return NOTIFY_DONE;    
  }
  puts("SIGCHLD not handled");
  return NOTIFY_IGNORED;
}

int my_compare(a, b)
char *a;
char *b;
{
  int n=0;
  while( (char)(*(a+n))!='\0' &&
         (char)(*(a+n)) == (char)(*(b+n)) )
    if( (char)(*(b+n))=='\0' ) return 0;
    else n++;
  return 1;
}

int to_next_error(item, event)
Panel_item  item;
Event *event;
{
/*  char *error_section, xx[16];
  unsigned long i, errms_pt, l, line, oldline, go_on, prev_errpt;  

  if ( (char)*(comp_results[0]+errpt)=='\0' ) return;
  if ( errpt==0 )
    xv_set(results_message, PANEL_LABEL_STRING, "--- first message ---", NULL);

  line=oldline=0; go_on=1; prev_errpt=errpt; errms_pt=0;
  l=strlen(file_directory)+1;
  errms_pt=0;
  while (go_on)
  {
    i=0;
    oldline=line;
    if ( errmess_buf[compnum][errms_pt]=='\0')
    {
      errms_pt=0;
      while( (char)*(comp_results[0]+errpt)!='\n')
        if( (char)*(comp_results[0]+errpt)!='\0' )
          errpt++;
        else go_on=0;
    }
    if ( (char)*(comp_results[0]+errpt)=='\0' )  
      go_on=0;
    else
      if ( errmess_buf[compnum][errms_pt]=='*' )
        if (my_compare(filenamep+l, (char)*(comp_results[0]+errpt))) 
          errpt+=strlen(filenamep+l);
        else
        {
          while ( (char)*(errmess_buf[0]+errpt)!='\n' && 
                  (char)*(errmess_buf[0]+errpt)!='\0' )   errpt++;
          errms_pt=0;
        }
      else
        if ( errmess_buf[compnum][errms_pt]=='#' )
        {
          while( (char)*(comp_results[0]+errpt)>47 &&
                 (char)*(comp_results[0]+errpt)<58 )
            xx[i++] = (char)*(comp_results[0]+(errpt++));   * incrementation correct? *
          xx[i]='\0';
          line = atol(xx);
          if (line!=0 && oldline!=0 && line!=oldline) go_on=0;
printf(" +line%s, %d+ ",(errmess_buf[0]+errpt), line); 
        }
        else
          if ( (char)*(comp_results[0]+errpt) == errmess_buf[compnum][errms_pt] )
          { errpt++; errms_pt++; }
          else
            while( (char)*(comp_results[0]+errpt)!="\n" && (char)*(comp_results[0]+errpt)!="\0" )
              {errpt++; errms_pt =0 }
printf("[%d, %d]", errms_pt, errpt); 
    errms_pt++;
if (errpt>300) go_on=0;
  }
  error_section = strncpy( malloc(errpt-prev_errpt)+1, comp_results[0]+prev_errpt, errpt-prev_errpt);
  sprintf(error_section+errpt, "\0");
  printf("\n{[%s], %d}\n", error_section, errpt-prev_errpt);
  xv_set(resulttext, PANEL_VALUE, error_section, NULL);
  
  if ( (char)*(comp_results[0]+errpt)=='\0' )
    xv_set(results_message, PANEL_LABEL_STRING, "--- last message ---", NULL);
*/
}

int to_last_error(item, event)
Panel_item  item;
Event *event;
{
}

int exitresults(item, event)
Panel_item  item;
Event *event;
{
  if (compilerrunning==1) return;
  xv_destroy_safe(resultframe);
  resultframe=0;
  if (comp_results[0]!=NULL)
    free (comp_results[0]);
  comp_results[0]=NULL;
}

void 
Compile(menu, menu_item)
Menu        menu;  
Menu_item   menu_item;
{
  Compile2(); 
}

void 
Compile1(item)
Panel_item   item;
{
  Compile2();
}

void 
Compile2()
{
  int pid,l,i,j,k,a,b,c,d,e;
  char *childparam[256];
  char temp[4096];
  Panel mypanel;
  if (compilerrunning) return;
  getedittext();
  l=strlen(file_directory)+1;
  if (!strcmp(filenamep, ""))
  {
    Panel mypanel = (Panel) xv_get (panel, PANEL_PARENT_PANEL);
    notice_prompt(mypanel, NULL,
        NOTICE_MESSAGE_STRINGS, " No file is being edited ",
        NULL,
        NOTICE_BUTTON_YES,      " Open file ",
        NULL);
    Filechooseropen();
    return;
  }
  if (strcmp(file_directory,working_directory))
  {
    Panel mypanel = (Panel) xv_get (panel, PANEL_PARENT_PANEL);
    notice_prompt(mypanel, NULL,
        NOTICE_MESSAGE_STRINGS, " Could not start to compile because: ",
                                " directory of edited file is "
                                " different from working directory ",
        NULL,
        NOTICE_BUTTON_YES,      " Change path ",
        NULL);
    Filechooseropen();
    return;
  }

  Saved_notify(panel);

  if (terminate_buf[compnum][0]!='y')
  {
      Printformat_function(strcpy (malloc(sizeof(compiler_buf[compnum])+1),compiler_buf[compnum]));
    return;
  }

  for(i=j=0; compiler_buf[compnum][i]!='\0' && j<4096; i++)
    if ((int)compiler_buf[compnum][i]!=92 && compiler_buf[compnum][i]!='*')
      temp[j++]=compiler_buf[compnum][i];
    else
      /* return not available */
      /*if ((int)compiler_buf[compnum][i]==92 && compiler_buf[compnum][i+1]=='n')
      { 
        temp[j++]='\n';
        i++;
      }
      else*/ 
        if (compiler_buf[compnum][i]=='*')
        { 
          strncpy(temp+j, (char *)(filename), strlen(filename)-strlen(source_buf[compnum]));
          j+=strlen(filename)-strlen(source_buf[compnum]);
        }
  temp[j++]='\0';
  

  result_counter = 1;
  pipe (pipe_input);

  switch( pid=fork())
  { 
    case -1: 
      printf("Sorry, could not fork a new process, using terminal subwindow");
      close(pipe_input[0]);
      close(pipe_input[1]);
      Printformat_function(strcpy (malloc(sizeof(compiler_buf[compnum])+1),compiler_buf[compnum]));
      return;
      
    case 0:
      dup2(pipe_input[1], 1);
      dup2(pipe_input[1], 2);  

      for (k=j=i=0; i<strlen(temp)+1; i++)
      {
        if (*(temp+i)==' ' || *(temp+i)=='\0')
        {
          childparam[k] = malloc(i-j+1);
          strncpy(childparam[k], temp+j, i-j);
          sprintf(childparam[k++]+i-j, "\0") ;
          j=i+1;
        }
      }
      childparam[k]=NULL;

      for (i = getdtablesize(); i > 2; i--)
          (void) close(i);
      for (i = 0; i < NSIG; i++)
          (void) signal(i, SIG_DFL);
      execvp(*childparam,childparam);
          printf(" {%s, %s} ",*childparam,childparam);
      if (errno == ENOENT)
        printf("'%s' not found", *childparam);
      else
        perror(*childparam);
      perror("execvp");
      _exit(-1);
      
    default:
      close(pipe_input[1]);
  }
  notify_set_input_func(client1, get_results, pipe_input[0]);
  notify_set_wait3_func(client1, sigchldcatcher, pid);
  
  notify_start();
  
  /* Creating of resultframe */
  if (resultframe==0)
  {
    resultframe = (Frame)xv_create ((int)NULL, FRAME, 
         FRAME_LABEL,     "Compiler Results",
         FRAME_ICON,      compilericon,
         NULL);
    resultpanel = (Panel)xv_create(resultframe, PANEL, NULL);
    resulttext = (Textsw)xv_create(resultpanel, PANEL_MULTILINE_TEXT,
         PANEL_VALUE_STORED_LENGTH,  10000,
         PANEL_DISPLAY_ROWS,         9,
         PANEL_VALUE_DISPLAY_LENGTH, 88,
         NULL);
    xv_set(resultpanel, PANEL_LAYOUT, PANEL_HORIZONTAL, NULL);
    results_message = xv_create(resultpanel, PANEL_MESSAGE, 
         PANEL_LABEL_STRING, "*** Compiling ***", 
         NULL);
    window_fit(resultpanel);
    resultpanel1 = (Panel)xv_create(resultframe, PANEL,
         XV_WIDTH,        xv_get(resulttext, XV_WIDTH),
         NULL);
    xv_set(resultpanel1, PANEL_LAYOUT, PANEL_HORIZONTAL, NULL);
    (void)xv_create (resultpanel1, PANEL_BUTTON,
         PANEL_LABEL_STRING,       "------->",
         PANEL_NOTIFY_PROC,          to_next_error,
         NULL);  
    (void)xv_create (resultpanel1, PANEL_BUTTON,
         PANEL_LABEL_STRING,       " First ",
         /*PANEL_NOTIFY_PROC,          to_next_error,*/ 
         NULL);  
    xv_set(resultpanel1, PANEL_LAYOUT, PANEL_VERTICAL, NULL);
    (void)xv_create (resultpanel1, PANEL_BUTTON,
         PANEL_LABEL_STRING,       "<-------",
         PANEL_NOTIFY_PROC,          to_last_error,
         NULL);  
    xv_set(resultpanel1, PANEL_LAYOUT, PANEL_HORIZONTAL, NULL);
    (void)xv_create (resultpanel1, PANEL_BUTTON,
         PANEL_LABEL_STRING,       " Last ",
         /*PANEL_NOTIFY_PROC,          exitresults,*/
         NULL);  
    xv_set(resultpanel1, PANEL_LAYOUT, PANEL_VERTICAL, NULL);
    (void)xv_create (resultpanel1, PANEL_BUTTON,
         PANEL_LABEL_STRING,       "Run Xap",
         PANEL_NOTIFY_PROC,          RunX1,
         NULL);  
    xv_set(resultpanel1, PANEL_LAYOUT, PANEL_HORIZONTAL, NULL);
    (void)xv_create (resultpanel1, PANEL_BUTTON,
         PANEL_LABEL_STRING,       "Run fg.",
         PANEL_NOTIFY_PROC,          Run1,
         NULL);  
    xv_set(resultpanel1, PANEL_LAYOUT, PANEL_VERTICAL, NULL);
    (void)xv_create (resultpanel1, PANEL_BUTTON,
         PANEL_LABEL_STRING,       "Compile",
         PANEL_NOTIFY_PROC,        Compile1,
         NULL);  
    xv_set(resultpanel1, PANEL_LAYOUT, PANEL_HORIZONTAL, NULL);
    (void)xv_create (resultpanel1, PANEL_BUTTON,
         PANEL_LABEL_STRING,       " Close ",
         PANEL_NOTIFY_PROC,          exitresults,
         NULL);  
    window_fit(resultpanel1);
    xv_set(resultpanel1, XV_HEIGHT, xv_get(resultpanel, XV_HEIGHT), NULL);
    window_fit(resultframe);
    xv_set(resultframe, XV_SHOW, TRUE, NULL);
  }
  else
    xv_set(results_message, 
           PANEL_LABEL_STRING, "*** Compiling ***", 
           NULL);
  compilerrunning=1;
  errpt=0;
  xv_set(resulttext, PANEL_VALUE, temp, NULL);
  free(comp_results[0]);              
/*free(temp);*/
}

void 
RunX(menu, menu_item)
Menu        menu;  
Menu_item   menu_item;
{
RunX2();
}

void 
RunX1(item)
Panel_item   item;
{
RunX2();
}

void 
RunX2()
{
  int l=strlen(file_directory)+1;
  if (strcmp(file_directory,working_directory))
  {
    Panel mypanel = (Panel) xv_get (panel, PANEL_PARENT_PANEL);
    notice_prompt(mypanel, NULL,
        NOTICE_MESSAGE_STRINGS, " The directory of the edited file must ",
                                "   be identical with the current one   ",
        NULL,
        NOTICE_BUTTON_YES,      " Change path in Open menu ",
        NULL);
    Filechooseropen();
    return;
  }
  getedittext();            
  ttysw_input (tty, usew_buf[compnum],  strlen(usew_buf[compnum]) );
  ttysw_input (tty, " ", 1);
  ttysw_input (tty, filename, strlen(filename)-strlen(source_buf[compnum]));
  ttysw_input (tty, exec_buf[compnum], strlen(exec_buf[compnum]));
  ttysw_input (tty, " ", 1);
  ttysw_input (tty, tatt_buf[compnum], strlen(tatt_buf[compnum]));
  ttysw_input (tty, " &\n", strlen(" &\n") );
}

void 
Run(menu, menu_item)
Menu        menu;  
Menu_item   menu_item;
{
  Run2();
}

void 
Run1(item)
Panel_item   item;
{
  Run2();
}

void 
Run2()
{
  int l=strlen(file_directory)+1;
  if (strcmp(file_directory,working_directory))
  {
    Panel mypanel = (Panel) xv_get (panel, PANEL_PARENT_PANEL);
    notice_prompt(mypanel, NULL,
        NOTICE_MESSAGE_STRINGS, " The directory of the edited file must ",
                                "   be identical with the current one   ",
        NULL,
        NOTICE_BUTTON_YES,      " Change path in Open menu ",
        NULL);
    Filechooseropen();
    return;
  }
  getedittext();
  ttysw_input (tty, usew_buf[compnum],  strlen(usew_buf[compnum]) );
  ttysw_input (tty, " ", 1);
  ttysw_input (tty, filename, strlen(filename)-strlen(source_buf[compnum]));
  ttysw_input (tty, exec_buf[compnum], strlen(exec_buf[compnum]));
  ttysw_input (tty, " ", 1);
  ttysw_input (tty,  tatt_buf[compnum], strlen(tatt_buf[compnum]));
  ttysw_input (tty, "\n", strlen("\n") );
}

void 
Break(menu, menu_item)
Menu        menu;  
Menu_item   menu_item;
{
  Break2();
}

void 
Break1(item)
Panel_item   item;
{
  Break2();
}

void 
Break2()
{
  getedittext();
  ttysw_input (tty, "", 1);
  /*notify_post_destroy(client1, DESTROY_CHECKING, NOTIFY_SAFE);*/
}

void 
Helpabout (menu, menu_item)       
Menu menu;
Menu_item menu_item;
{ 
  Panel mypanel;
  int exithelp();
  if (helpframe!=0)  return;
  helpframe = (Frame)xv_create ((int)NULL, FRAME, 
    FRAME_LABEL,     "Help: About this Workbench",
  NULL);
  mypanel = (Panel)xv_create(helpframe, PANEL,
       NULL);
  helptext = (Textsw)xv_create(mypanel, PANEL_MULTILINE_TEXT,
    PANEL_DISPLAY_ROWS, 25,
    PANEL_VALUE_DISPLAY_LENGTH, 72,
    PANEL_VALUE, help_buf[0],
  NULL);
  xv_set(mypanel, XV_SHOW, TRUE, NULL);
  (void)xv_create (mypanel, PANEL_BUTTON,
    PANEL_LABEL_STRING,       "Close",
    PANEL_NOTIFY_PROC,          exithelp,
  NULL);  
  window_fit(helptext);
  window_fit(mypanel);
  window_fit(helpframe);
  xv_set(helpframe, XV_SHOW, TRUE, NULL);
}

void 
Helpquick (menu, menu_item)       
Menu menu;
Menu_item menu_item;
{
  Panel mypanel;
  int exithelp();
  if (helpframe!=0)  return;
  helpframe = (Frame)xv_create ((int)NULL, FRAME, 
    FRAME_LABEL,    "Help: Quick Description" ,
  NULL);
  mypanel = (Panel)xv_create(helpframe, PANEL,
       NULL);
  helptext = (Textsw)xv_create(mypanel, PANEL_MULTILINE_TEXT,
    PANEL_DISPLAY_ROWS, 25,
    PANEL_VALUE_DISPLAY_LENGTH, 72,
    PANEL_VALUE, help_buf[1],
  NULL);
  xv_set(mypanel, XV_SHOW, TRUE, NULL);
  (void)xv_create (mypanel, PANEL_BUTTON,
    PANEL_LABEL_STRING,       "Close",
    PANEL_NOTIFY_PROC,          exithelp,
  NULL);
  window_fit(mypanel);
  window_fit(helpframe);
  xv_set(helpframe, XV_SHOW, TRUE, NULL);
}

void 
Helpdetail (menu, menu_item)       
Menu menu;
Menu_item menu_item;
{
  Panel mypanel;
  int exithelp();
  if (helpframe!=0)  return;
  helpframe = (Frame)xv_create ((int)NULL, FRAME, 
    FRAME_LABEL,     "Help: Summary",
  NULL);
  mypanel = (Panel)xv_create(helpframe, PANEL,
       NULL);
  helptext = (Textsw)xv_create(mypanel, PANEL_MULTILINE_TEXT,
    PANEL_DISPLAY_ROWS, 25,
    PANEL_VALUE_DISPLAY_LENGTH, 72,
    PANEL_VALUE, help_buf[2],
  NULL);
  xv_set(mypanel, XV_SHOW, TRUE, NULL);
  (void)xv_create (mypanel, PANEL_BUTTON,
    PANEL_LABEL_STRING,       "Close",
    PANEL_NOTIFY_PROC,          exithelp,
  NULL);
  window_fit(mypanel);
  window_fit(helpframe);
  xv_set(helpframe, XV_SHOW, TRUE, NULL);
}

int exithelp(item, event)
Panel_item  item;
Event *event;
{
  xv_destroy_safe(helpframe);
  helpframe=0;
}

void
initcolor (cms_data, red, green, blue)
Xv_cmsdata *cms_data;
unsigned char *red, *green, *blue;
{
  red[0] = 255 ;    green[0] = 255 ;    blue[0] = 255 ;   /* white      */
  red[1] = 255 ;    green[1] =  0  ;    blue[1] =  0  ;   /* red        */
  red[2] =  0  ;    green[2] = 255 ;    blue[2] =  0  ;   /* green      */
  red[3] =  0  ;    green[3] =  0  ;    blue[3] = 255 ;   /* blue       */
  red[4] = 255 ;    green[4] = 255 ;    blue[4] =  0  ;   /* yellow     */
  red[5] = 188 ;    green[5] = 143 ;    blue[5] = 143 ;   /* brown      */
  red[6] = 220 ;    green[6] = 220 ;    blue[6] = 220 ;   /* gray       */
  red[7] =  0  ;    green[7] =  0  ;    blue[7] =  0  ;   /* black      */
  red[8] = 255 ;    green[8] = 128 ;    blue[8] =  0  ;   /* orange     */
  red[9] =  0  ;    green[9] = 128 ;    blue[9] =  0  ;   /* mid_green  */
  red[10] = 128 ;   green[10] =  0  ;   blue[10] =  0  ;  /* mid_red    */
  red[11] =  0  ;   green[11] =  0  ;   blue[11] = 128 ;  /* mid_blue   */
  red[12] = 96  ;   green[12] =  0  ;   blue[12] = 128  ; /* violet     */
  red[13] =  0  ;   green[13] = 64  ;   blue[13] =  0  ;  /* dark_green */
  red[14] = 64  ;   green[14] =  0  ;   blue[14] =  0  ;  /* dark_red   */
  red[15] =  0  ;   green[15] =  0  ;   blue[15] = 64  ;  /* dark_blue  */

  cms_data->type      = XV_STATIC_CMS ;
  cms_data->size      = NUM_COLORS ;
  cms_data->rgb_count = NUM_COLORS ;
  cms_data->index     = 0 ;
  cms_data->red       = red ;
  cms_data->green     = green ;
  cms_data->blue      = blue ;
}



void
configurate(thisfile)
char *thisfile;
{
  FILE *fp;
  char xx[16000];
  char configfile[256];
  int  i,j;
  xx[0]=' ';
  strncpy(configfile, thisfile, strlen(thisfile));
  strncpy(configfile+strlen(thisfile),".config",strlen(".config"));
  if(!(fp = fopen(configfile,"r")))
  {
    strncpy(configfile, "xwb.config", 10);
    if(!(fp = fopen(configfile,"r")))
      { printf("Error: Configuration file '%s.config' / 'xwb.config' not found\n", thisfile); return; }
  }
  
  while(xx[0]!='#')
    if(read(fileno(fp), xx, 1)==0) return;
  if(read(fileno(fp), xx, 1)==0) return;
  i=0;
  while((int)xx[i]<58 && (int)xx[i]>47)
    if(read(fileno(fp), xx+(++i), 1)==0) return;
  textsw_buf_size=atol(xx);
  
  while(xx[0]!='#')
    if(read(fileno(fp), xx, 1)==0) return;
  if(read(fileno(fp), xx, 1)==0) return;
  i=0;
  while((int)xx[i]<58 && (int)xx[i]>47)
    if(read(fileno(fp), xx+(++i), 1)==0) return;
  textsw_proj_buf_size=atol(xx);
  
  while(xx[0]!='#')
    if(read(fileno(fp), xx, 1)==0) return;
  if(read(fileno(fp), xx, 1)==0) return;
  i=0;
  while((int)xx[i]<58 && (int)xx[i]>47)
    if(read(fileno(fp), xx+(++i), 1)==0) return;
  projitems=atol(xx);
  
  while(xx[0]!='#')
    if(read(fileno(fp), xx, 1)==0) return;
  if(read(fileno(fp), xx, 1)==0) return;
  i=0;
  while((int)xx[i]<58 && (int)xx[i]>47)
    if(read(fileno(fp), xx+(++i), 1)==0) return;
  horizontalsize=atol(xx);
  if(read(fileno(fp), xx, 1)==0) return;
  verticalsize=atol(xx);

  while(xx[0]!='#')
    if(read(fileno(fp), xx, 1)==0) return;
  if(read(fileno(fp), xx, 1)==0) return;
  i=0;
  while((int)xx[i]<58 && (int)xx[i]>47)
    if(read(fileno(fp), xx+(++i), 1)==0) return;
  projhorizontalsize=atol(xx);
  if(read(fileno(fp), xx, 1)==0) return;
  projverticalsize=atol(xx);

  while(xx[0]!='#')
    if(read(fileno(fp), xx, 1)==0) return;
  if(read(fileno(fp), xx, 1)==0) return;
  i=0;
  while(xx[i]!='\0' && xx[i]!='\n')
    if(read(fileno(fp), xx+(++i), 1)==0) return;
  xx[i]='\0';
  spec_font=strcpy(malloc(strlen(xx)+1), xx);

  while(xx[0]!='#')
    if(read(fileno(fp), xx, 1)==0) return;
  if(read(fileno(fp), xx, 1)==0) return;
  i=0;
  while(xx[i]!='\0' && xx[i]!='\n')
    if(read(fileno(fp), xx+(++i), 1)==0) return;
  xx[i]='\0';
  reports = ( (char)(*xx)=='y' ? 1 : 0);
            


  while(xx[0]!='@')
    if(read(fileno(fp), xx, 1)==0) return;
  if(read(fileno(fp), xx, 1)==0) return;
  
  /* Reading configuration file and initialising compiler options */
  for(i=0; i<16; i++)
  {
    while(xx[0]!='{' && xx[0]!='@')
    {  if(xx[0]=='@') break;   if(read(fileno(fp), xx, 1)==0) return;  }
    while(xx[0]!='\n')
      if(read(fileno(fp), xx, 1)==0) return;
      
    j=0;
    while(j==0 || xx[j-1]!='\n')
      { if(read(fileno(fp), xx+j, 1)==0) return;  j++; }
    xx[j-1]='\0';
    strncpy (compilername_buf[i], xx, strlen(xx)) ;
    
    j=0;
    while(j==0 || xx[j-1]!='\n')
      { if(read(fileno(fp), xx+j, 1)==0) return;  j++; }
    xx[j-1]='\0';
    strncpy (compiler_buf[i]    , xx, strlen(xx)) ;
    
/*    j=0;
    while(j==0 || xx[j-1]!='\n')
      { if(read(fileno(fp), xx+j, 1)==0) return;  j++; }
    xx[j-1]='\0';
    strncpy (linker_buf[i]      , xx, strlen(xx) ) ;
    
    j=0;
    while(j==0 || xx[j-1]!='\n')
      { if(read(fileno(fp), xx+j, 1)==0) return;  j++; }
    xx[j-1]='\0';
    strncpy (attributes_buf[i]      , xx, strlen(xx) ) ;*/
    
    j=0;
    while(j==0 || xx[j-1]!='\n')
      { if(read(fileno(fp), xx+j, 1)==0) return;  j++; }
    xx[j-1]='\0';
    strncpy (source_buf[i]      , xx, strlen(xx) ) ;
    
    j=0;
    while(j==0 || xx[j-1]!='\n')
      { if(read(fileno(fp), xx+j, 1)==0) return;  j++; }
    xx[j-1]='\0';
    strncpy (exec_buf[i]      , xx, strlen(xx) ) ;
      
    j=0;
    while(j==0 || xx[j-1]!='\n')
      { if(read(fileno(fp), xx+j, 1)==0) return;  j++; }
    xx[j-1]='\0';
    strncpy (usew_buf[i]      , xx, strlen(xx) ) ;
    
    j=0;
    while(j==0 || xx[j-1]!='\n')
      { if(read(fileno(fp), xx+j, 1)==0) return;  j++; }
    xx[j-1]='\0';
    strncpy (printer_buf[i]      , xx, strlen(xx) ) ;
    
    j=0;
    while(j==0 || xx[j-1]!='\n')
      { if(read(fileno(fp), xx+j, 1)==0) return;  j++; }
    xx[j-1]='\0';
    strncpy (printformat_buf[i]      , xx, strlen(xx) ) ;
    
    j=0;
    while(j==0 || xx[j-1]!='\n')
      { if(read(fileno(fp), xx+j, 1)==0) return;  j++; }
    xx[j-1]='\0';
    strncpy (printformat_odd_buf[i]      , xx, strlen(xx) ) ;
    
    j=0;
    while(j==0 || xx[j-1]!='\n')
      { if(read(fileno(fp), xx+j, 1)==0) return;  j++; }
    xx[j-1]='\0';
    strncpy (printformat_even_buf[i]      , xx, strlen(xx) ) ;
        
    j=0;
    while(j==0 || xx[j-1]!='\n')
      { if(read(fileno(fp), xx+j, 1)==0) return;  j++; }
    xx[j-1]='\0';
    strncpy (preformat_print_buf[i]      , xx, strlen(xx) ) ;
        
    j=0;
    while(j==0 || xx[j-1]!='\n')
      { if(read(fileno(fp), xx+j, 1)==0) return;  j++; }
    xx[j-1]='\0';
    strncpy (errmess_buf[i]      , xx, strlen(xx) ) ;
    
    j=0;
    while(j==0 || xx[j-1]!='\n')
      { if(read(fileno(fp), xx+j, 1)==0) return;  j++; }
    xx[j-1]='\0';
    strncpy (terminate_buf[i]      , xx, strlen(xx) ) ;
    
    while(xx[0]!='}')
      if(read(fileno(fp), xx, 1)==0) return;
  }
  while(xx[0]!='@')
    if(read(fileno(fp), xx, 1)==0) return;
    
  /* Reading help text from configuration file */
  if(read(fileno(fp), xx, 1)==0) return;
  while(xx[0]!='{' && xx[0]!='@')
  {  if(xx[0]=='@') break;   if(read(fileno(fp), xx, 1)==0) return;  }  
  while(xx[0]!='{')
    if(read(fileno(fp), xx, 1)==0) return;
  while(xx[0]!='\n')
    if(read(fileno(fp), xx, 1)==0) return;
    
  j=0;
  while(j==0 || xx[j-1]!='}')
    { if(read(fileno(fp), xx+j, 1)==0) return;  j++; }
  xx[j-1]='\0';
  strncpy (help_buf[0], xx, strlen(xx)) ;
    
  while(xx[0]!='{' && xx[0]!='@')
  {  if(xx[0]=='@') break;   if(read(fileno(fp), xx, 1)==0) return;  }
  while(xx[0]!='{')
    if(read(fileno(fp), xx, 1)==0) return;
  while(xx[0]!='\n')
    if(read(fileno(fp), xx, 1)==0) return;
    
  j=0;
  while(j==0 || xx[j-1]!='}')
    { if(read(fileno(fp), xx+j, 1)==0) return;  j++; }
  xx[j-1]='\0';
  strncpy (help_buf[1], xx, strlen(xx)) ;
  
  while(xx[0]!='{' && xx[0]!='@')
  {  if(xx[0]=='@') break;   if(read(fileno(fp), xx, 1)==0) return;  }
  while(xx[0]!='{')
    if(read(fileno(fp), xx, 1)==0) return;
  while(xx[0]!='\n')
    if(read(fileno(fp), xx, 1)==0) return;
    
  j=0;
  while(j==0 || xx[j-1]!='}')
    { if(read(fileno(fp), xx+j, 1)==0) return;  j++; }
  xx[j-1]='\0';
  strncpy (help_buf[2], xx, strlen(xx)) ;
  
  /*while(xx[0]!='{' && xx[0]!='@')
  {  if(xx[0]=='@') break;   if(read(fileno(fp), xx, 1)==0) return;  }
  while(xx[0]!='{')
    if(read(fileno(fp), xx, 1)==0) return;
  while(xx[0]!='\n')
    if(read(fileno(fp), xx, 1)==0) return;

  j=0;
  while(j==0 || xx[j-1]!='}')
    { if(read(fileno(fp), xx+j, 1)==0) return;  j++; }
  xx[j-1]='\0';
  strncpy (help_buf[3], xx, strlen(xx)) ;
  close((int)fp);*/
}

void
piccanvas_repaint(canvas, pw, display, xid, xrects)
Canvas        canvas;
Xv_Window     pw;
Display      *display;
Window        xid;
Xv_xrectlist *xrects;
{
  float m = (float) (xv_get(frame, XV_WIDTH)-50) / 1000. ;
  XSetForeground(display, gc, colors[10]);
  XFillArc(display, xid, gc, -10.*m, 15.*m, 425.*m, 140.*m, 5750, 3833);
  XSetForeground(display, gc, colors[8]);
  XFillArc(display, xid, gc, -10.*m, 20.*m, 400.*m, 140.*m, 5750, 3833);
  XSetForeground(display, gc, colors[4]);
  XFillArc(display, xid, gc, -10.*m, 25.*m, 375.*m, 140.*m, 5750, 3833);
  XSetForeground(display, gc, colors[2]);  XFillArc(display, xid, gc, -10.*m, 30.*m, 350.*m, 140.*m, 5750, 3833);
  XSetForeground(display, gc, colors[9]);/* ++ */
  XFillArc(display, xid, gc, -10.*m, 35.*m, 325.*m, 140.*m, 5750, 3833);
  XSetForeground(display, gc, colors[3]);
  XFillArc(display, xid, gc, -10.*m, 40.*m, 300.*m, 140.*m, 5750, 3833);
  XSetForeground(display, gc, colors[11]);
  XFillArc(display, xid, gc, -10.*m, 45.*m, 275.*m, 140.*m, 5750, 3833);
  XSetForeground(display, gc, colors[15]);
  XFillArc(display, xid, gc, -10.*m, 50.*m, 250.*m, 140.*m, 5750, 3833);
  XFillRectangle(display, xid, gc, 8.*m, 80.*m, 111.*m, 52.*m);
  XSetForeground(display, gc, colors[0]);
  XDrawString(display, xid, gc, 7.*m, 95.*m, "  Schlampisoft", 14);
  XDrawString(display, xid, gc, 10.*m, 110.*m, "   X-window", 11);
  XDrawString(display, xid, gc, 7.*m, 125.*m, "   Workbench", 12);
  XFillArc(display, xid, gc, 114.*m, 20.*m, 60.*m, 40.*m, 0, 17300);
  XFillArc(display, xid, gc, 114.*m, 50.*m, 60.*m, 40.*m, 11550, 17300);
  XSetForeground(display, gc, colors[7]);
  XFillArc(display, xid, gc, 116.*m, 22.*m, 58.*m, 38.*m, 0, 17300);
  XFillArc(display, xid, gc, 116.*m, 52.*m, 58.*m, 38.*m, 11550, 17300);
  XSetForeground(display, gc, colors[0]);
  XFillArc(display, xid, gc, 129.*m, 30.*m, 32.*m, 22.*m, 0, 23500);
  XFillArc(display, xid, gc, 129.*m, 60.*m, 32.*m, 22.*m, 0, 23500);
  XSetForeground(display, gc, colors[2]);
  XFillArc(display, xid, gc, 117.*m, 24.*m, 45.*m, 30.*m, 19650, 3250);
  XFillArc(display, xid, gc, 128.*m, 30.*m, 30.*m, 20.*m, 0, 23500);
  XFillArc(display, xid, gc, 128.*m, 60.*m, 30.*m, 20.*m, 0, 23500);
  XSetForeground(display, gc, colors[9]);
  XFillArc(display, xid, gc, 128.*m, 30.*m, 30.*m, 20.*m, 10000, 9800);
  XSetForeground(display, gc, colors[3]);
  XFillArc(display, xid, gc, 128.*m, 30.*m, 30.*m, 20.*m, 11200, 5150);
  XFillArc(display, xid, gc, 128.*m, 60.*m, 30.*m, 20.*m, 6300, 10200);
  XSetForeground(display, gc, colors[9]);
  XFillArc(display, xid, gc, 128.*m, 60.*m, 30.*m, 20.*m, 16300, 3600);
  XFillArc(display, xid, gc, 128.*m, 60.*m, 30.*m, 20.*m, 2800, 2800);
  XFillRectangle(display, xid, gc, 131.*m, 36.*m, 20.*m, 5.*m);
  XFillRectangle(display, xid, gc, 140.*m, 36.*m, 12.*m, 13.*m);
  XFillRectangle(display, xid, gc, 148.*m, 36.*m, 4.*m, 14.*m);
  XFillRectangle(display, xid, gc, 141.*m, 61.*m, 4.*m, 18.*m);
  XFillRectangle(display, xid, gc, 143.*m, 65.*m, 10.*m, 12.*m);
}


void
initchips(panel, chips)
Panel panel;
Server_image chips[];
{
  register int i;
  Display *dpy = (Display *)xv_get (panel, XV_DISPLAY);
  unsigned long mask, *pixels;
  XGCValues values;
  Pixmap pixmap;

  if (DefaultDepth(dpy, DefaultScreen(dpy)) == 1)
  {
    ttysw_output(tty, "Editor colors disabled in two-color mode\n" , 42);
  }  
  else
  {
    values.graphics_exposures = FALSE ;
    values.foreground = 1 ;
    mask = GCGraphicsExposures | GCForeground ;
    gc = XCreateGC(dpy,
         RootWindow(dpy, DefaultScreen(dpy)), mask, &values);

    pixels = (unsigned long *)xv_get (panel, WIN_X_COLOR_INDICES);
    for(i=0; i<NUM_COLORS; i++)
    {
      chips[i] = (Server_image)xv_create (XV_NULL, SERVER_IMAGE,
                  SERVER_IMAGE_COLORMAP, "palette",
      XV_WIDTH,           16,
      XV_HEIGHT,          16,
      SERVER_IMAGE_DEPTH,  8,
      NULL);
    XSetForeground(dpy, gc, pixels[i]);
    pixmap = (Pixmap)xv_get (chips[i], XV_XID);
    XFillRectangle(dpy, pixmap, gc, 0, 0, 16, 16);
    }
  }   
}



void 
choosecolor (menu, menu_item)       
Menu menu;
Menu_item menu_item;
{
  int i;
  Frame       myframe ;
  Panel mypanel ;
  myframe = (Frame)xv_create ((int)NULL, FRAME,
        XV_WIDTH,       120,
        XV_HEIGHT,       80, 
        FRAME_LABEL,    "SELECT A COLOR:",
        NULL);
  mypanel = (Panel)xv_create (myframe, PANEL,
        PANEL_LAYOUT,   PANEL_VERTICAL,
        WIN_CMS_NAME,   "Palette",
        WIN_CMS_DATA,    &cms_data,
        XV_WIDTH,       120,
        XV_HEIGHT,       80,
        NULL);
}

void dummy () {}
